/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.uml;

import ash.reverse.parser.JavaParser;
import ash.reverse.struct.FileRecord;
import ash.reverse.uml.ClsGenerator;
import ash.reverse.uml.PkgGenerator;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UMLTool {
    static final String FONTDEF = "([PBI]+)(\\d+)(@(.+))$";
    private static Pattern fontDefPat = Pattern.compile("([PBI]+)(\\d+)(@(.+))$");
    private boolean cflag = false;
    private boolean pflag = false;
    private int selectLevel = 0;
    private boolean aflag = false;
    private boolean bflag = false;
    private boolean rflag = false;
    private boolean dflag = false;
    private Font font = null;
    private List<FileRecord> fileList = new ArrayList<FileRecord>();

    public static void main(String ... stringArray) {
        new UMLTool(stringArray);
    }

    private UMLTool(String ... stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (string.startsWith("-f")) {
                this.setFont(string.substring(2));
                continue;
            }
            if (string.startsWith("-")) {
                this.setParams(string.substring(1));
                continue;
            }
            this.parse(string);
        }
        this.generateUML(System.out);
    }

    private void setFont(String string) {
        Matcher matcher = fontDefPat.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(3);
            int n = Integer.parseInt(matcher.group(2));
            int n2 = 0;
            block5: for (char c : matcher.group(1).toCharArray()) {
                switch (c) {
                    case 'P': {
                        n2 |= 0;
                        continue block5;
                    }
                    case 'B': {
                        n2 |= 1;
                        continue block5;
                    }
                    case 'I': {
                        n2 |= 2;
                    }
                }
            }
            this.font = new Font(string2, n2, n);
        }
    }

    public UMLTool() {
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setParams(String string) {
        block9: for (char c : string.toCharArray()) {
            switch (c) {
                case 'c': {
                    this.cflag = true;
                    continue block9;
                }
                case 'p': {
                    this.pflag = true;
                    continue block9;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': {
                    this.selectLevel = c - 48;
                    continue block9;
                }
                case 'a': {
                    this.aflag = true;
                    continue block9;
                }
                case 'b': {
                    this.bflag = true;
                    continue block9;
                }
                case 'r': {
                    this.rflag = true;
                    continue block9;
                }
                case 'd': {
                    this.dflag = true;
                }
            }
        }
    }

    public void setParams(int n, boolean bl, boolean bl2) {
        this.selectLevel = n;
        this.aflag = bl;
        this.bflag = bl2;
    }

    public void generateUML(PrintStream printStream) {
        if (this.cflag) {
            ClsGenerator.generate(printStream, this.fileList, this.font, this.selectLevel, this.aflag, this.bflag);
        }
        if (this.pflag) {
            PkgGenerator.generate(printStream, this.fileList, this.font, this.rflag, this.dflag);
        }
    }

    public void parse(String string) {
        File file = new File(string);
        if (file != null) {
            this.parseSub(file);
        } else {
            this.printErr(string + ": \u30d1\u30b9\u540d\u3092\u78ba\u8a8d\u3057\u3066\u4e0b\u3055\u3044\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSub(File file) {
        block16: {
            block15: {
                if (!file.isDirectory()) break block15;
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (File file2 : fileArray) {
                        this.parseSub(file2);
                    }
                } else {
                    this.printErr(file.getName() + ": \u30a2\u30af\u30bb\u30b9\u8a31\u53ef\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                }
                break block16;
            }
            if (!file.getName().endsWith(".java")) break block16;
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                this.parseJavaCode(bufferedReader, file);
            }
            catch (IOException iOException) {
                this.printErr(file.getName() + ": \u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u304c\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            finally {
                if (file != null && bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    void printErr(Object object) {
        System.err.println(object);
    }

    protected void parseJavaCode(BufferedReader bufferedReader, File file) throws IOException {
        JavaParser javaParser = new JavaParser(bufferedReader, file.getName(), true);
        FileRecord fileRecord = javaParser.parse();
        this.fileList.add(fileRecord);
    }
}

