/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class JavaTokenizer
extends StreamTokenizer {
    protected String fname;
    protected int nSpaceLine = 0;
    protected int nLine = 0;
    protected int blockLevel = 0;
    protected int parenLevel = 0;
    private boolean makeSignature = false;
    private int lastLineNum = 1;
    private boolean tokenEaten = false;
    private boolean eof = false;
    private boolean pushback = false;
    private boolean atmark = false;
    private StringBuilder signatureBuffer = new StringBuilder();
    private boolean signatureSwitch = false;
    private int c1;
    private boolean parsingAnnotation;

    public JavaTokenizer(Reader reader, String string) {
        super(reader);
        this.fname = string;
        this.eof = false;
        this.eolIsSignificant(true);
        this.slashStarComments(true);
        this.slashSlashComments(true);
        this.ordinaryChar(47);
        this.wordChars(95, 95);
        this.wordChars(36, 36);
        this.parseNumbers();
    }

    protected void trace() {
        System.err.println(this.tokenString());
    }

    protected void trace(Object object) {
        System.err.println(object);
    }

    protected void appendCloser(String string) {
        this.signatureBuffer.append(string);
    }

    protected void startAnnotation() {
        this.parsingAnnotation = true;
    }

    protected void endAnnotation() {
        this.parsingAnnotation = false;
    }

    protected String getErrorInfo() {
        String string = "*** unexpected EOF:";
        if (this.fname != null) {
            string = string + "\n" + this.fname;
        }
        return string;
    }

    @Override
    public int nextToken() throws IOException {
        switch (super.nextToken()) {
            case -1: {
                if (this.eof) {
                    throw new IOException(this.getErrorInfo());
                }
                this.eof = true;
                return this.ttype;
            }
            case 10: {
                if (!this.tokenEaten) {
                    this.nSpaceLine += this.lineno() - this.lastLineNum;
                }
                this.tokenEaten = false;
                this.lastLineNum = this.lineno();
                return this.ttype;
            }
        }
        if (!this.tokenEaten) {
            ++this.nLine;
        }
        this.tokenEaten = true;
        return this.ttype;
    }

    @Override
    public void pushBack() {
        if (this.ttype == 123) {
            --this.blockLevel;
        }
        if (this.ttype == 40) {
            --this.parenLevel;
        }
        this.pushback = true;
    }

    protected void makeSignature() {
        this.makeSignature = true;
    }

    protected void startSignature() {
        this.signatureBuffer.delete(0, Integer.MAX_VALUE);
        this.signatureSwitch = true;
        this.c1 = 0;
    }

    protected String pruneSignature() {
        this.signatureSwitch = false;
        return this.signatureBuffer.toString();
    }

    protected void appendSignature(String string) {
        if (!this.makeSignature || !this.signatureSwitch) {
            return;
        }
        if ((string.equals(";") || string.equals("{")) && !this.parsingAnnotation) {
            this.signatureSwitch = false;
            return;
        }
        int n = string.charAt(0);
        if (this.c1 != 0 && n != 9) {
            if (Character.isJavaIdentifierPart(n)) {
                n = 65;
            }
            if ((this.c1 == 65 || this.c1 == 44 || this.c1 == 63) && n == 65 || this.c1 == 93 && n != 91 && n != 62 || this.c1 == 62 && n != 62 || this.c1 == 41 || this.c1 != 9 && n == 64 || this.signatureBuffer.toString().endsWith("...")) {
                this.signatureBuffer.append(' ');
            }
        }
        this.signatureBuffer.append(string);
        this.c1 = string.charAt(string.length() - 1);
        if (Character.isJavaIdentifierPart(this.c1)) {
            this.c1 = 65;
        }
    }

    protected int getToken() throws IOException {
        while (true) {
            if (!this.pushback) {
                this.nextToken();
            }
            if (this.ttype == -1) {
                return -1;
            }
            if (this.ttype == 10) continue;
            if (this.pushback) {
                this.pushback = false;
            } else {
                this.appendSignature(this.tokenString());
            }
            if (this.atmark && this.ttype == -3) {
                this.sval = "@" + this.sval;
                this.atmark = false;
                return -3;
            }
            boolean bl = this.atmark = this.ttype == 64;
            if (!this.atmark) break;
        }
        if (this.ttype == 123) {
            ++this.blockLevel;
        } else if (this.ttype == 125) {
            --this.blockLevel;
        } else if (this.ttype == 40) {
            ++this.parenLevel;
        } else if (this.ttype == 41) {
            --this.parenLevel;
        }
        return this.ttype;
    }

    private String tokenString() {
        switch (this.ttype) {
            case -3: {
                return this.sval;
            }
            case -2: {
                return "" + this.nval;
            }
            case 39: {
                return "'" + this.antiChar(this.sval) + "'";
            }
            case 34: {
                return "\"" + this.antiString(this.sval) + "\"";
            }
        }
        return "" + (char)this.ttype;
    }

    private String antiString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String antiChar(String string) {
        if (string.length() == 1) {
            switch (string.charAt(0)) {
                case '\\': {
                    return "\\\\";
                }
                case '\n': {
                    return "\\n";
                }
                case '\t': {
                    return "\\t";
                }
                case '\f': {
                    return "\\f";
                }
                case '\r': {
                    return "\\r";
                }
                case '\'': {
                    return "\\'";
                }
            }
            return string;
        }
        if (string.length() == 5 && string.charAt(0) == 'u') {
            return "\\" + string;
        }
        return string;
    }
}

