/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.editor.core;

import ash.gui.core.AshFont;
import ash.gui.core.GUIAdapter;
import ash.gui.editor.core.AshEditorFrame;
import ash.gui.editor.core.AshFontPanel;
import ash.util.FileUtil;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public abstract class AshEditorArea {
    private static File prevFile = GUIAdapter.findFile(".");
    private File currentFile = null;
    private boolean modified = false;
    protected Font font = AshFont.getFont();
    protected AshEditorFrame editFrame;
    private static int untitledSeq = 0;

    public AshEditorArea(AshEditorFrame ashEditorFrame) {
        this.editFrame = ashEditorFrame;
    }

    File getCurrentDirectory() {
        if (this.currentFile != null && this.currentFile.exists()) {
            prevFile = this.currentFile;
        }
        return prevFile;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    protected void setCurrentFile(File file) {
        this.currentFile = file;
        this.setModified(false);
    }

    void setFileName(String string) {
        this.currentFile = new File(string);
        this.setModified(true);
    }

    boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
        String string = !this.isEditable() ? "\uff08\u8aad\u307f\u8fbc\u307f\u5c02\u7528\uff09" : "";
        String string2 = this.currentFile != null ? FileUtil.getPath(this.currentFile) : "(\u7121\u984c)";
        String string3 = string2 + string;
        if (bl) {
            string3 = string3 + " *";
        }
        this.editFrame.notifyUpdate(this, string3);
    }

    protected void setFont() {
        this.font = AshFontPanel.updateFont(this.editFrame, this.font);
        this.setFont(this.font);
    }

    private static String nextUndefined() {
        return String.format("Untitled%02d", untitledSeq++);
    }

    void newFile() {
        this.resetDocument();
        this.setEditable(true);
        File file = this.getCurrentDirectory();
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        file = new File(file, AshEditorArea.nextUndefined());
        this.setCurrentFile(file);
    }

    boolean openFile(File file) {
        if (file.isFile()) {
            return this.openReadFile(file);
        }
        if (file.isDirectory()) {
            file = new File(file, AshEditorArea.nextUndefined());
        } else if (file.exists()) {
            return false;
        }
        this.resetDocument();
        this.setEditable(true);
        this.setCurrentFile(file);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean openReadFile(File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            this.readDocument(bufferedReader, file);
            this.setEditable(file.canWrite());
            this.setCurrentFile(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.editFrame.showError("\u8aad\u307f\u8fbc\u307f\u304c\u3067\u304d\u307e\u305b\u3093", fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.editFrame.showError("\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", iOException.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    boolean writeFile() {
        return this.writeFile(this.currentFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeFile(File file) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            this.writeDocument(bufferedWriter, file);
            this.setEditable(true);
            this.setCurrentFile(file);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.editFrame.showError("\u66f8\u304d\u51fa\u3057\u304c\u3067\u304d\u307e\u305b\u3093", fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            this.editFrame.showError("\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", iOException.toString());
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    void gotoLine() {
        while (true) {
            try {
                int n;
                String string = this.editFrame.inputDialog("\u884c\u756a\u53f7", "\u884c\u3078\u79fb\u52d5");
                if (string != null && !this.showLine((n = Integer.valueOf(string).intValue()) - 1)) {
                    this.editFrame.showMessage("\u884c\u756a\u53f7\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.editFrame.showError("\u6570\u5b57\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", numberFormatException.toString());
                continue;
            }
            break;
        }
    }

    protected abstract Component getEditArea();

    protected abstract void setEditable(boolean var1);

    protected abstract boolean isEditable();

    protected abstract boolean isSelectable();

    protected abstract void setRowColumn(int var1, int var2);

    protected abstract void setFont(Font var1);

    protected abstract void setTextData(String var1);

    public abstract boolean isSelected();

    public abstract String getSelectedText();

    protected abstract int getLineCount();

    protected abstract boolean showLine(int var1);

    protected abstract void copy();

    protected abstract void cut();

    protected abstract void paste();

    protected abstract void delete();

    protected abstract void selectAll();

    protected abstract void resetDocument();

    protected abstract void readDocument(BufferedReader var1, File var2) throws IOException;

    protected abstract void writeDocument(BufferedWriter var1, File var2) throws IOException;

    public void undo() {
    }

    public void redo() {
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }
}

