/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import ash.util.PrintableTree;
import java.io.PrintStream;
import java.util.Iterator;

public class PrintTree<T extends PrintableTree<T>> {
    private static final char LNK_NULL = ' ';
    private static final char LNK_CONT = '|';
    private static final char LNK_TERM = '+';
    private static final char LNK_LEAF = '-';
    private int maxLevel;
    private PrintStream out;
    private char[] cm;

    public PrintTree(int n, PrintStream printStream) {
        this.maxLevel = n;
        this.out = printStream;
        this.cm = new char[n];
    }

    public void printTree(PrintableTree<T> printableTree) {
        this.out.println(printableTree.getContent(0));
        this.printSubTree(printableTree, 1);
    }

    private void printSubTree(PrintableTree<T> printableTree, int n) {
        if (n > this.maxLevel) {
            this.out.println("\u6700\u5927\u30ec\u30d9\u30eb\u3092\u8d85\u3048\u307e\u3057\u305f\u3002");
            return;
        }
        Iterator<T> iterator = printableTree.iterator();
        while (iterator.hasNext()) {
            PrintableTree printableTree2 = (PrintableTree)iterator.next();
            this.cm[n - 1] = iterator.hasNext() ? 124 : 43;
            this.printIndent(n);
            if (printableTree2.hasMember()) {
                this.out.println(printableTree2.getContent(1));
                if (this.cm[n - 1] == '+') {
                    this.cm[n - 1] = 32;
                }
                this.printSubTree(printableTree2, n + 1);
                continue;
            }
            this.out.println(printableTree2.getContent(2));
        }
    }

    private void printIndent(int n) {
        for (int i = 0; i < n; ++i) {
            char c = i < n - 1 ? (char)' ' : '-';
            this.out.printf(" %c%c ", Character.valueOf(this.cm[i]), Character.valueOf(c));
        }
    }
}

