/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.uml;

import ash.reverse.uml.MethodNode;
import ash.reverse.uml.Node;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

class ClassNode
extends Node {
    private List<Node> attributes = new ArrayList<Node>();
    private List<MethodNode> methods = new ArrayList<MethodNode>();
    private int x;
    private int y;

    ClassNode(String string, String string2, int n) {
        super(string, string2, n);
    }

    void addAttribute(String string, String string2, int n) {
        this.attributes.add(new Node(string, string2, n));
    }

    void addMethod(MethodNode methodNode) {
        this.methods.add(methodNode);
    }

    @Override
    void print(PrintStream printStream) {
        String string = this.info + this.layoutInfo();
        if (this.packageID != 0) {
            string = string + "\t" + this.packageID;
        }
        printStream.println(string);
        for (Node node : this.attributes) {
            node.print(printStream);
        }
        for (MethodNode methodNode : this.methods) {
            ((Node)methodNode).print(printStream);
        }
    }

    private String layoutInfo() {
        return "\t" + this.x + "\t" + this.y + "\t" + this.height1() + "\t" + this.height2() + "\t" + this.height3() + "\t" + this.width();
    }

    int height() {
        return this.height1() + this.height2() + this.height3();
    }

    private int height1() {
        return this.height(1);
    }

    private int height2() {
        return this.height(this.attributes.size());
    }

    private int height3() {
        return this.height(this.methods.size());
    }

    private int height(int n) {
        return Math.max(8, this.upAdjust(n * this.fm.getHeight() + 4));
    }

    @Override
    int width() {
        int n;
        int n2 = super.width();
        for (Node node : this.attributes) {
            n = node.width();
            if (n <= n2) continue;
            n2 = n;
        }
        for (MethodNode methodNode : this.methods) {
            n = methodNode.width();
            if (n <= n2) continue;
            n2 = n;
        }
        return this.upAdjust(n2);
    }

    void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width(), this.height());
    }
}

