/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.parser;

import ash.reverse.parser.JavaTokenizer;
import ash.reverse.parser.JavaType;
import ash.reverse.parser.Mod;
import ash.reverse.parser.Visibility;
import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.FieldRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.GroupRecord;
import ash.reverse.struct.MethodRecord;
import ash.reverse.struct.ObjectRecord;
import java.io.IOException;
import java.io.Reader;

public class JavaParser
extends JavaTokenizer {
    private boolean signature;
    private GroupRecord currentClass;
    private Visibility visibility;
    private int modifiers;

    public JavaParser(Reader reader, String string, boolean bl) {
        super(reader, string);
        this.signature = bl;
        if (bl) {
            this.makeSignature();
        }
    }

    @Override
    protected String getErrorInfo() {
        String string = super.getErrorInfo();
        if (this.currentClass != null) {
            string = string + "\n" + this.currentClass.errMessage();
        }
        return string;
    }

    @Override
    protected void startSignature() {
        super.startSignature();
        this.visibility = Visibility.PACKAGE;
        this.modifiers = 0;
    }

    private boolean gleanProp(String string) {
        Visibility visibility = Visibility.value(string);
        if (visibility != Visibility.UNDEF) {
            this.visibility = visibility;
            return true;
        }
        int n = Mod.mask(string);
        this.modifiers |= n;
        return n != 0;
    }

    private void setPropTo(ObjectRecord objectRecord) {
        objectRecord.visibility(this.visibility);
        objectRecord.modifiers(this.modifiers);
    }

    public FileRecord parse() throws IOException {
        FileRecord fileRecord = new FileRecord(this.fname);
        this.startSignature();
        while (true) {
            switch (this.getToken()) {
                case -1: {
                    fileRecord.addLoc(this.nLine);
                    fileRecord.setLineEnd(this.nLine + this.nSpaceLine);
                    return fileRecord;
                }
                case -3: {
                    String string = this.sval;
                    if (string.equals("package")) {
                        this.startSignature();
                        while (this.getToken() != 59) {
                        }
                        fileRecord.pkgname(this.pruneSignature());
                        this.startSignature();
                        break;
                    }
                    if (string.equals("import") && this.signature) {
                        this.startSignature();
                        while (this.getToken() != 59) {
                        }
                        fileRecord.addImportDecl(this.pruneSignature());
                        this.startSignature();
                        break;
                    }
                    if (JavaType.valid(string)) {
                        this.parseClass(fileRecord);
                        this.startSignature();
                        break;
                    }
                    if (string.startsWith("@")) {
                        this.parseAnnotation();
                        break;
                    }
                    this.gleanProp(string);
                    break;
                }
                case 59: {
                    this.startSignature();
                }
            }
        }
    }

    private void parseClass(GroupRecord groupRecord) throws IOException {
        String string = this.sval;
        this.getToken();
        ClassRecord classRecord = new ClassRecord(string, this.sval, this.lineno(), groupRecord);
        this.setPropTo(classRecord);
        this.currentClass = classRecord;
        groupRecord.addMember(classRecord);
        while (this.getToken() != 123) {
        }
        classRecord.setSignature(this.pruneSignature());
        this.parseClassBody(classRecord);
        this.currentClass = groupRecord;
    }

    private void parseClassBody(ClassRecord classRecord) throws IOException {
        int n = this.blockLevel;
        int n2 = this.nLine;
        String string = null;
        String string2 = null;
        this.startSignature();
        if (classRecord.isEnum()) {
            this.parseEnumValue(classRecord);
            if (this.ttype == 125) {
                this.pushBack();
            }
        }
        block8: while (true) {
            switch (this.getToken()) {
                case -3: {
                    if (JavaType.valid(this.sval)) {
                        this.parseClass(classRecord);
                        break;
                    }
                    if (this.sval.startsWith("@")) {
                        this.parseAnnotation();
                        continue block8;
                    }
                    if (this.gleanProp(this.sval)) continue block8;
                    string = string2;
                    string2 = this.sval;
                    continue block8;
                }
                case 59: {
                    if (string2 == null) break;
                    this.addFieldDecl(classRecord, string2);
                    break;
                }
                case 61: {
                    this.parseFieldExpr(classRecord, string2);
                    break;
                }
                case 40: {
                    this.parseMethod(classRecord, string2);
                    break;
                }
                case 123: {
                    if (string2 != null) break;
                    this.pushBack();
                    this.parseMethod(classRecord, null);
                    break;
                }
                case 125: {
                    if (this.blockLevel < n) {
                        classRecord.setLineEnd(this.lineno());
                        classRecord.addLoc(this.nLine - n2 + 1);
                        return;
                    }
                }
                default: {
                    continue block8;
                }
            }
            string2 = null;
            string = null;
            this.startSignature();
        }
    }

    private void parseEnumValue(ClassRecord classRecord) throws IOException {
        String string = null;
        int n = this.parenLevel;
        block5: while (true) {
            switch (this.getToken()) {
                case 44: {
                    if (this.parenLevel > n) continue block5;
                }
                case 59: 
                case 125: {
                    if (string != null) {
                        classRecord.addEnum(string);
                    }
                    if (this.ttype == 59 || this.ttype == 125) {
                        return;
                    }
                    string = null;
                    break;
                }
                case -3: {
                    if (this.parenLevel != n) break;
                    string = this.sval;
                }
            }
        }
    }

    private void addFieldDecl(ClassRecord classRecord, String string) {
        int n = this.lineno();
        FieldRecord fieldRecord = new FieldRecord(string, n, classRecord);
        this.setPropTo(fieldRecord);
        classRecord.addMember(fieldRecord);
        fieldRecord.addLoc(1);
        fieldRecord.setLineEnd(n);
        fieldRecord.setFieldDecl(this.pruneSignature());
    }

    private void parseFieldExpr(ClassRecord classRecord, String string) throws IOException {
        FieldRecord fieldRecord = new FieldRecord(string, this.lineno(), classRecord);
        this.setPropTo(fieldRecord);
        classRecord.addMember(fieldRecord);
        String string2 = this.pruneSignature();
        if (string2.endsWith("=")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        fieldRecord.setFieldDecl(string2);
        int n = this.nLine;
        int n2 = this.blockLevel;
        boolean bl = false;
        this.startSignature();
        while (true) {
            this.getToken();
            if (n2 == this.blockLevel) {
                if (this.ttype == 59) break;
                if (this.ttype != -3) continue;
                fieldRecord.addToken(this.sval);
                if (!this.sval.equals("new")) continue;
                this.getToken();
                fieldRecord.addToken(this.sval);
                this.parseNewClass(classRecord);
                continue;
            }
            bl = true;
        }
        fieldRecord.addLoc(this.nLine - n + 1);
        fieldRecord.setLineEnd(this.lineno());
        String string3 = this.pruneSignature();
        if (bl) {
            string3 = "{...}";
        }
        if (!string3.equals("}")) {
            fieldRecord.value(string3);
        }
    }

    private void parseNewClass(ClassRecord classRecord) throws IOException {
        while (true) {
            switch (this.getToken()) {
                case 40: {
                    this.parseNewParen();
                    if (this.getToken() == 123) {
                        this.parseClassBody(classRecord);
                    } else {
                        this.pushBack();
                    }
                    return;
                }
                case 123: {
                    int n = this.blockLevel;
                    do {
                        this.getToken();
                    } while (this.blockLevel >= n);
                    return;
                }
                case 59: {
                    this.pushBack();
                    return;
                }
            }
        }
    }

    private void parseNewParen() throws IOException {
        int n = this.parenLevel;
        boolean bl = false;
        do {
            int n2;
            if ((n2 = this.getToken()) != 123) continue;
            bl = true;
        } while (n <= this.parenLevel);
        if (bl) {
            this.appendCloser("{})");
        }
    }

    private void parseMethod(ClassRecord classRecord, String string) throws IOException {
        if (string == null) {
            string = Mod.STATIC.in(this.modifiers) ? "static{}" : "instance{}";
        }
        MethodRecord methodRecord = classRecord.addMethod(string, this.lineno());
        this.setPropTo(methodRecord);
        int n = this.nLine;
        int n2 = this.blockLevel;
        boolean bl = false;
        if (!string.endsWith("{}")) {
            this.parseParen();
        }
        while (true) {
            this.getToken();
            if (!bl) {
                if (this.ttype == 59) break;
                if (this.blockLevel <= n2) continue;
                bl = true;
                continue;
            }
            if (this.blockLevel == n2) break;
            if (!this.signature || this.ttype != -3) continue;
            classRecord.addMethodToken(this.sval);
        }
        classRecord.setMethodLoc(this.nLine - n + 1, this.lineno());
        String string2 = this.pruneSignature();
        if (string2.isEmpty()) {
            string2 = "instance()";
        }
        if (string2.equals("static")) {
            string2 = "static()";
        }
        classRecord.setMethodSignature(string2);
    }

    private void parseAnnotation() throws IOException {
        this.appendSignature("\t");
        if (this.getToken() == 40) {
            this.startAnnotation();
            this.parseParen();
            this.endAnnotation();
            this.appendSignature("\t");
        } else {
            this.pushBack();
        }
    }

    private void parseParen() throws IOException {
        int n = this.parenLevel;
        do {
            this.getToken();
        } while (n <= this.parenLevel);
    }
}

