/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.editor.core;

import ash.gui.core.GUIAdapter;
import ash.util.FileUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;

public class AshGUIViewer {
    private static List<String> searchPath = new LinkedList<String>();
    private static AshGUIViewer guiViewer = new AshGUIViewer();
    private String filePath;
    private String lineNum;
    static final String GREP_PAT = "(([a-zA-Z]:)?([^:*?'<>\"\\(\\)]+)):\\s*(\\d+):";
    private static Pattern grepPat = Pattern.compile("(([a-zA-Z]:)?([^:*?'<>\"\\(\\)]+)):\\s*(\\d+):");
    static final String FQCN_PAT = "([\\w.]*?)\\.?\\w+(\\$\\w+)?\\.[\\w\\$<>]+";
    static final String ERR_PAT = "([\\w.]*?)\\.?\\w+(\\$\\w+)?\\.[\\w\\$<>]+\\((\\w+\\.java):\\s*(\\d+)\\)";
    private static Pattern runtimeErrPat = Pattern.compile("([\\w.]*?)\\.?\\w+(\\$\\w+)?\\.[\\w\\$<>]+\\((\\w+\\.java):\\s*(\\d+)\\)");
    private int start = 0;
    private int end = 0;

    public static int resetSearchPath(String[] stringArray) {
        searchPath.clear();
        return AshGUIViewer.addSearchPath(stringArray);
    }

    public static int addSearchPath(String[] stringArray) {
        if (stringArray.length == 0) {
            for (String string : searchPath) {
                System.out.println(string);
            }
        } else {
            int n = 0;
            for (String string : stringArray) {
                File file = GUIAdapter.findFile(string);
                if (file != null && file.isDirectory()) {
                    String string2 = FileUtil.getPath(file);
                    if (searchPath.contains(string2)) continue;
                    searchPath.add(n++, string2);
                    continue;
                }
                System.err.println("directory requred: " + string);
            }
        }
        return 0;
    }

    public static boolean openViewer(String string) {
        if (string == null) {
            return false;
        }
        if (AshGUIViewer.openWithSearchPath(string)) {
            return true;
        }
        String string2 = string.replace('.', '/');
        if (AshGUIViewer.openWithSearchPath(string2 + ".java")) {
            return true;
        }
        int n = string2.lastIndexOf(47);
        if (n > 0) {
            return AshGUIViewer.openWithSearchPath(string2.substring(0, n) + ".java");
        }
        return false;
    }

    private static boolean openWithSearchPath(String string) {
        if (AshGUIViewer._openViewer(string, "1")) {
            return true;
        }
        for (String string2 : searchPath) {
            if (!AshGUIViewer._openViewer(string2 + string, "1")) continue;
            return true;
        }
        return false;
    }

    public static boolean openFromTextArea(JTextArea jTextArea) {
        String string = jTextArea.getSelectedText();
        if (string != null && AshGUIViewer.openViewer(string.trim())) {
            return true;
        }
        if (AshGUIViewer.openFromTextArea(jTextArea, "")) {
            return true;
        }
        for (String string2 : searchPath) {
            if (!AshGUIViewer.openFromTextArea(jTextArea, string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean openFromTextArea(JTextArea jTextArea, String string) {
        if (!guiViewer.searchTarget(jTextArea, string)) {
            return false;
        }
        return AshGUIViewer._openViewer(AshGUIViewer.guiViewer.filePath, AshGUIViewer.guiViewer.lineNum);
    }

    private static boolean _openViewer(String string, String string2) {
        File file = GUIAdapter.findFile(string);
        if (file == null || !file.isFile()) {
            return false;
        }
        if (string.startsWith("~/")) {
            string = System.getenv("HOME") + string.substring(1);
        }
        GUIAdapter.openViewer(string, string2);
        return true;
    }

    private AshGUIViewer() {
    }

    private boolean searchTarget(JTextArea jTextArea, String string) {
        return guiViewer.searchRuntimeErrorFormat(jTextArea, string) || guiViewer.searchGrepFormat(jTextArea, string);
    }

    private boolean searchGrepFormat(JTextArea jTextArea, String string) {
        Matcher matcher = grepPat.matcher(AshGUIViewer.getCurrentLine(jTextArea));
        if (!matcher.find()) {
            return false;
        }
        this.filePath = matcher.group(1);
        this.lineNum = matcher.group(4);
        if (!matcher.group(3).startsWith("/")) {
            this.filePath = string + this.filePath;
        }
        return true;
    }

    private boolean searchRuntimeErrorFormat(JTextArea jTextArea, String string) {
        Matcher matcher = runtimeErrPat.matcher(AshGUIViewer.getCurrentLine(jTextArea));
        if (!matcher.find()) {
            return false;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(3);
        string2 = string2 != null ? string2.replace('.', '/') + "/" : "";
        this.filePath = string + string2 + string3;
        this.lineNum = matcher.group(4);
        return true;
    }

    public static String getCurrentLine(JTextArea jTextArea) {
        if (!guiViewer.currentLine(jTextArea)) {
            return "";
        }
        return jTextArea.getText().substring(AshGUIViewer.guiViewer.start, AshGUIViewer.guiViewer.end);
    }

    public static void selectCurrentLine(JTextArea jTextArea) {
        if (guiViewer.currentLine(jTextArea)) {
            jTextArea.setSelectionStart(AshGUIViewer.guiViewer.start);
            jTextArea.setSelectionEnd(AshGUIViewer.guiViewer.end);
        }
    }

    private boolean currentLine(JTextArea jTextArea) {
        String string = jTextArea.getText();
        int n = jTextArea.getCaretPosition();
        if (string.length() <= n || string.charAt(n) == '\n') {
            --n;
        }
        if (0 <= n) {
            this.start = string.lastIndexOf(10, n) + 1;
            this.end = string.indexOf(10, n);
            if (this.end < 0) {
                this.end = string.length();
            }
            return this.start < this.end;
        }
        return false;
    }
}

