/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.core;

import ash.gui.core.GUIAdapter;
import ash.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class AshGUIFrame
extends JFrame
implements ActionListener {
    private JPanel contentPane;
    private static final int TASKBAR_HEIGHT = 34;
    private StatusBar statusBar;
    public static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static int actionSerial = 0;

    public AshGUIFrame() {
        this.init();
    }

    public AshGUIFrame(String string) {
        super(string);
        this.init();
        this.construct();
        this.pack();
    }

    private void init() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AshGUIFrame.this.disposeFrame();
            }
        });
        this.contentPane = (JPanel)this.getContentPane();
        this.setJMenuBar(this.createMenuBar());
    }

    protected void construct() {
        this.setNorth(this.createToolBar());
        this.setCenter(this.createWorkArea());
        this.setSouth(this.getStatusBar());
    }

    protected void disposeFrame() {
        if (this.confirmDispose()) {
            assert (Log.debug(1, "==> AshGUIFrame#disposeFrame()"));
            this.dispose();
        }
    }

    protected boolean confirmDispose() {
        return true;
    }

    public void adjustLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height -= 34;
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        Point point = this.getLocation();
        int n = Math.min(Math.max(point.x, 0), dimension.width - dimension2.width);
        int n2 = Math.min(Math.max(point.y, 0), dimension.height - dimension2.height);
        this.setBounds(n, n2, dimension2.width, dimension2.height);
    }

    protected void setNorth(Component component) {
        if (component != null) {
            this.contentPane.add(component, "North");
        }
    }

    protected void setCenter(Component component) {
        if (component != null) {
            this.contentPane.add(component, "Center");
        }
    }

    protected void setSouth(Component component) {
        if (component != null) {
            this.contentPane.add(component, "South");
        }
    }

    protected void setWest(Component component) {
        if (component != null) {
            this.contentPane.add(component, "West");
        }
    }

    protected void setEast(Component component) {
        if (component != null) {
            this.contentPane.add(component, "East");
        }
    }

    protected JMenuBar createMenuBar() {
        return null;
    }

    protected JToolBar createToolBar() {
        return null;
    }

    protected Component createWorkArea() {
        return null;
    }

    protected StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar();
        }
        return this.statusBar;
    }

    protected void statusSetVisible(boolean bl) {
        this.statusBar.setVisible(bl);
    }

    public JMenuItem makeStatusMenuItem() {
        return this.getStatusBar().makeStatusMenuItem();
    }

    public void setMessage(String string) {
        this.getStatusBar().showMessage(string);
    }

    public void showCursorPos(int n, int n2) {
        this.getStatusBar().showCursorPos(n, n2);
    }

    protected String cursorPosDisplay(int n, int n2) {
        return "(" + n + ", " + n2 + ")";
    }

    public static void beep() {
        toolkit.beep();
    }

    protected static String actionName() {
        return String.format("ACTION_%03d", actionSerial++);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        GUIAdapter.getListener().actionPerformed(actionEvent);
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this.contentPane, string);
    }

    public void showError(String string, String string2) {
        AshGUIFrame.beep();
        JOptionPane.showMessageDialog(this.contentPane, string, string2, 0);
    }

    public int showConfirm(String string) {
        return JOptionPane.showConfirmDialog(this.contentPane, string);
    }

    public int showConfirm(String string, String string2) {
        return JOptionPane.showConfirmDialog(this.contentPane, string, string2, 0);
    }

    public String inputDialog(String string, String string2) {
        return JOptionPane.showInputDialog(this.contentPane, string, string2, 3);
    }

    protected class StatusBar
    extends JPanel {
        private JLabel statusLabel = new JLabel("\u60c5\u5831\u3092\u8868\u793a\u3059\u308b\u9818\u57df\u3067\u3059\u3002");
        private JLabel cursorPos = new JLabel();

        private StatusBar() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.statusLabel, "Center");
            this.add((Component)this.cursorPos, "East");
        }

        void showMessage(String string) {
            this.statusLabel.setText(string);
        }

        void showCursorPos(int n, int n2) {
            this.cursorPos.setText(AshGUIFrame.this.cursorPosDisplay(n, n2));
        }

        JMenuItem makeStatusMenuItem() {
            final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("\u30b9\u30c6\u30fc\u30bf\u30b9\u30d0\u30fc(S)", true);
            jCheckBoxMenuItem.setMnemonic(83);
            jCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    StatusBar.this.setVisible(jCheckBoxMenuItem.isSelected());
                }
            });
            return jCheckBoxMenuItem;
        }
    }
}

