/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import pbl2011.common.CommonConst;
import pbl2011.common.FileUtil;
import pbl2011.common.Util;
import pbl2011.model.Attribute;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;
import pbl2011.model.PackageManager;
import pbl2011.model.Parameter;

public class JavaCodeGenerator {
    private static final String SRC_DIR = "src";
    private static final String EXTENTION_JAVA = ".java";
    private static final String SPACE = " ";
    private static final String PATH_JAVA_SOURCE_TEMPLATE = "conf/javaSource.template";
    private static final String PLACE_HOLDER_PACKAGE_PHRASE = "<<package>>";
    private static final String PLACE_HOLDER_IMPORT_PHRASE = "<<import>>";
    private static final String PLACE_HOLDER_CLASS_COMMENT = "<<classComment>>";
    private static final String PLACE_HOLDER_CLASS_DECLARATION = "<<classOpenPhrase>>";
    private static final String PLACE_HOLDER_ATTRIBUTES = "<<attributes>>";
    private static final String PLACE_HOLDER_METHODS = "<<methods>>";
    private static final String INPORT_PHRASE = "import <<packageName>>.<<className>>;";
    private static final String ATTRIBUTE_PHRASE = "        <<visibility>> <<typeName>> <<attrName>>;";
    private static final String METHOD_START_PHRASE = "        <<visibility>> <<returnType>> <<methodName>> (<<params>>) {";
    private static final String PARAM_PHRASE = "<<paramType>> <<paramName>>";

    public static void generate(File file, List<ClassNode> list) {
        JavaCodeGenerator.makeOutputDir(file);
        JavaCodeGenerator.generateProcess(file, list);
    }

    private static void makeOutputDir(File file) {
        File file2 = new File(file.getAbsolutePath() + File.separator + SRC_DIR);
        if (file2.exists()) {
            FileUtil.deleteDir(file2);
        }
        file2.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateProcess(File file, List<ClassNode> list) {
        ArrayList<ClassNode> arrayList = JavaCodeGenerator.getAllActiveClassData(list);
        for (ClassNode classNode : arrayList) {
            if (classNode.isBuiltInClass) continue;
            OutputStreamWriter outputStreamWriter = null;
            String string = null;
            String string2 = null;
            try {
                if (classNode.packageId == CommonConst.PACKAGE_DEFAULT_ID) {
                    string2 = file.getAbsolutePath() + File.separator + SRC_DIR + File.separator + classNode.className + EXTENTION_JAVA;
                } else {
                    string = file.getAbsolutePath() + File.separator + SRC_DIR + File.separator + classNode.getPackageName().replace(".", File.separator);
                    string2 = string + File.separator + classNode.className + EXTENTION_JAVA;
                    File file2 = new File(string);
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                }
                outputStreamWriter = new FileWriter(string2);
                outputStreamWriter.write(JavaCodeGenerator.genarateClassCode(classNode, list));
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static String genarateClassCode(ClassNode classNode, List<ClassNode> list) {
        ClassLoader classLoader = Util.getClassLoader(JavaCodeGenerator.class);
        InputStream inputStream = classLoader.getResourceAsStream(PATH_JAVA_SOURCE_TEMPLATE);
        String string = FileUtil.readFile(inputStream);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PLACE_HOLDER_PACKAGE_PHRASE, classNode.getPackagePhrase());
        hashMap.put(PLACE_HOLDER_IMPORT_PHRASE, JavaCodeGenerator.genImportPhrase(classNode, list));
        hashMap.put(PLACE_HOLDER_CLASS_COMMENT, null);
        hashMap.put(PLACE_HOLDER_CLASS_DECLARATION, classNode.getClassdeclarationPhrase());
        hashMap.put(PLACE_HOLDER_ATTRIBUTES, JavaCodeGenerator.genAttributePhrase(classNode.attributeList, list));
        hashMap.put(PLACE_HOLDER_METHODS, JavaCodeGenerator.genMethodPhrase(classNode.methodList, list));
        return JavaCodeGenerator.replace(string, hashMap);
    }

    private static String genImportPhrase(ClassNode classNode, List<ClassNode> list) {
        HashSet<String> hashSet = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer();
        for (Attribute object : classNode.attributeList) {
            hashSet.addAll(Util.getTypeList(object.typeId));
        }
        for (Method method : classNode.methodList) {
            hashSet.addAll(Util.getTypeList(method.dataTypeId));
            for (Parameter parameter : method.parameterList) {
                hashSet.addAll(Util.getTypeList(parameter.dataTypeId));
            }
        }
        for (String string : hashSet) {
            ClassNode classNode2 = JavaCodeGenerator.getClassData(Integer.valueOf(string), list);
            if (!PackageManager.isNeedImport(classNode2.packageId) || classNode2.packageId == classNode.packageId) continue;
            String string4 = INPORT_PHRASE;
            string4 = JavaCodeGenerator.replace(string4, "<<packageName>>", classNode2.getPackageName());
            string4 = JavaCodeGenerator.replace(string4, "<<className>>", classNode2.className);
            stringBuffer.append(string4);
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private static String genAttributePhrase(List<Attribute> list, List<ClassNode> list2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Attribute attribute : list) {
            String string = ATTRIBUTE_PHRASE;
            string = JavaCodeGenerator.replace(string, "<<visibility>>", attribute.visibility.code());
            string = JavaCodeGenerator.replace(string, "<<typeName>>", JavaCodeGenerator.getTypeNameByTypeId(attribute.typeId, list2));
            string = JavaCodeGenerator.replace(string, "<<attrName>>", attribute.attributeName);
            stringBuffer.append(string);
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private static String genMethodPhrase(List<Method> list, List<ClassNode> list2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Method method : list) {
            String string = METHOD_START_PHRASE;
            string = JavaCodeGenerator.replace(string, "<<visibility>>", method.visibility.code());
            string = JavaCodeGenerator.replace(string, "<<returnType>>", JavaCodeGenerator.getTypeNameByTypeId(method.dataTypeId, list2));
            string = JavaCodeGenerator.replace(string, "<<methodName>>", method.methodName);
            string = string.replaceAll("<<params>>", JavaCodeGenerator.genParamPhrase(list2, method));
            stringBuffer.append(string);
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append("            // TODO");
            stringBuffer.append(System.getProperty("line.separator"));
            if (!"void".equals(JavaCodeGenerator.getTypeNameByTypeId(method.dataTypeId, list2))) {
                stringBuffer.append("            return null;");
                stringBuffer.append(System.getProperty("line.separator"));
            }
            stringBuffer.append("        }");
            stringBuffer.append(System.getProperty("line.separator"));
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private static String genParamPhrase(List<ClassNode> list, Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Parameter parameter : method.parameterList) {
            String string = PARAM_PHRASE;
            string = JavaCodeGenerator.replace(string, "<<paramType>>", JavaCodeGenerator.getTypeNameByTypeId(parameter.dataTypeId, list));
            string = JavaCodeGenerator.replace(string, "<<paramName>>", parameter.parameterName);
            stringBuffer.append(string);
            if (parameter.equals(method.parameterList.get(method.parameterList.size() - 1))) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private static ClassNode getClassData(int n, List<ClassNode> list) {
        for (ClassNode classNode : list) {
            if (classNode.classId != n) continue;
            return classNode;
        }
        return null;
    }

    private static ArrayList<ClassNode> getAllActiveClassData(List<ClassNode> list) {
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        for (ClassNode classNode : list) {
            if (classNode.delFlag || classNode.isBuiltInClass || classNode.p == null) continue;
            arrayList.add(classNode);
        }
        return arrayList;
    }

    private static String getTypeNameByTypeId(String string, List<ClassNode> list) {
        if (Util.hasSymbol(string)) {
            String string2 = string.replace(SPACE, "");
            List<String> list2 = Util.getTypeList(string2);
            for (String string3 : list2) {
                string2 = string2.replace(string3, JavaCodeGenerator.getClassData((int)Integer.valueOf((String)string3).intValue(), list).className);
            }
            return string2;
        }
        return JavaCodeGenerator.getClassData((int)Integer.valueOf((String)string).intValue(), list).className;
    }

    public static String replace(String string, String string2, String string3) {
        if (string3 == null || string3.length() == 0) {
            return string.replaceAll(string2 + SPACE, "");
        }
        return string.replaceAll(string2, string3);
    }

    public static String replace(String string, Map<String, String> map) {
        String string2 = JavaCodeGenerator.replaceNewLineCharacter(string);
        for (String string3 : map.keySet()) {
            if (map.get(string3) != null && !"".equals(map.get(string3))) {
                string2 = string2.replace(string3, map.get(string3));
                continue;
            }
            string2 = string2.replace(string3 + System.getProperty("line.separator"), "");
            string2 = string2.replace(string3 + SPACE, "");
        }
        return string2;
    }

    public static String replaceNewLineCharacter(String string) {
        return string.replace("\r\n", System.getProperty("line.separator"));
    }
}

