from PyQt4 import QtNetwork
class TinyURLDecoder(QtNetwork.QHttp):
    def __init__(self, parent=None):
        QtNetwork.QHttp.__init__(self, parent)

        self.rxURL = QtCore.QRegExp("(http?:\/\/tinyurl\.com\/[-_.!~*'()a-zA-Z0-9;/?:&=+$,%#]+)")
        self.url = QtCore.QUrl()
        self.setHost("tinyurl.com")
        self.url.setQueryDelimiters("=",";")
        self.decodeURLQueue = []
        self.decodedURLs = []
        self.progressDialog = QtGui.QProgressDialog(
                self.tr("Waiting response from TinyURL..."),
                self.tr("&Cancel"),
                0,
                100,
                form.textBrowser)
        self.progressDialog.setWindowTitle( self.tr("TinyURLDecoder"))
        self.progressDialog.setWindowModality(QtCore.Qt.WindowModal)
        self.connect(self.progressDialog,
                QtCore.SIGNAL("canceled()"),
                self.cancel)
        self.connect(self,
                QtCore.SIGNAL("parseDone"),
                self.queryNext)
        self.connect(self, QtCore.SIGNAL("done(bool)"), self.done)

    def done(self, error):
        self.url.clear()
        print "done"
        if not error and self.lastResponse().statusCode() == 301:
            self.parse()
            self.emit(QtCore.SIGNAL("parseDone"))

    def parse(self):
        print self.lastResponse().toString().toAscii()
        url = QtCore.QString.fromUtf8(self.lastResponse().value ( "Location" ).toAscii())
        self.decodedURLs.append(url)
    def queryEncoding(self, url):
        self.url.setUrl(url)
        return self.get()
    def get(self):
        print self.url.toString()
        return QtNetwork.QHttp.get(self, self.url.toString())

    def decode(self, urls):
        if len(urls) == 0:
            return
        self.decodeURLQueue = urls
        self.progressDialog.setMaximum(len(self.decodeURLQueue))
        self.progressDialog.setValue(0)
        self.progressDialog.show()
        self.queryEncoding(self.decodeURLQueue.pop(0))

    def queryNext(self):
        self.progressDialog.setValue( self.progressDialog.value() + 1)
        if not len(self.decodeURLQueue) == 0:
            self.queryEncoding(self.decodeURLQueue.pop(0))
        else:
            self.applyDecodedURLs()
            self.progressDialog.close()
    def applyDecodedURLs(self):
        str = form.textBrowser.toPlainText()
        retStr = QtCore.QString()
        head = self.rxURL.indexIn(str, 0)
        retStr += str.mid(0, head)
        while True:
            if head == -1:
                break;
            url = self.rxURL.cap()
            retStr += self.decodedURLs.pop(0)
            tail = head + self.rxURL.matchedLength()

            head = self.rxURL.indexIn(str, tail)
            len = head - tail
            if len < -1:
                retStr += str.mid(tail, -1)
            else:
                retStr += str.mid(tail, len)
        form.textBrowser.setHtml(
                form.convertNickTextToLink(
                    form.convetUriToLink( retStr)))
        print form.convertNickTextToLink(
                    form.convetUriToLink( retStr)).toAscii()
        return retStr

    def cancel(self):
        self.abort()
        self.url.clear()
        self.decodedURLs[:] = []
        print "Canceled"

    def decodeAllURL(self):
        str = form.textBrowser.toPlainText()
        pos = self.rxURL.indexIn(str)
        head = self.rxURL.indexIn(str, 0)
        urls = []
        while True:
            if head == -1:
                break;
            urls.append(self.rxURL.cap())
            tail = head + self.rxURL.matchedLength()
            head = self.rxURL.indexIn(str, tail)
            len = head - tail
        self.decode(urls)

tinyURLDecoder = TinyURLDecoder(form)
def tinyURLDecoderPopupMenuEvent(e):
    menu = form.textBrowser.createStandardContextMenu()
    actionTinyURLDecode = QtGui.QAction(
            tinyURLDecoder.tr("Decode all URL by TinyURL"),
            tinyURLDecoder)
    tinyURLDecoder.connect(actionTinyURLDecode,
            QtCore.SIGNAL("triggered()"),
            tinyURLDecoder.decodeAllURL)
    menu.addAction(actionTinyURLDecode)
    menu.exec_(e.globalPos())

form.textBrowser.contextMenuEvent = tinyURLDecoderPopupMenuEvent
