/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.factory;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.Adler32;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderInfo;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageType;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.AbstractRenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.factory.RenderedImageKey;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.image.ImageRenderedImage;
import org.eclipse.swt.graphics.RGB;

public class RenderedImageFactory {
    private static Map<RenderedImageKey, WeakReference<RenderedImage>> instanceMap = new WeakHashMap<RenderedImageKey, WeakReference<RenderedImage>>();
    private static final String E_MODIFIER_FACTORY = "factory";
    private static final String A_CLASS = "class";
    private static List<RenderedImageType> imageTypes = null;

    public static RenderInfo createInfo(int width, int height, boolean maintainAspectRatio, boolean antialias, RGB fill, RGB outline) {
        RenderedImageKey svgInfo = new RenderedImageKey();
        svgInfo.setValues(width, height, maintainAspectRatio, antialias, fill, outline);
        return svgInfo;
    }

    public static RenderedImage getInstance(URL theURL) {
        return RenderedImageFactory.getInstance(theURL, (RenderInfo)new RenderedImageKey());
    }

    public static RenderedImage getInstance(URL theURL, RenderInfo info) {
        try {
            InputStream is = theURL.openStream();
            int size = is.available();
            byte[] buffer = new byte[size];
            is.read(buffer);
            is.close();
            return RenderedImageFactory.getInstance(buffer, info, theURL.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RenderedImage getInstance(byte[] buffer, RenderInfo info, String url) {
        Adler32 checksum = new Adler32();
        checksum.update(buffer);
        RenderedImageKey key = new RenderedImageKey(info, checksum.getValue(), null, url);
        WeakReference<RenderedImage> ref = instanceMap.get(key);
        RenderedImage image = null;
        image = ref != null ? (RenderedImage)instanceMap.get(key).get() : RenderedImageFactory.autodetectImage(buffer, key);
        if (image == null) {
            instanceMap.remove(key);
            image = RenderedImageFactory.getInstance(buffer);
        }
        return image;
    }

    public static RenderedImage getInstance(String szFilePath) {
        return RenderedImageFactory.getInstance(szFilePath, (RenderInfo)new RenderedImageKey());
    }

    public static RenderedImage getInstance(String szFilePath, RenderInfo info) {
        try {
            FileInputStream fis = new FileInputStream(szFilePath);
            int size = fis.available();
            byte[] buffer = new byte[size];
            fis.read(buffer);
            fis.close();
            return RenderedImageFactory.getInstance(buffer, info, szFilePath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RenderedImage getInstance(byte[] buffer) {
        return RenderedImageFactory.getInstance(buffer, (RenderInfo)new RenderedImageKey());
    }

    public static RenderedImage getRelatedInstance(RenderedImage image, RenderInfo info) {
        if (image instanceof AbstractRenderedImage) {
            RenderedImageKey oldKey = ((AbstractRenderedImage)image).getKey();
            Object extraData = oldKey.getExtraData();
            if (info.getBackgroundColor() != null && !info.getBackgroundColor().equals((Object)oldKey.getBackgroundColor())) {
                extraData = null;
            } else if (info.getForegroundColor() != null && !info.getForegroundColor().equals((Object)oldKey.getForegroundColor())) {
                extraData = null;
            }
            RenderedImageKey key = new RenderedImageKey(info, oldKey.getChecksum(), extraData);
            WeakReference<RenderedImage> ref = instanceMap.get(key);
            if (ref != null) {
                return (RenderedImage)ref.get();
            }
            return RenderedImageFactory.autodetectImage(((AbstractRenderedImage)image).getBuffer(), key);
        }
        return null;
    }

    public static RenderedImage getInstance(byte[] buffer, RenderInfo info) {
        if (buffer == null) {
            throw new InvalidParameterException();
        }
        Adler32 checksum = new Adler32();
        checksum.update(buffer);
        RenderedImageKey key = new RenderedImageKey(info, checksum.getValue(), null);
        WeakReference<RenderedImage> ref = instanceMap.get(key);
        RenderedImage image = null;
        image = ref != null ? (RenderedImage)instanceMap.get(key).get() : RenderedImageFactory.autodetectImage(buffer, key);
        if (image == null) {
            instanceMap.remove(key);
            image = RenderedImageFactory.getInstance(buffer);
        }
        return image;
    }

    private static RenderedImage autodetectImage(byte[] buffer, RenderedImageKey key) {
        if (imageTypes == null) {
            imageTypes = new ArrayList<RenderedImageType>();
            IExtensionPoint riExtensionPt = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.gmf.runtime.draw2d.ui.render", "renderedImageFactory");
            IConfigurationElement[] configEls = riExtensionPt.getConfigurationElements();
            int i = 0;
            while (i < configEls.length) {
                IConfigurationElement element = configEls[i];
                if (element.getName().equals(E_MODIFIER_FACTORY)) {
                    RenderedImageType imageType = null;
                    try {
                        imageType = (RenderedImageType)element.createExecutableExtension(A_CLASS);
                        if (imageType != null) {
                            imageTypes.add(imageType);
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
        }
        RenderedImage image = null;
        ListIterator<RenderedImageType> li = imageTypes.listIterator();
        while (li.hasNext()) {
            RenderedImageType imageType = li.next();
            image = imageType.autoDetect(buffer, key);
            if (image != null) break;
        }
        if (image == null) {
            image = new ImageRenderedImage(buffer, key);
        }
        if (image != null) {
            instanceMap.put(key, new WeakReference<ImageRenderedImage>((ImageRenderedImage)image));
        }
        return image;
    }
}

