/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.attributelist;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.generate.internal.HtmlGeneratorUtils;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.generate.Generator;
import jp.sourceforge.tmdmaker.model.generate.GeneratorRuntimeException;
import jp.sourceforge.tmdmaker.model.generate.attributelist.AttributeListModelBuilder;
import jp.sourceforge.tmdmaker.model.generate.attributelist.EntityAttributePair;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeListHtmlGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(AttributeListHtmlGenerator.class);

    public String getGeneratorName() {
        return "\u30a2\u30c8\u30ea\u30d3\u30e5\u30fc\u30c8\u30ea\u30b9\u30c8\u3092HTML\u5f62\u5f0f\u3067\u51fa\u529b";
    }

    public String getGroupName() {
        return "HTML";
    }

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        logger.info("generate");
        VelocityContext context = HtmlGeneratorUtils.getVecityContext();
        try {
            HtmlGeneratorUtils.outputCSS(rootDir);
            HtmlGeneratorUtils.copyStream(AttributeListHtmlGenerator.class.getResourceAsStream("index.html"), new FileOutputStream(new File(rootDir, "attributes_index.html")));
            Map attributes = new AttributeListModelBuilder().build(models);
            context.put("entities", models);
            HtmlGeneratorUtils.applyTemplate("summary.html", this.getClass(), new File(rootDir, "summary.html"), context);
            context.put("attributes", attributes.entrySet());
            HtmlGeneratorUtils.applyTemplate("attribute_list.html", this.getClass(), new File(rootDir, "attribute_list.html"), context);
            File attributesDir = new File(rootDir, "attributes");
            attributesDir.mkdir();
            for (Map.Entry entry : attributes.entrySet()) {
                IAttribute attribute = ((EntityAttributePair)entry.getValue()).getAttribute();
                AbstractEntityModel entity = ((EntityAttributePair)entry.getValue()).getModel();
                context.put("attribute", (Object)attribute);
                context.put("entity", (Object)entity);
                if (entity instanceof Entity) {
                    context.put("entityType", (Object)((Entity)entity).getEntityType().getTypeName());
                } else {
                    context.remove((Object)"entityType");
                }
                HtmlGeneratorUtils.applyTemplate("attribute.html", this.getClass(), new File(attributesDir, String.valueOf(((EntityAttributePair)entry.getValue()).createAttributeFileKey()) + ".html"), context);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
    }

    public boolean isImplementModelOnly() {
        return false;
    }
}

