/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d.figure.relationship;

import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Cardinality;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class RelationshipFigure
extends PolylineConnection {
    private Figure sourceZeroCardinaliryFigure;
    private Figure targetZeroCardinaliryFigure;
    private Ellipse centerDecoration;
    private static final int LINE_WIDTH = 1;

    public RelationshipFigure() {
        this.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
        this.setLineWidth(1);
    }

    public void update(AbstractRelationship model) {
        this.createSourceDecoration(model.getSourceCardinality().equals((Object)Cardinality.MANY));
        if (model.isSourceNoInstance()) {
            this.createSourceZeroCardinalityDecoration();
        } else {
            this.removeSourceZeroCardinalityDecoration();
        }
        this.createTargetDecoration(model.getTargetCardinality().equals((Object)Cardinality.MANY));
        if (model.isTargetNoInstance()) {
            this.createTargetZeroCardinalityDecoration();
        } else {
            this.removeTargetZeroCardinalityDecoration();
        }
        if (model.isCenterMark()) {
            this.createCenterDecoration();
        } else {
            this.removeCenterDecoration();
        }
    }

    private void createCenterDecoration() {
        this.removeCenterDecoration();
        this.centerDecoration = new Ellipse();
        this.centerDecoration.setFill(false);
        this.centerDecoration.setBounds(new Rectangle(-1, -1, 15, 15));
        this.centerDecoration.setLineWidth(1);
        MidpointLocator locator = new MidpointLocator((Connection)this, 1);
        this.add((IFigure)this.centerDecoration, locator);
    }

    private void removeCenterDecoration() {
        if (this.centerDecoration != null) {
            this.remove((IFigure)this.centerDecoration);
            this.centerDecoration = null;
        }
    }

    private void createSourceDecoration(boolean souceCardinarityMany) {
        RotatableDecoration decoration = null;
        decoration = souceCardinarityMany ? this.createCardinarityManyDecoration() : this.createCardinalityOneDecoration();
        this.setSourceDecoration(decoration);
    }

    private void createTargetDecoration(boolean targetCardinarityMany) {
        RotatableDecoration decoration = null;
        decoration = targetCardinarityMany ? this.createCardinarityManyDecoration() : this.createCardinalityOneDecoration();
        this.setTargetDecoration(decoration);
    }

    private void createSourceZeroCardinalityDecoration() {
        this.removeSourceZeroCardinalityDecoration();
        this.sourceZeroCardinaliryFigure = this.createZeroCardinalityFigure();
        this.createZeroCardinaliryDecoration(this.sourceZeroCardinaliryFigure, false);
    }

    private void removeSourceZeroCardinalityDecoration() {
        if (this.sourceZeroCardinaliryFigure != null) {
            this.remove((IFigure)this.sourceZeroCardinaliryFigure);
            this.sourceZeroCardinaliryFigure = null;
        }
    }

    public void createTargetZeroCardinalityDecoration() {
        this.removeTargetZeroCardinalityDecoration();
        this.targetZeroCardinaliryFigure = this.createZeroCardinalityFigure();
        this.createZeroCardinaliryDecoration(this.targetZeroCardinaliryFigure, true);
    }

    public void removeTargetZeroCardinalityDecoration() {
        if (this.targetZeroCardinaliryFigure != null) {
            this.remove((IFigure)this.targetZeroCardinaliryFigure);
            this.targetZeroCardinaliryFigure = null;
        }
    }

    private void createZeroCardinaliryDecoration(Figure figure, boolean isEnd) {
        ConnectionEndpointLocator locator = new ConnectionEndpointLocator((Connection)this, isEnd);
        locator.setUDistance(8);
        locator.setVDistance(0);
        this.add((IFigure)figure, locator);
    }

    private RotatableDecoration createCardinarityManyDecoration() {
        PointList manyPointList = new PointList();
        manyPointList.addPoint(0, 2);
        manyPointList.addPoint(-1, 0);
        manyPointList.addPoint(0, -2);
        PolylineDecoration decoration = new PolylineDecoration();
        decoration.setTemplate(manyPointList);
        return decoration;
    }

    private RotatableDecoration createCardinalityOneDecoration() {
        PointList onePointList = new PointList();
        onePointList.addPoint(-1, 2);
        onePointList.addPoint(-1, -2);
        PolylineDecoration decoration = new PolylineDecoration();
        decoration.setTemplate(onePointList);
        return decoration;
    }

    private Figure createZeroCardinalityFigure() {
        Ellipse figure = new Ellipse();
        figure.setFill(false);
        figure.setBounds(new Rectangle(-1, -1, 8, 8));
        return figure;
    }
}

