/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.actions;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractSubsetType;
import jp.sourceforge.tmdmaker.ui.actions.AbstractEntitySelectionAction;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.ui.editor.gef3.editparts.node.AbstractSubsetTypeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class SubsetTypeTurnAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_SUBSETTYPE";

    public SubsetTypeTurnAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.RotateSubsetType);
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1) {
            Object selection = this.getSelectedObjects().get(0);
            return selection instanceof AbstractSubsetTypeEditPart;
        }
        return false;
    }

    public void run() {
        AbstractModelEditPart<? extends AbstractEntityModel> part = this.getPart();
        AbstractSubsetType model = (AbstractSubsetType)part.getModel();
        this.execute(new SubsetTypeChangeCommand(model));
    }

    private static class SubsetTypeChangeCommand
    extends Command {
        private AbstractSubsetType<?> model;
        private boolean oldVertical;
        private boolean newVertical;

        public SubsetTypeChangeCommand(AbstractSubsetType<?> model) {
            this.model = model;
            this.oldVertical = model.isVertical();
            this.newVertical = !this.oldVertical;
        }

        public void execute() {
            this.model.setVertical(this.newVertical);
        }

        public void undo() {
            this.model.setVertical(this.oldVertical);
        }
    }
}

