/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import jp.sourceforge.tmdmaker.dialog.AttributeDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditEntity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.rule.EntityRecognitionRule;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EntityNameAndIdentifierNameAndTypeSettingPanel
extends Composite {
    private EditEntity entity;
    private Label identifierLabel = null;
    private Text identifierText = null;
    private Label typeLabel = null;
    private Combo typeCombo = null;
    private Button nameAutoCreateCheckBox = null;
    private Label nameLabel = null;
    private Text nameText = null;
    private Button descButton = null;

    public EntityNameAndIdentifierNameAndTypeSettingPanel(Composite parent, int style) {
        super(parent, 0);
        this.initialize();
        this.nameAutoCreateCheckBox.setSelection(true);
        this.nameText.setEnabled(false);
        this.typeCombo.select(0);
    }

    public EntityNameAndIdentifierNameAndTypeSettingPanel(Composite parent, int style, EditEntity entity) {
        super(parent, style);
        this.entity = entity;
        this.initialize();
    }

    public void updateValue() {
        String identifierName = this.entity.getEditIdentifier().getName();
        String entityName = this.entity.getName();
        this.selectAutoCreateCheckBox(identifierName, entityName);
        this.identifierText.setText(identifierName);
        if (!this.nameAutoCreateCheckBox.getSelection()) {
            this.nameText.setText(entityName);
        }
        this.selectEntityTypeCombo(this.entity.getType());
        this.typeCombo.setEnabled(this.entity.isEntityTypeEditable());
    }

    private void selectAutoCreateCheckBox(String identifierName, String entityName) {
        String autoCreateEntityName = this.createEntityName(identifierName);
        if (autoCreateEntityName.equals(entityName)) {
            this.nameAutoCreateCheckBox.setSelection(true);
            this.nameText.setEnabled(false);
        } else {
            this.nameAutoCreateCheckBox.setSelection(false);
            this.nameText.setEnabled(true);
        }
    }

    private void selectEntityTypeCombo(EntityType type) {
        if (EntityType.RESOURCE.equals((Object)type)) {
            this.typeCombo.select(0);
        } else if (EntityType.EVENT.equals((Object)type)) {
            this.typeCombo.select(1);
        } else {
            this.typeCombo.select(2);
        }
    }

    private void initialize() {
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 0x1000000;
        gridData10.verticalAlignment = 2;
        GridData gridData9 = new GridData();
        gridData9.horizontalSpan = 2;
        GridData gridData1 = new GridData();
        gridData1.verticalAlignment = 2;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = -1;
        gridData.verticalAlignment = 2;
        this.nameAutoCreateCheckBox = new Button((Composite)this, 32);
        this.nameAutoCreateCheckBox.setText("\u500b\u4f53\u6307\u5b9a\u5b50\u304b\u3089\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u540d\u7b49\u3092\u81ea\u52d5\u751f\u6210");
        this.nameAutoCreateCheckBox.setLayoutData((Object)gridData9);
        this.typeLabel = new Label((Composite)this, 0);
        this.typeLabel.setText("\u985e\u5225");
        this.typeLabel.setLayoutData((Object)gridData10);
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText("\u30a8\u30f3\u30c6\u30a3\u30c6\u30a3\u540d");
        this.nameText = new Text((Composite)this, 2048);
        this.nameText.setLayoutData((Object)gridData1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                System.out.println("nameText#modifyText()");
                Text t = (Text)e.widget;
                EntityNameAndIdentifierNameAndTypeSettingPanel.this.entity.setName(t.getText());
            }
        });
        this.createTypeCombo();
        this.nameAutoCreateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                if (b.getSelection()) {
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.nameText.setEnabled(false);
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.nameText.setText(EntityNameAndIdentifierNameAndTypeSettingPanel.this.createEntityName(EntityNameAndIdentifierNameAndTypeSettingPanel.this.identifierText.getText()));
                } else {
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.nameText.setEnabled(true);
                }
            }
        });
        this.identifierLabel = new Label((Composite)this, 0);
        this.identifierLabel.setText("\u500b\u4f53\u6307\u5b9a\u5b50");
        this.identifierText = new Text((Composite)this, 2048);
        this.identifierText.setLayoutData((Object)gridData);
        this.identifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                System.out.println("identifierText#modifyText()");
                Text t = (Text)e.widget;
                EntityNameAndIdentifierNameAndTypeSettingPanel.this.entity.setIdentifierName(t.getText());
                if (EntityNameAndIdentifierNameAndTypeSettingPanel.this.nameAutoCreateCheckBox.getSelection()) {
                    String oldName = EntityNameAndIdentifierNameAndTypeSettingPanel.this.nameText.getText();
                    String newName = EntityNameAndIdentifierNameAndTypeSettingPanel.this.createEntityName(t.getText());
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.nameText.setText(newName);
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.entity.updateTypeAttribute(oldName, newName);
                }
            }
        });
        this.descButton = new Button((Composite)this, 0);
        this.descButton.setText("\u8a73\u7d30");
        this.descButton.setLayoutData((Object)gridData11);
        this.descButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAttribute edited;
                AttributeDialog dialog = new AttributeDialog(EntityNameAndIdentifierNameAndTypeSettingPanel.this.getShell(), EntityNameAndIdentifierNameAndTypeSettingPanel.this.entity.getEditIdentifier());
                if (dialog.open() == 0 && (edited = dialog.getEditedValue()).isEdited()) {
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.entity.updateEditIdentifier(edited);
                    EntityNameAndIdentifierNameAndTypeSettingPanel.this.identifierText.setText(edited.getName());
                }
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 5;
        this.updateValue();
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(372, 88));
    }

    private void createTypeCombo() {
        this.typeCombo = new Combo((Composite)this, 8);
        this.typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EntityNameAndIdentifierNameAndTypeSettingPanel.this.entity.setType(EntityNameAndIdentifierNameAndTypeSettingPanel.this.getSelectedType());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.typeCombo.add("\u30ea\u30bd\u30fc\u30b9");
        this.typeCombo.add("\u30a4\u30d9\u30f3\u30c8");
        if (this.entity.isLatuta()) {
            this.typeCombo.add("\u4e0d\u660e");
        }
    }

    private String createEntityName(String identifierName) {
        return EntityRecognitionRule.getInstance().generateEntityNameFromIdentifier(identifierName);
    }

    private EntityType getSelectedType() {
        int selection = this.typeCombo.getSelectionIndex();
        if (selection == 0) {
            return EntityType.RESOURCE;
        }
        if (selection == 1) {
            return EntityType.EVENT;
        }
        return EntityType.LAPUTA;
    }
}

