/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.preferences.appearance;

import jp.sourceforge.tmdmaker.ui.preferences.IPreferenceListener;
import jp.sourceforge.tmdmaker.ui.setting.AppearanceSetting;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class AppearancePreferenceListener
implements IPreferenceListener {
    public void propertyChange(PropertyChangeEvent event) {
        AppearanceSetting config = AppearanceSetting.getInstance();
        if (event.getProperty().equals("resourceEntityColorPreference")) {
            config.setResorceRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("eventEntityColorPreference")) {
            config.setEventRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("combinationTableColorPreference")) {
            config.setCombinationTableRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("mappingListColorPreference")) {
            config.setMappingListRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("recursiveTableColorPreference")) {
            config.setRecursiveTableRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("resourceSubsetColorPreference")) {
            config.setResourceSubsetRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("eventSubsetColorPreference")) {
            config.setEventSubsetRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("virtualEntityColorPreference")) {
            config.setVirtualEntityRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("supersetColorPreference")) {
            config.setSupersetRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("multivalueOrColorPreference")) {
            config.setMultivalueOrRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("laputaColorPreference")) {
            config.setLaputaRGB(this.convertRGBIfNeed(event.getNewValue()));
        } else if (event.getProperty().equals("entityColorEnablePreference")) {
            System.out.println("P_ENTITY_COLOR_ENABLED");
            config.setColorEnabled(this.convertBooleanIfNeed(event.getNewValue()));
        }
    }

    private RGB convertRGBIfNeed(Object value) {
        if (value instanceof RGB) {
            return (RGB)value;
        }
        return StringConverter.asRGB((String)((String)value));
    }

    private boolean convertBooleanIfNeed(Object value) {
        System.out.println(value);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return StringConverter.asBoolean((String)((String)value));
    }

    @Override
    public void preferenceStart(IPreferenceStore store) {
        AppearanceSetting config = AppearanceSetting.getInstance();
        config.setResorceRGB(StringConverter.asRGB((String)store.getString("resourceEntityColorPreference")));
        config.setEventRGB(StringConverter.asRGB((String)store.getString("eventEntityColorPreference")));
        config.setCombinationTableRGB(StringConverter.asRGB((String)store.getString("combinationTableColorPreference")));
        config.setMappingListRGB(StringConverter.asRGB((String)store.getString("mappingListColorPreference")));
        config.setRecursiveTableRGB(StringConverter.asRGB((String)store.getString("recursiveTableColorPreference")));
        config.setResourceSubsetRGB(StringConverter.asRGB((String)store.getString("resourceSubsetColorPreference")));
        config.setEventSubsetRGB(StringConverter.asRGB((String)store.getString("eventSubsetColorPreference")));
        config.setMultivalueOrRGB(StringConverter.asRGB((String)store.getString("multivalueOrColorPreference")));
        config.setVirtualEntityRGB(StringConverter.asRGB((String)store.getString("virtualEntityColorPreference")));
        String colorString = store.getString("supersetColorPreference");
        config.setSupersetRGB(StringConverter.asRGB((String)colorString));
        config.setLaputaRGB(StringConverter.asRGB((String)store.getString("laputaColorPreference")));
        config.setColorEnabled(store.getBoolean("entityColorEnablePreference"));
    }
}

