/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.TableEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.model.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.setting.AppearanceSetting;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.swt.graphics.Color;

public class RecursiveTableEditPart
extends AbstractEntityEditPart {
    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        RecursiveTable table = (RecursiveTable)this.getModel();
        entityFigure.setNotImplement(table.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(table.getName());
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> rk : table.getReusedIdentifieres().entrySet()) {
            for (Identifier identifier : rk.getValue().getIdentifires()) {
                entityFigure.addRelationship(identifier.getName());
            }
        }
        if (AppearanceSetting.getInstance().isColorEnabled()) {
            entityFigure.setBackgroundColor(new Color(null, AppearanceSetting.getInstance().getRecursiveTableRGB()));
        } else {
            entityFigure.setBackgroundColor(ColorConstants.white);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RecursiveTableComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        RecursiveTable table = (RecursiveTable)this.getModel();
        TableEditDialog dialog = new TableEditDialog(this.getViewer().getControl().getShell(), "\u518d\u5e30\u8868\u7de8\u96c6", table);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, table, editAttributeList);
            ModelEditCommand command = new ModelEditCommand(table, dialog.getEditedValue());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    private static class RecursiveTableComponentEditPolicy
    extends ComponentEditPolicy {
        private RecursiveTableComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            RecursiveTable model = (RecursiveTable)this.getHost().getModel();
            return new TableDeleteCommand(model, model.getModelTargetConnections().get(0));
        }
    }
}

