package jp.terasoluna.fw.collector.util;

import static org.junit.Assert.*;

import java.util.NoSuchElementException;

import jp.terasoluna.fw.collector.AbstractCollector;
import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.CollectorExceptionHandlerStub1;
import jp.terasoluna.fw.collector.CollectorExceptionHandlerStub2;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandlerStatus;
import jp.terasoluna.fw.collector.validate.ExceptionValidationErrorHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorException;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.file.dao.FileLineException;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/**
 * RN^ƃRg[uCN̑gݍ킹B 
 * @\ɊY邪AJUnitł\ł邱ƁA gݍ킹̃p^[ɂ킽邱ƂA JUnit̎ƂB
 */
public class ControlBreakCheckerTest2 {

    /**
     * uCNL[̃J
     */
    private static final String BREAK_KEY = "column1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * Rg[uCNƑgݍ킹̃eXgB<br>
     * BUG_B30020̋B
     * <p>
     * <ul>
     * <li>OnhȂ(̂܂܃G[X[)</li>
     * </ul>
     * Ғl͈ȉ̒ʂ
     * ̓f[^F[1(bkv1), 2(bkv1), 3(bkv1), (O), 5(bkv2), 6(bkv2), 7(bkv3), 
     * (O), 9(bkv3), 10(bkv4), 11(bkv4), (O),
     * 13(bkv5), 14(bkv5), 15(bkv5)]
     * ʁF[1(1), 2, 3(4), (O)(24), 5(2), 6(3), 7(14), 
     * (O)(24), 9(23), 10(1), 11(4), (O)(24), 13(2), 14, 15(3)]
     * 1:OuCN 2:OuCNs\(OuCN莞ɗOX[)
     * 3:uCN 4:uCNs\(uCN莞ɗOX[)
     */
    @Test
    public void testDefaultHandler001() throws Exception {

        ControlBreakCheckerTestBean bean01 = new ControlBreakCheckerTestBean("aaa", "1", "1");
        ControlBreakCheckerTestBean bean02 = new ControlBreakCheckerTestBean("aaa", "2", "1");
        ControlBreakCheckerTestBean bean03 = new ControlBreakCheckerTestBean("aaa", "3", "1");
        ControlBreakCheckerTestBean bean04 = new ControlBreakCheckerTestBean("bbb", "4", "Exception");
        ControlBreakCheckerTestBean bean05 = new ControlBreakCheckerTestBean("bbb", "5", "1");
        ControlBreakCheckerTestBean bean06 = new ControlBreakCheckerTestBean("bbb", "6", "1");
        ControlBreakCheckerTestBean bean07 = new ControlBreakCheckerTestBean("ccc", "7", "1");
        ControlBreakCheckerTestBean bean08 = new ControlBreakCheckerTestBean("ccc", "8", "Exception");
        ControlBreakCheckerTestBean bean09 = new ControlBreakCheckerTestBean("ccc", "9", "1");
        ControlBreakCheckerTestBean bean10 = new ControlBreakCheckerTestBean("ddd", "10", "1");
        ControlBreakCheckerTestBean bean11 = new ControlBreakCheckerTestBean("ddd", "11", "1");
        ControlBreakCheckerTestBean bean12 = new ControlBreakCheckerTestBean("ddd", "12", "Exception");
        ControlBreakCheckerTestBean bean13 = new ControlBreakCheckerTestBean("eee", "13", "1");
        ControlBreakCheckerTestBean bean14 = new ControlBreakCheckerTestBean("eee", "14", "1");
        ControlBreakCheckerTestBean bean15 = new ControlBreakCheckerTestBean("eee", "15", "1");
        ControlBreakCheckerTestBean[] beans = { bean01, bean02, bean03, bean04,
                bean05, bean06, bean07, bean08, bean09, bean10, bean11, bean12,
                bean13, bean14, bean15 };

        // E̓`FbNG[nhFȂ
        ValidationErrorHandler argValidationErrorHandler = null;
        // OnhFȂ
        CollectorExceptionHandler argExceptionHandler = null;
        Collector<ControlBreakCheckerTestBean> collector = createTestCollector(
                argValidationErrorHandler, argExceptionHandler, beans);

        // ####################1vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################2vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        // ####################3vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=(G[)
        try {
            ControlBreakChecker.isBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            assertEquals("̓G[", e.getMessage());
        }

        // ####################4vf(O)####################
        try {
            collector.next();
            fail();
        } catch (FileLineException e) {
            // |C^i߂
        }
        try {
            ControlBreakChecker.isPreBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            // OuCNs\
        }
        try {
            ControlBreakChecker.isBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            // uCNs\
        }
        // ####################5vf####################
        assertTrue(collector.hasNext());
        collector.next();
        // OuCN=(G[)
        try {
            ControlBreakChecker.isPreBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            assertEquals("̓G[", e.getMessage());
        }

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################6vf####################
        assertTrue(collector.hasNext());
        collector.next();
        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("bbb", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################7vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("ccc", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=(G[)
        try {
            ControlBreakChecker.isBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            assertEquals("̓G[", e.getMessage());
        }
        // ####################8vf̓G[####################
        try {
            collector.next();
            fail();
        } catch (FileLineException e) {
            // |C^i߂
        }
        try {
            ControlBreakChecker.isPreBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            // OuCNs\
        }
        try {
            ControlBreakChecker.isBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            // uCNs\
        }
        // ####################9vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=(G[)
        try {
            ControlBreakChecker.isPreBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            assertEquals("̓G[", e.getMessage());
        }

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("ccc", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################10vf####################
        assertTrue(collector.hasNext());
        collector.next();
        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("ddd", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################11vf####################
        assertTrue(collector.hasNext());
        collector.next();
        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=(G[)
        try {
            ControlBreakChecker.isBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            assertEquals("̓G[", e.getMessage());
        }

        // ####################12vf̓G[####################
        try {
            collector.next();
            fail();
        } catch (FileLineException e) {
            // |C^i߂
        }
        try {
            ControlBreakChecker.isPreBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            // OuCNs\
        }
        try {
            ControlBreakChecker.isBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            // uCNs\
        }
        // ####################13vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=(G[)
        try {
            ControlBreakChecker.isPreBreak(collector, BREAK_KEY);
            fail();
        } catch (FileLineException e) {
            assertEquals("̓G[", e.getMessage());
        }
        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################14vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################15vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("eee", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        collector.close();
    }

    /**
     * Rg[uCNƑgݍ킹̃eXgB<br>
     * BUG_B30020̋B
     * <p>
     * <ul>
     * <li>Onh(END)</li>
     * <li>̓f[^̃uCNOŗOEND</li>
     * </ul>
     * Ғl͈ȉ̒ʂ
     * ̓f[^F[1(bkv1), 2(bkv1), (O), 4(bkv2)]
     * ʁF[1(1), 2(3)]
     * 1:OuCN 2:OuCNs\(OuCN莞ɗOX[)
     * 3:uCN 4:uCNs\(uCN莞ɗOX[)
     */
    @Test
    public void testErrorHandlerReturnsEnd001() throws Exception {
        ControlBreakCheckerTestBean bean01 = new ControlBreakCheckerTestBean("aaa", "1", "1");
        ControlBreakCheckerTestBean bean02 = new ControlBreakCheckerTestBean("aaa", "2", "1");
        ControlBreakCheckerTestBean bean03 = new ControlBreakCheckerTestBean("aaa", "3", "Exception"); // O
        ControlBreakCheckerTestBean bean04 = new ControlBreakCheckerTestBean("bbb", "4", "1");

        ControlBreakCheckerTestBean[] beans = { bean01, bean02, bean03, bean04 };

        // E̓`FbNG[nhFȂ
        ValidationErrorHandler argValidationErrorHandler = null;
        // OnhF(ENDԂ)
        CollectorExceptionHandler argExceptionHandler = new CollectorExceptionHandlerStub1();
        Collector<ControlBreakCheckerTestBean> collector = createTestCollector(
                argValidationErrorHandler, argExceptionHandler, beans);

        // ####################1vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################2vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################3vf####################
        try {
            collector.next();
            fail();
        } catch (NoSuchElementException e) {
        }

        collector.close();
    }

    /**
     * Rg[uCNƑgݍ킹̃eXgB<br>
     * BUG_B30020̋B
     * <p>
     * <ul>
     * <li>Onh(END)</li>
     * <li>̓f[^̃uCNŗOEND</li>
     * </ul>
     * Ғl͈ȉ̒ʂ
     * ̓f[^F[1(bkv1), 2(bkv1), 3(bkv1), (O), 5(bkv2)]
     * ʁF[1(1), 2, 3(3)]
     * 1:OuCN 2:OuCNs\(OuCN莞ɗOX[)
     * 3:uCN 4:uCNs\(uCN莞ɗOX[)
     */
    @Test
    public void testErrorHandlerReturnsEnd002() throws Exception {
        ControlBreakCheckerTestBean bean01 = new ControlBreakCheckerTestBean("aaa", "1", "1");
        ControlBreakCheckerTestBean bean02 = new ControlBreakCheckerTestBean("aaa", "2", "1");
        ControlBreakCheckerTestBean bean03 = new ControlBreakCheckerTestBean("aaa", "3", "1");
        ControlBreakCheckerTestBean bean04 = new ControlBreakCheckerTestBean("bbb", "4", "Exception"); // O
        ControlBreakCheckerTestBean bean05 = new ControlBreakCheckerTestBean("bbb", "5", "1");

        ControlBreakCheckerTestBean[] beans = { bean01, bean02, bean03, bean04,
                bean05 };

        // E̓`FbNG[nhFȂ
        ValidationErrorHandler argValidationErrorHandler = null;
        // OnhF(ENDԂ)
        CollectorExceptionHandler argExceptionHandler = new CollectorExceptionHandlerStub1();
        Collector<ControlBreakCheckerTestBean> collector = createTestCollector(
                argValidationErrorHandler, argExceptionHandler, beans);

        // ####################1vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################2vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################3vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################4vf####################
        try {
            collector.next();
            fail();
        } catch (NoSuchElementException e) {
        }

        collector.close();
    }

    /**
     * Rg[uCNƑgݍ킹̃eXgB<br>
     * BUG_B30020̋B
     * <p>
     * <ul>
     * <li>Onh(SKIP)</li>
     * <li>uCNɗO(uCN\)</li>
     * </ul>
     * Ғl͈ȉ̒ʂ
     * ̓f[^F[1(bkv1), 2(bkv1), (O), 4(bkv1), 5(bkv1), (O), 7(bkv2), 8(bkv2), (O), 10(bkv3), 11(bkv3), (O)]
     * ʁF[1(1), 2, 4, 5(3), 7(1), 8(3), 10(1), 11(3)]
     * 1:OuCN 2:OuCNs\(OuCN莞ɗOX[)
     * 3:uCN 4:uCNs\(uCN莞ɗOX[)
     */
    @Test
    public void testErrorHandlerReturnsSkip001() throws Exception {
        ControlBreakCheckerTestBean bean01 = new ControlBreakCheckerTestBean("aaa", "1", "1");
        ControlBreakCheckerTestBean bean02 = new ControlBreakCheckerTestBean("aaa", "2", "1");
        ControlBreakCheckerTestBean bean03 = new ControlBreakCheckerTestBean("aaa", "3", "Exception");
        ControlBreakCheckerTestBean bean04 = new ControlBreakCheckerTestBean("aaa", "4", "1");
        ControlBreakCheckerTestBean bean05 = new ControlBreakCheckerTestBean("aaa", "5", "1");
        ControlBreakCheckerTestBean bean06 = new ControlBreakCheckerTestBean("aaa", "6", "Exception");
        ControlBreakCheckerTestBean bean07 = new ControlBreakCheckerTestBean("bbb", "7", "1");
        ControlBreakCheckerTestBean bean08 = new ControlBreakCheckerTestBean("bbb", "8", "1");
        ControlBreakCheckerTestBean bean09 = new ControlBreakCheckerTestBean("ccc", "9", "Exception");
        ControlBreakCheckerTestBean bean10 = new ControlBreakCheckerTestBean("ccc", "10", "1");
        ControlBreakCheckerTestBean bean11 = new ControlBreakCheckerTestBean("ccc", "11", "1");
        ControlBreakCheckerTestBean bean12 = new ControlBreakCheckerTestBean("ccc", "12", "Exception");

        ControlBreakCheckerTestBean[] beans = { bean01, bean02, bean03, bean04,
                bean05, bean06, bean07, bean08, bean09, bean10, bean11, bean12 };

        // E̓`FbNG[nhFȂ
        ValidationErrorHandler argValidationErrorHandler = null;
        // OnhF(SKIPԂ)
        CollectorExceptionHandler argExceptionHandler = new CollectorExceptionHandlerStub2(CollectorExceptionHandlerStatus.SKIP);
        Collector<ControlBreakCheckerTestBean> collector = createTestCollector(
                argValidationErrorHandler, argExceptionHandler, beans);

        // ####################1vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################2vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################3vf####################
        // ####################4vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################5vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################6vf####################
        // ####################7vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("bbb", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################8vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("bbb", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################9vf####################
        // ####################10vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("ccc", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################11vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("ccc", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################12vf####################
        collector.close();
    }

    /**
     * Rg[uCNƑgݍ킹̃eXgB<br>
     * BUG_B30019̋B
     * <p>
     * <ul>
     * <li>̓`FbNG[nh(̂܂ܗOX[)</li>
     * </ul>
     * Ғl͈ȉ̒ʂ
     * ̓f[^F[1(bkv1), 2(bkv1), 3(bkv1), 4(̓`FbNG[)(bkv2), 5(bkv2), 6(bkv2), 7(bkv3), 
     * 8(̓`FbNG[)(bkv3), 9(bkv3), 10(bkv4), 11(bkv4), 12(̓`FbNG[)(bkv4), 13(bkv5), 14(bkv5), 15(bkv5)]
     * ʁF[1(1), 2, 3(3), 4(̓`FbNG[)(1), 5, 6(3), 7(1),
     * 8(̓`FbNG[), 9(3), 10(1), 11, 12(̓`FbNG[)(3), 13(1), 14, 15(3)]
     * 1:OuCN 2:OuCNs\(OuCN莞ɗOX[)
     * 3:uCN 4:uCNs\(uCN莞ɗOX[)
     */
    @Test
    public void testValidateErrorHandler001() throws Exception {

        ControlBreakCheckerTestBean bean01 = new ControlBreakCheckerTestBean("aaa", "1", "1");
        ControlBreakCheckerTestBean bean02 = new ControlBreakCheckerTestBean("aaa", "2", "1");
        ControlBreakCheckerTestBean bean03 = new ControlBreakCheckerTestBean("aaa", "3", "1");
        ControlBreakCheckerTestBean bean04 = new ControlBreakCheckerTestBean("bbb", "4", "validateError");
        ControlBreakCheckerTestBean bean05 = new ControlBreakCheckerTestBean("bbb", "5", "1");
        ControlBreakCheckerTestBean bean06 = new ControlBreakCheckerTestBean("bbb", "6", "1");
        ControlBreakCheckerTestBean bean07 = new ControlBreakCheckerTestBean("ccc", "7", "1");
        ControlBreakCheckerTestBean bean08 = new ControlBreakCheckerTestBean("ccc", "8", "validateError");
        ControlBreakCheckerTestBean bean09 = new ControlBreakCheckerTestBean("ccc", "9", "1");
        ControlBreakCheckerTestBean bean10 = new ControlBreakCheckerTestBean("ddd", "10", "1");
        ControlBreakCheckerTestBean bean11 = new ControlBreakCheckerTestBean("ddd", "11", "1");
        ControlBreakCheckerTestBean bean12 = new ControlBreakCheckerTestBean("ddd", "12", "validateError");
        ControlBreakCheckerTestBean bean13 = new ControlBreakCheckerTestBean("eee", "13", "1");
        ControlBreakCheckerTestBean bean14 = new ControlBreakCheckerTestBean("eee", "14", "1");
        ControlBreakCheckerTestBean bean15 = new ControlBreakCheckerTestBean("eee", "15", "1");
        ControlBreakCheckerTestBean[] beans = { bean01, bean02, bean03, bean04,
                bean05, bean06, bean07, bean08, bean09, bean10, bean11, bean12,
                bean13, bean14, bean15 };

        // E̓`FbNG[nhF
        ValidationErrorHandler argValidationErrorHandler = new ExceptionValidationErrorHandler();
        // OnhFȂ
        CollectorExceptionHandler argExceptionHandler = null;
        Collector<ControlBreakCheckerTestBean> collector = createTestCollector(
                argValidationErrorHandler, argExceptionHandler, beans);

        // ####################1vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################2vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################3vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("aaa", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################4vf####################
        try {
            collector.next();
            fail();
        } catch (ValidationErrorException e) {
            // |C^i߂
        }

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("bbb", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################5vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################6vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("bbb", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################7vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("ccc", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################8vf####################
        try {
            collector.next();
            fail();
        } catch (ValidationErrorException e) {
            // |C^i߂
        }

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################9vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("ccc", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################10vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("ddd", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################11vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################12vf####################
        try {
            collector.next();
            fail();
        } catch (ValidationErrorException e) {
            // |C^i߂
        }

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("ddd", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // ####################13vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=TRUE
        assertTrue(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));
        assertEquals("eee", ControlBreakChecker.getPreBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################14vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=FALSE
        assertFalse(ControlBreakChecker.isBreak(collector, BREAK_KEY));

        // ####################15vf####################
        assertTrue(collector.hasNext());
        collector.next();

        // OuCN=FALSE
        assertFalse(ControlBreakChecker.isPreBreak(collector, BREAK_KEY));

        // uCN=TRUE
        assertTrue(ControlBreakChecker.isBreak(collector, BREAK_KEY));
        assertEquals("eee", ControlBreakChecker.getBreakKey(collector,
                BREAK_KEY).get(BREAK_KEY));

        collector.close();
    }

    /**
     * eXgf[^񋟂RN^𐶐B 
     * Validator@\ACollectorTestBeani[łB
     * CollectorTestBean1column3"validateError"Ɠ̓`FbNG[ƂȂ
     * "Exception"Ɠ̓G[B
     * @param argValidationErrorHandler ValidationErrorHandler
     * @param argExceptionHandler ExceptionHandler
     * @param CollectorTestBean[] beans RN^̒gɂȂCollectorTestBean1̔z
     * @return eXgf[^񋟂RN^
     */
    private static Collector<ControlBreakCheckerTestBean> createTestCollector(
            final ValidationErrorHandler argValidationErrorHandler,
            final CollectorExceptionHandler argExceptionHandler,
            final ControlBreakCheckerTestBean[] beans) {
        Collector<ControlBreakCheckerTestBean> collector = new AbstractCollector<ControlBreakCheckerTestBean>() {
            {
                this.validator = new Validator() {

                    // ̓`FbNsBcolumn3"validateError"̏ꍇ͓̓`FbNG[ƂB
                    public void validate(Object target, Errors errors) {
                        ControlBreakCheckerTestBean data = (ControlBreakCheckerTestBean) target;
                        if ("validateError".equals(data.getColumn3())) {
                            errors.rejectValue("column3", "errors.numeric");
                        }
                    }

                    public boolean supports(Class<?> clazz) {
                        return (clazz == ControlBreakCheckerTestBean.class);
                    }
                };
                this.validationErrorHandler = argValidationErrorHandler;
                this.exceptionHandler = argExceptionHandler;
            }

            // column3"Exception"FileLineExceptioni̓G[jƂƂɂ
            public Integer call() throws Exception {

                for (int count = 0; count < beans.length; count++) {
                    if ("Exception".equals(beans[count].getColumn3())) {
                        addQueue(new DataValueObject(new FileLineException("̓G["), count));
                    } else {
                        addQueue(new DataValueObject(beans[count], count));
                    }
                }

                setFinish();
                return 0;
            }

        };

        return collector;

    }

}
