/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.transaction.util;

import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.expectLastCall;
import static org.easymock.EasyMock.replay;
import static org.easymock.EasyMock.verify;

import java.lang.reflect.Method;

import junit.framework.TestCase;

import org.springframework.aop.framework.ProxyFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.SimpleTransactionStatus;

/**
 * TransactionUtil ubN{bNXeXgB<br>
 * {@link jp.terasoluna.fw.util.TransactionUtil} NX̃eXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * O𔭐Ƃ[obNs邳ɎgpTransactionUtilNXB<br>
 * setRollbackOnly\bhgpisRollbackOnlyXe[^XtrueɕύXB
 * <p>
 * 
 * @see jp.terasoluna.fw.util.TransactionUtil
 */
public class TransactionUtilTest extends TestCase {

    /**
     * ÖׂɃ\bhpӁB
     */
    protected Method exceptionalMethod;

    /**
     * RXgN^B
     */
    public TransactionUtilTest() {
        try {
            // eXg郁\bhLbV
            exceptionalMethod = ITestBean.class.getMethod("exceptional",
                    new Class[] { Throwable.class });
        } catch (NoSuchMethodException ex) {
            throw new RuntimeException("Shouldn't happen", ex);
        }
    }

    /**
     * testSetRollbackOnly() <br>
     * <br>
     * 
     * (n) <br>
     * ϓ_FA<br>
     * <br>
     * ͒lF(Ăяo\bh) setRollbackOnly();<br>
     * () isRollbackOnly:false<br>
     * 
     * <br>
     * ҒlF(ԕω) isRollbackOnly:"true"<br>
     * 
     * <br>
     * TransactionUtilNXsetRollbackOnly\bhĂяoꂽAisRollbackOnlytrueɂȂ܂B
     * <br>
     * 
     * @throws Throwable
     *             ̃\bhŔO
     */
    public void testSetRollbackOnly() throws Throwable {

        // O
        TransactionAttribute txatt = new DefaultTransactionAttribute();

        MapTransactionAttributeSource tas = new MapTransactionAttributeSource();
        tas.register(exceptionalMethod, txatt);
        SimpleTransactionStatus status = new SimpleTransactionStatus();

        // bN쐬
        PlatformTransactionManager mock = createMock(PlatformTransactionManager.class);

        // getTransaction\bh͈txattA߂lstatus1Ă΂
        expect(mock.getTransaction(txatt)).andReturn(status);
        expectLastCall().times(1);

        // commit\bh͈statusA߂lvoid1Ă΂
        mock.commit(status);
        expectLastCall().times(1);

        // bNL
        replay(mock);

        TestBean outer = new TestBean() {
            @Override
            public void exceptional(Throwable t) throws Throwable {

                // eXgs
                TransactionUtil.setRollbackOnly();

                SimpleTransactionStatus sts = new SimpleTransactionStatus();
                sts = (SimpleTransactionStatus) TransactionAspectSupport
                        .currentTransactionStatus();

                // 
                assertEquals(true, sts.isRollbackOnly());

            }
        };
        ITestBean outerProxy = (ITestBean) advised(outer, mock, tas);
        outerProxy.exceptional(null);

        // bNKʂ̃\bhAщ񐔂ĂяoĂ
        verify(mock);

    }

    /**
     * AhoCXIuWFNgƃgUNṼZbgAbvp̃IuWFNg쐬ev[g\bhB<br>
     * TransactionInterceptor쐬ĂKp܂B
     * 
     * @param target
     *            TransactionUtilTest nulll
     * @param ptm
     *            Proxy0 C^[tF[X̂߂EasyMock
     * @param tas
     *            MapTransactionAttributeSource nbV}bv
     * @return pf ProxyFactory JDBCC^[tF[X̃vLV
     */
    Object advised(Object target, PlatformTransactionManager ptm,
            TransactionAttributeSource tas) {
        TransactionInterceptor ti = new TransactionInterceptor();
        ti.setTransactionManager(ptm);
        assertEquals(ptm, ti.getTransactionManager());
        ti.setTransactionAttributeSource(tas);
        assertEquals(tas, ti.getTransactionAttributeSource());

        ProxyFactory pf = new ProxyFactory(target);
        pf.addAdvice(0, ti);
        return pf.getProxy();
    }
}
