/*
 * $Id: PrivateAccessUtil.java 5230 2007-09-28 10:04:13Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */
package jp.terasoluna.fw.file.ut;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 *  private\bhĂяo߂̃[eBeBNXB
 * @version 2003.08.29
 * @author OH 
 */
class PrivateAccessUtil {

    /**
     * private\bhistaticłȂ́jĂяoB<BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA 𗘗pVvɋLqłB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int calcAdd(int val1, int val2, int val3) {
     *         return val1 + val2 + val3;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Sample sample = new Sample();
     *         Integer result = (Integer) PrivateAccessUtil.invokePrivate(
     *             sample,
     *             &quot;calcAdd&quot;,
     *             new Class[] { int.class, int.class, int.class },
     *             new Object[] { new Integer(1), new Integer(2), 
     *                            new Integer(3) }
     *         );
     *         assertEquals(6, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Object target, String methodName,
            Class[] argTypes, Object[] args) throws Exception {

        // p[^l̃`FbN
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null || methodName.equals("")) {
            throw new IllegalArgumentException();
        }
        if (argTypes.length != args.length) {
            throw new IllegalArgumentException();
        }

        // private\bhĂяoB
        // X[p[NXSĂɂČĂяogCB
        Class c = target.getClass();
        while (c != null) {
            try {
                Method method = c.getDeclaredMethod(methodName, argTypes);
                method.setAccessible(true);
                return method.invoke(target, args);
            } catch (InvocationTargetException e) {
                // Ăяo\bhO𓊂ꍇB
                throw (Exception) e.getTargetException();
            } catch (Exception e) {
                // ĂяoƂ\bh݂ȂꍇAȂB
                // (eNXœgCJԂB)
            }
            c = c.getSuperclass();
        }
        // ĂяoƂ\bh݂ȂꍇB
        throw new NoSuchMethodException("Could not invoke "
                + target.getClass().getName() + "." + methodName + "()");
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^0pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private int getString() {
     *         return &quot;success&quot;;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testGetString() {
     *         Sample sample = new Sample();
     *         String result = 
     *            (String) PrivateAccessUtil.invokePrivate(sample, &quot;getString&quot;):
     *         assertEquals(&quot;success&quot;, result);
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName)
                                                                        throws Exception {

        return invokePrivate(target, methodName, new Class[] {},
                new Object[] {});
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^1pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private long square(long val) {
     *         return val &circ; 2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testSquare() {
     *         Sample sample = new Sample();
     *         Long result = (Long) PrivateAccessUtil.invokePrivate(
     *             sample, &quot;square&quot;, long.class, new Long(2L)):
     *         assertEquals(4, result.longValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Object target, String methodName,
            Class argType, Object arg) throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
                new Object[] { arg });
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^2pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2) {
     *         return val1 + val2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Sample sample = new Sample();
     *         Integer result = (Integer) PrivateAccessUtil.invokePrivate(
     *             sample,
     *             &quot;calcAdd&quot;,
     *             int.class,
     *             int.class,
     *             new Integer(1),
     *             new Integer(2)
     *         );
     *         assertEquals(3, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Object target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
                                                                     throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType1,
                argType2 }, new Object[] { arg1, arg2 });
    }

    /**
     * staticprivate\bhĂяoB <BR>
     * <BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA 𗘗pVvɋLqłB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2, int val3) {
     *         return val1 + val2 + val3;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Integer result = (Integer) PrivateAccessUtil.invokePrivate(
     *             Sample.class,
     *             &quot;calcAdd&quot;,
     *             new Class[] { int.class, int.class, int.class },
     *             new Object[] { new Integer(1), new Integer(2), 
     *                            new Integer(3) }
     *         );
     *         assertEquals(6, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName,
            Class[] argTypes, Object[] args) throws Exception {

        // p[^l̃`FbN
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (methodName == null || methodName.equals("")) {
            throw new IllegalArgumentException();
        }
        if (argTypes.length != args.length) {
            throw new IllegalArgumentException();
        }

        // private\bhĂяoB
        // X[p[NXSĂɂČĂяogCB
        Class c = target;
        while (c != null) {
            try {
                Method method = c.getDeclaredMethod(methodName, argTypes);
                method.setAccessible(true);
                return method.invoke(target, args);
            } catch (InvocationTargetException e) {
                // Ăяo\bhO𓊂ꍇB
                throw (Exception) e.getTargetException();
            } catch (Exception e) {
                // ĂяoƂ\bh݂ȂꍇAȂB
                // (eNXœgCJԂB)
            }
            c = c.getSuperclass();
        }
        // ĂяoƂ\bh݂ȂꍇB
        throw new NoSuchMethodException("Could not invoke "
                + target.getClass().getName() + "." + methodName + "()");
    }

    /**
     * staticprivate\bhĂяoip[^0pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int getString() {
     *         return &quot;success&quot;;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testGetString() {
     *         String result = (String) PrivateAccessUtil.invokePrivate(
     *             Sample.class, &quot;getString&quot;):
     *         assertEquals(&quot;success&quot;, result);
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName)
                                                                       throws Exception {

        return invokePrivate(target, methodName, new Class[] {},
                new Object[] {});
    }

    /**
     * staticprivate\bhĂяoip[^1pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static long square(long val) {
     *         return val &circ; 2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testSquare() {
     *         Long result = (Long) PrivateAccessUtil.invokePrivate(
     *             Sample.class, &quot;square&quot;, long.class, new Long(2L)):
     *         assertEquals(4, result.longValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName,
            Class argType, Object arg) throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
                new Object[] { arg });
    }

    /**
     * staticprivate\bhĂяoip[^2pjB
     * 
     * <pre>
     * [gp]
     * class Sample {
     *     private static int calcAdd(int val1, int val2) {
     *         return val1 + val2;
     *     }
     * }
     * 
     * class SampleTest {
     *     &#064;SuppressWarnings(&quot;unchecked&quot;) public void testCalcAdd() {
     *         Integer result = (Integer) PrivateAccessUtil.invokePrivate(
     *             Sample.class,
     *             &quot;calcAdd&quot;,
     *             int.class,
     *             int.class,
     *             new Integer(1),
     *             new Integer(2)
     *         );
     *         assertEquals(3, result.intValue());
     *     }
     * }
     * </pre>
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lB int,boolean̊{f[^^́AInteger, Booleañbp[NX i[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB int, boolean̊{f[^^́AInteger, Boolean bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public static Object invokePrivate(Class target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
                                                                     throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType1,
                argType2 }, new Object[] { arg1, arg2 });
    }
}
