/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.VariableFileLineWriter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CsIuWFNgf[^ǂݍ݁A1s̃f[^ϒ` t@CɏށB<br>
 * AbstractFileLineWriter̃TuNXB
 * <p>
 * @author cNi
 * @author O
 * @see jp.terasoluna.fw.file.dao.standard.VariableFileLineWriter
 */
public class VariableFileLineWriterTest {

    private static final String TEMP_FILE_NAME = VariableFileLineWriterTest.class
            .getResource("VariableFileLineWriterTest_tmp.txt").getPath();

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(VariableFileLineWriterTest.class);
    }

    @Before
    public void setUp() throws Exception {
        VMOUTUtil.initialize();
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    /**
     * testVariableFileLineWriter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileName:"(pX)VariableFileLineWriter_testVariableFileLineWriter01.txt"<br>
     * () clazz:FileFormatAme[VAdelimiterAencloseCharl<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatter.java<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#init():1Ă΂邱<br>
     * (ԕω) AbstractFileLineWriter#AbstractFileLineWriter():1Ă΂邱ƁB<br>
     * nĂ邱ƂmFB<br>
     * (ԕω) this.encloseChar:parameterClass̃Ame[VFileFormatencloseChar()̒lB<br>
     * (ԕω) this.delimiter:parameterClass̃Ame[VFileFormatdelimiter()̒lB<br>
     * <br>
     * p^[<br>
     * @FileFormatׂăftHgl̏ꍇɁARXgN^̌ďoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testVariableFileLineWriter01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<VariableFileLineWriter_Stub01> clazz = VariableFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O̐ݒ
        // Ȃ

        // eXg{
        VariableFileLineWriter<VariableFileLineWriter_Stub01> result = null;
        try {
            result = new VariableFileLineWriter<VariableFileLineWriter_Stub01>(
                    fileName, clazz, columnFormatterMap);

            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "init"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "<init>", 0);
            assertEquals(3, arguments.size());
            assertEquals(fileName, arguments.get(0));
            assertEquals(VariableFileLineWriter_Stub01.class, arguments.get(1));
            assertEquals(columnFormatterMap, arguments.get(2));
            assertEquals(Character.MIN_VALUE, UTUtil.getPrivateField(result,
                    "encloseChar"));
            assertEquals(',', UTUtil.getPrivateField(result, "delimiter"));
        } finally {
            // eXgΏۂ̃N[Y
            if (result != null) {
                result.closeFile();
            }
        }
    }

    /**
     * testVariableFileLineWriter02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:"(pX)VariableFileLineWriter_testVariableFileLineWriter02.txt"<br>
     * () clazz:FileFormatAme[VAdelimiter'\u0000'AencloseChar'\"'<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatter.java<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#init():Ă΂ȂƁB<br>
     * (ԕω) AbstractFileLineWriter#AbstractFileLineWriter():1Ă΂邱ƁB<br>
     * nĂ邱ƂmFB<br>
     * (ԕω) O:"Delimiter can not use '\u0000'."̃bZ[WAIllegalStateExceptionAt@CFileExceptionB<br>
     * <br>
     * OB@FileFormatdelimiter'\u0000'ݒ肵ꍇAO邱ƂmFB<br>
     * t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testVariableFileLineWriter02() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<VariableFileLineWriter_Stub04> clazz = VariableFileLineWriter_Stub04.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O̐ݒ
        // Ȃ

        try {
            // eXg{
            new VariableFileLineWriter<VariableFileLineWriter_Stub04>(fileName,
                    clazz, columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "init"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "<init>", 0);
            assertEquals(3, arguments.size());
            assertEquals(fileName, arguments.get(0));
            assertEquals(VariableFileLineWriter_Stub04.class, arguments.get(1));
            assertEquals(columnFormatterMap, arguments.get(2));

            assertEquals(FileException.class, e.getClass());
            assertEquals("Delimiter can not use '\\u0000'.", e.getMessage());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testVariableFileLineWriter03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileName:"(pX)VariableFileLineWriter_testVariableFileLineWriter03.txt"<br>
     * () clazz:FileFormatAme[VAdelimiter'#'<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatter.java<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#init():Ă΂邱<br>
     * (ԕω) AbstractFileLineWriter#AbstractFileLineWriter():1Ă΂邱ƁB<br>
     * nĂ邱ƂmFB<br>
     * (ԕω) this.encloseChar:parameterClass̃Ame[VFileFormatencloseChar()̒lB<br>
     * (ԕω) this.delimiter:parameterClass̃Ame[VFileFormatdelimiter()̒lB<br>
     * <br>
     * @FileFormatdelimiter'#'ݒAencloseChar'"'ݒ肵ꍇARXgN^̌ďoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testVariableFileLineWriter03() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<VariableFileLineWriter_Stub07> clazz = VariableFileLineWriter_Stub07.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O̐ݒ
        // Ȃ

        VariableFileLineWriter<VariableFileLineWriter_Stub07> result = null;
        try {
            // eXg{
            result = new VariableFileLineWriter<VariableFileLineWriter_Stub07>(
                    fileName, clazz, columnFormatterMap);

            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "init"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "<init>", 0);
            assertEquals(3, arguments.size());
            assertEquals(fileName, arguments.get(0));
            assertEquals(VariableFileLineWriter_Stub07.class, arguments.get(1));
            assertEquals(columnFormatterMap, arguments.get(2));
            assertEquals('"', UTUtil.getPrivateField(result, "encloseChar"));
            assertEquals('#', UTUtil.getPrivateField(result, "delimiter"));
        } finally {
            // eXgΏۂ̃N[Y
            if (result != null) {
                result.closeFile();
            }
        }
    }

    /**
     * ُn<br>
     * sɋ؂蕶܂܂
     */
    @Test
    public void testVariableFileLineWriter04() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new VariableFileLineWriter<VariableFileLine_Stub01>(fileName,
                    VariableFileLine_Stub01.class, columnFormatterMap);
            fail();
        } catch (FileException e) {
            assertEquals(
                    "delimiter is the same as lineFeedChar and is no use.", e
                            .getMessage());
            assertEquals(fileName, e.getFileName());
            assertSame(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * sƋ؂蕶
     */
    @Test
    public void testVariableFileLineWriter05() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new VariableFileLineWriter<VariableFileLine_Stub02>(fileName,
                    VariableFileLine_Stub02.class, columnFormatterMap);
            fail();
        } catch (FileException e) {
            assertEquals(
                    "delimiter is the same as lineFeedChar and is no use.", e
                            .getMessage());
            assertEquals(fileName, e.getFileName());
            assertSame(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * t@CsIuWFNgOutputFileColumnAme[V
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testVariableFileLineWriter06() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Class<FileLineObject_Empty> clazz = FileLineObject_Empty.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new VariableFileLineWriter<FileLineObject_Empty>(fileName, clazz,
                    columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("OutputFileColumn is not found.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testGetColumn01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t:ȉ̃JVariableFileLineWriterX^u<br>
     * "abcdef"<br>
     * () index:0<br>
     * () this.encloseChar:Charcator.MIN_VALUE<br>
     * <br>
     * ҒlF(߂l) String:abcdef<br>
     * (ԕω) AbstractFileLineWriter#getColumn():1Ăяo邱<br>
     * n邱<br>
     * <br>
     * l擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub05> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub05>(
                fileName, VariableFileLineWriter_Stub05.class,
                columnFormatterMap);

        // ̐ݒ
        VariableFileLineWriter_Stub05 t = new VariableFileLineWriter_Stub05();
        t.setColumn01("abcdef");
        int index = 0;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肳ĂB

        try {
            // eXg{
            String result = lineWriter.getColumn(t, index);
            // ԋpl̊mF
            assertEquals("abcdef", result);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertSame(t, arguments.get(0));
            assertEquals(index, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn02() <br>
     * <br>
     * (n <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t:ȉ̃JVariableFileLineWriterX^u<br>
     * "abcdef"<br>
     * () index:0<br>
     * () this.encloseChar:'\"'<br>
     * <br>
     * ҒlF(߂l) String:abcdef<br>
     * (ԕω) AbstractFileLineWriter#getColumn():1Ăяo邱<br>
     * n邱<br>
     * <br>
     * l擾邱ƂmFB<br>
     * o͑ΏۂɃGXP[vΏۂ̕i͂ݕjꍇ͒ʏ̕ <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn02() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub06> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub06>(
                fileName, VariableFileLineWriter_Stub06.class,
                columnFormatterMap);

        // ̐ݒ
        VariableFileLineWriter_Stub06 t = new VariableFileLineWriter_Stub06();
        t.setColumn01("abcdef");
        int index = 0;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肳ĂB

        try {
            // eXg{
            String result = lineWriter.getColumn(t, index);

            // ԋpl̊mF
            assertEquals("abcdef", result);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertSame(t, arguments.get(0));
            assertEquals(index, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t:ȉ̃JVariableFileLineWriterX^u<br>
     * "ab\"cdef"<br>
     * () index:0<br>
     * () this.encloseChar:'\"'<br>
     * <br>
     * ҒlF(߂l) String:"ab\"\"cdef"<br>
     * (ԕω) AbstractFileLineWriter#getColumn():1Ăяo邱<br>
     * n邱<br>
     * <br>
     * l擾邱ƂmFB<br>
     * o͑ΏۂɃGXP[vΏۂ̕i͂ݕjꍇɁAGXP[v <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn03() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> textGetterMap = new HashMap<String, ColumnFormatter>();
        textGetterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub06> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub06>(
                fileName, VariableFileLineWriter_Stub06.class, textGetterMap);

        // ̐ݒ
        VariableFileLineWriter_Stub06 t = new VariableFileLineWriter_Stub06();
        t.setColumn01("ab\"cdef");
        int index = 0;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肳ĂB

        try {
            // eXg{
            String result = lineWriter.getColumn(t, index);

            // ԋpl̊mF
            assertEquals("ab\"\"cdef", result);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertSame(t, arguments.get(0));
            assertEquals(index, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn04() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:null<br>
     * () index:0<br>
     * () this.encloseChar:'\"'<br>
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     * <br>
     * tnullɂƁANullPointerExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetColumn04() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> textGetterMap = new HashMap<String, ColumnFormatter>();
        textGetterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub06> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub06>(
                fileName, VariableFileLineWriter_Stub06.class, textGetterMap);

        // ̐ݒ
        VariableFileLineWriter_Stub06 t = null;
        int index = 0;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肳ĂB

        // eXg{
        try {
            lineWriter.getColumn(t, index);
            fail("NullPointerExceptionX[܂łB");
        } catch (NullPointerException e) {
            assertEquals(NullPointerException.class, e.getClass());
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t:ȉ̃JVariableFileLineWriterX^u<br>
     * "abcdef"<br>
     * "aaabbb"<br>
     * () index:1<br>
     * () this.encloseChar:'\"'<br>
     * <br>
     * ҒlF(߂l) String:aaabbb<br>
     * (ԕω) AbstractFileLineWriter#getColumn():1Ăяo邱<br>
     * n邱<br>
     * <br>
     * index̒lɕRÂJ̒li͂ݕȂ̏ꍇj擾ł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testGetColumn05() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> textGetterMap = new HashMap<String, ColumnFormatter>();
        textGetterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub08> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub08>(
                fileName, VariableFileLineWriter_Stub08.class, textGetterMap);

        // ̐ݒ
        VariableFileLineWriter_Stub08 t = new VariableFileLineWriter_Stub08();
        t.setColumn01("abcdef");
        t.setColumn02("aaabbb");
        int index = 1;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肳ĂB

        try {
            // eXg{
            String result = lineWriter.getColumn(t, index);

            // ԋpl̊mF
            assertEquals("aaabbb", result);

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertSame(t, arguments.get(0));
            assertEquals(index, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.delimiter:not null<br>
     * ','<br>
     * <br>
     * ҒlF(߂l) delimiter:not null<br>
     * ','<br>
     * <br>
     * delimitergetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub01> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub01>(
                fileName, VariableFileLineWriter_Stub01.class,
                columnFormatterMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(lineWriter, "delimiter", ',');

        try {
            // eXg{
            char result = lineWriter.getDelimiter();

            // ԋpl̊mF
            assertEquals(',', result);
            // ԕω̊mF
            // Ȃ
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.encloseChar:not null<br>
     * '\u0000'<br>
     * <br>
     * ҒlF(߂l) encloseChar:not null<br>
     * '\u0000'<br>
     * <br>
     * encloseChargetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        VariableFileLineWriter<VariableFileLineWriter_Stub01> lineWriter = new VariableFileLineWriter<VariableFileLineWriter_Stub01>(
                fileName, VariableFileLineWriter_Stub01.class,
                columnFormatterMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(lineWriter, "encloseChar", '\u0000');

        try {
            // eXg{
            char result = lineWriter.getEncloseChar();

            // ԋpl̊mF
            assertEquals('\u0000', result);

            // ԕω̊mF
            // Ȃ
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * n<br>
     * FileFormatencloseCharOutputFileColumncolumnEncloseCharɂāAX̃JɈ͂ݕݒ
     * @throws Exception
     */
    @Test
    public void testPrintDataLine01() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        VariableFileLineWriter<CSVFileLine_Stub01> fileLineWriter = new VariableFileLineWriter<CSVFileLine_Stub01>(
                fileName, CSVFileLine_Stub01.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub01 t1 = new CSVFileLine_Stub01();
        CSVFileLine_Stub01 t2 = new CSVFileLine_Stub01();
        CSVFileLine_Stub01 t3 = new CSVFileLine_Stub01();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");
        t2.setColumn1("5");
        t2.setColumn2("66");
        t2.setColumn3("777");
        t2.setColumn4("8888");
        t3.setColumn1("9");
        t3.setColumn2("AA");
        t3.setColumn3("BBB");
        t3.setColumn4("CCCC");

        // eXg{
        fileLineWriter.printDataLine(t1);
        fileLineWriter.printDataLine(t2);
        fileLineWriter.printDataLine(t3);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("\"1\",22,333,|4444|", reader.readLine());
            assertEquals("\"5\",66,777,|8888|", reader.readLine());
            assertEquals("\"9\",AA,BBB,|CCCC|", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * n<br>
     * FileFormatencloseCharOutputFileColumncolumnEncloseCharɂāAX̃JɈ͂ݕݒ
     * @throws Exception
     */
    @Test
    public void testPrintDataLine02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        VariableFileLineWriter<CSVFileLine_Stub02> fileLineWriter = new VariableFileLineWriter<CSVFileLine_Stub02>(
                fileName, CSVFileLine_Stub02.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub02 t1 = new CSVFileLine_Stub02();
        CSVFileLine_Stub02 t2 = new CSVFileLine_Stub02();
        CSVFileLine_Stub02 t3 = new CSVFileLine_Stub02();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");
        t2.setColumn1("5");
        t2.setColumn2("66");
        t2.setColumn3("777");
        t2.setColumn4("8888");
        t3.setColumn1("9");
        t3.setColumn2("AA");
        t3.setColumn3("BBB");
        t3.setColumn4("CCCC");

        // eXg{
        fileLineWriter.printDataLine(t1);
        fileLineWriter.printDataLine(t2);
        fileLineWriter.printDataLine(t3);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("\"1\",'22',\"333\",|4444|", reader.readLine());
            assertEquals("\"5\",'66',\"777\",|8888|", reader.readLine());
            assertEquals("\"9\",'AA',\"BBB\",|CCCC|", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * n<br>
     * LbVĂAme[V̏𗘗pĂ鎖mFB<br>
     * @throws Exception
     */
    @Test
    public void testPrintDataLine03() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        VariableFileLineWriter<CSVFileLine_Stub03> fileLineWriter = new VariableFileLineWriter<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub03 t1 = new CSVFileLine_Stub03();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");

        // t@CsIuWFNgɐݒ肵ĂlSď㏑
        // ȉ̐ݒ肪Kp΁At@CsIuWFNg
        // Ame[VɃANZXĂȂƂɂȂB
        char[] charArray = new char[] { 0, 0, 0, 0 };
        // O
        UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", "\r\n");
        UTUtil.setPrivateField(fileLineWriter, "delimiter", '_');
        UTUtil.setPrivateField(fileLineWriter, "outputFileColumns", null);
        UTUtil.setPrivateField(fileLineWriter, "columnFormats", new String[] {
                "", "", "", "" });
        UTUtil.setPrivateField(fileLineWriter, "columnBytes", new int[] { -1,
                -1, -1, -1 });
        // UTUtil.setPrivateField(fileLineWriter, "totalBytes", 0);
        UTUtil.setPrivateField(fileLineWriter, "paddingTypes",
                new PaddingType[] { PaddingType.NONE, PaddingType.NONE,
                        PaddingType.NONE, PaddingType.NONE });
        UTUtil.setPrivateField(fileLineWriter, "paddingChars", charArray);
        UTUtil.setPrivateField(fileLineWriter, "trimChars", charArray);
        UTUtil.setPrivateField(fileLineWriter, "columnEncloseChar", charArray);
        UTUtil.setPrivateField(fileLineWriter, "stringConverters",
                new NullStringConverter[] { new NullStringConverter(),
                        new NullStringConverter(), new NullStringConverter(),
                        new NullStringConverter() });

        // eXg{
        fileLineWriter.printDataLine(t1);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("1_22_333_4444", reader.readLine());
        } finally {
            reader.close();
        }
    }
}
