/*
 * $Id: VariableFileLineIteratorTest.java 5655 2007-12-04 06:41:04Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.VariableFileLineIterator} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ϒt@Cp̃t@CANZX(f[^擾)NXB
 * <p>
 * @author cNi
 * @author O
 * @see jp.terasoluna.fw.file.dao.standard.VariableFileLineIterator
 */
public class VariableFileLineIteratorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(VariableFileLineIteratorTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public VariableFileLineIteratorTest(String name) {
        super(name);
    }

    /**
     * testVariableFileLineIterator01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:File_Empty.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:VariableFileLineIterator_Stub02<br>
     * @delimiterAencloseCharlȊO<br>
     * () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParser.java<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIterator#AbstractFileLineIterator():1Ă΂B<br>
     * p[^Ɉn邱ƁB<br>
     * (ԕω) this.delimiter:͒l<br>
     * (ԕω) this.encloseChar:͒l<br>
     * (ԕω) AbstractFileLineIterator#init():1Ăяo邱<br>
     * <br>
     * p^[B<br>
     * clazzɎw肳ĂNX̒ldelimiterAencloseChar邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testVariableFileLineIterator01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^̎Ȃ̂ŕsv

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub02> clazz = VariableFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        // Ȃ

        // eXg{
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub02>(
                fileName, clazz, columnParserMap);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        // 
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));

        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(3, arguments.size());
        assertEquals(fileName, arguments.get(0));
        assertSame(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));

        assertEquals('"', variableFileLineIterator.getEncloseChar());
        assertEquals('A', variableFileLineIterator.getDelimiter());

        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * testVariableFileLineIterator02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:File_Empty.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:VariableFileLineIterator_Stub03<br>
     * @delimiter'\u0000'encloseCharli\u0000jȊO<br>
     * () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParser.java<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIterator#AbstractFileLineIterator():1Ă΂B<br>
     * p[^Ɉn邱ƁB<br>
     * (ԕω) O:"Delimiter can not use '\u0000'."̃bZ[WAIllegalStateExceptionAt@CFileExceptionB<br>
     * <br>
     * OB@FileFormatdelimiter'\u0000'ݒ肵ꍇAO邱ƂmFB<br>
     * t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testVariableFileLineIterator02() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^̎Ȃ̂ŕsv

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub03> clazz = VariableFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            new VariableFileLineIterator<VariableFileLineIterator_Stub03>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            // 
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "<init>"));

            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineIterator.class, "<init>", 0);
            assertEquals(3, arguments.size());
            assertEquals(fileName, arguments.get(0));
            assertSame(clazz, arguments.get(1));
            assertSame(columnParserMap, arguments.get(2));

            assertEquals("Delimiter can not use '\\u0000'.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertSame(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testVariableFileLineIterator03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:File_Empty.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:VariableFileLineIterator_Stub01<br>
     * @delimiterAencloseCharl<br>
     * () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParser.java<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIterator#AbstractFileLineIterator():1Ă΂B<br>
     * p[^Ɉn邱ƁB<br>
     * (ԕω) this.delimiter:l<br>
     * (ԕω) this.encloseChar:l<br>
     * (ԕω) AbstractFileLineIterator#init():1Ăяo邱<br>
     * <br>
     * clazzŎw肵NX@FileFormatdelimiterAencloseCharl̏ꍇ́AdelimiterAencloseCharl̂܂܂ł邱Ƃ̃eXgB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testVariableFileLineIterator03() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^̎Ȃ̂ŕsv

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub01> clazz = VariableFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        // Ȃ

        // eXg{
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        // 
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));

        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(3, arguments.size());
        assertEquals(fileName, arguments.get(0));
        assertSame(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));

        assertEquals(Character.MIN_VALUE, variableFileLineIterator
                .getEncloseChar());
        assertEquals(',', variableFileLineIterator.getDelimiter());

        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * ُn<br>
     * sɋ؂蕶܂܂
     */
    public void testVariableFileLineIterator04() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();

        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // eXg{
        try {
            new VariableFileLineIterator<VariableFileLine_Stub01>(fileName,
                    VariableFileLine_Stub01.class, columnParserMap);
            fail();
        } catch (FileException e) {
            assertEquals(
                    "delimiter is the same as lineFeedChar and is no use.", e
                            .getMessage());
            assertEquals(fileName, e.getFileName());
            assertSame(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * sƋ؂蕶
     */
    public void testVariableFileLineIterator05() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();

        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // eXg{
        try {
            new VariableFileLineIterator<VariableFileLine_Stub02>(fileName,
                    VariableFileLine_Stub02.class, columnParserMap);
            fail();
        } catch (FileException e) {
            assertEquals(
                    "delimiter is the same as lineFeedChar and is no use.", e
                            .getMessage());
            assertEquals(fileName, e.getFileName());
            assertSame(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * t@CsIuWFNgInputFileColumnAme[V
     * @throws Exception ̃\bhŔO
     */
    public void testVariableFileLineIterator06() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<FileLineObject_Empty> clazz = FileLineObject_Empty.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        // eXg{
        try {
            new VariableFileLineIterator<FileLineObject_Empty>(fileName, clazz,
                    columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("InputFileColumn is not found.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testSeparateColumns01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() fileLineString:null<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:new String[0]<br>
     * <br>
     * p^[B<br>
     * nullƂēnꂽꍇAvf0̔zԋp邱ƂmFB<br>
     * ʏ̏ł̕ԋpl߂邱Ƃ͂ȂB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = null;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(0, result.length);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * vf1̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals("aaa", result[0]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa,aaa,aaa"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa","aaa","aaa"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * vf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa,aaa,aaa";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("aaa", result[1]);
        assertEquals("aaa", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aaa\""<br>
     * () this.encloseChar:'\"'<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa"}<br>
     * <br>
     * p^[B(͂ݕꍇ̏)<br>
     * vf1̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub11> clazz = VariableFileLineIterator_Stub11.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub11>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aaa\"";

        // O
        UTUtil.setPrivateField(variableFileLineIterator, "columnEncloseChar",
                new char[] { '\"', '\"' });

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals("aaa", result[0]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aaa\",\"aaa\",\"aaa\""<br>
     * () this.encloseChar:'\"'<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa","aaa","aaa"}<br>
     * <br>
     * p^[B(͂ݕꍇ̏B)<br>
     * vf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub11> clazz = VariableFileLineIterator_Stub11.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub11>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aaa\",\"aaa\",\"aaa\"";

        // O
        UTUtil.setPrivateField(variableFileLineIterator, "columnEncloseChar",
                new char[] { '\"', '\"', '\"' });

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("aaa", result[1]);
        assertEquals("aaa", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aa\ra\",\"aa,a\",\"aa\"\"a\""<br>
     * ͂ݕA<br>
     * s؂蕶܂܂A<br>
     * ؂蕶܂܂A<br>
     * ͂ݕ܂܂ꍇ<br>
     * () this.encloseChar:'\"'<br>
     * () super.lineFeedChar:\r<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aa\ra","aa,a","aa\"a"}<br>
     * <br>
     * p^[B(͂ݕꍇ̏B)<br>
     * vf4̔zԋp邱ƂmFB<br>
     * s؂蕶A؂蕶A͂ݕꂼ̕fg܂ĂꍇAGXP[v邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub12> clazz = VariableFileLineIterator_Stub12.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub12>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aa\ra\",\"aa,a\",\"aa\"\"a\"";

        // O
        UTUtil.setPrivateField(variableFileLineIterator, "columnEncloseChar",
                new char[] { '\"', '\"', '\"', '\"', '\"', '\"', '\"', '\"' });

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aa\ra", result[0]);
        assertEquals("aa,a", result[1]);
        assertEquals("aa\"a", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns07() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() fileLineString:󕶎<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:new String[0]<br>
     * <br>
     * p^[B<br>
     * 󕶎ƂēnꂽꍇAvf0̔zԋp邱ƂmFB<br>
     * ʏ̏ł̕ԋpl߂邱Ƃ͂ȂB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub13> clazz = VariableFileLineIterator_Stub13.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub13>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(0, result.length);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa,aaa,aaa"<br>
     * () this.encloseChar:'\"'<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa","aaa","aaa"}<br>
     * <br>
     * p^[B(encloseCharݒ肳ĂA؂蕶Ȃꍇ̏)<br>
     * vf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub11> clazz = VariableFileLineIterator_Stub11.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub11>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa,aaa,aaa";

        // O
        UTUtil.setPrivateField(variableFileLineIterator, "columnEncloseChar",
                new char[] { Character.MIN_VALUE, Character.MIN_VALUE,
                        Character.MIN_VALUE });

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("aaa", result[1]);
        assertEquals("aaa", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns09() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:",,,,"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"", "", "", "", ""}<br>
     * <br>
     * p^[B(؂蕶Ȃꍇ̏)<br>
     * 󔒕T̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns09() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = ",,,,";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(5, result.length);
        assertEquals("", result[0]);
        assertEquals("", result[1]);
        assertEquals("", result[2]);
        assertEquals("", result[3]);
        assertEquals("", result[4]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns10() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa#aaa#aaa"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:'#'<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa","aaa","aaa"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * ؂蕶ftHgȊÔ̂ɐݒ肵ꍇłAvf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns10() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub14> clazz = VariableFileLineIterator_Stub14.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub14>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa#aaa#aaa";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("aaa", result[1]);
        assertEquals("aaa", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns11() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:",bbb,ccc"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"","bbb","ccc"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * 󕶎擪ɂꍇłAvf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns11() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = ",bbb,ccc";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("", result[0]);
        assertEquals("bbb", result[1]);
        assertEquals("ccc", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns12() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa,,ccc"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa","","ccc"}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * 󕶎rɊ܂܂ꍇłAvf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns12() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa,,ccc";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("", result[1]);
        assertEquals("ccc", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns13() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"aaa,bbb,"<br>
     * () this.encloseChar:Character.MIN_VALUE<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aaa","bbb",""}<br>
     * <br>
     * p^[B(͂ݕȂꍇ̏)<br>
     * 󕶎ŌɊ܂܂ꍇłAvf3̔zԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns13() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub10> clazz = VariableFileLineIterator_Stub10.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub10>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa,bbb,";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, result.length);
        assertEquals("aaa", result[0]);
        assertEquals("bbb", result[1]);
        assertEquals("", result[2]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testSeparateColumns14() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"\"aa\"bb\""<br>
     * () this.encloseChar:'\"'<br>
     * () delimiter:','<br>
     * <br>
     * ҒlF(߂l) columns[]:{"aabb\""}<br>
     * <br>
     * ͂ݕݒ肳ĂAGXP[vĂȂ͂ݕf[^ƂĊi[Ăꍇ́A\ʃf[^ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testSeparateColumns14() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub11> clazz = VariableFileLineIterator_Stub11.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub11>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "\"aa\"bb\"";

        // O
        UTUtil.setPrivateField(variableFileLineIterator, "columnEncloseChar",
                new char[] { '\"', '\"' });

        // eXg{
        String[] result = variableFileLineIterator
                .separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, result.length);
        assertEquals("aabb\"", result[0]);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() this.encloseChar:not null<br>
     * 'a'<br>
     * <br>
     * ҒlF(߂l) encloseChar:not null<br>
     * 'a'<br>
     * <br>
     * encloseChargetterɓ삷邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileLineIterator_Stub20> clazz = VariableFileLineIterator_Stub20.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        VariableFileLineIterator variableFileLineIterator = new VariableFileLineIterator<VariableFileLineIterator_Stub20>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        char result = variableFileLineIterator.getEncloseChar();

        // ԋpl̊mF
        assertEquals('a', result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * n<br>
     * InputFileColumncolumnEncloseCharɂāAX̃JɈ͂ݕݒ
     * @throws Exception
     */
    public void testNext01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        VariableFileLineIterator<CSVFileLine_Stub01> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub01>(
                fileName, CSVFileLine_Stub01.class, columnParserMap);

        // eXg{
        CSVFileLine_Stub01 result1 = fileLineIterator.next();
        CSVFileLine_Stub01 result2 = fileLineIterator.next();
        CSVFileLine_Stub01 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("4444", result1.getColumn4());

        assertEquals("5", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("8888", result2.getColumn4());

        assertEquals("9", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("CCCC", result3.getColumn4());
    }

    /**
     * n<br>
     * FileFormatencloseCharInputFileColumncolumnEncloseCharɂāAJɈ͂ݕݒ
     * @throws Exception
     */
    public void testNext02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        VariableFileLineIterator<CSVFileLine_Stub02> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub02>(
                fileName, CSVFileLine_Stub02.class, columnParserMap);

        // eXg{
        CSVFileLine_Stub02 result1 = fileLineIterator.next();
        CSVFileLine_Stub02 result2 = fileLineIterator.next();
        CSVFileLine_Stub02 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("4444", result1.getColumn4());

        assertEquals("5", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("8888", result2.getColumn4());

        assertEquals("9", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("CCCC", result3.getColumn4());
    }

    /**
     * n<br>
     * LbVĂAme[V̏𗘗pĂ鎖mFB<br>
     * @throws Exception
     */
    public void testNext03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        // t@CsIuWFNgɐݒ肵ĂlSď㏑
        // ȉ̐ݒ肪Kp΁At@CsIuWFNg
        // Ame[VɃANZXĂȂƂɂȂB
        char[] charArray = new char[] { 0, 0, 0, 0 };
        // O
        UTUtil.setPrivateField(fileLineIterator, "lineFeedChar", "\r\n");
        UTUtil.setPrivateField(fileLineIterator, "delimiter", '_');
        UTUtil.setPrivateField(fileLineIterator, "inputFileColumns", null);
        UTUtil.setPrivateField(fileLineIterator, "columnFormats", new String[] {
                "", "", "", "" });
        UTUtil.setPrivateField(fileLineIterator, "columnBytes", new int[] { -1,
                -1, -1, -1 });
        UTUtil.setPrivateField(fileLineIterator, "totalBytes", 0);
        UTUtil.setPrivateField(fileLineIterator, "trimChars", charArray);
        UTUtil
                .setPrivateField(fileLineIterator, "columnEncloseChar",
                        charArray);
        UTUtil.setPrivateField(fileLineIterator, "stringConverters",
                new NullStringConverter[] { new NullStringConverter(),
                        new NullStringConverter(), new NullStringConverter(),
                        new NullStringConverter() });
        LineReader reader = (LineReader) UTUtil.getPrivateField(
                fileLineIterator, "lineReader");
        UTUtil.setPrivateField(reader, "lineFeedChar", "\r\n");

        // eXg{
        CSVFileLine_Stub03 result1 = fileLineIterator.next();
        CSVFileLine_Stub03 result2 = fileLineIterator.next();
        CSVFileLine_Stub03 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("\"1\"", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("|4444|", result1.getColumn4());

        assertEquals("\"5\"", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("|8888|", result2.getColumn4());

        assertEquals("\"9\"", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("|CCCC|", result3.getColumn4());
    }

    /**
     * testGetEncloseCharcter001.
     * @throws Exception
     */
    public void testGetEncloseCharcter001() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        char[] columnEncloseChar = new char[] {};
        int index = 0;

        // eXg{
        Object result = UTUtil.invokePrivate(fileLineIterator,
                "getEncloseCharcter", char[].class, int.class,
                columnEncloseChar, index);

        assertNotNull(result);
        assertEquals(Character.class, result.getClass());
        assertEquals(Character.valueOf('c'), (Character) result);
    }

    /**
     * testGetEncloseCharcter002.
     * @throws Exception
     */
    public void testGetEncloseCharcter002() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        char[] columnEncloseChar = new char[] { 'A', 'B', 'C' };
        int index = 0;

        // eXg{
        Object result = UTUtil.invokePrivate(fileLineIterator,
                "getEncloseCharcter", char[].class, int.class,
                columnEncloseChar, index);

        assertNotNull(result);
        assertEquals(Character.class, result.getClass());
        assertEquals(Character.valueOf('A'), (Character) result);
    }

    /**
     * testGetEncloseCharcter003.
     * @throws Exception
     */
    public void testGetEncloseCharcter003() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        char[] columnEncloseChar = new char[] { 'A', 'B', 'C' };
        int index = 1;

        // eXg{
        Object result = UTUtil.invokePrivate(fileLineIterator,
                "getEncloseCharcter", char[].class, int.class,
                columnEncloseChar, index);

        assertNotNull(result);
        assertEquals(Character.class, result.getClass());
        assertEquals(Character.valueOf('B'), (Character) result);
    }

    /**
     * testGetEncloseCharcter004.
     * @throws Exception
     */
    public void testGetEncloseCharcter004() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        char[] columnEncloseChar = new char[] { 'A', 'B', 'C' };
        int index = 2;

        // eXg{
        Object result = UTUtil.invokePrivate(fileLineIterator,
                "getEncloseCharcter", char[].class, int.class,
                columnEncloseChar, index);

        assertNotNull(result);
        assertEquals(Character.class, result.getClass());
        assertEquals(Character.valueOf('C'), (Character) result);
    }

    /**
     * testGetEncloseCharcter005.
     * @throws Exception
     */
    public void testGetEncloseCharcter005() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        char[] columnEncloseChar = new char[] { 'A', 'B', 'C' };
        int index = 3;

        // eXg{
        Object result = UTUtil.invokePrivate(fileLineIterator,
                "getEncloseCharcter", char[].class, int.class,
                columnEncloseChar, index);

        assertNotNull(result);
        assertEquals(Character.class, result.getClass());
        assertEquals(Character.valueOf('c'), (Character) result);
    }

    /**
     * testGetEncloseCharcter006.
     * @throws Exception
     */
    public void testGetEncloseCharcter006() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        VariableFileLineIterator<CSVFileLine_Stub03> fileLineIterator = new VariableFileLineIterator<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnParserMap);

        char[] columnEncloseChar = new char[] { 'A', 'B', 'C' };
        int index = 4;

        // eXg{
        Object result = UTUtil.invokePrivate(fileLineIterator,
                "getEncloseCharcter", char[].class, int.class,
                columnEncloseChar, index);

        assertNotNull(result);
        assertEquals(Character.class, result.getClass());
        assertEquals(Character.valueOf('c'), (Character) result);
    }
}
