/*
 * $Id: PlainFileQueryDAOTest.java 5576 2007-11-15 13:13:32Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.PlainFileQueryDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CsIuWFNggpȂ̃f[^擾pFileLineIteratorNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.PlainFileQueryDAO
 */
public class PlainFileQueryDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(PlainFileQueryDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public PlainFileQueryDAOTest(String name) {
        super(name);
    }

    /**
     * testExcecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:PlainFleQueryDAO01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:PlainFileQueryDAO_Stub01<br>
     * @<br>
     * () AbstractFileQueryDAO.columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     * ҒlF(߂l) FileLineIterator:PlainFileLineIterator̃CX^X<br>
     * (ԕω) PlainFileLineIterator#PlainFileLineIterator():1Ă΂邱ƁB<br>
     * n邱ƂmFB<br>
     * <br>
     * PlainFileLineIteratorCX^X邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExcecute01() throws Exception {
        // eXgΏۂ̃CX^X
        PlainFileQueryDAO plainFileQueryDAO = new PlainFileQueryDAO();

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<PlainFileQueryDAO_Stub01> clazz = PlainFileQueryDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        UTUtil.setPrivateField(plainFileQueryDAO, "columnParserMap",
                columnParserMap);

        // eXg{
        FileLineIterator result = plainFileQueryDAO.execute(fileName, clazz);

        // ԋpl̊mF
        assertEquals(PlainFileLineIterator.class, result.getClass());

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(PlainFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(PlainFileLineIterator.class,
                "<init>", 0);
        assertSame(fileName, arguments.get(0));
        assertSame(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));
    }

}
