/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.NullColumnParser} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> String^̃t@CsIuWFNg̑Ƀt@Cǂݍ񂾃J̕i[B
 * <p>
 * @author c Ni
 * @see jp.terasoluna.fw.file.dao.standard.NullColumnParser
 */
public class NullColumnParserTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(NullColumnParserTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public NullColumnParserTest(String name) {
        super(name);
    }

    /**
     * testParse01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂString^ setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵 񂪊i[B<br>
     * <br>
     * t@CsIuWFNgString^ɁAcolumn̒lݒ肳 ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse01() throws Exception {
        // eXgΏۂ̃CX^X
        NullColumnParser nullColumnParser = new NullColumnParser();

        // ̐ݒ
        String column = "AA";
        NullColumnParser_Stub01 t = new NullColumnParser_Stub01();
        Method method = NullColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { String.class });
        String columnFormat = "BB";

        // O̐ݒ
        // Ȃ

        // eXg{
        nullColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        assertSame(column, result);
    }

    /**
     * testParse02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂString^ setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉private<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) O:IllegalAccessException ƂmFB<br>
     * <br>
     * t@CsIuWFNgString^setter\bh ANZXłȂꍇAIllegalAccessExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse02() throws Exception {
        // eXgΏۂ̃CX^X
        NullColumnParser nullColumnParser = new NullColumnParser();

        // ̐ݒ
        String column = "AA";
        NullColumnParser_Stub01 t = new NullColumnParser_Stub01();
        Method method = NullColumnParser_Stub01.class.getDeclaredMethod(
                "setAPrivate", new Class[] { String.class });
        String columnFormat = "BB";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            nullColumnParser.parse(column, t, method, columnFormat);
            fail("IllegalAccessExceptionX[܂łB");
        } catch (IllegalAccessException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalAccessException.class, e.getClass());
        }
    }

    /**
     * testParse03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂString^ setter\bh<br>
     * method:setter\bhOX[<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) O:InvocationTargetException ƂmFB<br>
     * <br>
     * t@CsIuWFNgString^setter\bhO X[ꍇAsetter\bhX[Obv InvocationTargetExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse03() throws Exception {
        // eXgΏۂ̃CX^X
        NullColumnParser nullColumnParser = new NullColumnParser();

        // ̐ݒ
        String column = "AA";
        NullColumnParser_Stub01 t = new NullColumnParser_Stub01();
        Method method = NullColumnParser_Stub01.class.getDeclaredMethod(
                "setAException", new Class[] { String.class });
        String columnFormat = "BB";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            nullColumnParser.parse(column, t, method, columnFormat);

            // 
            fail();
        } catch (InvocationTargetException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(InvocationTargetException.class, e.getClass());
        }
    }

    /**
     * testParse04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂString^ setter\bh<br>
     * method:setter\bḧ<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException邱 mFB<br>
     * <br>
     * t@CsIuWFNgString^setter\bḧ ꍇAIllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse04() throws Exception {
        // eXgΏۂ̃CX^X
        NullColumnParser nullColumnParser = new NullColumnParser();

        // ̐ݒ
        String column = "AA";
        NullColumnParser_Stub01 t = new NullColumnParser_Stub01();
        Method method = NullColumnParser_Stub01.class.getDeclaredMethod(
                "setAAndB", new Class[] { String.class, String.class });
        String columnFormat = "BB";

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            nullColumnParser.parse(column, t, method, columnFormat);

            // 
            fail();
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    /**
     * testParse05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() column:null<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂString^ setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:null ݒ肳B<br>
     * <br>
     * columnNull̏ꍇɁAt@CsIuWFNg̑null ݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse05() throws Exception {
        // eXgΏۂ̃CX^X
        NullColumnParser nullColumnParser = new NullColumnParser();

        // ̐ݒ
        String column = null;
        NullColumnParser_Stub01 t = new NullColumnParser_Stub01();
        Method method = NullColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { String.class });
        String columnFormat = null;

        // O̐ݒ
        // Ȃ

        // eXg{
        nullColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        assertNull(result);
    }

    /**
     * testParse06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() column:StringCX^X<br>
     * () t@CsIuWFNg<br>
     * t:t@CsIuWFNgX^u<br>
     * () t@CsIuWFNg(t)ɂString^setter\bh<br>
     * method:ΏۂƂȂsetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:null<br>
     * <br>
     * ҒlF(ԕω) t@CsIuWFNg(t)̑:columnŐݒ肵񂪊i[B<br>
     * <br>
     * columnFormatNull̏ꍇɁAt@CsIuWFNgString^ɁAcolumn̒lݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testParse06() throws Exception {
        // eXgΏۂ̃CX^X
        NullColumnParser nullColumnParser = new NullColumnParser();

        // ̐ݒ
        String column = "AA";
        NullColumnParser_Stub01 t = new NullColumnParser_Stub01();
        Method method = NullColumnParser_Stub01.class.getDeclaredMethod("setA",
                new Class[] { String.class });
        String columnFormat = "BB";

        // O̐ݒ
        // Ȃ

        // eXg{
        nullColumnParser.parse(column, t, method, columnFormat);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object result = UTUtil.getPrivateField(t, "a");
        assertSame(column, result);
    }
}
