/*
 * $Id: LineFeed1LineReaderTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import org.easymock.classextension.EasyMock;

/**
 * {@link jp..terasoluna.fw.file.dao.standard.LineFeed1LineReader} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ͂ݕȂAs؂蕶1̏ꍇ̃t@C1s̕擾鏈sB
 * <p>
 * @author cNi
 * @see jp..terasoluna.fw.file.dao.standard.LineFeed1LineReader
 */
public class LineFeed1LineReaderTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(LineFeed1LineReaderTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public LineFeed1LineReaderTest(String name) {
        super(name);
    }

    /**
     * testLineFeed1LineReader01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() reader:ReaderCX^X<br>
     * () lineFeedChar:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) this.reader:readerƓ̃CX^X<br>
     * (ԕω) this.lineFeedChar:lineFeedCharƓ̃CX^X<br>
     * <br>
     * IuWFNgł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed1LineReader01() throws Exception {
        // O()
        Reader reader = new BufferedReader(new StringReader(""));
        String lineFeedChar = new String("a");

        // eXg{
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                reader, lineFeedChar);

        // 
        assertNotNull(lineFeed1LineReader);

        Reader lineFeed1Reader = (Reader) UTUtil.getPrivateField(
                lineFeed1LineReader, "reader");
        assertSame(reader, lineFeed1Reader);

        String lineFeed1LineFeedChar = (String) UTUtil.getPrivateField(
                lineFeed1LineReader, "lineFeedChar");
        assertSame(lineFeedChar, lineFeed1LineFeedChar);
    }

    /**
     * testLineFeed1LineReader02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() reader:null<br>
     * () lineFeedChar:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) Ȃ:IllegalArgumentException<br>
     * EbZ[WF"reader is required."<br>
     * <br>
     * readernull̏ꍇIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed1LineReader02() throws Exception {
        // O()
        Reader reader = null;
        String lineFeedChar = new String();

        try {
            // eXg{
            new LineFeed1LineReader(reader, lineFeedChar);
            fail("IllegalArgumentException܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(e instanceof IllegalArgumentException);
            assertEquals("reader is required.", e.getMessage());
        }
    }

    /**
     * testLineFeed1LineReader03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() reader:ReaderCX^X<br>
     * () lineFeedChar:null<br>
     * <br>
     * ҒlF(ԕω) Ȃ:IllegalArgumentException<br>
     * EbZ[WF"lineFeedChar is required."<br>
     * <br>
     * lineFeedCharnull̏ꍇIllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed1LineReader03() throws Exception {
        // O()
        Reader reader = new BufferedReader(new StringReader(""));
        String lineFeedChar = null;

        try {
            // eXg{
            new LineFeed1LineReader(reader, lineFeedChar);
            fail("IllegalArgumentException܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(e instanceof IllegalArgumentException);
            assertEquals("lineFeedChar is required.", e.getMessage());
        }
    }

    /**
     * testLineFeed1LineReader04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() reader:ReaderCX^X<br>
     * () lineFeedChar:s؂蕶1Ȃꍇ<br>
     * <br>
     * ҒlF(ԕω) Ȃ:IllegalArgumentException<br>
     * EbZ[WF"lineFeedChar should be defined by 1 digit of character string."<br>
     * <br>
     * lineFeedChar̍s؂蕶1Ȃꍇ IllegalArgumentException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testLineFeed1LineReader04() throws Exception {
        // O()
        Reader reader = new BufferedReader(new StringReader(""));
        String lineFeedChar = "aa";

        try {
            // eXg{
            new LineFeed1LineReader(reader, lineFeedChar);
            fail("IllegalArgumentException܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(e instanceof IllegalArgumentException);
            assertEquals("lineFeedChar should be defined"
                    + " by 1 digit of character string.", e.getMessage());
        }
    }

    /**
     * testReadLine01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FF.G <br>
     * <br>
     * ͒lF() reader:not null<br>
     * reader̃X^u<br>
     * IOExceptionB<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(ԕω) -:IOExceptionBFileExceptioɃbv邱ƂmFB<br>
     * <br>
     * OBreaderOX[ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine01() throws Exception {
        // Mock쐬
        Reader reader = EasyMock.createMock(Reader.class);
        EasyMock.expect(reader.read()).andReturn(null).andThrow(
                new IOException());
        EasyMock.replay(reader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                reader, tempLineFeedChar);

        // eXg{
        try {
            lineFeed1LineReader.readLine();
            fail("FileException܂łB");
        } catch (FileException e) {
            // 
            assertTrue(e instanceof FileException);
            assertEquals("Reader control operation was failed.", e.getMessage());
            assertTrue(e.getCause() instanceof IOException);
        }
    }

    /**
     * testReadLine02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:""()<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:""<br>
     * <br>
     * ̕񂪕ԋp̂mFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine02() throws Exception {
        // O(Ώ)

        String str = "";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        String lineFeedChar = "\r";
        UTUtil.setPrivateField(lineFeed1LineReader, "lineFeedChar",
                lineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("", resutl);
    }

    /**
     * testReadLine03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,aaa,aaa\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aaa,aaa"<br>
     * <br>
     * 1sԋp̂mFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine03() throws Exception {
        // O(Ώ)
        String str = "aaa,aaa,aaa\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("aaa,aaa,aaa", resutl);
    }

    /**
     * testReadLine04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aaa\",\"aaa\",\"aaa\"\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"\"aaa\",\"aaa\",\"aaa\""<br>
     * <br>
     * 1sԋpB͂ݕꍇB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine04() throws Exception {
        // O(Ώ)
        String str = "\"aaa\",\"aaa\",\"aaa\"\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("\"aaa\",\"aaa\",\"aaa\"", resutl);
    }

    /**
     * testReadLine05() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aa,a\",\"aa\"\"a\",\"aaa\"\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"\"aa,a\",\"aa\"\"a\",\"aaa\""<br>
     * <br>
     * ̒Ɉ͂ݕA؂蕶܂܂ĂꍇB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine05() throws Exception {
        // O(Ώ)
        String str = "\"aa,a\",\"aa\"\"a\",\"aaa\"\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String result = lineFeed1LineReader.readLine();

        // 
        assertEquals("\"aa,a\",\"aa\"\"a\",\"aaa\"", result);
    }

    /**
     * testReadLine06() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aaa\",\"aaa\",\"aa\ra\"\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"\"aaa\",\"aaa\",\"aa"<br>
     * <br>
     * ̒ɍs؂蕶܂܂ĂꍇB<br>
     * s؂蕶̂Ƃœǂݍ݂͏IB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine06() throws Exception {
        // O(Ώ)
        String str = "\"aaa\",\"aaa\",\"aa\ra\"\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String result = lineFeed1LineReader.readLine();

        // 
        assertEquals("\"aaa\",\"aaa\",\"aa", result);
    }

    /**
     * testReadLine07() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\"aaa\",\"aaa\",\"aaa\"aaa\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"\"aaa\",\"aaa\",\"aaa\"aaa"<br>
     * <br>
     * 1sԋpB͂ݕ(I)̌ɕ񂪂ȂꍇA ؂蕶͍s؂蕶܂ł͑̕SđÕJɊ܂܂B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine07() throws Exception {
        // O(Ώ)
        String str = "\"aaa\",\"aaa\",\"aaa\"aaa\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("\"aaa\",\"aaa\",\"aaa\"aaa", resutl);
    }

    /**
     * testReadLine08() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,aaa,aaa"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aaa,aaa"<br>
     * <br>
     * s؂蕶܂܂ĂȂꍇׂẴf[^o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine08() throws Exception {
        // O(Ώ)
        String str = "aaa,aaa,aaa";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("aaa,aaa,aaa", resutl);
    }

    /**
     * testReadLine09() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"\",\",\"\"\"\",\"\"\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"\",\",\"\"\"\",\"\""<br>
     * <br>
     * ̒Ɉ͂ݕASp܂܂ĂꍇB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine09() throws Exception {
        // O(Ώ)
        String str = "\",\",\"\"\"\",\"\"\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("\",\",\"\"\"\",\"\"", resutl);
    }

    /**
     * testReadLine10() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() readerǂݎ镶:"aaa,aaa,aaa\raaa,aaa,aaa\raaa,aaa,aaa\r"<br>
     * () reader:not null <br>
     * ReaderCX^X<br>
     * () lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) String:"aaa,aaa,aaa"<br>
     * <br>
     * s̕񂪂ꍇAʕ1ŝݕԋp̂mFB<br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine10() throws Exception {
        // O(Ώ)
        String str = "aaa,aaa,aaa\raaa,aaa,aaa\raaa,aaa,aaa\r";
        StringReader stringReader = new StringReader(str);
        BufferedReader bufReader = new BufferedReader(stringReader);

        String tempLineFeedChar = "\r";
        LineFeed1LineReader lineFeed1LineReader = new LineFeed1LineReader(
                bufReader, tempLineFeedChar);

        // eXg{
        String resutl = lineFeed1LineReader.readLine();

        // 
        assertEquals("aaa,aaa,aaa", resutl);
    }
}
