/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.FixedFileUpdateDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Œ蒷t@CpFileLineWriter𐶐B<br>
 * AbstractFileUpdateDAÕTuNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.FixedFileUpdateDAO
 */
public class FixedFileUpdateDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FixedFileUpdateDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public FixedFileUpdateDAOTest(String name) {
        super(name);
    }

    /**
     * testExecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:not null ""(󕶎)łȂ<br>
     * StringCX^X<br>
     * "aaa"<br>
     * () clazz: not null(FileFormatAme[VX^ugp)<br>
     * () getColumnFormatterMapij:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatterCX^X<br>
     * <br>
     * ҒlF(߂l) fileLineWriter:FixedFileLineWriter̃CX^X<br>
     * (ԕω) FixedFileLineWriter#FixedFileLineWriter(): 1Ă΂<br>
     * mF<br>
     * <br>
     * p^[<br>
     * ꂼnot nullł΁A߂lAĂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecute01() throws Exception {
        // eXgΏۂ̃CX^X
        FixedFileUpdateDAO fileUpdateDAO = new FixedFileUpdateDAO();

        // ̐ݒ
        String fileName = "aaa";
        Class<FixedFileUpdateDAO_Stub01> clazz = FixedFileUpdateDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        UTUtil.setPrivateField(fileUpdateDAO, "columnFormatterMap",
                columnFormatterMap);

        // eXg{
        FileLineWriter<FixedFileUpdateDAO_Stub01> fileLineWriter = fileUpdateDAO
                .execute(fileName, clazz);

        // ԋpl̊mF
        assertEquals(FixedFileLineWriter.class.getName(), fileLineWriter
                .getClass().getName());

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(FixedFileLineWriter.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(FixedFileLineWriter.class,
                "<init>", 0);
        assertSame(fileName, arguments.get(0));
        assertSame(clazz, arguments.get(1));
        assertSame(columnFormatterMap, arguments.get(2));

        // ㏈
        fileLineWriter.closeFile();
        // eXgt@C폜
        File file = new File("aaa");
        file.delete();
    }

}
