/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.text.DecimalFormat;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.DecimalFormatLocal} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> DecimalFormatXbhZ[tł͂Ȃ߁AThreadLocalgpăXbhZ[tɂB
 * <p>
 * @author I 
 * @see jp.terasoluna.fw.file.dao.standard.DecimalFormatLocal
 */
public class DecimalFormatLocalTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(DecimalFormatLocalTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DecimalFormatLocalTest(String name) {
        super(name);
    }

    /**
     * testDecimalFormatLocalStringpattern01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() pattern:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) this.pattern:patternƓl<br>
     * <br>
     * patternƓlݒ肳邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDecimalFormatLocalStringpattern01() throws Exception {
        // O()
        String pattern = new String();

        // eXg{
        DecimalFormatLocal decimalFormatLocal = new DecimalFormatLocal(pattern);

        // 
        assertNotNull(decimalFormatLocal);
        assertSame(pattern, UTUtil.getPrivateField(decimalFormatLocal,
                "pattern"));
    }

    /**
     * testInitialValue01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE.f <br>
     * <br>
     * ͒lF() pattern:null<br>
     * <br>
     * ҒlF(ԕω) Ȃ:NullPointerException<br>
     * <br>
     * Onull̏ꍇNullPointerException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInitialValue01() throws Exception {
        // O
        DecimalFormatLocal decimalFormatLocal = new DecimalFormatLocal(null);

        // O()
        UTUtil.setPrivateField(decimalFormatLocal, "pattern", null);

        try {
            // eXg{
            decimalFormatLocal.initialValue();
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testInitialValue02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() pattern:"-\\#,##0.##"<br>
     * <br>
     * ҒlF(߂l) DecimalFormat:patternɑ΂DecimalFormatCX^X<br>
     * <br>
     * OnullȂꍇ{邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInitialValue02() throws Exception {
        // O
        DecimalFormatLocal decimalFormatLocal = new DecimalFormatLocal(null);
        String pattern = "-\\#,##0.##";

        // O()
        UTUtil.setPrivateField(decimalFormatLocal, "pattern", pattern);

        // eXg{
        DecimalFormat result = decimalFormatLocal.initialValue();

        // 
        assertNotNull(result);
        assertTrue(result instanceof DecimalFormat);
        assertEquals(pattern, DecimalFormat.class.cast(result).toPattern());
    }
}
