/*
 * $Id: DecimalColumnFormatterTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.DecimalColumnFormatter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Ame[VcolumnFormat̋Lqɏ]A̕ϊsB
 * <p>
 * @author c Ni
 * @see jp.terasoluna.fw.file.dao.standard.DecimalColumnFormatter
 */
public class DecimalColumnFormatterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(DecimalColumnFormatterTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DecimalColumnFormatterTest(String name) {
        super(name);
    }

    /**
     * testFormat01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal01<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:null<br>
     * <br>
     * ҒlF(߂l) :"1000000"<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕null̏ꍇA tB[hgetter\bhݒ肳ĂꍇɁA ΏۃtB[h̏񂪐݂̂̕(BigDecimal.toPlainString()̌)
     * ƂĎ擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat01() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal01(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal01");

        String columnFormat = null;

        // eXg{
        String result = decimalColumnFormatter.format(stub, method,
                columnFormat);

        // 
        assertNotNull(result);
        assertEquals("1000000", result);
    }

    /**
     * testFormat02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal02<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:"\\##,###,###.00"<br>
     * <br>
     * ҒlF(߂l) :"\\1,000,000.00"<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕񂪐ݒ肳ꂽꍇA tB[hgetter\bhݒ肳ĂꍇɁA ΏۃtB[h̏񂪃tH[}bgɏ]ƂĎ擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat02() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal02(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal02");

        String columnFormat = "\\##,###,###.00";

        // eXg{
        String result = decimalColumnFormatter.format(stub, method,
                columnFormat);

        // 
        assertNotNull(result);
        assertEquals("\\1,000,000.00", result);
    }

    /**
     * testFormat03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal03<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFprivate<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:"\\##,###,###.00"<br>
     * <br>
     * ҒlF(ԕω) -:IllegalAccessException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tB[hgetter\bhprivateŐ錾ꂽꍇA IllegalAccessException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat03() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal03(new BigDecimal(1000000));

        Method method = stub.getClass().getDeclaredMethod("getDecimal03");

        String columnFormat = "\\##,###,###.00";

        // eXg{
        try {
            decimalColumnFormatter.format(stub, method, columnFormat);
            fail("IllegalAccessException܂łB");
        } catch (IllegalAccessException e) {
            // 
            assertTrue(e instanceof IllegalAccessException);
        }
    }

    /**
     * testFormat04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal04<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFOB<br>
     * () columnFormat:"\\##,###,###.00"<br>
     * <br>
     * ҒlF(ԕω) -:InvocationTargetException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tB[hgetter\bhOꍇA InvocationTargetException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat04() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal04(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal04");

        String columnFormat = "\\##,###,###.00";

        // eXg{
        try {
            decimalColumnFormatter.format(stub, method, columnFormat);
            fail("InvocationTargetException܂łB");
        } catch (InvocationTargetException e) {
            // 
            assertTrue(e instanceof InvocationTargetException);
        }
    }

    /**
     * testFormat05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal05<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EF<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:new String()<br>
     * <br>
     * ҒlF(ԕω) -:IllegalArgumentException邱ƂmFB<br>
     * <br>
     * ُP[X<br>
     * tB[hgetter\bhƂĈȂ̃\bh݂ȂꍇA IllegalArgumentException邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat05() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal05(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal05",
                new Class[] { BigDecimal.class });

        String columnFormat = new String();

        // eXg{
        try {
            decimalColumnFormatter.format(stub, method, columnFormat);
            fail("IllegalArgumentException܂łB");
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(e instanceof IllegalArgumentException);
        }
    }

    /**
     * testFormat06() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal06<br>
     * - ^FBigDecimal<br>
     * - ݒlFnull<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:null<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * t@CsIuWFNg̃tB[hlnull̏ꍇA󕶎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat06() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal06(null);

        Method method = stub.getClass().getMethod("getDecimal06");

        String columnFormat = null;

        // eXg{
        String result = decimalColumnFormatter.format(stub, method,
                columnFormat);

        // 
        assertNotNull(result);
        assertEquals("", result);

    }

    /**
     * testFormat07() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal07<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:""<br>
     * <br>
     * ҒlF(߂l) :"1000000"<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕񂪋󕶎̏ꍇAtB[hgetter\bh ݒ肳ĂꍇɁAΏۃtB[h̏񂪐݂̂̕ (BigDecimal.toPlainString()̌)ƂĎ擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat07() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal07(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal07");

        String columnFormat = "";

        // eXg{
        String result = decimalColumnFormatter.format(stub, method,
                columnFormat);

        // 
        assertNotNull(result);
        assertEquals("1000000", result);
    }

    /**
     * testFormat08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal08<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:"\\##,###,###.00"<br>
     * () dfMap:vfȂConcurrentHashMapCX^X<br>
     * <br>
     * ҒlF(߂l) :"\\1,000,000.00"<br>
     * (ԕω) dfMap:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"\\##,###,###.00"<br>
     * valueFL[ɑ΂DecimalFormatLocalCX^X<br>
     * (ԕω) DecimalFormatLocal#<init>:1Ă΂<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕ɑ΂DecimalFormatLocalLbVɑ݂ȂꍇA Ȃs邱ƂmFB<br>
     * ܂AVꂽtH[}bgp̕ɑ΂ DecimalFormatLocalLbV邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat08() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal08(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal08");

        String columnFormat = "\\##,###,###.00";

        ConcurrentHashMap<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();
        UTUtil.setPrivateField(decimalColumnFormatter, "dfMap", dfMap);
        dfMap.clear();

        // eXg{
        String result = decimalColumnFormatter.format(stub, method,
                columnFormat);

        // 
        assertNotNull(result);
        assertEquals("\\1,000,000.00", result);

        assertSame(dfMap, UTUtil.getPrivateField(decimalColumnFormatter,
                "dfMap"));
        assertEquals(1, dfMap.size());
        assertTrue(dfMap.containsKey(columnFormat));
        DecimalFormatLocal dfMapValue = dfMap.get(columnFormat);
        assertNotNull(dfMapValue);
        assertEquals(columnFormat, UTUtil
                .getPrivateField(dfMapValue, "pattern"));

        assertEquals(1, VMOUTUtil.getCallCount(DecimalFormatLocal.class,
                "<init>"));
    }

    /**
     * testFormat09() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() :ȉ̏ObjectCX^X<br>
     * EtB[h<br>
     * - tB[hFdecimal09<br>
     * - ^FBigDecimal<br>
     * - ݒlFnew BigDecimal(1000000)<br>
     * E\bh<br>
     * - tB[hɑ΂getterAsetter\bh݂B<br>
     * getter\bh̒`͈method̋Lqɏ]B<br>
     * () method:ΏۃtB[hɑ΂getter\bh̃CX^X<br>
     * EFpublic<br>
     * EFȂ<br>
     * EFΏۃtB[̏ԂB<br>
     * () columnFormat:"\\##,###,###.00"<br>
     * () dfMap:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"\\##,###,###.00"<br>
     * valueFL[ɑ΂DecimalFormatLocalCX^X<br>
     * <br>
     * ҒlF(߂l) :"\\1,000,000.00"<br>
     * (ԕω) dfMap:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"\\##,###,###.00"<br>
     * valueFL[ɑ΂DecimalFormatLocalCX^X<br>
     * (ԕω) DecimalFormatLocal#<init>:Ă΂Ȃ<br>
     * <br>
     * P[X<br>
     * tH[}bgp̕ɑ΂DecimalFormatLocalLbVɑ݂ꍇA Ȃs邱ƂmFB<br>
     * ܂AtH[}bgp̕ɑ΂DecimalFormatLocalVȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat09() throws Exception {
        // O
        DecimalColumnFormatter decimalColumnFormatter = new DecimalColumnFormatter();

        // O()
        DecimalColumnFormatter_FileLineObjectStub01 stub = new DecimalColumnFormatter_FileLineObjectStub01();
        stub.setDecimal09(new BigDecimal(1000000));

        Method method = stub.getClass().getMethod("getDecimal09");

        String columnFormat = "\\##,###,###.00";

        ConcurrentHashMap<String, DecimalFormatLocal> dfMap = new ConcurrentHashMap<String, DecimalFormatLocal>();
        DecimalFormatLocal dfMapValue = new DecimalFormatLocal(columnFormat);
        dfMap.put(columnFormat, dfMapValue);
        UTUtil.setPrivateField(decimalColumnFormatter, "dfMap", dfMap);

        VMOUTUtil.initialize();

        // eXg{
        String result = decimalColumnFormatter.format(stub, method,
                columnFormat);

        // 
        assertNotNull(result);
        assertEquals("\\1,000,000.00", result);

        assertSame(dfMap, UTUtil.getPrivateField(decimalColumnFormatter,
                "dfMap"));
        assertEquals(1, dfMap.size());
        assertTrue(dfMap.containsKey(columnFormat));
        DecimalFormatLocal formatLocal = dfMap.get(columnFormat);
        assertSame(dfMapValue, formatLocal);

        assertFalse(VMOUTUtil.isCalled(DecimalFormatLocal.class, "<init>"));
    }
}
