/*
 * $Id: DateColumnFormatterTest.java 5354 2007-10-03 06:06:25Z anh $
 * 
 * Copyright (c) 2006 NTT DATA Corporation
 * 
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.DateColumnFormatter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Ame[VcolumnFormat̋Lqɏ]A̕ϊsB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.DateColumnFormatter
 */
public class DateColumnFormatterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(DateColumnFormatterTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DateColumnFormatterTest(String name) {
        super(name);
    }

    /**
     * testFormat01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:null<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(߂l) String:methodDate^Ɋi[ĂlyyyyMMddtH[}bg̕ŏo͂<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * (ԕω) DateFormatLocalRXgN^:\bh1Ă΂B<br>
     * <br>
     * t@CsIuWFNgDate^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFBtH[}bgp̕null͋󕶎̏ꍇ̓tH[}bgs킸("yyyyMMdd")ɏo͂邱ƂmF
     * B}bvɃtH[}bgp̕LbVB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFormat01() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = null;

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(columnFormatter, "map", map);

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("19700101", testResult);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals("yyyyMMdd", VMOUTUtil.getArgument(Map.class, "get", 0, 0));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        List arguments = VMOUTUtil.getArguments(Map.class, "put", 0);
        assertEquals("yyyyMMdd", arguments.get(0));
        assertTrue(arguments.get(1) instanceof DateFormatLocal);
        Map getMap = (Map) UTUtil.getPrivateField(columnFormatter, "map");
        assertEquals(1, getMap.size());
        assertEquals(1, VMOUTUtil.getCallCount(DateFormatLocal.class, "<init>"));
        assertEquals("yyyyMMdd", VMOUTUtil.getArgument(DateFormatLocal.class,
                "<init>", 0, 0));
    }

    /**
     * testFormat02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:""<br>
     * () map:key:"yyyyMMdd"<br>
     * value:new DateFormatLocal("yyyyMMdd")<br>
     * <br>
     * ҒlF(߂l) String:methodDate^Ɋi[ĂlyyyyMMddtH[}bg̕ŏo͂<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bhĂ΂ȂB<br>
     * (ԕω) DateFormatLocalRXgN^:\bhĂ΂ȂB<br>
     * <br>
     * t@CsIuWFNgDate^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFB}bv擾tH[}bgp̕Őݒ肳ꂽƂɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat02() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        map.put("yyyyMMdd", new DateFormatLocal("yyyyMMdd"));
        UTUtil.setPrivateField(columnFormatter, "map", map);

        VMOUTUtil.initialize();

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("19700101", testResult);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals("yyyyMMdd", VMOUTUtil.getArgument(Map.class, "get", 0, 0));
        assertFalse(VMOUTUtil.isCalled(Map.class, "put"));
        assertFalse(VMOUTUtil.isCalled(DateFormatLocal.class, "<init>"));
    }

    /**
     * testFormat03() <br>
     * <br>
     * (n)<br>
     * <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:""<br>
     * () map:key:"yyyy-MM-dd"<br>
     * value:new DateFormatLocal("yyyy-MM-dd")<br>
     * <br>
     * ҒlF(߂l) String:methodDate^Ɋi[ĂlyyyyMMddtH[}bg̕ŏo͂<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * (ԕω) DateFormatLocalRXgN^:\bh1Ă΂B<br>
     * <br>
     * t@CsIuWFNgDate^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFBtH[}bgp̕null͋󕶎̏ꍇ̓tH[}bgs킸("yyyyMMdd")ɏo͂邱ƂmF
     * B}bvɃtH[}bgp̕LbVB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFormat03() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        map.put("yyyy-MM-dd", new DateFormatLocal("yyyy-MM-dd"));
        UTUtil.setPrivateField(columnFormatter, "map", map);

        VMOUTUtil.initialize();

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("19700101", testResult);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals("yyyyMMdd", VMOUTUtil.getArgument(Map.class, "get", 0, 0));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        List arguments = VMOUTUtil.getArguments(Map.class, "put", 0);
        assertEquals("yyyyMMdd", arguments.get(0));
        assertTrue(arguments.get(1) instanceof DateFormatLocal);
        Map getMap = (Map) UTUtil.getPrivateField(columnFormatter, "map");
        assertEquals(2, getMap.size());
        assertEquals(1, VMOUTUtil.getCallCount(DateFormatLocal.class, "<init>"));
        assertEquals("yyyyMMdd", VMOUTUtil.getArgument(DateFormatLocal.class,
                "<init>", 0, 0));
    }

    /**
     * testFormat04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(߂l) String:methodDate^Ɋi[Ăl̕BcolumnFormatŒ`tH[}bgŏo͂B<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * (ԕω) DateFormatLocalRXgN^:\bh1Ă΂B<br>
     * <br>
     * t@CsIuWFNgDate^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFBtH[}bgp̕Őݒ肳ꂽƂɏo͂邱ƂmFB}bvɃtH[}bgp̕LbVB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFormat04() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(columnFormatter, "map", map);

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("1970/01/01", testResult);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(columnFormat, VMOUTUtil
                .getArgument(Map.class, "get", 0, 0));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        List arguments = VMOUTUtil.getArguments(Map.class, "put", 0);
        assertEquals(columnFormat, arguments.get(0));
        assertTrue(arguments.get(1) instanceof DateFormatLocal);
        Map getMap = (Map) UTUtil.getPrivateField(columnFormatter, "map");
        assertEquals(1, getMap.size());
        assertEquals(1, VMOUTUtil.getCallCount(DateFormatLocal.class, "<init>"));
        assertEquals(columnFormat, VMOUTUtil.getArgument(DateFormatLocal.class,
                "<init>", 0, 0));
    }

    /**
     * testFormat05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * () map:key:"yyyy/MM/dd"<br>
     * value:new DateFormatLocal("yyyy/MM/dd")<br>
     * <br>
     * ҒlF(߂l) String:methodDate^Ɋi[Ăl̕BcolumnFormatŒ`tH[}bgŏo͂B<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bhĂ΂ȂB<br>
     * (ԕω) DateFormatLocalRXgN^:\bhĂ΂ȂB<br>
     * <br>
     * t@CsIuWFNgDate^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFB}bv擾tH[}bgp̕Őݒ肳ꂽƂɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat05() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        map.put(columnFormat, new DateFormatLocal(columnFormat));
        UTUtil.setPrivateField(columnFormatter, "map", map);

        VMOUTUtil.initialize();

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("1970/01/01", testResult);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(columnFormat, VMOUTUtil
                .getArgument(Map.class, "get", 0, 0));
        assertFalse(VMOUTUtil.isCalled(Map.class, "put"));
        assertFalse(VMOUTUtil.isCalled(DateFormatLocal.class, "<init>"));
    }

    /**
     * testFormat06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * () map:key:"yyyy-MM-dd"<br>
     * value:new DateFormatLocal("yyyy-MM-dd")<br>
     * <br>
     * ҒlF(߂l) String:methodDate^Ɋi[Ăl̕BcolumnFormatŒ`tH[}bgŏo͂B<br>
     * (ԕω) Map.get():\bh1Ă΂B<br>
     * (ԕω) Map.put():\bh1Ă΂B<br>
     * (ԕω) DateFormatLocalRXgN^:\bh1Ă΂B<br>
     * <br>
     * t@CsIuWFNgDate^Ɋi[ĂIuWFNg̕擾邱Ƃł邱ƂmFBtH[}bgp̕Őݒ肳ꂽƂɏo͂邱ƂmFB}bvɃtH[}bgp̕LbVB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFormat06() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        map.put("yyyy-MM-dd", new DateFormatLocal("yyyy-MM-dd"));
        UTUtil.setPrivateField(columnFormatter, "map", map);

        VMOUTUtil.initialize();

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("1970/01/01", testResult);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        assertEquals(columnFormat, VMOUTUtil
                .getArgument(Map.class, "get", 0, 0));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        List arguments = VMOUTUtil.getArguments(Map.class, "put", 0);
        assertEquals(columnFormat, arguments.get(0));
        assertTrue(arguments.get(1) instanceof DateFormatLocal);
        Map getMap = (Map) UTUtil.getPrivateField(columnFormatter, "map");
        assertEquals(2, getMap.size());
        assertEquals(1, VMOUTUtil.getCallCount(DateFormatLocal.class, "<init>"));
        assertEquals(columnFormat, VMOUTUtil.getArgument(DateFormatLocal.class,
                "<init>", 0, 0));
    }

    /**
     * testFormat07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fprivate<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * <br>
     * ҒlF(ԕω) O:IllegalAccessException邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgDate^getter\bhɃANZXłȂꍇAIllegalAccessExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat07() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub02 stub = new DateColumnFormatter_Stub02();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getDeclaredMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // OȂ

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("IllegalAccessException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalAccessException.class, e.getClass());
        }
    }

    /**
     * testFormat08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFOX[<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * <br>
     * ҒlF(ԕω) O:InvocationTargetException邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgDate^getter\bhOX[ꍇAgetter\bhX[ObvInvocationTargetExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat08() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub03 stub = new DateColumnFormatter_Stub03();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("InvocationTargetException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(InvocationTargetException.class, e.getClass());
        }
    }

    /**
     * testFormat09() <br>
     * <br>
     * (ُn) <br>
     * <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @F<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException邱ƂmFB<br>
     * <br>
     * t@CsIuWFNgDate^getter\bḧꍇAIllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat09() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub04 stub = new DateColumnFormatter_Stub04();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate",
                new Class[] { Date.class });
        String columnFormat = "yyyy/MM/dd";

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    /**
     * testFormat10() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnew Date(0)<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"AAA"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException邱ƂmFB<br>
     * <br>
     * columnFormatɐȂtp^[ꂽꍇ́AIllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat10() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "AAA";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(columnFormatter, "map", map);

        // eXg{
        try {
            columnFormatter.format(stub, method, columnFormat);
            fail("IllegalArgumentException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class, e.getClass());
        }
    }

    /**
     * testFormat11() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :not null<br>
     * Date^tB[h<br>
     * @lFnull<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(߂l) String:󕶎<br>
     * (ԕω) Map.get():\bhĂ΂ȂB<br>
     * (ԕω) Map.put():\bhĂ΂ȂB<br>
     * (ԕω) DateFormatLocalRXgN^:\bhĂ΂ȂB<br>
     * <br>
     * tDate^tB[hnullݒ肳Ăꍇ́A󕶎ԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat11() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(columnFormatter, "map", map);

        // eXg{
        String testResult = columnFormatter.format(stub, method, columnFormat);

        // ԋpl̊mF
        assertEquals("", testResult);

        // ԕω̊mF
        assertFalse(VMOUTUtil.isCalled(Map.class, "get"));
        assertFalse(VMOUTUtil.isCalled(Map.class, "put"));
        assertFalse(VMOUTUtil.isCalled(DateFormatLocal.class, "<init>"));
    }

    /**
     * testFormat12() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :null<br>
     * () t@CsIuWFNg(t)ɂDate^getter\bh<br>
     * method:ȉ̐ݒMethodCX^X<br>
     * @Fpublic<br>
     * @FȂ<br>
     * () tH[}bgp̕<br>
     * columnFormat:"yyyy/MM/dd"<br>
     * () map:vfȂ<br>
     * <br>
     * ҒlF(ԕω) O:NullPointerException邱ƂmFB<br>
     * <br>
     * tnullꍇ́ANullPointerExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */

    public void testFormat12() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new DateColumnFormatter();

        // ̐ݒ
        DateColumnFormatter_Stub01 stub = new DateColumnFormatter_Stub01();
        UTUtil.setPrivateField(stub, "date", new Date(0));
        Method method = stub.getClass().getMethod("getDate");
        String columnFormat = "yyyy/MM/dd";

        // O̐ݒ
        Map<String, DateFormatLocal> map = new ConcurrentHashMap<String, DateFormatLocal>();
        UTUtil.setPrivateField(columnFormatter, "map", map);

        // eXg{
        try {
            columnFormatter.format(null, method, columnFormat);
            fail("NullPointerException܂łBsłB");
        } catch (Exception e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(NullPointerException.class, e.getClass());
        }
    }

}
