/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.File;
import java.util.HashMap;
import java.util.List;

import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.CSVFileUpdateDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> CSVt@CpFileLineWriter𐶐B<br>
 * AbstractFileUpdateDAÕTuNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.CSVFileUpdateDAO
 */
public class CSVFileUpdateDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(CSVFileUpdateDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public CSVFileUpdateDAOTest(String name) {
        super(name);
    }

    /**
     * testExecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * () clazz:Class<T>CX^X<br>
     * () AbstractFileUpdateDAO.columnFormatterMap: HashMapCX^X<br>
     * <br>
     * ҒlF(߂l) fileLineWriter:CSVFileLineWriter<T>CX^X<br>
     * (ԕω) CSVFileLineWriter#CSVFileLineWriter():1Ă΂B<br>
     * Ă΂Ƃ̈mFB<br>
     * (ԕω) AbstractFileUpdateDAO#getColumnFormatterMap(): 1Ă΂<br>
     * <br>
     * p^[<br>
     * ꂼnot nullł΁A߂lAĂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecute01() throws Exception {
        // eXgΏۂ̃CX^X
        CSVFileUpdateDAO fileUpdateDAO = new CSVFileUpdateDAO();

        // ̐ݒ
        String fileName = "aaa";
        Class<CSVFileUpdateDAO_Stub01> clazz = CSVFileUpdateDAO_Stub01.class;

        // O̐ݒ
        HashMap<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        UTUtil.setPrivateField(fileUpdateDAO, "columnFormatterMap",
                columnFormatterMap);

        // eXg{
        FileLineWriter<CSVFileUpdateDAO_Stub01> fileLineWriter = fileUpdateDAO
                .execute(fileName, clazz);

        // ԋpl̊mF
        assertEquals(CSVFileLineWriter.class, fileLineWriter.getClass());

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(CSVFileLineWriter.class,
                "<init>"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileUpdateDAO.class,
                "getColumnFormatterMap"));
        List arguments = VMOUTUtil.getArguments(CSVFileLineWriter.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertEquals(columnFormatterMap, arguments.get(2));

        // N[Y
        fileLineWriter.closeFile();
        // eXgt@C폜
        File file = new File("aaa");
        file.delete();
    }

}
