/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.CSVFileLineWriter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CsIuWFNgf[^ǂݍ݁A 1s̃f[^CSV`Ńt@C ɏށB<br>
 * AbstractFileLineWriter̃TuNXB
 * <p>
 * @author c Ni
 * @author  O
 * @see jp.terasoluna.fw.file.dao.standard.CSVFileLineWriter
 */
public class CSVFileLineWriterTest {

    private static final String TEMP_FILE_NAME = CSVFileLineWriterTest.class
            .getResource("CSVFileLineWriterTest_tmp.txt").getPath();

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(CSVFileLineWriterTest.class);
    }

    @Before
    public void setUp() throws Exception {
        VMOUTUtil.initialize();
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    /**
     * testCSVFileLineWriter01() <br>
     * <br>
     * (ُn) <br>
     * <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:"(pX)CSVFileLineWriter_testCSVFileLineWriter01.txt"<br>
     * () clazz:CSVFileLineWriter_Stub05CX^X<br>
     * @@FileFormat̐ݒ<br>
     * @@delimiter='A'<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatter.java<br>
     * <br>
     * ҒlF(ԕω) O:"Delimiter can not change."̃bZ[WAIllegalStateExceptionAt@CFileExceptionB<br>
     * <br>
     * OB@FileFormatdelimiterɏlȊOݒ肵ꍇAO邱ƂmFB<br>
     * t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testCSVFileLineWriter01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^̎sv

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<CSVFileLineWriter_Stub05> clazz = CSVFileLineWriter_Stub05.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O̐ݒ
        // Ȃ
        CSVFileLineWriter<CSVFileLineWriter_Stub05> writer = null;

        try {
            // eXg{
            writer = new CSVFileLineWriter<CSVFileLineWriter_Stub05>(fileName,
                    clazz, columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("Delimiter can not change.", e.getMessage());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
        } finally {
            if (writer != null) {
                writer.closeFile();
            }
        }
    }

    /**
     * testCSVFileLineWriter02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:"(pX)CSVFileLineWriter_testCSVFileLineWriter02.txt"<br>
     * () clazz:CSVFileLineWriter_Stub01<br>
     * @@FileFormat̐ݒ<br>
     * @@delimiterȊO=ftHglȊO<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatter.java<br>
     * <br>
     * ҒlF(ԕω) this.encloseChar:clazz̃Ame[VFileFormatencloseChar()̒lB<br>
     * (ԕω) AbstractFileLineWriter#AbstractFileLineWriter():1Ăяo邱<br>
     * mF邱<br>
     * (ԕω) AbstractFileLineWriter#init():1Ăяo邱<br>
     * <br>
     * @FileFormatdelimiterȊO̐ݒftHglł͂Ȃf[^Őݒ肵ꍇARXgN^̌Ăяoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testCSVFileLineWriter02() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^̎sv

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<CSVFileLineWriter_Stub01> clazz = CSVFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O̐ݒ
        // Ȃ

        CSVFileLineWriter<CSVFileLineWriter_Stub01> result = null;
        try {
            // eXg{
            result = new CSVFileLineWriter<CSVFileLineWriter_Stub01>(fileName,
                    clazz, columnFormatterMap);

            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals('\"', UTUtil.getPrivateField(result, "encloseChar"));

            int superCallCount = VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "<init>");
            assertEquals(1, superCallCount);
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "<init>", 0);
            assertEquals(3, arguments.size());
            assertEquals(fileName, arguments.get(0));
            assertEquals(CSVFileLineWriter_Stub01.class, arguments.get(1));
            assertEquals(columnFormatterMap, arguments.get(2));

            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "init"));
        } finally {
            // eXgΏۂ̃N[Y
            if (result != null) {
                result.closeFile();
            }
        }
    }

    /**
     * ُn<br>
     * t@CsIuWFNgOutputFileColumnAme[V
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testCSVFileLineWriter03() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<FileLineObject_Empty> clazz = FileLineObject_Empty.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<FileLineObject_Empty> writer = null;
        // eXg{
        try {
            new CSVFileLineWriter<FileLineObject_Empty>(fileName, clazz,
                    columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("OutputFileColumn is not found.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        } finally {
            if (writer != null) {
                writer.closeFile();
            }
        }
    }

    /**
     * testGetColumn01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() t:CSVFileLineWriter_Stub06CX^X<br>
     * @@FileFormat()<br>
     * @Stringϐcolumn01<br>
     * @@Ame[VF@OutputFileColumn(columnIndex = 0)<br>
     * @@lF"abcdef"<br>
     * () index:0<br>
     * <br>
     * ҒlF(߂l) String:"abcdef"<br>
     * (ԕω) AbstractFileLineWriter#getColumn():nāA1Ăяo邱<br>
     * <br>
     * tɐݒ肳ꂽNXi͂ݕݒ肳ĂȂꍇj̃JCfbNX1̑li͂ݕ܂܂Ȃj擾ł邱ƂmFeXgB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    @SuppressWarnings("unchecked")
    public void testGetColumn01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<CSVFileLineWriter_Stub06> lineWriter = new CSVFileLineWriter<CSVFileLineWriter_Stub06>(
                fileName, CSVFileLineWriter_Stub06.class, columnFormatterMap);

        // ̐ݒ
        CSVFileLineWriter_Stub06 stub = new CSVFileLineWriter_Stub06();
        stub.setColumn01("abcdef");

        // O̐ݒ
        // Ȃ

        try {
            // eXg{
            String result = lineWriter.getColumn(stub, 0);

            // ԋpl̊mF
            assertEquals("abcdef", result);

            // ԕω̊mF
            int superCallCount = VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn");
            assertEquals(1, superCallCount);
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, arguments.size());
            assertSame(stub, arguments.get(0));
            assertEquals(0, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() t:CSVFileLineWriter_Stub07CX^X<br>
     * @@FileFormat(encloseChar='\"')<br>
     * @Stringϐcolumn01<br>
     * @@Ame[VF@OutputFileColumn(columnIndex = 0)<br>
     * @@lF"abcdef"<br>
     * () index:0<br>
     * <br>
     * ҒlF(߂l) String:"abcdef"<br>
     * (ԕω) AbstractFileLineWriter#getColumn():nāA1Ăяo邱<br>
     * <br>
     * tɐݒ肳ꂽNXi͂ݕݒ肳Ăꍇj̃JCfbNX1̑li͂ݕ܂܂Ȃj擾ł邱ƂmFeXgB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    @SuppressWarnings("unchecked")
    public void testGetColumn02() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        CSVFileLineWriter<CSVFileLineWriter_Stub07> lineWriter = new CSVFileLineWriter<CSVFileLineWriter_Stub07>(
                fileName, CSVFileLineWriter_Stub07.class, columnFormatterMap);

        // ̐ݒ
        CSVFileLineWriter_Stub07 stub = new CSVFileLineWriter_Stub07();
        stub.setColumn01("abcdef");

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            String result = lineWriter.getColumn(stub, 0);

            // ԋpl̊mF
            assertEquals("abcdef", result);

            // ԕω̊mF
            int superCallCount = VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn");
            assertEquals(1, superCallCount);
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, arguments.size());
            assertSame(stub, arguments.get(0));
            assertEquals(0, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() t:CSVFileLineWriter_Stub07CX^X<br>
     * @@FileFormat(encloseChar='\"')<br>
     * @Stringϐcolumn01<br>
     * @@Ame[VF@OutputFileColumn(columnIndex = 0)<br>
     * @@lF"ab\"cdef"<br>
     * () index:0<br>
     * <br>
     * ҒlF(߂l) String:"ab""cdef"<br>
     * (ԕω) AbstractFileLineWriter#getColumn():nāA1Ăяo邱<br>
     * <br>
     * tɐݒ肳ꂽNXi͂ݕݒ肳Ăꍇj̃JCfbNX1̑li͂ݕ܂܂jGXP[vāA擾ł邱ƂmFeXgB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    @SuppressWarnings("unchecked")
    public void testGetColumn03() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        CSVFileLineWriter<CSVFileLineWriter_Stub07> lineWriter = new CSVFileLineWriter<CSVFileLineWriter_Stub07>(
                fileName, CSVFileLineWriter_Stub07.class, columnFormatterMap);

        // ̐ݒ
        CSVFileLineWriter_Stub07 stub = new CSVFileLineWriter_Stub07();
        UTUtil.setPrivateField(stub, "column01", "ab\"cdef");

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            String result = lineWriter.getColumn(stub, 0);

            // ԋpl̊mF
            assertEquals("ab\"\"cdef", result);

            // ԕω̊mF
            int superCallCount = VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn");
            assertEquals(1, superCallCount);
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, arguments.size());
            assertSame(stub, arguments.get(0));
            assertEquals(0, arguments.get(1));
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetColumn04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:CSVFileLineWriter_Stub06CX^X<br>
     * @@FileFormat()<br>
     * @Stringϐcolumn01<br>
     * @@Ame[VF@OutputFileColumn(columnIndex = 0)<br>
     * @@lF"abcdef"<br>
     * () index:1<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#getColumn():nāA1Ăяo邱<br>
     * (ԕω) O:ArrayIndexOutOfBoundsException<br>
     * AbstractFileLineWriter#getColumn()Ŕ<br>
     * <br>
     * indexɃJCfbNXɑ݂ȂlnƁAArrayIndexOutOfBoundsException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    @SuppressWarnings("unchecked")
    public void testGetColumn04() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        CSVFileLineWriter<CSVFileLineWriter_Stub06> lineWriter = new CSVFileLineWriter<CSVFileLineWriter_Stub06>(
                fileName, CSVFileLineWriter_Stub06.class, columnFormatterMap);

        // ̐ݒ
        CSVFileLineWriter_Stub06 stub = new CSVFileLineWriter_Stub06();
        UTUtil.setPrivateField(stub, "column01", "abcdef");

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            lineWriter.getColumn(stub, 1);
            fail("ArrayIndexOutOfBoundsExceptionX[܂łB");
        } catch (ArrayIndexOutOfBoundsException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            int superCallCount = VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getColumn");
            assertEquals(1, superCallCount);
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "getColumn", 0);
            assertEquals(2, arguments.size());
            assertSame(stub, arguments.get(0));
            assertEquals(1, arguments.get(1));

            assertEquals(ArrayIndexOutOfBoundsException.class, e.getClass());
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.delimiter:"','"<br>
     * <br>
     * ҒlF(߂l) this.delimiter:"','"<br>
     * <br>
     * delimitergetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<CSVFileLineWriter_Stub04> lineWriter = new CSVFileLineWriter<CSVFileLineWriter_Stub04>(
                fileName, CSVFileLineWriter_Stub04.class, columnFormatterMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // ftHgňȉɂȂĂ邽߁AȂ
        // this.delimiter:"','"

        // eXg{
        try {
            char result = lineWriter.getDelimiter();

            // ԋpl̊mF
            assertEquals(',', result);

            // ԕω̊mF
            // Ȃ
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() this.encloseChar:'\u0000'<br>
     * <br>
     * ҒlF(߂l) this.encloseChar:'\u0000'<br>
     * <br>
     * encloseChargetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<CSVFileLineWriter_Stub04> lineWriter = new CSVFileLineWriter<CSVFileLineWriter_Stub04>(
                fileName, CSVFileLineWriter_Stub04.class, columnFormatterMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // ftHgňȉɂȂĂ邽߁AȂ
        // this.encloseChar:\u0000'

        // eXg{
        try {
            char result = lineWriter.getEncloseChar();

            // ԋpl̊mF
            assertEquals('\u0000', result);

            // ԕω̊mF
            // Ȃ
        } finally {
            // eXgΏۂ̃N[Y
            lineWriter.closeFile();
        }
    }

    /**
     * n<br>
     * OutputFileColumncolumnEncloseCharɂāAX̃JɈ͂ݕݒ
     * @throws Exception
     */
    @Test
    public void testPrintDataLine01() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<CSVFileLine_Stub01> fileLineWriter = new CSVFileLineWriter<CSVFileLine_Stub01>(
                fileName, CSVFileLine_Stub01.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub01 t1 = new CSVFileLine_Stub01();
        CSVFileLine_Stub01 t2 = new CSVFileLine_Stub01();
        CSVFileLine_Stub01 t3 = new CSVFileLine_Stub01();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");
        t2.setColumn1("5");
        t2.setColumn2("66");
        t2.setColumn3("777");
        t2.setColumn4("8888");
        t3.setColumn1("9");
        t3.setColumn2("AA");
        t3.setColumn3("BBB");
        t3.setColumn4("CCCC");

        // eXg{
        fileLineWriter.printDataLine(t1);
        fileLineWriter.printDataLine(t2);
        fileLineWriter.printDataLine(t3);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("\"1\",22,333,|4444|", reader.readLine());
            assertEquals("\"5\",66,777,|8888|", reader.readLine());
            assertEquals("\"9\",AA,BBB,|CCCC|", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * n<br>
     * FileFormatencloseCharOutputFileColumncolumnEncloseCharɂāAX̃JɈ͂ݕݒ
     * @throws Exception
     */
    @Test
    public void testPrintDataLine02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<CSVFileLine_Stub02> fileLineWriter = new CSVFileLineWriter<CSVFileLine_Stub02>(
                fileName, CSVFileLine_Stub02.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub02 t1 = new CSVFileLine_Stub02();
        CSVFileLine_Stub02 t2 = new CSVFileLine_Stub02();
        CSVFileLine_Stub02 t3 = new CSVFileLine_Stub02();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");
        t2.setColumn1("5");
        t2.setColumn2("66");
        t2.setColumn3("777");
        t2.setColumn4("8888");
        t3.setColumn1("9");
        t3.setColumn2("AA");
        t3.setColumn3("BBB");
        t3.setColumn4("CCCC");

        // eXg{
        fileLineWriter.printDataLine(t1);
        fileLineWriter.printDataLine(t2);
        fileLineWriter.printDataLine(t3);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("\"1\",'22',\"333\",|4444|", reader.readLine());
            assertEquals("\"5\",'66',\"777\",|8888|", reader.readLine());
            assertEquals("\"9\",'AA',\"BBB\",|CCCC|", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * n<br>
     * LbVĂAme[V̏𗘗pĂ鎖mFB<br>
     * @throws Exception
     */
    @Test
    public void testPrintDataLine03() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        CSVFileLineWriter<CSVFileLine_Stub03> fileLineWriter = new CSVFileLineWriter<CSVFileLine_Stub03>(
                fileName, CSVFileLine_Stub03.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub03 t1 = new CSVFileLine_Stub03();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");

        // t@CsIuWFNgɐݒ肵ĂlSď㏑
        // ȉ̐ݒ肪Kp΁At@CsIuWFNg
        // Ame[VɃANZXĂȂƂɂȂB
        char[] charArray = new char[] { 0, 0, 0, 0 };
        // O
        UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", "\r\n");
        UTUtil.setPrivateField(fileLineWriter, "delimiter", '_');
        UTUtil.setPrivateField(fileLineWriter, "outputFileColumns", null);
        UTUtil.setPrivateField(fileLineWriter, "columnFormats", new String[] {
                "", "", "", "" });
        UTUtil.setPrivateField(fileLineWriter, "columnBytes", new int[] { -1,
                -1, -1, -1 });
        // UTUtil.setPrivateField(fileLineWriter, "totalBytes", 0);
        UTUtil.setPrivateField(fileLineWriter, "paddingTypes",
                new PaddingType[] { PaddingType.NONE, PaddingType.NONE,
                        PaddingType.NONE, PaddingType.NONE });
        UTUtil.setPrivateField(fileLineWriter, "paddingChars", charArray);
        UTUtil.setPrivateField(fileLineWriter, "trimChars", charArray);
        UTUtil.setPrivateField(fileLineWriter, "columnEncloseChar", charArray);
        UTUtil.setPrivateField(fileLineWriter, "stringConverters",
                new NullStringConverter[] { new NullStringConverter(),
                        new NullStringConverter(), new NullStringConverter(),
                        new NullStringConverter() });

        // eXg{
        fileLineWriter.printDataLine(t1);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("1_22_333_4444", reader.readLine());
        } finally {
            reader.close();
        }
    }
}
