/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.annotation.StringConverter;
import jp.terasoluna.fw.file.annotation.StringConverterToLowerCase;
import jp.terasoluna.fw.file.annotation.StringConverterToUpperCase;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.FileLineException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CANZX(ǎ)̃X[p[NXBۃNX̂߁AAbstractFileLineIteratorImplNX쐬Ď{B
 * <p>
 * @author cNi
 * @author O
 * @see jp.terasoluna.fw.file.dao.standard.AbstractFileLineIterator
 */
public class AbstractFileLineIteratorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(AbstractFileLineIteratorTest.class
        // .getClass());
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public AbstractFileLineIteratorTest(String name) {
        super(name);
    }

    /**
     * testAbstractFileLineIteratorStringClassMap01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init01"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF"\r"(ftHglȊO)<br>
     *                       - fileEncodingF"MS932"(ftHglȊO)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     *                       "AbstractFileLineIterator_init01"<br>
     *                       (ԕω) this.clazz:clazẑƓCX^X<br>
     *                       (ԕω) lineFeedChar:"\r"<br>
     *                       (ԕω) fileEncoding:"MS932"<br>
     *                       (ԕω) headerLineCount:1<br>
     *                       (ԕω) trailerLineCount:1<br>
     *                       (ԕω) this.columnParserMap:columnParserMapCX^X<br>
     *                       (ԕω) O:Ȃ<br>
     * <br>
     *                       p^[B<br>
     *                       ɐݒ肳ꂽɂAbstractFileLineIteratorNXĐ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAbstractFileLineIteratorStringClassMap01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init01";
        Class<AbstractFileLineIterator_Stub01> clazz = AbstractFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(fileName, UTUtil.getPrivateField(fileLineIterator,
                "fileName"));
        assertSame(AbstractFileLineIterator_Stub01.class, UTUtil
                .getPrivateField(fileLineIterator, "clazz"));
        assertEquals("\r", UTUtil.getPrivateField(fileLineIterator,
                "lineFeedChar"));
        assertEquals("MS932", UTUtil.getPrivateField(fileLineIterator,
                "fileEncoding"));
        assertEquals(1, UTUtil.getPrivateField(fileLineIterator,
                "headerLineCount"));
        assertEquals(1, UTUtil.getPrivateField(fileLineIterator,
                "trailerLineCount"));
        assertSame(columnParserMap, UTUtil.getPrivateField(fileLineIterator,
                "columnParserMap"));
    }

    /**
     * testAbstractFileLineIteratorStringClassMap02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:null<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF"\r"(ftHglȊO)<br>
     *                       - fileEncodingF"MS932"(ftHglȊO)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"fileName is required."<br>
     *                       EOFIllegalArgumentException<br>
     *                       Et@CFnull<br>
     * <br>
     *                       OB<br>
     *                       t@Cݒ肳ĂȂ(null)ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAbstractFileLineIteratorStringClassMap02() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = null;
        Class<AbstractFileLineIterator_Stub01> clazz = AbstractFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("fileName is required.", e.getMessage());
            assertSame(IllegalArgumentException.class, e.getCause().getClass());
            assertNull(e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init03"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒĂȂ<br> () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                         E"int"=IntColumnParser<br>
     *                         E"java.lang.String"=NullColumnParser.java<br>
     *                         () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                         @<br>
     * <br>
     *                         ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                         EbZ[WF"FileFormat annotation is not found."<br>
     *                         EOFIllegalStateException<br>
     *                         Et@CFfileNameƓCX^XB<br>
     * <br>
     *                         OB<br>
     *                         clazzɓnꂽNXCX^XɁA@FileFormat̐ݒ肪݂Ȃꍇ́AO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractFileLineIteratorStringClassMap03() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init03";
        Class<AbstractFileLineIterator_Stub02> clazz = AbstractFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub02>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("FileFormat annotation is not found.", e.getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC,E <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init04"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF""(󕶎)<br>
     *                       - fileEncodingF""(󕶎)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) this.fileName:fileNameƓCX^X<br>
     *                       "AbstractFileLineIterator_init04"<br>
     *                       (ԕω) this.clazz:clazẑƓCX^X<br>
     *                       (ԕω) lineFeedChar:VXe̍s؂蕶<br>
     *                       System.getProperty("line.separator")<br>
     *                       (ԕω) fileEncoding:VXẽt@CGR[fBO<br>
     *                       System.getProperty("file.encoding")<br>
     *                       (ԕω) headerLineCount:1<br>
     *                       (ԕω) trailerLineCount:1<br>
     *                       (ԕω) this.columnParserMap:columnParserMapCX^X<br>
     * <br>
     *                       p^[B<br>
     *                       clazzɓnꂽNXCX^X́FileFormatɁulineFeedCharvƁufileEncodingv󕶎Őݒ肳ĂꍇAAbstractFileLineIteratorNXthis
     *                       .lineFeddCharthis.fileEncodingVXeftHglŏĐ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractFileLineIteratorStringClassMap04() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init04";
        Class<AbstractFileLineIterator_Stub03> clazz = AbstractFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub03> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub03>(
                fileName, clazz, columnParserMap);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(fileName, UTUtil.getPrivateField(fileLineIterator,
                "fileName"));
        assertSame(AbstractFileLineIterator_Stub03.class, UTUtil
                .getPrivateField(fileLineIterator, "clazz"));
        assertSame(System.getProperty("line.separator"), UTUtil
                .getPrivateField(fileLineIterator, "lineFeedChar"));
        assertSame(System.getProperty("file.encoding"), UTUtil.getPrivateField(
                fileLineIterator, "fileEncoding"));
        assertEquals(1, UTUtil.getPrivateField(fileLineIterator,
                "headerLineCount"));
        assertEquals(1, UTUtil.getPrivateField(fileLineIterator,
                "trailerLineCount"));
        assertSame(columnParserMap, UTUtil.getPrivateField(fileLineIterator,
                "columnParserMap"));
    }

    /**
     * testAbstractFileLineIteratorStringClassMap05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init05"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF";"(encloseCharƓl)<br>
     *                       - encloseCharF";"(delimiterƓl)<br>
     *                       - lineFeedCharF"\r"(ftHglȊO)<br>
     *                       - fileEncodingF"MS932"(ftHglȊO)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) lineFeedChar:I8<br>
     *                       (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"Delimiter is the same as EncloseChar and is no use."<br>
     *                       EOFIllegalStateException<br>
     *                       Et@CFfileNameƓCX^XB<br>
     * <br>
     *                       OB<br>
     *                       clazzɓnꂽNXCX^X@FileFormaɁudelimitervƁuencloseCharvꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractFileLineIteratorStringClassMap05() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init05";
        Class<AbstractFileLineIterator_Stub04> clazz = AbstractFileLineIterator_Stub04.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub04>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Delimiter is the same as EncloseChar and is no use.",
                    e.getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * ""<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF"\r"(ftHglȊO)<br>
     *                       - fileEncodingF"MS932"(ftHglȊO)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"fileName is required."<br>
     *                       EOFIllegalArgumentException<br>
     *                       Et@CF""(󕶎)<br>
     * <br>
     *                       OB<br>
     *                       t@C󕶎̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAbstractFileLineIteratorStringClassMap06() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "";
        Class<AbstractFileLineIterator_Stub01> clazz = AbstractFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("fileName is required.", e.getMessage());
            assertSame(IllegalArgumentException.class, e.getCause().getClass());
            assertEquals("", e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init07"<br>
     * () clazz:null<br>
     * () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"int"=IntColumnParser<br>
     * E"java.lang.String"=NullColumnParser.java<br>
     * () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"clazz is required."<br>
     * EOFIllegalArgumentException<br>
     * Et@CFfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * clazzunullv̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAbstractFileLineIteratorStringClassMap07() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init07";
        Class<AbstractFileLineIterator_Stub01> clazz = null;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("clazz is required.", e.getMessage());
            assertSame(IllegalArgumentException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init08"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF"\r"(ftHglȊO)<br>
     *                       - fileEncodingF"MS932"(ftHglȊO)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:null<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"columnFormaterMap is required."<br>
     *                       EOFIllegalArgumentException<br>
     *                       Et@CFfileNameƓCX^XB<br>
     * <br>
     *                       OB<br>
     *                       columnParserMapunullv̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAbstractFileLineIteratorStringClassMap08() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init08";
        Class<AbstractFileLineIterator_Stub01> clazz = AbstractFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = null;

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("columnFormaterMap is required.", e.getMessage());
            assertSame(IllegalArgumentException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init11"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF""(󕶎)<br>
     *                       - fileEncodingF""(󕶎)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     * <br>
     *                       ۃNXłB<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"Failed in instantiation of clazz."<br>
     *                       EOFInstantiationException<br>
     *                       Et@CFfileNameƓCX^XB<br>
     * <br>
     *                       OB<br>
     *                       CX^XłȂClassClazzɐݒ肳ꂽꍇɗO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractFileLineIteratorStringClassMap09() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init11";
        Class<AbstractFileLineIterator_Stub05> clazz = AbstractFileLineIterator_Stub05.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub05>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Failed in instantiation of clazz.", e.getMessage());
            assertSame(InstantiationException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init12"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF""(󕶎)<br>
     *                       - fileEncodingF""(󕶎)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     * <br>
     *                       ftHgRXgN^uprivatevŐ錾ĂB<br>
     *                       () columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     *                       E"int"=IntColumnParser<br>
     *                       E"java.lang.String"=NullColumnParser.java<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"clazz's nullary  constructor is not accessible"<br>
     *                       EOFIllegalAccessException<br>
     *                       Et@CFfileNameƓCX^XB<br>
     * <br>
     *                       OB<br>
     *                       ftHgRXgN^̒ڃANZXoȂClassClazzɐݒ肳ꂽꍇɗO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testAbstractFileLineIteratorStringClassMap10() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init12";
        Class<AbstractFileLineIterator_Stub06> clazz = AbstractFileLineIterator_Stub06.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub06>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("clazz's nullary  constructor is not accessible", e
                    .getMessage());
            assertSame(IllegalAccessException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testAbstractFileLineIteratorStringClassMap11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() fileName:StringCX^X<br>
     * "AbstractFileLineIterator_init13"<br>
     * () clazz:ȉ̐ݒClassCX^X<br>
     * @FileFormat̐ݒ<br> - delimiterF"|"(ftHglȊO)<br>
     *                       - encloseCharF"\""(ftHglȊO)<br>
     *                       - lineFeedCharF"\r"(ftHglȊO)<br>
     *                       - fileEncodingF"MS932"(ftHglȊO)<br>
     *                       - headerLineCountF1(ftHglȊO)<br>
     *                       - trailerLineCountF1(ftHglȊO)<br>
     *                       () columnParserMap:vfȂMap<String, ColumnParser>CX^X<br>
     *                       () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     *                       @<br>
     * <br>
     *                       ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                       EbZ[WF"columnFormaterMap is required."<br>
     *                       EOFIllegalArgumentException<br>
     *                       Et@CFfileNameƓCX^XB<br>
     * <br>
     *                       OB<br>
     *                       columnParserMap͂邪AMapɗvfꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testAbstractFileLineIteratorStringClassMap11() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = "AbstractFileLineIterator_init13";
        Class<AbstractFileLineIterator_Stub01> clazz = AbstractFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "init", null);

        // eXg{
        try {
            new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                    fileName, clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("columnFormaterMap is required.", e.getMessage());
            assertSame(IllegalArgumentException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testHasNext01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.reader:not null<br>
     * ReaderCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_hasNext01.txt"t@C݂B<br>
     * -------------------<br>
     * 1s<br>
     * -------------------<br>
     * f[^<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * (ԕω) reader.ready():1Ă΂<br>
     * <br>
     * p^[<br>
     * tB[hreader玟̍s̃R[h̎擾\ȏꍇtrueԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testHasNext01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_hasNext01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        boolean result = fileLineIterator.hasNext();

        // ԋpl̊mF
        assertTrue(result);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(BufferedReader.class, "read"));
    }

    /**
     * testHasNext02() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.reader:not null<br>
     * ReaderCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_hasNext02.txt"<br>
     * () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_hasNext02.txt"t@C݂B<br>
     * -------------------<br>
     * <br>
     * -------------------<br>
     * f[^<br>
     * <br>
     * ҒlF(߂l) boolean:false<br>
     * (ԕω) reader.ready():1Ă΂<br>
     * <br>
     * p^[<br>
     * tB[hreader玟̍s̃R[h̎擾s\ȏꍇfalseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testHasNext02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_hasNext02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        boolean result = fileLineIterator.hasNext();

        // ԋpl̊mF
        assertFalse(result);

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(BufferedReader.class, "read"));
    }

    /**
     * testHasNext03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC,G <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.reader:not null<br>
     * ReaderCX^X<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_hasNext02.txt"<br>
     * () reader.ready():IOException𔭐B<br>
     * <br>
     * ҒlF(ԕω) reader.ready():1Ă΂<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Processing of reader was failed."<br>
     * EOFIOException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * ʃNXݒ肳ĂȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testHasNext03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_hasNext02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        IOException exception = new IOException();
        VMOUTUtil.setExceptionAtAllTimes(BufferedReader.class, "read",
                exception);

        // eXg{
        try {
            fileLineIterator.hasNext();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil
                    .getCallCount(BufferedReader.class, "read"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Processing of reader was failed.", e.getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testHasNext04() <br>
     * <br>
     * (ُn) <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.reader:not null<br>
     * ReaderCX^X<br>
     * () this.fileName:StringCX^X<br>
     * <br>
     * () reader.ready():IOException𔭐B<br>
     * <br>
     * ҒlF<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Processing of reader#reset was failed."<br>
     * EOFIOException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * ʃNXݒ肳ĂȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testHasNext04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        IOException exception = new IOException();
        VMOUTUtil.setExceptionAtAllTimes(BufferedReader.class, "reset",
                exception);

        // eXg{
        try {
            fileLineIterator.hasNext();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF

            assertSame(FileException.class, e.getClass());
            assertEquals("Processing of reader#reset was failed.", e
                    .getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testNext01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:C^tF[XȂǂ̃CX^XłȂClass̃CX^X<br>
     * CX^Xɐݒ肷B<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_next06.txt"<br>
     * () this.currentLineCount:0<br>
     * () this.readTrailer:false<br>
     * () this.isCheckByte():true<br>
     * <br>
     * ҒlF(ԕω) this.hasNext():2Ă΂<br>
     * readLine()̒hasNextPĂ΂ĂB<br>
     * (ԕω) this.readLine():1Ă΂<br>
     * (ԕω) this.separateColumns(String):Ă΂Ȃ<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Failed in an instantiate of a FileLineObject."<br>
     * EOFInstantiationException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * tB[hclazzɃCX^XłȂNXݒ肳ꂽꍇAFileException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next06.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "clazz",
                AbstractFileLineIterator_Stub14.class);
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, VMOUTUtil.getCallCount(fileLineIterator.getClass(),
                    "separateColumns"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Failed in an instantiate of a FileLineObject.", e
                    .getMessage());
            assertSame(InstantiationException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testNext02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ftHgRXgN^̒ڎss\(private錾)Class̃CX^X<br>
     * CX^Xɐݒ肷B<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_next06.txt"<br>
     * () this.currentLineCount:0<br>
     * () this.readTrailer:false<br>
     * () this.isCheckByte():true<br>
     * <br>
     * ҒlF(ԕω) this.hasNext():2Ă΂<br>
     * readLine()̒hasNextPĂ΂ĂB<br>
     * (ԕω) this.readLine():1Ă΂<br>
     * (ԕω) this.separateColumns(String):Ă΂Ȃ<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Failed in an instantiate of a FileLineObject."<br>
     * EOFIllegalAccessException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * tB[hclazz̃RXgN^ڎsłȂ悤ɐݒ肳ĂꍇAFileException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next06.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "clazz",
                AbstractFileLineIterator_Stub15.class);
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, VMOUTUtil.getCallCount(fileLineIterator.getClass(),
                    "separateColumns"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Failed in an instantiate of a FileLineObject.", e
                    .getMessage());
            assertSame(IllegalAccessException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testNext03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hсA@InputFileColumn̐ݒ͂Ȃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_next06.txt"<br>
     * () this.currentLineCount:0<br>
     * () this.readTrailer:false<br>
     * () this.isCheckByte():true<br>
     * () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next06.txt"t@C݂B<br>
     * -------------------<br>
     * s<br>
     * s<br>
     * s<br>
     * -------------------<br>
     * f[^<br>
     * <br>
     * ҒlF(߂l) this.clazz.getClass():this.clazzŐݒ肳ĂNX̃CX^X<br>
     * (ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     * (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     * (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     * (ԕω) this.hasNext():2Ă΂<br>
     * readLine()̒hasNextPĂ΂ĂB<br>
     * (ԕω) this.readLine():1Ă΂<br>
     * (ԕω) this.separateColumns(String):1Ă΂<br>
     * (ԕω) this.currentLineCount:1<br>
     * <br>
     * t@CǂݎJ󕶎ŁAt@CsIuWFNgclazzɃtB[hȂꍇ́At@CsIuWFNg擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next06.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub08> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub08>(
                fileName, AbstractFileLineIterator_Stub08.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        Object result = fileLineIterator.next();

        // ԋpl̊mF
        assertSame(AbstractFileLineIterator_Stub08.class, result.getClass());

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class, "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class, "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class, "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }
        assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));
    }

    /**
     * testNext04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FF,G <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肪ȂtB[h<br>
     * - tB[hFString column1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.currentLineCount:0<br>
     * () this.readTrailer:false<br>
     * () this.isCheckByte():true<br>
     * () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_bulidFields01.txt"t@C݂B<br>
     * -------------------<br>
     * test<br>
     * -------------------<br>
     * f[^<br>
     * <br>
     * ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     * (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     * (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     * (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     * (ԕω) this.hasNext():2Ă΂<br>
     * readLine()̒hasNextPĂ΂ĂB<br>
     * (ԕω) this.readLine():1Ă΂<br>
     * (ԕω) this.separateColumns(String):1Ă΂<br>
     * (ԕω) this.currentLineCount:0<br>
     * (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     * EbZ[WF"Column Count is different from FileLineObject's column counts"<br>
     * EOFIllegalStateException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * EsԍF1<br>
     * EJFnull<br>
     * EJCfbNXF-1<br>
     * <br>
     * t@CǂݎJƃt@CsIuWFNg̃JȂꍇɁAFileLineException邱ƂmFB<br>
     * ł́At@CǂݎJ1݂At@CsIuWFNgclazz@InputFileColumn`ȂtB[ĥ݂ꍇĂB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next08.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("int", new IntColumnParser());
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub08> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub08>(
                fileName, AbstractFileLineIterator_Stub08.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(FileLineException.class, e.getClass());
            assertEquals(
                    "Column Count is different from FileLineObject's column counts",
                    e.getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertNull(e.getColumnName());
            assertEquals(-1, e.getColumnIndex());
        }
    }

    /**
     * testNext05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(߂l) this.clazz.getClass():this.clazzŐݒ肳ĂNX̃CX^X<br>
     *                        - column1F1<br>
     *                        - column2F"line1"<br>
     *                        - column3F111111<br>
     *                        - column4F1980/01/21<br>
     *                        (ԕω) FileDAOUtility.trim(String, String, char, TrimType):4Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):4Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():1Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():1Ă΂<br>
     *                        (ԕω) DecimalColumnParser#parse():1Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():1Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:1<br>
     * <br>
     *                        B(oCg`FbN)<br>
     *                        Ώۃt@C̓eݒ肳ꂽt@CsIuWFNg擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        AbstractFileLineIterator_Stub09 result = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("getColumn1", 1, result.getColumn1());
        assertEquals("line1", result.getColumn2());
        assertEquals(new BigDecimal(111111), result.getColumn3());
        Calendar column4 = new GregorianCalendar();
        column4.set(1980, 0, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result.getColumn4()
                .toString());

        // ԕω̊mF
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals("NullColumnParser", 1, VMOUTUtil.getCallCount(
                NullColumnParser.class, "parse"));
        assertEquals("DateColumnParser", 1, VMOUTUtil.getCallCount(
                DateColumnParser.class, "parse"));
        assertEquals("DecimalColumnParser", 1, VMOUTUtil.getCallCount(
                DecimalColumnParser.class, "parse"));
        assertEquals("", 1, VMOUTUtil.getCallCount(IntColumnParser.class,
                "parse"));
        assertEquals(4, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));
    }

    /**
     * testNext06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE,G <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > bytesF5<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next12.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next12.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        ABCDE,1234<br>
     *                        -------------------<br>
     *                        ُf[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):1Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):1Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():1Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():1Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Data size is different from a set point of a column."<br>
     *                        EOFIllegalStateException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        tB[hclazz@InputFileColumnbytes`͂ꂽt@C̏bytesݒɂĂȂꍇAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next12.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub10> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub10>(
                fileName, AbstractFileLineIterator_Stub10.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals("FileDAOUtility:trim", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "trim"));
            assertEquals("FileDAOUtility:padding", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "padding"));
            assertEquals("NullColumnParser", 1, VMOUTUtil.getCallCount(
                    NullColumnParser.class, "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals("NullStringConverter", 1, VMOUTUtil.getCallCount(
                    NullStringConverter.class, "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(FileLineException.class, e.getClass());
            assertEquals(
                    "Data size is different from a set point of a column.", e
                            .getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals("getColumnIndex", 1, e.getColumnIndex());
        }
    }

    /**
     * testNext07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > bytesF5<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next13.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next13.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        ABCDE,12345<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(߂l) this.clazz.getClass():this.clazzŐݒ肳ĂNX̃CX^X<br>
     *                        - column1F"ABCDE"<br>
     *                        - column2F"12345"<br>
     *                        (ԕω) FileDAOUtility.trim(String, String, char, TrimType):2Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):2Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():2Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():2Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:1<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnbytes`͂ꂽt@C̏bytesݒɂĂꍇAΏۃt@C̓eݒ肳ꂽt@CsIuWFNg擾邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next13.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub10> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub10>(
                fileName, AbstractFileLineIterator_Stub10.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        AbstractFileLineIterator_Stub10 result = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("ABCDE", result.getColumn1());
        assertEquals("12345", result.getColumn2());

        // ԕω̊mF
        assertEquals(2, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(2, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals(2, VMOUTUtil.getCallCount(NullColumnParser.class, "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class, "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                "parse"));
        assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class, "parse"));
        assertEquals(2, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));
    }

    /**
     * testNext08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next15.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=ColumnParserX^u(sƗO𓊂B)<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () ColumnParser.parse():IllegalArgumentExceptionO<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next15.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,ABCDE<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):2Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):2Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():2Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Failed in coluomn data parsing."<br>
     *                        EOFllegalArgumentException<br>
     *                        (ColumnParser.parse()ŔO)<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C擾f[^tB[ȟ^ɂ킹ăp[Y鏈llegalArgumentExceptionꍇAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next15.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String",
                new AbstractFileLineIterator_ColumnParserStub01());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11>(
                fileName, AbstractFileLineIterator_Stub11.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(2, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                    IntColumnParser.class, "parse"));
            assertEquals(2, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("AbstractFileLineIterator", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(FileLineException.class, e.getClass());
            assertEquals("Failed in coluomn data parsing.", e.getMessage());
            assertSame(IllegalArgumentException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals("getColumnIndex", 1, e.getColumnIndex());
        }
    }

    /**
     * testNext09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next15.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=ColumnParserX^u(sƗO𓊂B)<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () ColumnParser.parse():IllegalAccessExceptionO<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next15.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,ABCDE<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):2Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):2Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():2Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Failed in coluomn data parsing."<br>
     *                        EOFIllegalAccessException<br>
     *                        (ColumnParser.parse()ŔO)<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C擾f[^tB[ȟ^ɂ킹ăp[Y鏈IllegalAccessExceptionꍇAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext09() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next15.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String",
                new AbstractFileLineIterator_ColumnParserStub02());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11>(
                fileName, AbstractFileLineIterator_Stub11.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(2, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                    IntColumnParser.class, "parse"));
            assertEquals(2, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("AbstractFileLineIterator", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(FileLineException.class, e.getClass());
            assertEquals("Failed in coluomn data parsing.", e.getMessage());
            assertSame(IllegalAccessException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals("getColumnIndex", 1, e.getColumnIndex());
        }
    }

    /**
     * testNext10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next15.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=ColumnParserX^u(sƗO𓊂B)<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () ColumnParser.parse():InvocationTargetExceptionO<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next15.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,ABCDE<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):2Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):2Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():2Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Failed in coluomn data parsing."<br>
     *                        EOFInvocationTargetException<br>
     *                        (ColumnParser.parse()ŔO)<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C擾f[^tB[ȟ^ɂ킹ăp[Y鏈InvocationTargetExceptionꍇAFileLineException邱ƂmFB
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext10() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next15.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String",
                new AbstractFileLineIterator_ColumnParserStub03());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11>(
                fileName, AbstractFileLineIterator_Stub11.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(2, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                    IntColumnParser.class, "parse"));
            assertEquals(2, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("AbstractFileLineIterator", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(FileLineException.class, e.getClass());
            assertEquals("Failed in coluomn data parsing.", e.getMessage());
            assertSame(InvocationTargetException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals("getColumnIndex", 1, e.getColumnIndex());
        }
    }

    /**
     * testNext11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next15.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=ColumnParserX^u(sƗO𓊂B)<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () ColumnParser.parse():ParsrExceptionO<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next15.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,ABCDE<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):2Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):2Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():2Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Failed in coluomn data parsing."<br>
     *                        EOFParsrException<br>
     *                        (ColumnParser.parse()ŔO)<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C擾f[^tB[ȟ^ɂ킹ăp[Y鏈ParsrExceptionꍇAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext11() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next15.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String",
                new AbstractFileLineIterator_ColumnParserStub04());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub11>(
                fileName, AbstractFileLineIterator_Stub11.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(2, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                    IntColumnParser.class, "parse"));
            assertEquals(2, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(FileLineException.class, e.getClass());
            assertEquals("Failed in coluomn data parsing.", e.getMessage());
            assertSame(ParseException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals("getColumnIndex", 1, e.getColumnIndex());
        }
    }

    /**
     * testNext12() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next19.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next19.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        2,line2,222222,1980/02/21<br>
     *                        3,line3,333333,1980/03/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(߂l) this.clazz.getClass():this.clazzŐݒ肳ĂNX̃CX^X<br>
     *                        E1ڂ̎s<br>
     *                        - column1F1<br>
     *                        - column2F"line1"<br>
     *                        - column3F111111<br>
     *                        - column4F1980/01/21<br>
     * <br>
     *                        E2ڂ̎s<br>
     *                        - column1F2<br>
     *                        - column2F"line2"<br>
     *                        - column3F222222<br>
     *                        - column4F1980/02/21<br>
     * <br>
     *                        E3ڂ̎s<br>
     *                        - column1F3<br>
     *                        - column2F"line3"<br>
     *                        - column3F333333<br>
     *                        - column4F1980/03/21<br>
     *                        (ԕω) FileDAOUtility.trim(String, String, char, TrimType):1̎s4Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):1̎s4Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():1̎s1Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():1̎s1Ă΂<br>
     *                        (ԕω) DecimalColumnParser#parse():1̎s1Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1̎s1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():1̎s4Ă΂<br>
     *                        (ԕω) this.hasNext():1̎s2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1̎s1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1̎s1Ă΂<br>
     *                        (ԕω) this.currentLineCount:E1ڎsF1<br>
     *                        E2ڎsF2<br>
     *                        E3ڎsF3<br>
     * <br>
     *                        B<br>
     *                        Ώۃt@Cɂ镡s̏񂪊e1sɑ΂next()\bhĂԓxɐݒ肳ꂽt@CsIuWFNg擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext12() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next19.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{i1ځj
        AbstractFileLineIterator_Stub09 result = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("getColumn1", 1, result.getColumn1());
        assertEquals("line1", result.getColumn2());
        assertEquals(new BigDecimal(111111), result.getColumn3());
        Calendar column4 = new GregorianCalendar();
        column4.set(1980, 0, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result.getColumn4()
                .toString());

        // ԕω̊mF
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals("NullColumnParser", 1, VMOUTUtil.getCallCount(
                NullColumnParser.class, "parse"));
        assertEquals("DateColumnParser", 1, VMOUTUtil.getCallCount(
                DateColumnParser.class, "parse"));
        assertEquals("DecimalColumnParser", 1, VMOUTUtil.getCallCount(
                DecimalColumnParser.class, "parse"));
        assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                IntColumnParser.class, "parse"));
        assertEquals(4, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals("AbstractFileLineIterator:hasNext", 2, VMOUTUtil
                .getCallCount(AbstractFileLineIterator.class, "hasNext"));
        assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));

        // eXg{i2ځj
        AbstractFileLineIterator_Stub09 result02 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("getColumn1", 2, result02.getColumn1());
        assertEquals("line2", result02.getColumn2());
        assertEquals(new BigDecimal(222222), result02.getColumn3());
        column4.set(1980, 1, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result02.getColumn4()
                .toString());

        // ԕω̊mFiĂяo񐔂1ځ{ɂȂj
        assertEquals(8, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(8, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals("NullColumnParser", 2, VMOUTUtil.getCallCount(
                NullColumnParser.class, "parse"));
        assertEquals("DateColumnParser", 2, VMOUTUtil.getCallCount(
                DateColumnParser.class, "parse"));
        assertEquals("DecimalColumnParser", 2, VMOUTUtil.getCallCount(
                DecimalColumnParser.class, "parse"));
        assertEquals("IntColumnParser", 2, VMOUTUtil.getCallCount(
                IntColumnParser.class, "parse"));
        assertEquals(8, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(4, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals("AbstractFileLineIterator", 2, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 2, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals("currentLineCount", 2, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));

        // eXg{i3ځj
        AbstractFileLineIterator_Stub09 result03 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals(3, result03.getColumn1());
        assertEquals("line3", result03.getColumn2());
        assertEquals(new BigDecimal(333333), result03.getColumn3());
        column4.set(1980, 2, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result03.getColumn4()
                .toString());

        // ԕω̊mFiĂяo񐔂1ځ{2ځ{ɂȂj
        assertEquals(12, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(12, VMOUTUtil
                .getCallCount(FileDAOUtility.class, "padding"));
        assertEquals(3, VMOUTUtil.getCallCount(NullColumnParser.class, "parse"));
        assertEquals(3, VMOUTUtil.getCallCount(DateColumnParser.class, "parse"));
        assertEquals(3, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                "parse"));
        assertEquals(3, VMOUTUtil.getCallCount(IntColumnParser.class, "parse"));
        assertEquals(12, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(6, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals(3, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 3, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals(3, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testNext13() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "File_Empty.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"File_Empty.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        <br>
     *                        -------------------<br>
     *                        hasNext()falseɂȂf[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():1Ă΂<br>
     *                        (ԕω) this.readLine():Ă΂Ȃ<br>
     *                        (ԕω) this.separateColumns(String):Ă΂Ȃ<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"The data which can be acquired doesn't exist."<br>
     *                        EOFNoSuchElementException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF0<br>
     *                        EJFnull<br>
     *                        EJCfbNXF-1<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C̓ȅꍇit@Cɓǂ߂f[^ȂꍇjɁAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext13() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next20.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub12> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub12>(
                fileName, AbstractFileLineIterator_Stub12.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂łB");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals("hasNext", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, VMOUTUtil.getCallCount(fileLineIterator.getClass(),
                    "separateColumns"));
            assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));

            assertEquals(FileLineException.class, e.getClass());
            assertEquals("The data which can be acquired doesn't exist.", e
                    .getMessage());
            assertSame(NoSuchElementException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertNull(e.getColumnName());
            assertEquals(-1, e.getColumnIndex());
        }
    }

    /**
     * testNext14() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:true<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():Ă΂Ȃ<br>
     *                        (ԕω) this.readLine():Ă΂Ȃ<br>
     *                        (ԕω) this.separateColumns(String):Ă΂Ȃ<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Data part should be called before trailer part."<br>
     *                        EOFIllegalStateException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF0<br>
     *                        EJFnull<br>
     *                        EJCfbNXF-1<br>
     * <br>
     *                        OB<br>
     *                        gC̃f[^擾sꂽnext()Ă΂ꂽꍇɁAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext14() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "readTrailer", true);
        // ̑́AeXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂łB");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, VMOUTUtil.getCallCount(fileLineIterator.getClass(),
                    "separateColumns"));
            assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));

            assertEquals(FileLineException.class, e.getClass());
            assertEquals("Data part should be called before trailer part.", e
                    .getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals(0, e.getLineNo());
            assertNull(e.getColumnName());
            assertEquals(-1, e.getColumnIndex());
        }
    }

    /**
     * testNext15() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next23.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next23.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111<br>
     *                        -------------------<br>
     *                        JRŃtB[h̐ƍĂȂB<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Column Count is different from FileLineObject's column counts"<br>
     *                        EOFIllegalStateException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF1<br>
     *                        EJFnull<br>
     *                        EJCfbNXF-1<br>
     * <br>
     *                        OB<br>
     *                        t@CsIuWFNg̃}bsOΏۃtB[h̐ƍȂf[^Ώۃt@CǂޏꍇɁAFileLineException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext15() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next23.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileLineExceptionX[܂łB");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertEquals(FileLineException.class, e.getClass());
            assertEquals("Column Count is different from FileLineObject's "
                    + "column counts", e.getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("getLineNo", 1, e.getLineNo());
            assertNull(e.getColumnName());
            assertEquals(-1, e.getColumnIndex());
        }
    }

    /**
     * testNext16() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.readLine():FileExceptionO<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():PĂ΂<br>
     *                        readLine()̒ŃG[N邽߁AhasNext͌Ă΂Ȃ<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):Ă΂Ȃ<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:this.readLine()ŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C̓ǂ݂ɎsꍇɁAÔ܂܃X[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext16() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        FileException exception = new FileException("readLineł̃G[łB");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "readLine", exception);
        // ̑́AeXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals("hasNext", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, VMOUTUtil.getCallCount(fileLineIterator.getClass(),
                    "separateColumns"));
            assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));

            assertSame(exception, e);
        }
    }

    /**
     * testNext17() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        E@InputFileColumnݒȂ̃tB[h<br>
     *                        - tB[hFString noMappingColumn1<br>
     *                        - tB[hFString noMappingColumn2<br>
     *                        - tB[hFString noMappingColumn3<br>
     *                        - tB[hFString noMappingColumn4<br>
     *                        NX`A@L薳̃tB[h̏ԂĒ`邱ƁB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next19.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next19.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        2,line2,222222,1980/02/21<br>
     *                        3,line3,333333,1980/03/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(߂l) this.clazz.getClass():this.clazzŐݒ肳ĂNX̃CX^X<br>
     *                        E1ڂ̎s<br>
     *                        - column1F1<br>
     *                        - column2F"line1"<br>
     *                        - column3F111111<br>
     *                        - column4F1980/01/21<br>
     * <br>
     *                        E2ڂ̎s<br>
     *                        - column1F2<br>
     *                        - column2F"line2"<br>
     *                        - column3F222222<br>
     *                        - column4F1980/02/21<br>
     * <br>
     *                        E3ڂ̎s<br>
     *                        - column1F3<br>
     *                        - column2F"line3"<br>
     *                        - column3F333333<br>
     *                        - column4F1980/03/21<br>
     *                        (ԕω) FileDAOUtility.trim(String, String, char, TrimType):1̎s4Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):1̎s4Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():1̎s4Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():1̎s4Ă΂<br>
     *                        (ԕω) DecimalColumnParser#parse():1̎s4Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1̎s4Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():1̎s4Ă΂<br>
     *                        (ԕω) this.hasNext():1̎s2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1̎s1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1̎s1Ă΂<br>
     *                        (ԕω) this.currentLineCount:E1ڎsF1<br>
     *                        E2ڎsF2<br>
     *                        E3ڎsF3<br>
     * <br>
     *                        B<br>
     *                        t@CsIuWFNg@InputFileColumn̐ݒ肪ȂtB[hLĂȂȉ̏邱ƂmFB<br>
     *                        Ώۃt@Cɂ镡s̏񂪊e1sɑ΂next()\bhĂԓxɐݒ肳ꂽt@CsIuWFNg擾B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext17() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next19.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub13> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub13>(
                fileName, AbstractFileLineIterator_Stub13.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{i1ځj
        AbstractFileLineIterator_Stub13 result = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("getColumn1", 1, result.getColumn1());
        assertEquals("line1", result.getColumn2());
        assertEquals(new BigDecimal(111111), result.getColumn3());
        Calendar column4 = new GregorianCalendar();
        column4.set(1980, 0, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result.getColumn4()
                .toString());

        // ԕω̊mF
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals("NullColumnParser", 1, VMOUTUtil.getCallCount(
                NullColumnParser.class, "parse"));
        assertEquals("DateColumnParser", 1, VMOUTUtil.getCallCount(
                DateColumnParser.class, "parse"));
        assertEquals("DecimalColumnParser", 1, VMOUTUtil.getCallCount(
                DecimalColumnParser.class, "parse"));
        assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                IntColumnParser.class, "parse"));
        assertEquals(4, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals("AbstractFileLineIterator", 1, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));

        // eXg{i2ځj
        AbstractFileLineIterator_Stub13 result02 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals(2, result02.getColumn1());
        assertEquals("line2", result02.getColumn2());
        assertEquals(new BigDecimal(222222), result02.getColumn3());
        column4.set(1980, 1, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result02.getColumn4()
                .toString());

        // ԕω̊mFiĂяo񐔂1ځ{ɂȂj
        assertEquals(8, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(8, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals(2, VMOUTUtil.getCallCount(NullColumnParser.class, "parse"));
        assertEquals(2, VMOUTUtil.getCallCount(DateColumnParser.class, "parse"));
        assertEquals(2, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                "parse"));
        assertEquals(2, VMOUTUtil.getCallCount(IntColumnParser.class, "parse"));
        assertEquals(8, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(4, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 2, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals(2, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));

        // eXg{i3ځj
        AbstractFileLineIterator_Stub13 result03 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals(3, result03.getColumn1());
        assertEquals("line3", result03.getColumn2());
        assertEquals(new BigDecimal(333333), result03.getColumn3());
        column4.set(1980, 2, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result03.getColumn4()
                .toString());

        // ԕω̊mFiĂяo񐔂1ځ{2ځ{ɂȂj
        assertEquals(12, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(12, VMOUTUtil
                .getCallCount(FileDAOUtility.class, "padding"));
        assertEquals(3, VMOUTUtil.getCallCount(NullColumnParser.class, "parse"));
        assertEquals(3, VMOUTUtil.getCallCount(DateColumnParser.class, "parse"));
        assertEquals(3, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                "parse"));
        assertEquals(3, VMOUTUtil.getCallCount(IntColumnParser.class, "parse"));
        assertEquals(12, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(6, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals(3, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 3, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals(3, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testNext18() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () FileDAOUtility.trim(String, String, char, TrimType):FileExceptionO<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):1Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:FileDAOUtility.trim(String, String, char, TrimType)ŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C˃t@CsIuWFNg̃}bsÕgŗOꍇɁAÔ܂܃X[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext18() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        FileException exception = new FileException("trimł̃G[łB");
        VMOUTUtil.setExceptionAtAllTimes(FileDAOUtility.class, "trim",
                exception);
        // ̑́AeXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals("FileDAOUtility", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(exception, e);
        }
    }

    /**
     * testNext19() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () FileDAOUtility.padding(String, String, int, char, PaddingType):FileExceptionO<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):1Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):1Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:FileDAOUtility.padding(String, String, int, char,
     *                        PaddingType)ŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@C˃t@CsIuWFNg̃}bsÕpfBOŗOꍇɁAÔ܂܃X[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext19() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        FileException exception = new FileException("paddingł̃G[łB");
        VMOUTUtil.setExceptionAtAllTimes(FileDAOUtility.class, "padding",
                exception);
        // ̑́AeXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals("FileDAOUtility:trim", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "trim"));
            assertEquals("FileDAOUtility:padding", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertSame(exception, e);
        }
    }

    /**
     * testNext20() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.hasNext():FileExceptionO<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):Ă΂Ȃ<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):Ă΂Ȃ<br>
     *                        (ԕω) NullColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():Ă΂Ȃ<br>
     *                        (ԕω) this.hasNext():PĂ΂<br>
     *                        (ԕω) this.readLine():Ă΂Ȃ<br>
     *                        (ԕω) this.separateColumns(String):Ă΂Ȃ<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:this.hasNext()ŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     *                        OB<br>
     *                        Ώۃt@Cɑ΂Ď̏f[^邩̃`FbNŗOꍇɁAÔ܂܃X[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext20() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        FileException exception = new FileException("paddingł̃G[łB");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "hasNext", exception);
        // ̑́AeXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(0, VMOUTUtil
                    .getCallCount(FileDAOUtility.class, "trim"));
            assertEquals(0, VMOUTUtil.getCallCount(FileDAOUtility.class,
                    "padding"));
            assertEquals(0, VMOUTUtil.getCallCount(NullColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(NullStringConverter.class,
                    "convert"));
            assertEquals("hasNext", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));
            assertEquals(0, VMOUTUtil.getCallCount(fileLineIterator.getClass(),
                    "separateColumns"));
            assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));

            assertSame(exception, e);
        }
    }

    /**
     * testNext21() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next09.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():false<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next09.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        1,line1,111111,1980/01/21<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(߂l) this.clazz.getClass():this.clazzŐݒ肳ĂNX̃CX^X<br>
     *                        - column1F1<br>
     *                        - column2F"line1"<br>
     *                        - column3F111111<br>
     *                        - column4F1980/01/21<br>
     *                        (ԕω) FileDAOUtility.trim(String, String, char, TrimType):4Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):4Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():1Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():1Ă΂<br>
     *                        (ԕω) DecimalColumnParser#parse():1Ă΂<br>
     *                        (ԕω) IntColumnParser#parse():1Ă΂<br>
     *                        (ԕω) NullStringConverter#convert():4Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) String.getBytes():Ă΂Ȃ<br>
     *                        (ԕω) this.currentLineCount:1<br>
     * <br>
     *                        B(oCg`FbNȂ)<br>
     *                        Ώۃt@C̓eݒ肳ꂽt@CsIuWFNg擾邱ƂmFB<br>
     *                        AAoCg`FbNȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext21() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next09.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub09>(
                fileName, AbstractFileLineIterator_Stub09.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "isCheckByte", false);
        // ̑́AeXgΏۂ̃CX^Xɐݒ肵ĂB

        // eXg{
        AbstractFileLineIterator_Stub09 result = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("getColumn1", 1, result.getColumn1());
        assertEquals("line1", result.getColumn2());
        assertEquals(new BigDecimal(111111), result.getColumn3());
        Calendar column4 = new GregorianCalendar();
        column4.set(1980, 0, 21, 0, 0, 0);
        assertEquals(column4.getTime().toString(), result.getColumn4()
                .toString());

        // ԕω̊mF
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "trim"));
        assertEquals(4, VMOUTUtil.getCallCount(FileDAOUtility.class, "padding"));
        assertEquals("NullColumnParser", 1, VMOUTUtil.getCallCount(
                NullColumnParser.class, "parse"));
        assertEquals("DateColumnParser", 1, VMOUTUtil.getCallCount(
                DateColumnParser.class, "parse"));
        assertEquals("DecimalColumnParser", 1, VMOUTUtil.getCallCount(
                DecimalColumnParser.class, "parse"));
        assertEquals("IntColumnParser", 1, VMOUTUtil.getCallCount(
                IntColumnParser.class, "parse"));
        assertEquals(4, VMOUTUtil.getCallCount(NullStringConverter.class,
                "convert"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "hasNext"));
        assertEquals("AbstractFileLineIterator", 1, VMOUTUtil.getCallCount(
                AbstractFileLineIterator.class, "readLine"));

        // mavenNƂȂseparateColumns擾łȂ߁AXLbv
        if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                .getProperty("java.system.class.loader")))) {
            assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                    fileLineIterator.getClass(), "separateColumns"));
        }

        assertEquals(0, VMOUTUtil.getCallCount(String.class, "getBytes"));
        assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                fileLineIterator, "currentLineCount"));
    }

    /**
     * testNext22() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl<br>
     * ǂݎf[^1sJ}i,jŋ؂āAJƂĕԂ<br>
     * <br>
     * CX^Xthis.fileEncoding"aaa"ɒu邱<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > bytesF5<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_next13.txt"<br>
     *                        () this.currentLineCount:0<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     *                        E"java.util.Date"=DateColumnParserCX^X<br>
     *                        E"java.math.BigDecimal"=DecimalColumnParserCX^X<br>
     *                        E"int"=IntColumnParserCX^X<br>
     *                        () this.readTrailer:false<br>
     *                        () this.isCheckByte():true<br>
     *                        () Ώۃt@C:ȉ̓e"AbstractFileLineIterator_next13.txt"t@C݂B<br>
     *                        -------------------<br>
     *                        ABCDE,12345<br>
     *                        -------------------<br>
     *                        f[^<br>
     * <br>
     *                        ҒlF(ԕω) FileDAOUtility.trim(String, String, char, TrimType):1Ă΂<br>
     *                        (ԕω) FileDAOUtility.padding(String, String, int, char, PaddingType):1Ă΂<br>
     *                        (ԕω) NullColumnParser#parse():1Ă΂<br>
     *                        (ԕω) DateColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) DecimalColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) IntColumnParser#parse():Ă΂Ȃ<br>
     *                        (ԕω) NullStringConverter#convert():1Ă΂<br>
     *                        (ԕω) this.hasNext():2Ă΂<br>
     *                        readLine()̒hasNextPĂ΂ĂB<br>
     *                        (ԕω) this.readLine():1Ă΂<br>
     *                        (ԕω) this.separateColumns(String):1Ă΂<br>
     *                        (ԕω) this.currentLineCount:0<br>
     *                        (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                        EbZ[WF"fileEncoding which isn't supported was set."<br>
     *                        EOFUnsupportedEncodingException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     *                        OB<br>
     *                        RXgN^ɁAfileEncodingsȃGR[fBOɒuꍇ́A#next()ĂяoɗON邱ƂmFB<br>
     * <br>
     *                        sɃNXȂ΁ARXgN^ŌĂ΂#buildLineReader()ɂAONB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testNext22() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next13.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub10> fileLineIterator = new AbstractFileLineIteratorImpl01<AbstractFileLineIterator_Stub10>(
                fileName, AbstractFileLineIterator_Stub10.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒ肵ĂB
        UTUtil.setPrivateField(fileLineIterator, "fileEncoding", "aaa");

        // eXg{
        try {
            fileLineIterator.next();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals("FileDAOUtility:trim", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "trim"));
            assertEquals("FileDAOUtility:padding", 1, VMOUTUtil.getCallCount(
                    FileDAOUtility.class, "padding"));
            assertEquals("NullColumnParser", 1, VMOUTUtil.getCallCount(
                    NullColumnParser.class, "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DateColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(DecimalColumnParser.class,
                    "parse"));
            assertEquals(0, VMOUTUtil.getCallCount(IntColumnParser.class,
                    "parse"));
            assertEquals("NullStringConverter", 1, VMOUTUtil.getCallCount(
                    NullStringConverter.class, "convert"));
            assertEquals(2, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "hasNext"));
            assertEquals("readLine", 1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            // mavenNƂȂseparateColumns擾łȂ߁AXLbv
            if (!("jp.co.dgic.testing.common.DJUnitClassLoader".equals(System
                    .getProperty("java.system.class.loader")))) {
                assertEquals("separateColumns", 1, VMOUTUtil.getCallCount(
                        fileLineIterator.getClass(), "separateColumns"));
            }

            assertEquals("currentLineCount", 1, UTUtil.getPrivateField(
                    fileLineIterator, "currentLineCount"));

            assertEquals(FileException.class, e.getClass());
            assertEquals("fileEncoding which isn't supported was set.", e
                    .getMessage());
            assertEquals(UnsupportedEncodingException.class, e.getCause()
                    .getClass());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testRemove01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏UnsupportedOperationException()B<br>
     * EbZ[WF"remove() isn't supported."<br>
     * <br>
     * \bhsƃAT|[gO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testRemove01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next06.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        try {
            fileLineIterator.remove();
            fail("UnsupportedOperationExceptionX[܂łB");
        } catch (UnsupportedOperationException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(UnsupportedOperationException.class, e.getClass());
            assertEquals("remove() isn't supported.", e.getMessage());
        }
    }

    /**
     * testInit01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:true<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:true<br>
     * (ԕω) this.buildFields():Ă΂Ȃ<br>
     * (ԕω) this.buildStringConverters():Ă΂Ȃ<br>
     * (ԕω) this.buildMethods():Ă΂Ȃ<br>
     * (ԕω) this.buildLineReader():Ă΂Ȃ<br>
     * (ԕω) this.buildHeader():Ă΂Ȃ<br>
     * (ԕω) this.buildTrailerQueue():Ă΂Ȃ<br>
     * <br>
     * B<br>
     * init()Ă΂ꂽꍇ́Ainit()sȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_next06.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", true);

        // eXg{
        fileLineIterator.init();

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "calledInit"));
        assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                "buildFields"));
        assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                "buildStringConverters"));
        assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                "buildMethods"));
        assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                "buildLineReader"));
        assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                "buildHeader"));
        assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                "buildTrailerQueue"));
    }

    /**
     * testInit02() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:true<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():1Ă΂<br>
     * (ԕω) this.buildMethods():1Ă΂<br>
     * (ԕω) this.buildLineReader():1Ă΂<br>
     * (ԕω) this.buildHeader():1Ă΂<br>
     * (ԕω) this.buildTrailerQueue():1Ă΂<br>
     * <br>
     * B<br>
     * ŏInit()Ă΂ꂽꍇ́Ainit()s邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);

        // eXg{
        fileLineIterator.init();

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "calledInit"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "buildFields"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "buildStringConverters"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "buildMethods"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "buildLineReader"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "buildHeader"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "buildTrailerQueue"));
    }

    /**
     * testInit03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():FileExceptionOB<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:false<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():Ă΂Ȃ<br>
     * (ԕω) this.buildMethods():Ă΂Ȃ<br>
     * (ԕω) this.buildLineReader():Ă΂Ȃ<br>
     * (ԕω) this.buildHeader():Ă΂Ȃ<br>
     * (ԕω) this.buildTrailerQueue():Ă΂Ȃ<br>
     * (ԕω) O:this.buildFields()ŔÔ܂ܓ邱ƂmFB<br>
     * <br>
     * OB<br>
     * this.buildFields()ŗOꍇɁAÔ܂ܓ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);
        FileException exception = new FileException("buildFields̃G[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "buildFields", exception);

        // eXg{
        try {
            fileLineIterator.init();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "calledInit"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildFields"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildStringConverters"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildMethods"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildLineReader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildHeader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildTrailerQueue"));

            assertSame(exception, e);
        }
    }

    /**
     * testInit04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():FileLineExceptionOB<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:false<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():1Ă΂<br>
     * (ԕω) this.buildMethods():Ă΂Ȃ<br>
     * (ԕω) this.buildLineReader():Ă΂Ȃ<br>
     * (ԕω) this.buildHeader():Ă΂Ȃ<br>
     * (ԕω) this.buildTrailerQueue():Ă΂Ȃ<br>
     * (ԕω) O:this.buildStringConverter()ŔÔ܂ܓ邱ƂmFB<br>
     * <br>
     * OB<br>
     * this.buildStringConverter()ŗOꍇɁAÔ܂ܓ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);
        FileLineException exception = new FileLineException(
                "buildStringConverters̃G[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "buildStringConverters", exception);

        // eXg{
        try {
            fileLineIterator.init();
            fail("FileLineExceptionX[܂łB");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "calledInit"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildFields"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildStringConverters"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildMethods"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildLineReader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildHeader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildTrailerQueue"));

            assertSame(exception, e);
        }
    }

    /**
     * testInit05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():FileExceptionOB<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:false<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():1Ă΂<br>
     * (ԕω) this.buildMethods():1Ă΂<br>
     * (ԕω) this.buildLineReader():Ă΂Ȃ<br>
     * (ԕω) this.buildHeader():Ă΂Ȃ<br>
     * (ԕω) this.buildTrailerQueue():Ă΂Ȃ<br>
     * (ԕω) O:this.buildMethods()ŔÔ܂ܓ邱ƂmFB<br>
     * <br>
     * OB<br>
     * this.buildMethods()ŗOꍇɁAÔ܂ܓ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);
        FileException exception = new FileException("buildMethods̃G[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "buildMethods", exception);

        // eXg{
        try {
            fileLineIterator.init();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "calledInit"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildFields"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildStringConverters"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildMethods"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildLineReader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildHeader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildTrailerQueue"));

            assertSame(exception, e);
        }
    }

    /**
     * testInit06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():FileExceptionOB<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:false<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():1Ă΂<br>
     * (ԕω) this.buildMethods():1Ă΂<br>
     * (ԕω) this.buildLineReader():1Ă΂<br>
     * (ԕω) this.buildHeader():1Ă΂<br>
     * (ԕω) this.buildTrailerQueue():Ă΂Ȃ<br>
     * (ԕω) O:this.buildHeader()ŔÔ܂ܓ邱ƂmFB<br>
     * <br>
     * OB<br>
     * this.buildHeader()ŗOꍇɁAÔ܂ܓ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);
        FileException exception = new FileException("buildHeaders̃G[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "buildHeader", exception);

        // eXg{
        try {
            fileLineIterator.init();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "calledInit"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildFields"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildStringConverters"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildMethods"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildHeader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildTrailerQueue"));

            assertSame(exception, e);
        }
    }

    /**
     * testInit07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():FileExceptionOB<br>
     * () this.buildLineReader():폈<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:false<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():1Ă΂<br>
     * (ԕω) this.buildMethods():1Ă΂<br>
     * (ԕω) this.buildLineReader():1Ă΂<br>
     * (ԕω) this.buildHeader():1Ă΂<br>
     * (ԕω) this.buildTrailerQueue():1Ă΂<br>
     * (ԕω) O:this.buildTrailerQueue()ŔÔ܂ܓ邱ƂmFB<br>
     * <br>
     * OB<br>
     * this.buildTrailerQueue()ŗOꍇɁAÔ܂ܓ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);
        FileException exception = new FileException("buildTrailerQueuẽG[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "buildTrailerQueue", exception);

        // eXg{
        try {
            fileLineIterator.init();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "calledInit"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildFields"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildStringConverters"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildMethods"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildHeader"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildTrailerQueue"));

            assertSame(exception, e);
        }
    }

    /**
     * testInit08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.calledInit:false<br>
     * () this.buildFields():폈<br>
     * () this.buildStringConverters():폈<br>
     * () this.buildMethods():폈<br>
     * () this.buildHeader():폈<br>
     * () this.buildTrailerQueue():폈<br>
     * () this.buildLineReader():FileExceptionOB<br>
     * <br>
     * ҒlF(ԕω) this.calledInit:false<br>
     * (ԕω) this.buildFields():1Ă΂<br>
     * (ԕω) this.buildStringConverters():1Ă΂<br>
     * (ԕω) this.buildMethods():1Ă΂<br>
     * (ԕω) this.buildLineReader():1Ă΂<br>
     * (ԕω) this.buildHeader():Ă΂Ȃ<br>
     * (ԕω) this.buildTrailerQueue():Ă΂Ȃ<br>
     * (ԕω) O:this.buildLineReader()ŔÔ܂ܓ邱ƂmFB<br>
     * <br>
     * OB<br>
     * this.buildLineReader()ŗOꍇɁAÔ܂ܓ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testInit08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "calledInit", false);
        FileException exception = new FileException("buildLineReader̃G[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "buildLineReader", exception);

        // eXg{
        try {
            fileLineIterator.init();
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "calledInit"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildFields"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildStringConverters"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildMethods"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "buildLineReader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildHeader"));
            assertFalse(VMOUTUtil.isCalled(AbstractFileLineIterator.class,
                    "buildTrailerQueue"));

            assertSame(exception, e);
        }
    }

    /**
     * testBuildLineReader01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl03<br>
     * @#getEncloseChar()F'\"'Ԃ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r\n"<br>
     * () this.lineReader:null<br>
     * <br>
     * ҒlF(ԕω) this.reader:"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * (ԕω) this.lineReader:ȉ̐ݒEncloseCharLineFeed2LineReaderCX^X<br>
     * EdelimiterCharacterF','<br>
     * EencloseCharacterF''\"'<br>
     * ElineFeedCharF"\r\n"<br>
     * EreaderF"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * <br>
     * B<br>
     * t@CsIuWFNg̃NX@FileFormat̐ݒɁu͂ݕvƁu؂蕶vƁu2̍s؂蕶vݒ肳ĂꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20> fileLineIterator = new AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20>(
                fileName, AbstractFileLineIterator_Stub20.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "enclosed", true);
        UTUtil.setPrivateField(fileLineIterator, "columnEncloseChar",
                new char[] {});

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object reader = UTUtil.getPrivateField(fileLineIterator, "reader");
        assertEquals(BufferedReader.class, reader.getClass());

        Object reader02 = UTUtil
                .getPrivateField(fileLineIterator, "lineReader");
        assertEquals(EncloseCharLineFeed2LineReader.class, reader02.getClass());
        assertEquals(',', UTUtil
                .getPrivateField(reader02, "delimiterCharacter"));
        assertEquals('\"', UTUtil.getPrivateField(reader02, "encloseCharacter"));
        assertEquals("\r\n", UTUtil.getPrivateField(reader02, "lineFeedChar"));
        assertSame(reader, UTUtil.getPrivateField(reader02, "reader"));

        String result = ((BufferedReader) reader).readLine();
        assertEquals("AbstractFileLineIterator_buildLineReader01", result);

        // ㏈
        ((BufferedReader) reader).close();
    }

    /**
     * testBuildLineReader02() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl03<br>
     * @#getEncloseChar()F'\"'Ԃ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildLineReader01.txt"<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r"<br>
     * () this.lineReader:null<br>
     * <br>
     * ҒlF(ԕω) this.reader:"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * (ԕω) this.lineReader:ȉ̐ݒEncloseCharLineFeed1LineReaderCX^X<br>
     * EdelimiterCharacterF','<br>
     * EencloseCharacterF''\"'<br>
     * ElineFeedCharF"\r"<br>
     * EreaderF"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * <br>
     * B<br>
     * t@CsIuWFNg̃NX@FileFormat̐ݒɁu͂ݕvƁu؂蕶vƁu1̍s؂蕶vݒ肳ĂꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub21> fileLineIterator = new AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub21>(
                fileName, AbstractFileLineIterator_Stub21.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "enclosed", true);
        UTUtil.setPrivateField(fileLineIterator, "columnEncloseChar",
                new char[] {});

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object reader = UTUtil.getPrivateField(fileLineIterator, "reader");
        assertEquals(BufferedReader.class, reader.getClass());

        Object reader02 = UTUtil
                .getPrivateField(fileLineIterator, "lineReader");
        assertEquals(EncloseCharLineFeed1LineReader.class, reader02.getClass());
        assertEquals(',', UTUtil
                .getPrivateField(reader02, "delimiterCharacter"));
        assertEquals('\"', UTUtil.getPrivateField(reader02, "encloseCharacter"));
        assertEquals("\r", UTUtil.getPrivateField(reader02, "lineFeedChar"));
        assertSame(reader, UTUtil.getPrivateField(reader02, "reader"));

        String result = ((BufferedReader) reader).readLine();
        assertEquals("AbstractFileLineIterator_buildLineReader01", result);

        // ㏈
        ((BufferedReader) reader).close();
    }

    /**
     * testBuildLineReader03() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl04<br>
     * @#getEncloseChar()FCharacter.MIN_VALUEԂ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildLineReader01.txt"<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r\n"<br>
     * () this.lineReader:null<br>
     * <br>
     * ҒlF(ԕω) this.reader:"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * (ԕω) this.lineReader:ȉ̐ݒLineFeed2LineReaderCX^X<br>
     * ElineFeedCharF"\r\n"<br>
     * EreaderF"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * <br>
     * B<br>
     * t@CsIuWFNg̃NX@FileFormat̐ݒɁu؂蕶vƁu2̍s؂蕶vݒ肳ĂꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub20> fileLineIterator = new AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub20>(
                fileName, AbstractFileLineIterator_Stub20.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object reader = UTUtil.getPrivateField(fileLineIterator, "reader");
        assertEquals(BufferedReader.class, reader.getClass());

        Object reader02 = UTUtil
                .getPrivateField(fileLineIterator, "lineReader");
        assertEquals(LineFeed2LineReader.class, reader02.getClass());
        assertEquals("\r\n", UTUtil.getPrivateField(reader02, "lineFeedChar"));
        assertSame(reader, UTUtil.getPrivateField(reader02, "reader"));

        String result = ((BufferedReader) reader).readLine();
        assertEquals("AbstractFileLineIterator_buildLineReader01", result);

        // ㏈
        ((BufferedReader) reader).close();
    }

    /**
     * testBuildLineReader04() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl04<br>
     * @#getEncloseChar()FCharacter.MIN_VALUEԂ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildLineReader01.txt"<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r"<br>
     * () this.lineReader:null<br>
     * <br>
     * ҒlF(ԕω) this.reader:"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * (ԕω) this.lineReader:ȉ̐ݒLineFeed1LineReaderCX^X<br>
     * ElineFeedCharF"\r"<br>
     * EreaderF"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * <br>
     * B<br>
     * t@CsIuWFNg̃NX@FileFormat̐ݒɁu؂蕶vƁu1̍s؂蕶vݒ肳ĂꍇɁA邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub21> fileLineIterator = new AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub21>(
                fileName, AbstractFileLineIterator_Stub21.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object reader = UTUtil.getPrivateField(fileLineIterator, "reader");
        assertEquals(BufferedReader.class, reader.getClass());

        Object reader02 = UTUtil
                .getPrivateField(fileLineIterator, "lineReader");
        assertEquals(LineFeed1LineReader.class, reader02.getClass());
        assertEquals("\r", UTUtil.getPrivateField(reader02, "lineFeedChar"));
        assertSame(reader, UTUtil.getPrivateField(reader02, "reader"));

        String result = ((BufferedReader) reader).readLine();
        assertEquals("AbstractFileLineIterator_buildLineReader01", result);

        // ㏈
        ((BufferedReader) reader).close();
    }

    /**
     * testBuildLineReader05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl03<br>
     * @#getEncloseChar()F'\"'Ԃ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildLineReader_noExist.txt"i݂Ȃt@Cj<br>
     * CX^Xɐݒ肷B<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r\n"<br>
     * () this.lineReader:null<br>
     * CX^Xɐݒ肷B<br>
     * () this.reader:null<br>
     * CX^Xɐݒ肷B<br>
     * <br>
     * ҒlF(ԕω) this.reader:null<br>
     * (ԕω) this.lineReader:null<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Failed in generation of reader."<br>
     * EOFFileNotFoundException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * ݂Ȃt@CfileNameɐݒ肵ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20> fileLineIterator = new AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20>(
                fileName, AbstractFileLineIterator_Stub20.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        String fileName_test = "AbstractFileLineIterator_buildLineReader_noExist.txt";
        UTUtil.setPrivateField(fileLineIterator, "fileName", fileName_test);
        UTUtil.setPrivateField(fileLineIterator, "lineReader", null);
        UTUtil.setPrivateField(fileLineIterator, "reader", null);
        // ̑́AeXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildLineReader");
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertNull(UTUtil.getPrivateField(fileLineIterator, "reader"));
            assertNull(UTUtil.getPrivateField(fileLineIterator, "lineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Failed in generation of reader.", e.getMessage());
            assertSame(FileNotFoundException.class, e.getCause().getClass());
            assertSame(fileName_test, e.getFileName());
        }
    }

    /**
     * testBuildLineReader06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl03<br>
     * @#getEncloseChar()F'\"'Ԃ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "File_1Linecsv"<br>
     * () this.fileEncoding:݂ȂGR[h<br>
     * CX^Xɐݒ肷<br>
     * () this.lineFeedChar:"\r\n"<br>
     * () this.lineReader:null<br>
     * CX^Xɐݒ肷B<br>
     * () this.reader:null<br>
     * CX^Xɐݒ肷B<br>
     * <br>
     * ҒlF(ԕω) this.reader:null<br>
     * (ԕω) this.lineReader:null<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Failed in generation of reader."<br>
     * EOFUnsupportedEncodingException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * ݂ȂGR[hfileEncodeɐݒ肵ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20> fileLineIterator = new AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20>(
                fileName, AbstractFileLineIterator_Stub20.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fileEncoding", "aaa");
        UTUtil.setPrivateField(fileLineIterator, "lineReader", null);
        UTUtil.setPrivateField(fileLineIterator, "reader", null);
        // ̑́AeXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildLineReader");
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertNull(UTUtil.getPrivateField(fileLineIterator, "reader"));
            assertNull(UTUtil.getPrivateField(fileLineIterator, "lineReader"));

            assertSame(FileException.class, e.getClass());
            assertEquals("Failed in generation of reader.", e.getMessage());
            assertSame(UnsupportedEncodingException.class, e.getCause()
                    .getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testBuildLineReader07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl04<br>
     * @#getEncloseChar()FCharacter.MIN_VALUEԂ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildLineReader01.txt"<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r\r\r"<br>
     * CX^Xɐݒ肷<br>
     * () this.lineReader:null<br>
     * CX^Xɐݒ肷B<br>
     * () this.reader:null<br>
     * CX^Xɐݒ肷B<br>
     * <br>
     * ҒlF(ԕω) this.reader:"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * (ԕω) this.lineReader:null<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"lineFeedChar length must be 0 or 1 or 2. but: 3"<br>
     * EOFIllegalStateException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * t@CsIuWFNg̃NX@FileFormat̐ݒɁu؂蕶vƁu3ȏ̍s؂蕶vݒ肳ĂꍇɁAOX[B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub20> fileLineIterator = new AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub20>(
                fileName, AbstractFileLineIterator_Stub20.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "lineFeedChar", "\r\r\r");
        UTUtil.setPrivateField(fileLineIterator, "lineReader", null);
        UTUtil.setPrivateField(fileLineIterator, "reader", null);
        // ̑́AeXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildLineReader");
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            Object reader = UTUtil.getPrivateField(fileLineIterator, "reader");
            assertEquals(BufferedReader.class, reader.getClass());

            Object reader02 = UTUtil.getPrivateField(fileLineIterator,
                    "lineReader");
            assertNull(reader02);

            assertSame(FileException.class, e.getClass());
            assertEquals("lineFeedChar length must be 0 or 1 or 2. but: 3", e
                    .getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testBuildLineReader08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl03<br>
     * @#getEncloseChar()F'\"'Ԃ<br>
     * @#getDelimiter()F','Ԃ<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildLineReader01.txt"<br>
     * () this.fileEncoding:VXeftHgl<br>
     * () this.lineFeedChar:"\r\r\r"<br>
     * CX^Xɐݒ肷<br>
     * () this.lineReader:null<br>
     * CX^Xɐݒ肷B<br>
     * () this.reader:null<br>
     * CX^Xɐݒ肷B<br>
     * <br>
     * ҒlF(ԕω) this.reader:"AbstractFileLineIterator_buildLineReader01.txt"ɑ΂BufferedReaderCX^X<br>
     * (ԕω) this.lineReader:null<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"lineFeedChar length must be 0 or 1 or 2. but: 3"<br>
     * EOFIllegalStateException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * t@CsIuWFNg̃NX@FileFormat̐ݒɁu͂ݕvƁu؂蕶vƁu3ȏ̍s؂蕶vݒ肳ĂꍇɁAOX[B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildLineReader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20> fileLineIterator = new AbstractFileLineIteratorImpl03<AbstractFileLineIterator_Stub20>(
                fileName, AbstractFileLineIterator_Stub20.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "lineFeedChar", "\r\r\r");
        UTUtil.setPrivateField(fileLineIterator, "lineReader", null);
        UTUtil.setPrivateField(fileLineIterator, "reader", null);
        // ̑́AeXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildLineReader");
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            Object reader = UTUtil.getPrivateField(fileLineIterator, "reader");
            assertEquals(BufferedReader.class, reader.getClass());

            Object reader02 = UTUtil.getPrivateField(fileLineIterator,
                    "lineReader");
            assertNull(reader02);

            assertSame(FileException.class, e.getClass());
            assertEquals("lineFeedChar length must be 0 or 1 or 2. but: 3", e
                    .getMessage());
            assertSame(IllegalStateException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testBuildLineReader09() <br>
     * <br>
     * (ُn) <br>
     * <br>
     * ͒lFmarkSupported falseԂ<br>
     * <br>
     * ҒlF O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"BufferedReader of this JVM dose not support mark method"<br>
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildLineReader09() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub21> fileLineIterator = new AbstractFileLineIteratorImpl04<AbstractFileLineIterator_Stub21>(
                fileName, AbstractFileLineIterator_Stub21.class,
                columnParserMap);

        // markSupportedfalseԋp悤ɐݒ
        VMOUTUtil.setReturnValueAtAllTimes(BufferedReader.class,
                "markSupported", false);
        try {
            // eXg{
            UTUtil.invokePrivate(fileLineIterator, "buildLineReader");
            fail();
        } catch (FileException e) {
            assertEquals(
                    "BufferedReader of this JVM dose not support mark method",
                    e.getMessage());
        }
    }

    /**
     * testBuildFields01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂB<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.fields:null<br>
     * () this.columnParserMap:ȉ̗vf<br>
     * Map<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     * ҒlF(ԕω) Field.getAnnotation():Ă΂Ȃ<br>
     * (ԕω) this.fields:vfȂFieldzCX^X<br>
     * (ԕω) Class.getDeclaredFields():2Ă΂<br>
     * <br>
     * B<br>
     * tB[hclazztB[hĂȂꍇAI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildFields");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        Object result_fields = (Field[]) UTUtil.getPrivateField(
                fileLineIterator, "fields");
        assertEquals(Field[].class, result_fields.getClass());
        Field[] fields = (Field[]) result_fields;
        assertEquals(0, fields.length);
        assertEquals(2, VMOUTUtil
                .getCallCount(Class.class, "getDeclaredFields"));
    }

    /**
     * testBuildFields02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn3<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.fields:null<br>
     * () this.columnParserMap:ȉ̗vf<br>
     * Map<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     * ҒlF(ԕω) Field.getAnnotation():3Ă΂<br>
     * (ԕω) this.fields:vfȂFieldzCX^X<br>
     * (ԕω) Class.getDeclaredFields():2Ă΂<br>
     * <br>
     * B<br>
     * tB[hclazz@InputFileColumnݒȂ̃tB[ĥݎꍇA}bsOΏۃtB[h̏񂪐ݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub30> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub30>(
                fileName, AbstractFileLineIterator_Stub30.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildFields");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(3, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        Object result_fields = (Field[]) UTUtil.getPrivateField(
                fileLineIterator, "fields");
        assertEquals(Field[].class, result_fields.getClass());
        Field[] fields = (Field[]) result_fields;
        assertEquals(0, fields.length);
        assertEquals(2, VMOUTUtil
                .getCallCount(Class.class, "getDeclaredFields"));
    }

    /**
     * testBuildFields03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():6Ă΂<br>
     *                        (ԕω) this.fields:this.clazzɑ΂tB[hvf3FieldzCX^X<br>
     *                        PDcolumn1<br>
     *                        QDcolumn2<br>
     *                        RDcolumn3<br>
     * <br>
     *                        ԂcolumnIndex<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[ĥݎA܂etB[hcolumnIndexlɏdȂꍇA}bsOΏۃtB[h̏񂪐ݒ肳邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub31> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub31>(
                fileName, AbstractFileLineIterator_Stub31.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildFields");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(6, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        Object result_fields = (Field[]) UTUtil.getPrivateField(
                fileLineIterator, "fields");
        assertEquals(Field[].class, result_fields.getClass());
        Field[] fields = (Field[]) result_fields;
        assertEquals(3, fields.length);
        assertEquals("column1", fields[0].getName());
        assertEquals("column2", fields[1].getName());
        assertEquals("column3", fields[2].getName());
        assertEquals(2, VMOUTUtil
                .getCallCount(Class.class, "getDeclaredFields"));
    }

    /**
     * testBuildFields04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn3<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        NX`A@L薳̃tB[h̏ԂĒ`邱ƁB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():9Ă΂<br>
     *                        (ԕω) this.fields:this.clazzɑ΂tB[hvf3FieldzCX^X<br>
     *                        PDcolumn1<br>
     *                        QDcolumn2<br>
     *                        RDcolumn3<br>
     * <br>
     *                        ԂcolumnIndex<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠EȂ̃tB[hA܂etB[hcolumnIndexlɏdȂꍇA}bsOΏۃtB[h̏񂪐ݒ肳邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub32> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub32>(
                fileName, AbstractFileLineIterator_Stub32.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildFields");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(9, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        Object result_fields = (Field[]) UTUtil.getPrivateField(
                fileLineIterator, "fields");
        assertEquals(Field[].class, result_fields.getClass());
        Field[] fields = (Field[]) result_fields;
        assertEquals(3, fields.length);
        assertEquals("column1", fields[0].getName());
        assertEquals("column2", fields[1].getName());
        assertEquals("column3", fields[2].getName());
        assertEquals(2, VMOUTUtil
                .getCallCount(Class.class, "getDeclaredFields"));
    }

    /**
     * testBuildFields05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():3Ă΂<br>
     *                        (ԕω) this.fields:null<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     *                        (ԕω) -:ȉ̏FileException邱ƂmFB<br>
     *                        EbZ[WF"Column Index is duplicate : 1"<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     *                        OB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[ĥݎA܂etB[hcolumnIndexldĂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub33> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub33>(
                fileName, AbstractFileLineIterator_Stub33.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildFields");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(3, VMOUTUtil
                    .getCallCount(Field.class, "getAnnotation"));
            Object result_fields = (Field[]) UTUtil.getPrivateField(
                    fileLineIterator, "fields");
            assertNull(result_fields);
            assertEquals(2, VMOUTUtil.getCallCount(Class.class,
                    "getDeclaredFields"));

            assertEquals(FileException.class, e.getClass());
            assertEquals("Column Index is duplicate : 1", e.getMessage());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testBuildFields06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn3<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndex͏dȂAAԂł͂ȂB<br>
     *                        NX`A@L薳̃tB[h̏ԂĒ`邱ƁB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():6Ă΂<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     *                        (ԕω) -:ȉ̏FileException邱ƂmFB<br>
     *                        EbZ[WF"columnIndex in FileLineObject is not sequential order."<br>
     *                        Et@CFtB[hfileNameƓCX^X<br>
     *                        EbvꂽOFIllegalStateException<br>
     * <br>
     *                        OB<br>
     *                        tB[hclazz@InputFileColumnݒ肠EȂ̃tB[hA܂etB[hcolumnIndexlԂł͂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub34> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub34>(
                fileName, AbstractFileLineIterator_Stub34.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildFields");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(6, VMOUTUtil
                    .getCallCount(Field.class, "getAnnotation"));
            assertEquals(2, VMOUTUtil.getCallCount(Class.class,
                    "getDeclaredFields"));

            assertEquals(FileException.class, e.getClass());
            assertEquals(
                    "columnIndex in FileLineObject is not sequential order.", e
                            .getMessage());
            assertSame(fileName, e.getFileName());
            assertSame(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testBuildFields07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn3<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > ̑ځFftHgl<br>
     * <br>
     *                        ȉ̐ݒ͌p̐eNXɒ`ĂB<br>
     *                        E@InputFileColumnݒȂ̃tB[h<br>
     *                        - tB[hFString noMappingColumn1<br>
     *                        - tB[hFString noMappingColumn2<br>
     *                        E@InputFileColumnݒ肠̃tB[h<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndex͏dȂB<br>
     *                        NXp֌WɂAeNXɂ@InputFileColumnݒ肠̃tB[hB<br>
     *                        NX`A@L薳̃tB[h̏ԂĒ`邱ƁB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():9Ă΂<br>
     *                        (ԕω) this.fields:this.clazzɑ΂tB[hvf3FieldzCX^X<br>
     *                        PDcolumn1<br>
     *                        QDcolumn2<br>
     *                        RDcolumn3<br>
     * <br>
     *                        ԂcolumnIndex<br>
     *                        (ԕω) Class.getDeclaredFields():3Ă΂<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠EȂ̃tB[hAetB[hcolumnIndexlɏdȂA܂tB[h̒`eNXɂꍇA
     *                        eNX܂߂}bsOΏۃtB[h̏񂪐ݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub36> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub36>(
                fileName, AbstractFileLineIterator_Stub36.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildFields");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(9, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        Object result_fields = (Field[]) UTUtil.getPrivateField(
                fileLineIterator, "fields");
        assertEquals(Field[].class, result_fields.getClass());
        Field[] fields = (Field[]) result_fields;
        assertEquals(3, fields.length);
        assertEquals("column1", fields[0].getName());
        assertEquals("column2", fields[1].getName());
        assertEquals("column3", fields[2].getName());
        assertEquals(3, VMOUTUtil
                .getCallCount(Class.class, "getDeclaredFields"));
    }

    /**
     * testBuildFields08() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumn@OutputFileColumn̐ݒ肪tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumn@OutputFileColumn̐ݒ<br> > columnIndexF2<br>
     *                                           > ̑ځFftHgl<br>
     *                                           - tB[hFString column1<br>
     * @InputFileColumn@OutputFileColumn̐ݒ<br> > columnIndexF0<br>
     *                                           > ̑ځFftHgl<br>
     *                                           - tB[hFString column2<br>
     * @InputFileColumn@OutputFileColumn̐ݒ<br> > columnIndexF1<br>
     *                                           > ̑ځFftHgl<br>
     *                                           columnIndexdȂB<br>
     *                                           () this.fileName:StringCX^X<br>
     *                                           "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                                           () this.fields:null<br>
     *                                           () this.columnParserMap:ȉ̗vf<br>
     *                                           Map<String, ColumnParser>CX^X<br>
     *                                           E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                                           ҒlF(ԕω) Field.getAnnotation():3Ă΂<br>
     *                                           (ԕω) this.fields:this.clazzɑ΂tB[hvf3FieldzCX^X<br>
     *                                           PDcolumn1<br>
     *                                           QDcolumn2<br>
     *                                           RDcolumn3<br>
     * <br>
     *                                           ԂcolumnIndex<br>
     *                                           (ԕω) Class.getDeclaredFields():2Ă΂<br>
     * <br>
     *                                           B<br>
     *                                           tB[hclazz@InputFileColumn@OutputFileColumn̐ݒ肠̃tB[hA܂etB[hcolumnIndexlɏdȂꍇ
     *                                           A}bsOΏۃtB[h̏񂪐ݒ肳邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub37> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub37>(
                fileName, AbstractFileLineIterator_Stub37.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildFields");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(6, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        Object result_fields = (Field[]) UTUtil.getPrivateField(
                fileLineIterator, "fields");
        assertEquals(Field[].class, result_fields.getClass());
        Field[] fields = (Field[]) result_fields;
        assertEquals(3, fields.length);
        assertEquals("column1", fields[0].getName());
        assertEquals("column2", fields[1].getName());
        assertEquals("column3", fields[2].getName());
        assertEquals(2, VMOUTUtil
                .getCallCount(Class.class, "getDeclaredFields"));
    }

    /**
     * testBuildFields09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FB,G <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():1Ă΂<br>
     *                        (ԕω) this.fields:null<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     *                        (ԕω) -:ȉ̏FileException邱ƂmFB<br>
     *                        EOFIllegalStateException<br>
     *                        EbZ[WF"Column Index in FileLineObject is bigger than the total number of the field."<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     *                        ُB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[ĥݎA܂etB[hcolumnIndexlɏdȂ0n܂AԂł͂ȂꍇAO邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields09() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub38> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub38>(
                fileName, AbstractFileLineIterator_Stub38.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildFields");
            fail("FileExceptionĂ܂B");
        } catch (FileException e) {
            // O̊mF
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals("Column Index in FileLineObject is bigger than the "
                    + "total number of the field.", e.getMessage());
            assertEquals(fileName, e.getFileName());

            // ԕω̊mF
            assertEquals(1, VMOUTUtil
                    .getCallCount(Field.class, "getAnnotation"));
            Object result_fields = UTUtil.getPrivateField(fileLineIterator,
                    "fields");
            assertNull(result_fields);
            assertEquals(2, VMOUTUtil.getCallCount(Class.class,
                    "getDeclaredFields"));
        }
    }

    /**
     * testBuildFields10() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FB,G <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF-1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():3Ă΂<br>
     *                        (ԕω) this.fields:null<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     *                        (ԕω) -:ȉ̏FileException邱ƂmFB<br>
     *                        EOFIllegalStateException<br>
     *                        EbZ[WF"Column Index in FileLineObject is the minus number."<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     *                        ُB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[ĥݎA܂etB[hcolumnIndexlɏdȂA}CiXlݒ肳ꂽꍇAO邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields10() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub39> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub39>(
                fileName, AbstractFileLineIterator_Stub39.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildFields");
            fail("FileExceptionĂ܂B");
        } catch (FileException e) {
            // O̊mF
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals("Column Index in FileLineObject is the minus number.",
                    e.getMessage());
            assertEquals(fileName, e.getFileName());

            // ԕω̊mF
            assertEquals(3, VMOUTUtil
                    .getCallCount(Field.class, "getAnnotation"));
            Object result_fields = UTUtil.getPrivateField(fileLineIterator,
                    "fields");
            assertNull(result_fields);
            assertEquals(2, VMOUTUtil.getCallCount(Class.class,
                    "getDeclaredFields"));
        }
    }

    /**
     * testBuildFields11() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FB,G <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFlong column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        this.columnParserMapɑ݂Ȃ^CṽtB[hB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.fields:null<br>
     *                        () this.columnParserMap:ȉ̗vf<br>
     *                        Map<String, ColumnParser>CX^X<br>
     *                        E"java.lang.String"=NullColumnParserCX^X<br>
     * <br>
     *                        ҒlF(ԕω) Field.getAnnotation():2Ă΂<br>
     *                        (ԕω) this.fields:null<br>
     *                        (ԕω) Class.getDeclaredFields():2Ă΂<br>
     *                        (ԕω) -:ȉ̏FileException邱ƂmFB<br>
     *                        EOFIllegalStateException<br>
     *                        EbZ[WF"There is a type which isn't supported in a mapping target field in FileLineObject."<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     *                        ُB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[ĥݎAΏۃtB[hthis.columnParserMapɑ݂Ȃ^̃tB[h̏ꍇAO邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildFields11() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub90> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub90>(
                fileName, AbstractFileLineIterator_Stub90.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "fields", null);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildFields");
            fail("FileExceptionĂ܂B");
        } catch (FileException e) {
            // O̊mF
            assertTrue(IllegalStateException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals("There is a type which isn't supported in a mapping "
                    + "target field in FileLineObject.", e.getMessage());
            assertEquals(fileName, e.getFileName());

            // ԕω̊mF
            assertEquals(2, VMOUTUtil
                    .getCallCount(Field.class, "getAnnotation"));
            Object result_fields = UTUtil.getPrivateField(fileLineIterator,
                    "fields");
            assertNull(result_fields);
            assertEquals(2, VMOUTUtil.getCallCount(Class.class,
                    "getDeclaredFields"));
        }
    }

    /**
     * testBuildStringConverter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂB<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.stringConverter:null<br>
     * () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     * () this.currentLineCount:0<br>
     * () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     * ҒlF(ԕω) Field.getAnnotationij:Ă΂Ȃ<br>
     * (ԕω) Class.newInstance():Ă΂Ȃ<br>
     * (ԕω) Map.containsKey(Object):Ă΂Ȃ<br>
     * (ԕω) Map.put(K, V):Ă΂Ȃ<br>
     * (ԕω) Map.get(Object):Ă΂Ȃ<br>
     * (ԕω) this.stringConverters:vfȂStringConverterzCX^X<br>
     * (ԕω) this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     * <br>
     * B<br>
     * tB[hclazztB[hĂȂꍇAStringConverter֘AtB[h(StringConverterȂ)邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(0, stringConverters.length);
        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(0, stringConverterCacheMap.size());
    }

    /**
     * testBuildStringConverter02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.stringConverter:null<br>
     * () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     * () this.currentLineCount:0<br>
     * () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     * ҒlF(ԕω) Field.getAnnotationij:Ă΂Ȃ<br>
     * (ԕω) Class.newInstance():Ă΂Ȃ<br>
     * (ԕω) Map.containsKey(Object):Ă΂Ȃ<br>
     * (ԕω) Map.put(K, V):Ă΂Ȃ<br>
     * (ԕω) Map.get(Object):Ă΂Ȃ<br>
     * (ԕω) this.stringConverters:vfȂStringConverterzCX^X<br>
     * (ԕω) this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     * <br>
     * B<br>
     * tB[hclazz@InputFileColumnݒȂ̃tB[hiPĵݎꍇAStringConverter֘AtB[h(StringConverterȂ)邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub40> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub40>(
                fileName, AbstractFileLineIterator_Stub40.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(0, stringConverters.length);
        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(0, stringConverterCacheMap.size());
    }

    /**
     * testBuildStringConverter03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():1Ă΂<br>
     *                        (ԕω) Map.containsKey(Object):1Ă΂<br>
     *                        (ԕω) Map.put(K, V):1Ă΂<br>
     *                        (ԕω) Map.get(Object):Ă΂Ȃ<br>
     *                        (ԕω) this.stringConverters:ȉ̗vfStringConverterzCX^X<br>
     *                        E[0]FStringConverterToUpperCaseCX^X<br>
     * <br>
     *                        this.stringConverterCacheMapɊi[ĂStringConverterToUpperCaseCX^XƓ́B<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E StringConverterToUpperCase.class<br>
     *                        =StringConverterToUpperCaseCX^X<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hi
     *                        PĵݎꍇAStringConverterzɂ1StringConverterALbVɂ͂PStringConverterݒ肳ASCX^X̂Ƃm
     *                        F   B <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub41> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub41>(
                fileName, AbstractFileLineIterator_Stub41.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(1, stringConverters.length);
        assertEquals(StringConverterToUpperCase.class, stringConverters[0]
                .getClass());
        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(1, stringConverterCacheMap.size());
        assertSame(stringConverters[0], stringConverterCacheMap
                .get(StringConverterToUpperCase.class));
    }

    /**
     * testBuildStringConverter04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn3<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () this.stringConverter:null<br>
     * () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     * () this.currentLineCount:0<br>
     * () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     * ҒlF(ԕω) Field.getAnnotationij:Ă΂Ȃ<br>
     * (ԕω) Class.newInstance():Ă΂Ȃ<br>
     * (ԕω) Map.containsKey(Object):Ă΂Ȃ<br>
     * (ԕω) Map.put(K, V):Ă΂Ȃ<br>
     * (ԕω) Map.get(Object):Ă΂Ȃ<br>
     * (ԕω) this.stringConverters:vfȂStringConverterzCX^X<br>
     * (ԕω) this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     * <br>
     * B<br>
     * tB[hclazz@InputFileColumnݒȂ̃tB[hiRĵݎꍇAStringConverter֘AtB[h(StringConverterȂ)邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub42> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub42>(
                fileName, AbstractFileLineIterator_Stub42.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Field.class, "getAnnotation"));
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(0, stringConverters.length);
        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(0, stringConverterCacheMap.size());
    }

    /**
     * testBuildStringConverter05() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        stringConverterSB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():1Ă΂<br>
     *                        (ԕω) Map.containsKey(Object):3Ă΂<br>
     *                        (ԕω) Map.put(K, V):1Ă΂<br>
     *                        (ԕω) Map.get(Object):2Ă΂<br>
     *                        (ԕω) this.stringConverters:ȉ̗vfStringConverterzCX^X<br>
     *                        E[0]FStringConverterToUpperCaseCX^X<br>
     *                        E[1]FStringConverterToUpperCaseCX^X<br>
     *                        E[2]FStringConverterToUpperCaseCX^X<br>
     * <br>
     *                        RSthis.stringConverterCacheMapɊi[ĂStringConverterToUpperCaseCX^XƓ́B<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E StringConverterToUpperCase.class<br>
     *                        =StringConverterToUpperCaseCX^X<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hi
     *                        RĵݎAݒ肳ꂽstringConverterStB[h̏ꍇAStringConverterzɂ͂RStringConverterALbVɂ͂PStringCo
     *                        n v e r t e r       A   S    C  X ^  X     m F   B <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub43> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub43>(
                fileName, AbstractFileLineIterator_Stub43.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(3, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(2, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(3, stringConverters.length);
        assertEquals(StringConverterToUpperCase.class, stringConverters[0]
                .getClass());
        assertSame(stringConverters[0], stringConverters[1]);
        assertSame(stringConverters[0], stringConverters[2]);
        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(1, stringConverterCacheMap.size());
        assertSame(stringConverters[0], stringConverterCacheMap
                .get(StringConverterToUpperCase.class));
    }

    /**
     * testBuildStringConverter06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠EȂ̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString noMappingColumn1<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        stringConverterSB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():1Ă΂<br>
     *                        (ԕω) Map.containsKey(Object):2Ă΂<br>
     *                        (ԕω) Map.put(K, V):1Ă΂<br>
     *                        (ԕω) Map.get(Object):1Ă΂<br>
     *                        (ԕω) this.stringConverters:ȉ̗vfStringConverterzCX^X<br>
     *                        E[0]FStringConverterToUpperCaseCX^X<br>
     *                        E[1]Fnull<br>
     *                        E[2]FStringConverterToUpperCaseCX^X<br>
     * <br>
     *                        i[ĂCX^Xthis.stringConverterCacheMapɊi[ĂStringConverterToUpperCaseCX^XƓ́B<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E StringConverterToUpperCase.class<br>
     *                        =StringConverterToUpperCaseCX^X<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[i
     *                        QjhƂȂtB[hiPjAݒ肳ꂽstringConverterStB[h̏ꍇAStringConverterzɂ͂QStringConverterALbV
     *                         P   S t r i n g C o n v e r t e r       A   S    C  X ^  X     m F   B <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub44> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub44>(
                fileName, AbstractFileLineIterator_Stub44.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(2, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(2, stringConverters.length);
        assertEquals(StringConverterToUpperCase.class, stringConverters[0]
                .getClass());
        assertSame(stringConverters[0], stringConverters[1]);
        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(1, stringConverterCacheMap.size());
        assertSame(stringConverters[0], stringConverterCacheMap
                .get(StringConverterToUpperCase.class));
    }

    /**
     * testBuildStringConverter07() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠EȂ̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column5<br>
     * @InputFileColumnݒ<br> > columnIndexF4<br>
     *                        > stringConverterF<br>
     *                        StringConverterToLowerCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > stringConverterF<br>
     *                        NullStringConverter.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > stringConverterF<br>
     *                        StringConverterToLowerCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        2ӏœstringConverter𗘗pĂB<br>
     *                        stringConverter̎ނ͂R<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():3Ă΂<br>
     *                        (ԕω) Map.containsKey(Object):5Ă΂<br>
     *                        (ԕω) Map.put(K, V):3Ă΂<br>
     *                        (ԕω) Map.get(Object):2Ă΂<br>
     *                        (ԕω) this.stringConverters:ȉ̗vfStringConverterzCX^X<br>
     *                        E[0]FNullStringConverterCX^X<br>
     *                        E[1]FStringConverterToLowerCaseCX^X<br>
     *                        E[2]FNullStringConverterCX^X<br>
     *                        E[3]FStringConverterToUpperCaseCX^X<br>
     *                        E[4]FStringConverterToLowerCaseCX^X<br>
     * <br>
     *                        i[ĂCX^Xthis.stringConverterCacheMapɊi[Ă铯^̃CX^XƓ́B<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E NullStringConverter.class<br>
     *                        =NullStringConverterCX^X<br>
     *                        E StringConverterToUpperCase.class<br>
     *                        =StringConverterToUpperCaseCX^X<br>
     *                        E StringConverterToLowerCase.class<br>
     *                        =StringConverterToLowerCaseCX^X<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hi5ĵݎAݒ肳ꂽstringConverterd(2ӏ)ꍇAStringConverterzɂ͂TStringConverter
     *                        ALbVɂ͂RStringConverterݒ肳A^Cv͓CX^X𗘗p邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub45> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub45>(
                fileName, AbstractFileLineIterator_Stub45.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(3, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(5, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(3, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(2, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(5, stringConverters.length);
        assertSame(NullStringConverter.class, stringConverters[0].getClass());
        assertSame(StringConverterToLowerCase.class, stringConverters[1]
                .getClass());
        assertSame(NullStringConverter.class, stringConverters[2].getClass());
        assertSame(StringConverterToUpperCase.class, stringConverters[3]
                .getClass());
        assertSame(StringConverterToLowerCase.class, stringConverters[4]
                .getClass());

        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(3, stringConverterCacheMap.size());
        assertSame(stringConverters[0], stringConverterCacheMap
                .get(NullStringConverter.class));
        assertSame(stringConverters[1], stringConverterCacheMap
                .get(StringConverterToLowerCase.class));
        assertSame(stringConverters[2], stringConverterCacheMap
                .get(NullStringConverter.class));
        assertSame(stringConverters[3], stringConverterCacheMap
                .get(StringConverterToUpperCase.class));
        assertSame(stringConverters[4], stringConverterCacheMap
                .get(StringConverterToLowerCase.class));
    }

    /**
     * testBuildStringConverter08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > stringConverterF<br>
     *                        StringConverter.class<br>
     *                        > ̑ځFftHgl<br>
     *                        stringConverterC^tF[XB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():2Ă΂<br>
     *                        (ԕω) Map.containsKey(Object):2Ă΂<br>
     *                        (ԕω) Map.put(K, V):1Ă΂<br>
     *                        (ԕω) Map.get(Object):Ă΂Ȃ<br>
     *                        (ԕω) this.stringConverters:null<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E NullStringConverter.class<br>
     *                        =NullStringConverterCX^X<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Failed in an instantiate of a stringConverter."<br>
     *                        EOFInstantiationException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF-1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hAݒ肳ꂽstringConverterC^tF[X̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter08() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub46> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub46>(
                fileName, AbstractFileLineIterator_Stub46.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");
            fail("FileLineExceptionX[܂łB");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(2, VMOUTUtil.getCallCount(Class.class, "newInstance"));
            assertEquals(2, VMOUTUtil.getCallCount(Map.class, "containsKey"));
            assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
            assertEquals(0, VMOUTUtil.getCallCount(Map.class, "get"));
            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineIterator, "stringConverters");
            assertNull(stringConverters);

            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineIterator.getClass(),
                            "stringConverterCacheMap");
            assertEquals(1, stringConverterCacheMap.size());
            Object cacheMap01 = stringConverterCacheMap
                    .get(NullStringConverter.class);
            assertSame(NullStringConverter.class, cacheMap01.getClass());

            assertEquals(FileLineException.class, e.getClass());
            assertEquals("Failed in an instantiate of a stringConverter.", e
                    .getMessage());
            assertEquals(InstantiationException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
            assertEquals(-1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());
        }
    }

    /**
     * testBuildStringConverter09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > stringConverterFftHgŒڃCX^XłȂƎStringConverter.class<br>
     *                        > ̑ځFftHgl<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:vfĂȂHashMap<Class, StringConverter>CX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():2Ă΂<br>
     *                        (ԕω) Map.containsKey(Object):2Ă΂<br>
     *                        (ԕω) Map.put(K, V):1Ă΂<br>
     *                        (ԕω) Map.get(Object):Ă΂Ȃ<br>
     *                        (ԕω) this.stringConverters:null<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E NullStringConverter.class<br>
     *                        =NullStringConverterCX^X<br>
     *                        (ԕω) O:ȉ̏FileLineException邱ƂmFB<br>
     *                        EbZ[WF"Failed in an instantiate of a stringConverter."<br>
     *                        EOFIllegalAccessException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     *                        EsԍF-1<br>
     *                        EJFcolumn2<br>
     *                        EJCfbNXF1<br>
     * <br>
     *                        OB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hAݒ肳ꂽstringConverterftHgRXgN^ŃCX^XłȂNX̏ꍇAO邱ƂmF
     *                        B <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter09() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub47> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub47>(
                fileName, AbstractFileLineIterator_Stub47.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");
            fail("FileLineExceptionX[܂łB");
        } catch (FileLineException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF

            assertEquals(2, VMOUTUtil.getCallCount(Class.class, "newInstance"));
            assertEquals(2, VMOUTUtil.getCallCount(Map.class, "containsKey"));
            assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
            assertEquals(0, VMOUTUtil.getCallCount(Map.class, "get"));
            StringConverter[] stringConverters = (StringConverter[]) UTUtil
                    .getPrivateField(fileLineIterator, "stringConverters");
            assertNull(stringConverters);

            Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                    .getPrivateField(fileLineIterator.getClass(),
                            "stringConverterCacheMap");
            assertEquals(1, stringConverterCacheMap.size());
            Object cacheMap01 = stringConverterCacheMap
                    .get(NullStringConverter.class);
            assertSame(NullStringConverter.class, cacheMap01.getClass());

            assertEquals(FileLineException.class, e.getClass());
            assertEquals("Failed in an instantiate of a stringConverter.", e
                    .getMessage());
            assertEquals(IllegalAccessException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
            assertEquals(-1, e.getLineNo());
            assertEquals("column2", e.getColumnName());
            assertEquals(1, e.getColumnIndex());
        }
    }

    /**
     * testBuildStringConverter10() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > stringConverterF<br>
     *                        StringConverterToUpperCase.class<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > stringConverterF<br>
     *                        StringConverterToLowerCase<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        stringConverterSႤB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () this.stringConverter:null<br>
     *                        () this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E NullStringConverter.class<br>
     *                        =NullStringConverterCX^X<br>
     *                        E StringConverterToUpperCase.class<br>
     *                        =StringConverterToUpperCaseCX^X<br>
     *                        E StringConverterToLowerCase.class<br>
     *                        =StringConverterToLowerCaseCX^X<br>
     *                        () this.currentLineCount:0<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.newInstance():Ă΂Ȃ<br>
     *                        (ԕω) Map.containsKey(Object):3Ă΂<br>
     *                        (ԕω) Map.put(K, V):Ă΂Ȃ<br>
     *                        (ԕω) Map.get(Object):3Ă΂<br>
     *                        (ԕω) this.stringConverters:ȉ̗vfStringConverterzCX^X<br>
     *                        E[0]FNullStringConverterCX^X<br>
     *                        E[1]FStringConverterToLowerCaseCX^X<br>
     *                        E[2]FStringConverterToUpperCaseCX^X<br>
     * <br>
     *                        i[ĂCX^Xthis.stringConverterCacheMapɊi[Ă铯^̃CX^XƓ́B<br>
     *                        (ԕω) this.stringConverterCacheMap:ȉ̗vfHashMap<Class, StringConverter>CX^X<br>
     *                        E NullStringConverter.class<br>
     *                        =NullStringConverterCX^X<br>
     *                        E StringConverterToUpperCase.class<br>
     *                        =StringConverterToUpperCaseCX^X<br>
     *                        E StringConverterToLowerCase.class<br>
     *                        =StringConverterToLowerCaseCX^X<br>
     * <br>
     *                        B<br>
     *                        StatictB[hthis.stringConverterCacheMapɃLbVꍇAStringConverter̃CX^XȂŃLbV𗘗p邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildStringConverter10() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub48> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub48>(
                fileName, AbstractFileLineIterator_Stub48.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Map<Class, StringConverter> cache_stringConverterCacheMap = new HashMap<Class, StringConverter>();
        StringConverter cache01 = new NullStringConverter();
        StringConverter cache02 = new StringConverterToLowerCase();
        StringConverter cache03 = new StringConverterToUpperCase();
        cache_stringConverterCacheMap.put(NullStringConverter.class, cache01);
        cache_stringConverterCacheMap.put(StringConverterToLowerCase.class,
                cache02);
        cache_stringConverterCacheMap.put(StringConverterToUpperCase.class,
                cache03);
        UTUtil.setPrivateField(fileLineIterator, "stringConverterCacheMap",
                cache_stringConverterCacheMap);

        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^Xłłɐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildStringConverters");
        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "newInstance"));
        assertEquals(3, VMOUTUtil.getCallCount(Map.class, "containsKey"));
        assertEquals(0, VMOUTUtil.getCallCount(Map.class, "put"));
        assertEquals(3, VMOUTUtil.getCallCount(Map.class, "get"));
        StringConverter[] stringConverters = (StringConverter[]) UTUtil
                .getPrivateField(fileLineIterator, "stringConverters");
        assertEquals(3, stringConverters.length);
        assertSame(cache01, stringConverters[0]);
        assertSame(cache02, stringConverters[1]);
        assertSame(cache03, stringConverters[2]);

        Map<Class, StringConverter> stringConverterCacheMap = (Map<Class, StringConverter>) UTUtil
                .getPrivateField(fileLineIterator.getClass(),
                        "stringConverterCacheMap");
        assertEquals(3, stringConverterCacheMap.size());
        assertSame(cache01, stringConverterCacheMap
                .get(NullStringConverter.class));
        assertSame(cache02, stringConverterCacheMap
                .get(StringConverterToLowerCase.class));
        assertSame(cache03, stringConverterCacheMap
                .get(StringConverterToUpperCase.class));
    }

    /**
     * testBuildMethods01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * EtB[hĂȂB<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     * ҒlF(ԕω) Class.getMethod(String):Ă΂Ȃ<br>
     * (ԕω) this.methods:vfȂMethodzCX^X<br>
     * <br>
     * B<br>
     * tB[hclazztB[hĂȂꍇAthis.methodsɃ\bh񂪐ȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildMethods01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildMethods");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "getMethod"));
        Method[] methods = (Method[]) UTUtil.getPrivateField(fileLineIterator,
                "methods");
        assertEquals(0, methods.length);
    }

    /**
     * testBuildMethods02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn1<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     * ҒlF(ԕω) Class.getMethod(String):Ă΂Ȃ<br>
     * (ԕω) this.methods:vfȂMethodzCX^X<br>
     * <br>
     * B<br>
     * tB[hclazz@InputFileColumnݒȂ̃tB[hiPĵݎꍇAthis.methodsɃ\bh񂪐ȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildMethods02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub50> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub50>(
                fileName, AbstractFileLineIterator_Stub50.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildMethods");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "getMethod"));
        Method[] methods = (Method[]) UTUtil.getPrivateField(fileLineIterator,
                "methods");
        assertEquals(0, methods.length);
    }

    /**
     * testBuildMethods03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        EtB[hɑ΂Zb^\bh݂B<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.getMethod(String):1Ă΂<br>
     *                        (ԕω) this.methods:ȉ̗vfMethodzCX^X<br>
     *                        E[0]FsetColumn1(String)̃\bhCX^X<br>
     * <br>
     *                        \bhƈ̌^mF|Cg<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hiPĵݎÃtB[hɑ΂Zb^\bh݂ꍇAthis.methodsɂ̃tB[hɑ΂Zb^
     *                         \ b h             m F   B <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildMethods03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub51> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub51>(
                fileName, AbstractFileLineIterator_Stub51.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildMethods");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(Class.class, "getMethod"));
        Method[] methods = (Method[]) UTUtil.getPrivateField(fileLineIterator,
                "methods");
        assertEquals(1, methods.length);
        assertEquals("setColumn1", methods[0].getName());
        Class[] method01_param = methods[0].getParameterTypes();
        assertEquals(1, method01_param.length);
        assertSame(String.class, method01_param[0]);
    }

    /**
     * testBuildMethods04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        EtB[hɑ΂Zb^\bh݂ȂB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.getMethod(String):1Ă΂<br>
     *                        (ԕω) this.methods:null<br>
     *                        (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     *                        EbZ[WF"The setter method of column doesn't exist."<br>
     *                        EOFNoSuchMethodException<br>
     *                        Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     *                        OB<br>
     *                        tB[hclazz@InputFileColumnݒ肠̃tB[hÃtB[hɑ΂Zb^\bhȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildMethods04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub52> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub52>(
                fileName, AbstractFileLineIterator_Stub52.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildMethods");
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(Class.class, "getMethod"));
            Method[] methods = (Method[]) UTUtil.getPrivateField(
                    fileLineIterator, "methods");
            assertNull(methods);

            assertSame(FileException.class, e.getClass());
            assertEquals("The setter method of column doesn't exist.", e
                    .getMessage());
            assertSame(NoSuchMethodException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());
        }
    }

    /**
     * testBuildMethods05() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒȂ̃tB[h<br>
     * - tB[hFString noMappingColumn3<br>
     * - tB[hFString noMappingColumn1<br>
     * - tB[hFString noMappingColumn2<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_bulidFields01.txt"<br>
     * () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     * ҒlF(ԕω) Class.getMethod(String):Ă΂Ȃ<br>
     * (ԕω) this.methods:vfȂMethodzCX^X<br>
     * <br>
     * B<br>
     * tB[hclazz@InputFileColumnݒȂ̃tB[hiRĵݎꍇAthis.methodsɃ\bh񂪐ȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildMethods05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub53> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub53>(
                fileName, AbstractFileLineIterator_Stub53.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildMethods");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(Class.class, "getMethod"));
        Method[] methods = (Method[]) UTUtil.getPrivateField(fileLineIterator,
                "methods");
        assertEquals(0, methods.length);
    }

    /**
     * testBuildMethods06() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - SځFftHgl<br>
     * E@InputFileColumnݒ肠EȂ̃tB[h<br>
     * - tB[hFString column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFString noMappingColumn1<br>
     *                        - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.getMethod(String):2Ă΂<br>
     *                        (ԕω) this.methods:ȉ̗vfMethodzCX^X<br>
     *                        E[0]FsetColumn1(String)̃\bhCX^X<br>
     *                        E[1]FsetColumn2(String)̃\bhCX^X<br>
     * <br>
     *                        \bhƈ̌^mF|Cg<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒ肠EȂ̃tB[hi
     *                        Rj𗼕A@ݒ肠tB[h̃Zb^\bh݂ꍇAthis.methodsɁݒ肠tB[hɑ΂郁\bĥݐ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildMethods06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub54> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub54>(
                fileName, AbstractFileLineIterator_Stub54.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildMethods");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(2, VMOUTUtil.getCallCount(Class.class, "getMethod"));
        Method[] methods = (Method[]) UTUtil.getPrivateField(fileLineIterator,
                "methods");
        assertEquals(2, methods.length);
        assertEquals("setColumn1", methods[0].getName());
        Class[] method01_param = methods[0].getParameterTypes();
        assertEquals(1, method01_param.length);
        assertSame(String.class, method01_param[0]);
        assertEquals("setColumn2", methods[1].getName());
        Class[] method02_param = methods[1].getParameterTypes();
        assertEquals(1, method01_param.length);
        assertSame(String.class, method02_param[0]);
    }

    /**
     * testBuildMethods07() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.clazz:ȉ̐ݒCX^X\Class̃CX^X<br>
     * E@FileFormat̐ݒ<br>
     * - encloseCharF"\""<br>
     * - ̑ځFftHgl<br>
     * E@InputFileColumnݒ肠̃tB[h<br>
     * - tB[hFString column2<br>
     * @InputFileColumnݒ<br> > columnIndexF1<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFint column1<br>
     * @InputFileColumnݒ<br> > columnIndexF0<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFDate column4<br>
     * @InputFileColumnݒ<br> > columnIndexF3<br>
     *                        > columnFormatFyyyy/MM/dd<br>
     *                        > ̑ځFftHgl<br>
     *                        - tB[hFBigDecimal column3<br>
     * @InputFileColumnݒ<br> > columnIndexF2<br>
     *                        > columnFormatF###,###<br>
     *                        > ̑ځFftHgl<br>
     *                        columnIndexdȂB<br>
     *                        () this.fileName:StringCX^X<br>
     *                        "AbstractFileLineIterator_bulidFields01.txt"<br>
     *                        () #buildFields̎s:eXgO#buildFields()sB<br>
     * <br>
     *                        ҒlF(ԕω) Class.getMethod(String):4Ă΂<br>
     *                        (ԕω) this.methods:ȉ̗vfMethodzCX^X<br>
     *                        E[0]FsetColumn1(int)̃\bhCX^X<br>
     *                        E[1]FsetColumn2(String)̃\bhCX^X<br>
     *                        E[2]FsetColumn3(BigDecimal)̃\bhCX^X<br>
     *                        E[3]FsetColumn4(Date)̃\bhCX^X<br>
     * <br>
     *                        \bhƈ̌^mF|Cg<br>
     * <br>
     *                        B<br>
     *                        tB[hclazz@InputFileColumnݒȂ̃tB[hiSĵݎÃtB[hɑ΂Zb^\bh݂ꍇAthis.methodsɃtB[hɑ΂Zb^\
     *                        b h             m F   B <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildMethods07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_bulidFields01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub55> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub55>(
                fileName, AbstractFileLineIterator_Stub55.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.invokePrivate(fileLineIterator, "buildFields");
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildMethods");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(4, VMOUTUtil.getCallCount(Class.class, "getMethod"));
        Method[] methods = (Method[]) UTUtil.getPrivateField(fileLineIterator,
                "methods");
        assertEquals(4, methods.length);
        assertEquals("setColumn1", methods[0].getName());
        Class[] method01_param = methods[0].getParameterTypes();
        assertEquals(1, method01_param.length);
        assertSame(int.class, method01_param[0]);

        assertEquals("setColumn2", methods[1].getName());
        Class[] method02_param = methods[1].getParameterTypes();
        assertEquals(1, method02_param.length);
        assertSame(String.class, method02_param[0]);

        assertEquals("setColumn3", methods[2].getName());
        Class[] method03_param = methods[2].getParameterTypes();
        assertEquals(1, method03_param.length);
        assertSame(BigDecimal.class, method03_param[0]);

        assertEquals("setColumn4", methods[3].getName());
        Class[] method04_param = methods[3].getParameterTypes();
        assertEquals(1, method04_param.length);
        assertSame(Date.class, method04_param[0]);
    }

    /**
     * testBuildHeader01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildHeader01.txt"<br>
     * () this.headerLineCount:0<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.header:vfȂArrayList<String>CX^X<br>
     * () this.hasNext(j:this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.header:vfȂArrayList<String>CX^X<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * <br>
     * p^[B<br>
     * wb_Ȃꍇthis.header̂ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildHeader01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildHeader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub60> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub60>(
                fileName, AbstractFileLineIterator_Stub60.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildHeader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object header_object = UTUtil.getPrivateField(fileLineIterator,
                "header");
        assertEquals(ArrayList.class, header_object.getClass());
        List header = (List) header_object;
        assertEquals(0, header.size());

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testBuildHeader02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildHeader01.txt"<br>
     * () this.headerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.header:vfȂArrayList<String>CX^X<br>
     * () this.hasNext(j:this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.header:ȉ̏ArrayList<String>CX^X<br>
     * E[0]F"Psڃf[^"<br>
     * (ԕω) LineReader.readLine():1Ă΂<br>
     * <br>
     * p^[B<br>
     * wb_1s̏ꍇAthis.header1s̏񂪊i[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildHeader02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildHeader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub61> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub61>(
                fileName, AbstractFileLineIterator_Stub61.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildHeader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object header_object = UTUtil.getPrivateField(fileLineIterator,
                "header");
        assertEquals(ArrayList.class, header_object.getClass());
        List header = (List) header_object;
        assertEquals(1, header.size());
        assertEquals("1sڃf[^", header.get(0));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(1, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testBuildHeader03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildHeader01.txt"<br>
     * () this.headerLineCount:3<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.header:vfȂArrayList<String>CX^X<br>
     * () this.hasNext(j:this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.header:ȉ̏ArrayList<String>CX^X<br>
     * E[0]F"Psڃf[^"<br>
     * E[1]F"Qsڃf[^"<br>
     * E[2]F"Rsڃf[^"<br>
     * (ԕω) LineReader.readLine():3Ă΂<br>
     * <br>
     * p^[B<br>
     * wb_3s̏ꍇAthis.header3s̏񂪊i[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildHeader03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildHeader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub62> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub62>(
                fileName, AbstractFileLineIterator_Stub62.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildHeader");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object header_object = UTUtil.getPrivateField(fileLineIterator,
                "header");
        assertEquals(ArrayList.class, header_object.getClass());
        List header = (List) header_object;
        assertEquals(3, header.size());
        assertEquals("1sڃf[^", header.get(0));
        assertEquals("2sڃf[^", header.get(1));
        assertEquals("3sڃf[^", header.get(2));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(3, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testBuildHeader04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildHeader02.txt"<br>
     * () this.headerLineCount:3<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * <br>
     * wb_sf[^t@C̍sȂB<br>
     * () this.header:vfȂArrayList<String>CX^X<br>
     * () this.hasNext(j:this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) LineReader.readLine():2Ă΂<br>
     * (ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"The data which can be acquired doesn't exist."<br>
     * EOFNoSuchElementException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * O<br>
     * wb_̍sΏۃf[^̍sȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildHeader04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildHeader02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub62> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub62>(
                fileName, AbstractFileLineIterator_Stub62.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildHeader");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("The data which can be acquired doesn't exist.", e
                    .getMessage());
            assertEquals(NoSuchElementException.class, e.getCause().getClass());
            assertSame(fileName, e.getFileName());

            Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                    "lineReader");
            assertEquals(2, VMOUTUtil.getCallCount(lineReader.getClass(),
                    "readLine"));
        }
    }

    /**
     * testBuildHeader05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildHeader01.txt"<br>
     * () this.headerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.header:vfȂArrayList<String>CX^X<br>
     * () this.hasNext(j:this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():FileExceptionB<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Error occurred by reading processing of a File."<br>
     * EOFFileException(LineReader.readLine()̌ʃCX^X)<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * O<br>
     * wb_̍sf[^擾FileExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildHeader05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildHeader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub61> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub61>(
                fileName, AbstractFileLineIterator_Stub61.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        FileException exception = new FileException("readLine̗Oł");
        VMOUTUtil.setReturnValueAtAllTimes(lineReader.getClass(), "readLine",
                exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildHeader");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("Error occurred by reading processing of a File.", e
                    .getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testBuildHeader06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildHeader01.txt"<br>
     * () this.headerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.header:vfȂArrayList<String>CX^X<br>
     * () this.hasNext(j:FileExceptionB<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) O:this.hasNext(jŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     * O<br>
     * Ώۃt@C̏ΏۍsmF`FbNŃG[ꍇA̗Ô܂ܕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildHeader06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildHeader01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub61> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub61>(
                fileName, AbstractFileLineIterator_Stub61.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        FileException exception = new FileException("readLine̗Oł");
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "hasNext", exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildHeader");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(exception, e);
        }
    }

    /**
     * testBuildTrailerQueue01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer01.txt"<br>
     * () this.trailerLineCount:0<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:null<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.trailerQueue:null<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * <br>
     * p^[BigC0sj<br>
     * gCȂꍇAgCL[ȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildTrailerQueue01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub70> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub70>(
                fileName, AbstractFileLineIterator_Stub70.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildTrailerQueue");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertNull(trailerQueue_object);

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testBuildTrailerQueue02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer01.txt"<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:null<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.trailerQueue:ȉ̗vfArrayBlockingQueue<String>CX^X<br>
     * E"Rsڃf[^"<br>
     * (ԕω) LineReader.readLine():1Ă΂<br>
     * <br>
     * p^[BigC1sj<br>
     * gC1sꍇAgCL[A̒Ƀf[^1sf[^i[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildTrailerQueue02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub71> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub71>(
                fileName, AbstractFileLineIterator_Stub71.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildTrailerQueue");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertEquals(ArrayBlockingQueue.class, trailerQueue_object.getClass());
        ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
        assertEquals(1, trailerQueue.size());
        assertEquals("3sڃf[^", trailerQueue.poll());

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(1, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testBuildTrailerQueue03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer01.txt"<br>
     * () this.trailerLineCount:3<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:null<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.trailerQueue:ȉ̗vfArrayBlockingQueue<String>CX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * (ԕω) LineReader.readLine():3Ă΂<br>
     * <br>
     * p^[BigC3sj<br>
     * gC3sꍇAgCL[A̒Ƀf[^3sf[^i[Ă邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildTrailerQueue03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub72> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub72>(
                fileName, AbstractFileLineIterator_Stub72.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        UTUtil.invokePrivate(fileLineIterator, "buildTrailerQueue");

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertEquals(ArrayBlockingQueue.class, trailerQueue_object.getClass());
        ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
        assertEquals(3, trailerQueue.size());
        assertEquals("3sڃf[^", trailerQueue.poll());
        assertEquals("4sڃf[^", trailerQueue.poll());
        assertEquals("5sڃf[^", trailerQueue.poll());

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(3, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testBuildTrailerQueue04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer01.txt"<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:null<br>
     * () this.hasNext():FileExceptionOB<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.trailerQueue:vfȂArrayBlockingQueue<String>CX^X<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * (ԕω) O:this.hasNext(jŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     * OBigC1sj<br>
     * ̏Ώۍsɑ΂鑶݃`FbNŃG[ꍇA̗Ô܂ܕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testBuildTrailerQueue04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub71> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub71>(
                fileName, AbstractFileLineIterator_Stub71.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς
        FileException exception = new FileException("hasNextł̃G[ł");
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "hasNext", exception);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildTrailerQueue");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            Object trailerQueue_object = UTUtil.getPrivateField(
                    fileLineIterator, "trailerQueue");
            assertEquals(ArrayBlockingQueue.class, trailerQueue_object
                    .getClass());
            ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
            assertEquals(0, trailerQueue.size());

            Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                    "lineReader");
            assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                    "readLine"));

            assertSame(exception, e);
        }
    }

    /**
     * testBuildTrailerQueue05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer01.txt"<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:null<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():FileExceptionOB<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Error occurred by reading processing of a File."<br>
     * EOFFileException(LineReader.readLine()̌ʃCX^X)<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OBigC1sj<br>
     * gC̍sf[^擾FileExceptionꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildTrailerQueue05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub71> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub71>(
                fileName, AbstractFileLineIterator_Stub71.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς
        FileException exception = new FileException("readLineł̃G[ł");
        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        VMOUTUtil.setReturnValueAtAllTimes(lineReader.getClass(), "readLine",
                exception);

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildTrailerQueue");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("Error occurred by reading processing of a File.", e
                    .getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testBuildTrailerQueue06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_buildTrailerQueue02.txt"<br>
     * () this.trailerLineCount:3<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * <br>
     * gCsf[^t@C̍sȂB<br>
     * () this.trailerQueue:null<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"The data which can be acquired doesn't exist."<br>
     * EOFNoSuchElementException<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * gC̍sΏۃf[^̍sȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testBuildTrailerQueue06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_buildTrailerQueue02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub72> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub72>(
                fileName, AbstractFileLineIterator_Stub72.class,
                columnParserMap);
        UTUtil.invokePrivate(fileLineIterator, "buildLineReader");

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            UTUtil.invokePrivate(fileLineIterator, "buildTrailerQueue");
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("The data which can be acquired doesn't exist.", e
                    .getMessage());
            assertEquals(NoSuchElementException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testCloseFile01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_closeFile01.txt"<br>
     * () this.reader:ReaderCX^X<br>
     * () Reader.close():I<br>
     * <br>
     * ҒlF(ԕω) reader.close():Ă΂<br>
     * <br>
     * <br>
     * N[Ys邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCloseFile01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_closeFile01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);
        fileLineIterator.init();

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.closeFile();

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(BufferedReader.class, "close"));
    }

    /**
     * testCloseFile02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_closeFile01.txt"<br>
     * () this.reader:ReaderCX^X<br>
     * () Reader.close():IOExceptionO<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Processing of reader was failed."<br>
     * EOFIOException(Reader.close()̂)<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * O<br>
     * N[XIOExceptionꍇAFileException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testCloseFile02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_closeFile01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);
        fileLineIterator.init();

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // eXgΏۂ̃CX^XŐݒς
        IOException exception = new IOException();
        VMOUTUtil.setExceptionAtAllTimes(BufferedReader.class, "close",
                exception);

        // eXg{
        try {
            fileLineIterator.closeFile();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("Processing of reader was failed.", e.getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testGetHeader01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.header:ȉ̏ArrayList<String>CX^X<br>
     * PD"wb_s1"<br>
     * QD"wb_s2"<br>
     * RD"wb_s3"<br>
     * <br>
     * ҒlF(߂l) List<String>:ȉ̏ArrayList<String>CX^X<br>
     * PD"wb_s1"<br>
     * QD"wb_s2"<br>
     * RD"wb_s3"<br>
     * <br>
     * p^[B<br>
     * wb_̏񂪐擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetHeader01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub07>(
                fileName, AbstractFileLineIterator_Stub07.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        List<String> header = new ArrayList<String>();
        header.add("wb_s1");
        header.add("wb_s2");
        header.add("wb_s3");
        UTUtil.setPrivateField(fileLineIterator, "header", header);

        // eXg{
        List result = fileLineIterator.getHeader();

        // ԋpl̊mF
        assertEquals(ArrayList.class, result.getClass());
        assertEquals("wb_s1", result.get(0));
        assertEquals("wb_s2", result.get(1));
        assertEquals("wb_s3", result.get(2));

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetTrailer01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer01.txt"<br>
     * () this.readTrailer:false<br>
     * () this.trailerLineCount:0<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:vfȂQueue<String>CX^X<br>
     * () this.trailer:vfȂArrayList<String>CX^X<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) List<String>:vfȂArrayList<String>CX^X<br>
     * <br>
     * this.trailerƓCX^X<br>
     * (ԕω) this.trailer:vfȂArrayList<String>CX^X<br>
     * (ԕω) this.readTrailer:true<br>
     * (ԕω) LineReader.readLine():3Ă΂<br>
     * <br>
     * p^[BigC0sj<br>
     * gCȂꍇ͌ʂ̂ƂmFB<br>
     * ܂Af[^s̏񂪑S΂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailer01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        List<String> result = fileLineIterator.getTrailer();

        // ԋpl̊mF
        assertSame(ArrayList.class, result.getClass());
        assertEquals(0, result.size());

        // ԕω̊mF
        Object trailer_object = UTUtil.getPrivateField(fileLineIterator,
                "trailer");
        assertSame(ArrayList.class, trailer_object.getClass());
        assertEquals(0, ((List) trailer_object).size());
        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "readTrailer"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(3, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testGetTrailer02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer02.txt"<br>
     * () this.readTrailer:false<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Qsڃf[^"<br>
     * () this.trailer:vfȂArrayList<String>CX^X<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) List<String>:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * <br>
     * this.trailerƓCX^X<br>
     * (ԕω) this.trailer:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * (ԕω) this.readTrailer:true<br>
     * (ԕω) LineReader.readLine():3Ă΂<br>
     * <br>
     * p^[BigC1sj<br>
     * f[^sSǂłȂꍇ(s)ɃgC擾ꍇAthis.trailer񂪕Ԃ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailer02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        List<String> result = fileLineIterator.getTrailer();

        // ԋpl̊mF
        assertSame(ArrayList.class, result.getClass());
        assertEquals(1, result.size());
        assertEquals("5sڃf[^", result.get(0));

        // ԕω̊mF
        Object trailer_object = UTUtil.getPrivateField(fileLineIterator,
                "trailer");
        assertSame(ArrayList.class, trailer_object.getClass());
        List<String> trailer = (List<String>) trailer_object;
        assertEquals(1, trailer.size());
        assertEquals("5sڃf[^", trailer.get(0));

        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "readTrailer"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(3, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testGetTrailer03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer02.txt"<br>
     * () this.readTrailer:false<br>
     * () this.trailerLineCount:3<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * () this.trailer:vfȂArrayList<String>CX^X<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) List<String>:ȉ̗vfArrayList<String>CX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * <br>
     * this.trailerƓCX^X<br>
     * (ԕω) this.trailer:ȉ̗vfArrayList<String>CX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * (ԕω) this.readTrailer:true<br>
     * (ԕω) LineReader.readLine():1Ă΂<br>
     * <br>
     * p^[BigC3sj<br>
     * f[^sSǂłȂꍇ(s)ɃgC擾ꍇAthis.trailer񂪕Ԃ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailer03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub82> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub82>(
                fileName, AbstractFileLineIterator_Stub82.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        List<String> result = fileLineIterator.getTrailer();

        // ԋpl̊mF
        assertSame(ArrayList.class, result.getClass());
        assertEquals(3, result.size());
        assertEquals("3sڃf[^", result.get(0));
        assertEquals("4sڃf[^", result.get(1));
        assertEquals("5sڃf[^", result.get(2));

        // ԕω̊mF
        Object trailer_object = UTUtil.getPrivateField(fileLineIterator,
                "trailer");
        assertSame(ArrayList.class, trailer_object.getClass());
        List<String> trailer = (List<String>) trailer_object;
        assertEquals(3, trailer.size());
        assertEquals("3sڃf[^", trailer.get(0));
        assertEquals("4sڃf[^", trailer.get(1));
        assertEquals("5sڃf[^", trailer.get(2));

        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "readTrailer"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(1, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testGetTrailer04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer02.txt"<br>
     * () this.readTrailer:false<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Qsڃf[^"<br>
     * () this.trailer:vfȂArrayList<String>CX^X<br>
     * () this.hasNext():FileExceptionOB<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(ԕω) this.trailer:vfȂArrayList<String>CX^X<br>
     * (ԕω) this.readTrailer:false<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * (ԕω) Ȃ:this.hasNext(jŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     * OBigC1sj<br>
     * ̏Ώۍsɑ΂鑶݃`FbNŃG[ꍇA̗Ô܂ܕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailer04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        FileException exception = new FileException("hasNextł̃G[ł");
        VMOUTUtil.setReturnValueAtAllTimes(AbstractFileLineIterator.class,
                "hasNext", exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            fileLineIterator.getTrailer();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            Object trailer_object = UTUtil.getPrivateField(fileLineIterator,
                    "trailer");
            assertSame(ArrayList.class, trailer_object.getClass());
            List<String> trailer = (List<String>) trailer_object;
            assertEquals(0, trailer.size());

            assertFalse((Boolean) UTUtil.getPrivateField(fileLineIterator,
                    "readTrailer"));

            Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                    "lineReader");
            assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                    "readLine"));

            assertSame(exception, e);
        }
    }

    /**
     * testGetTrailer05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer02.txt"<br>
     * () this.readTrailer:true<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȂLineReaderCX^X<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * () this.trailer:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) List<String>:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * <br>
     * this.trailerƓCX^X<br>
     * (ԕω) this.trailer:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * (ԕω) this.readTrailer:true<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * <br>
     * p^[BigC1sj<br>
     * gCɐĂꍇALbVĂgĈ܂ܕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailer05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        fileLineIterator.getTrailer();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        List<String> result = fileLineIterator.getTrailer();

        // ԋpl̊mF
        assertSame(ArrayList.class, result.getClass());
        assertEquals(1, result.size());
        assertEquals("5sڃf[^", result.get(0));

        // ԕω̊mF
        Object trailer_object = UTUtil.getPrivateField(fileLineIterator,
                "trailer");
        assertSame(ArrayList.class, trailer_object.getClass());
        List<String> trailer = (List<String>) trailer_object;
        assertEquals(1, trailer.size());
        assertEquals("5sڃf[^", trailer.get(0));

        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "readTrailer"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testGetTrailer06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer03.txt"<br>
     * () this.readTrailer:false<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȂLineReaderCX^X<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * () this.trailer:vfȂArrayList<String>CX^X<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) List<String>:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * <br>
     * this.trailerƓCX^X<br>
     * (ԕω) this.trailer:ȉ̗vfArrayList<String>CX^X<br>
     * E"Tsڃf[^"<br>
     * (ԕω) this.readTrailer:true<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * <br>
     * p^[BigC1sj<br>
     * f[^sSǂ񂾌ɃgC擾ꍇAthis.trailer񂪕Ԃ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailer06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        List<String> result = fileLineIterator.getTrailer();

        // ԋpl̊mF
        assertSame(ArrayList.class, result.getClass());
        assertEquals(1, result.size());
        assertEquals("5sڃf[^", result.get(0));

        // ԕω̊mF
        Object trailer_object = UTUtil.getPrivateField(fileLineIterator,
                "trailer");
        assertSame(ArrayList.class, trailer_object.getClass());
        List<String> trailer = (List<String>) trailer_object;
        assertEquals(1, trailer.size());
        assertEquals("5sڃf[^", trailer.get(0));

        assertTrue((Boolean) UTUtil.getPrivateField(fileLineIterator,
                "readTrailer"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testGetTrailer07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_getTrailer02.txt"<br>
     * () this.readTrailer:false<br>
     * () this.trailerLineCount:1<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Qsڃf[^"<br>
     * () this.trailer:vfȂArrayList<String>CX^X<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():FileExceptionOB<br>
     * <br>
     * ҒlF(ԕω) Ȃ:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Processing of lineReader was failed."<br>
     * EOFLineReader.readLine()ŃX[ꂽO<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OBigC1sj<br>
     * ̏Ώۍsɑ΂鑶݃`FbNŃG[ꍇA̗Ô܂ܕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetTrailer07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_getTrailer02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        FileException exception = new FileException("readLineł̃G[ł");
        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        VMOUTUtil.setReturnValueAtAllTimes(lineReader.getClass(), "readLine",
                exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            fileLineIterator.getTrailer();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("Processing of lineReader was failed.", e.getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testReadLine01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_skip01.txt"<br>
     * () this.trailerQueue:null<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * E"Usڃf[^"<br>
     * E"Vsڃf[^"<br>
     * () this.trailerLineCount:0<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) String:"Psڃf[^"<br>
     * (ԕω) this.trailerQueue:null<br>
     * (ԕω) LineReader.readLine():1Ă΂<br>
     * <br>
     * p^[<br>
     * (gCȂ)B<br>
     * gCȂꍇAf[^̃f[^1sԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        String result = fileLineIterator.readLine();

        // ԋpl̊mF
        assertEquals("1sڃf[^", result);

        // ԕω̊mF
        assertNull(UTUtil.getPrivateField(fileLineIterator, "trailerQueue"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(1, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testReadLine02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_readLine02.txt"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Rsڃf[^"<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * E"Usڃf[^"<br>
     * E"Vsڃf[^"<br>
     * () this.trailerLineCount:1<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) String:"Rsڃf[^"<br>
     * (ԕω) this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Ssڃf[^"<br>
     * (ԕω) Queue#add():1Ă΂<br>
     * (ԕω) LineReader.readLine():1Ă΂<br>
     * <br>
     * p^[<br>
     * (gC1sAQڈȌ̎s)B<br>
     * gCLf[^ɑ΂readLine()1ȏsreadLine()sꍇAgCL[̓eXVL[̍ŏ̃f[^f[^̃f[^ƂĕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadLine02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_readLine02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        String result = fileLineIterator.readLine();

        // ԋpl̊mF
        assertEquals("3sڃf[^", result);

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertEquals(ArrayBlockingQueue.class, trailerQueue_object.getClass());
        ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
        assertEquals(1, trailerQueue.size());
        assertEquals("4sڃf[^", trailerQueue.poll());

        assertEquals(1, VMOUTUtil.getCallCount(Queue.class, "add"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(1, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testReadLine03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_readLine02.txt"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Usڃf[^"<br>
     * E"Vsڃf[^"<br>
     * () this.trailerLineCount:3<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) String:"Rsڃf[^"<br>
     * (ԕω) this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * E"Usڃf[^"<br>
     * (ԕω) Queue#add():1Ă΂<br>
     * (ԕω) LineReader.readLine():1Ă΂<br>
     * <br>
     * p^[<br>
     * (gCsAQڈȌ̎s)B<br>
     * gCLf[^ɑ΂readLine()1ȏsreadLine()sꍇAgCL[̓eXVL[̍ŏ̃f[^f[^̃f[^ƂĕԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadLine03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_readLine02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub82> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub82>(
                fileName, AbstractFileLineIterator_Stub82.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        String result = fileLineIterator.readLine();

        // ԋpl̊mF
        assertEquals("3sڃf[^", result);

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertEquals(ArrayBlockingQueue.class, trailerQueue_object.getClass());
        ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
        assertEquals(3, trailerQueue.size());
        assertEquals("4sڃf[^", trailerQueue.poll());
        assertEquals("5sڃf[^", trailerQueue.poll());
        assertEquals("6sڃf[^", trailerQueue.poll());

        assertEquals(1, VMOUTUtil.getCallCount(Queue.class, "add"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(1, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testReadLine04() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_readLine03.txt"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Vsڃf[^"<br>
     * () this.lineReader:ȂLineReaderCX^X<br>
     * () this.trailerLineCount:1<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`  false<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * (ԕω) this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"Vsڃf[^"<br>
     * (ԕω) Queue#add():Ă΂Ȃ<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * <br>
     * f[^Sǂ񂾌readLine()sꍇAnullԂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadLine04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_readLine03.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub81>(
                fileName, AbstractFileLineIterator_Stub81.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        String result = fileLineIterator.readLine();

        // ԋpl̊mF
        assertNull(result);

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertEquals(ArrayBlockingQueue.class, trailerQueue_object.getClass());
        ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
        assertEquals(1, trailerQueue.size());
        assertEquals("7sڃf[^", trailerQueue.poll());

        assertEquals(0, VMOUTUtil.getCallCount(Queue.class, "add"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testReadLine05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE,F <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_skip01.txt"<br>
     * () this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"4sڃf[^"<br>
     * E"5sڃf[^"<br>
     * E"6sڃf[^"<br>
     * E"7sڃf[^"<br>
     * () this.lineReader:ȂLineReaderCX^X<br>
     * () this.trailerLineCount:3<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * <br>
     * ҒlF(߂l) String:null<br>
     * (ԕω) this.trailerQueue:ȉ̗vfQueue<String>CX^X<br>
     * E"4sڃf[^"<br>
     * E"5sڃf[^"<br>
     * E"6sڃf[^"<br>
     * E"7sڃf[^"<br>
     * (ԕω) Queue#add():Ă΂Ȃ<br>
     * (ԕω) LineReader.readLine():Ă΂Ȃ<br>
     * <br>
     * p^[B<br>
     * wb_AgC͗L邪f[^Ȃf[^ɑ΂readLine()sꍇAnullԂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testReadLine05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub83> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub83>(
                fileName, AbstractFileLineIterator_Stub83.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        VMOUTUtil.initialize();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        String result = fileLineIterator.readLine();

        // ԋpl̊mF
        assertNull(result);

        // ԕω̊mF
        Object trailerQueue_object = UTUtil.getPrivateField(fileLineIterator,
                "trailerQueue");
        assertEquals(ArrayBlockingQueue.class, trailerQueue_object.getClass());
        ArrayBlockingQueue trailerQueue = (ArrayBlockingQueue) trailerQueue_object;
        assertEquals(4, trailerQueue.size());
        assertEquals("4sڃf[^", trailerQueue.poll());
        assertEquals("5sڃf[^", trailerQueue.poll());
        assertEquals("6sڃf[^", trailerQueue.poll());
        assertEquals("7sڃf[^", trailerQueue.poll());

        assertEquals(0, VMOUTUtil.getCallCount(Queue.class, "add"));

        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        assertEquals(0, VMOUTUtil.getCallCount(lineReader.getClass(),
                "readLine"));
    }

    /**
     * testReadLine06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:StringCX^X<br>
     * "AbstractFileLineIterator_skip01.txt"<br>
     * () this.trailerQueue:null<br>
     * () this.lineReader:ȉ̏LineReaderCX^X<br>
     * E"Psڃf[^"<br>
     * E"Qsڃf[^"<br>
     * E"Rsڃf[^"<br>
     * E"Ssڃf[^"<br>
     * E"Tsڃf[^"<br>
     * E"Usڃf[^"<br>
     * E"Vsڃf[^"<br>
     * () this.trailerLineCount:0<br>
     * () this.hasNext():this.lineReader̒`ɏ]<br>
     * <br>
     * Ă΂^C~Oɂ킹Ē`<br>
     * () LineReader.readLine():FileExceptionOB<br>
     * <br>
     * ҒlF(ԕω) O:ȉ̏FileException邱ƂmFB<br>
     * EbZ[WF"Processing of lineReader was failed."<br>
     * EOFLineReader.readLine()ŃX[ꂽO<br>
     * Et@CFtB[hfileNameƓCX^XB<br>
     * <br>
     * OB<br>
     * LineReaderOꍇA̗OFileExceptionɃbvăX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testReadLine06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        fileLineIterator.init();
        Object lineReader = UTUtil.getPrivateField(fileLineIterator,
                "lineReader");
        FileException exception = new FileException("readLine̗Oł");
        VMOUTUtil.setExceptionAtAllTimes(lineReader.getClass(), "readLine",
                exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            fileLineIterator.readLine();
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(FileException.class, e.getClass());
            assertEquals("Processing of lineReader was failed.", e.getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testSkipint01() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() skipLines:0<br>
     * () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:Ă΂Ȃ<br>
     * (ԕω) this.currentLineCount:0<br>
     * <br>
     * p^[B<br>
     * SkipΏۍsȂꍇÂ܂ܐI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 0;

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.skip(skipLines);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(0, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testSkipint02() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() skipLines:1<br>
     * () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:1Ă΂<br>
     * (ԕω) this.currentLineCount:1<br>
     * <br>
     * p^[B<br>
     * SkipΏۍsPs̏ꍇAΏۃf[^PsǂނƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 1;

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.skip(skipLines);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(1, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testSkipint03() <br>
     * <br>
     * (n) <br>
     * ϓ_FD,E,F <br>
     * <br>
     * ͒lF() skipLines:3<br>
     * () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.readLine():s<br>
     * <br>
     * ҒlF(ԕω) this.readLine:3Ă΂<br>
     * () this.currentLineCount:3<br>
     * <br>
     * p^[B<br>
     * SkipΏۍsRs̏ꍇAΏۃf[^RsǂނƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 3;

        // O̐ݒ
        fileLineIterator.init();
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        fileLineIterator.skip(skipLines);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(3, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "readLine"));
        assertEquals(3, UTUtil.getPrivateField(fileLineIterator,
                "currentLineCount"));
    }

    /**
     * testSkipint04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() skipLines:1<br>
     * () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.readLine():FileExceptionO𔭐B<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.currentLineCount:0<br>
     * (ԕω) Ȃ:this.readLine()ŔFileException̂܂܃X[邱ƂmFB<br>
     * <br>
     * OB<br>
     * Ώۃf[^ǂޏŗOꍇA̗Ô܂ܕԂ邱ƂmFBB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 1;

        // O̐ݒ
        fileLineIterator.init();
        FileException exception = new FileException("readLine̗Oł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineIterator.class,
                "readLine", exception);
        // eXgΏۂ̃CX^XŐݒς

        // eXg{
        try {
            fileLineIterator.skip(skipLines);
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // O̊mF
            assertSame(exception, e);

            // ԕω̊mF
            assertEquals(0, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));
        }
    }

    /**
     * testSkipint05() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() skipLines:100<br>
     * <br>
     * Ώۃt@C̍s𒴂ݒ<br>
     * () AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.readLine():s<br>
     * () this.currentLineCount:0<br>
     * <br>
     * ҒlF(ԕω) this.readLine:7Ă΂<br>
     * (ԕω) this.currentLineCount:7<br>
     * t@C̃f[^s<br>
     * (ԕω) Ȃ:ȉ̐ݒFileLineExceptionB<br>
     * EbZ[WF"The data which can be acquired doesn't exist."<br>
     * EOFNoSuchElementException<br>
     * Et@CFΏۃt@C<br>
     * EsԍF8<br>
     * <br>
     * OB<br>
     * SkipΏۍs̐Ώۃf[^̐zꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSkipint05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 0);

        // ̐ݒ
        int skipLines = 100;

        // O̐ݒ
        fileLineIterator.init();

        // eXg{
        try {
            fileLineIterator.skip(skipLines);
            fail("FileLineExceptionX[܂ł");
        } catch (FileLineException e) {
            // O̊mF
            assertEquals("The data which can be acquired doesn't exist.", e
                    .getMessage());
            assertTrue(NoSuchElementException.class.isAssignableFrom(e
                    .getCause().getClass()));
            assertEquals(fileName, e.getFileName());
            assertEquals(8, e.getLineNo());

            // ԕω̊mF
            assertEquals(7, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "readLine"));

            assertEquals(7, UTUtil.getPrivateField(fileLineIterator,
                    "currentLineCount"));
        }
    }

    /**
     * testGetLineFeedChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.lineFeedChar:"\r"<br>
     * <br>
     * ҒlF(߂l) this.lineFeedChar:"\r"<br>
     * <br>
     * lineFeedChargetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetLineFeedChar01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // OlineFeedChar"\r"ݒς

        // eXg{
        String result = fileLineIterator.getLineFeedChar();

        // ԋpl̊mF
        assertEquals("\r", result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetFileEncoding01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileEncoding:not null<br>
     * <br>
     * ҒlF(߂l) this.fileEncoding:not null<br>
     * <br>
     * fileEncodinggetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetFileEncoding01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // OfileEncoding"MS932"ݒς

        // eXg{
        String result = fileLineIterator.getFileEncoding();

        // ԋpl̊mF
        assertEquals("MS932", result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetHeaderLineCount01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.headerLineCount:not null<br>
     * <br>
     * ҒlF(߂l) this.headerLineCount:not null<br>
     * <br>
     * headerLineCountgetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetHeaderLineCount01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // OheaderLineCount1ݒς

        // eXg{
        int result = fileLineIterator.getHeaderLineCount();

        // ԋpl̊mF
        assertEquals(1, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetTrailerLineCount01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.trailerLineCount:100<br>
     * <br>
     * ҒlF(߂l) this.trailerLineCount:100<br>
     * <br>
     * trailerLineCountgetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetTrailerLineCount01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // OtrailerLineCount1ݒς

        // eXg{
        int result = fileLineIterator.getTrailerLineCount();

        // ԋpl̊mF
        assertEquals(1, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetCurrentLineCount01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.currentLineCount:100<br>
     * <br>
     * ҒlF(߂l) this.currentLineCount:100<br>
     * <br>
     * currentLineCountgetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetCurrentLineCount01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        UTUtil.setPrivateField(fileLineIterator, "currentLineCount", 1);

        // eXg{
        int result = fileLineIterator.getCurrentLineCount();

        // ԋpl̊mF
        assertEquals(1, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetFields01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fields:not null<br>
     * <br>
     * ҒlF(߂l) this.fields:not null<br>
     * <br>
     * fieldsgetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetFields01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        Field[] fields = new Field[] {};
        UTUtil.setPrivateField(fileLineIterator, "fields", fields);

        // eXg{
        Field[] result = fileLineIterator.getFields();

        // ԋpl̊mF
        assertSame(fields, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testGetFileName01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF() AbstractFileLineIteratorNX:AbstractFileLineIteratorImpl02<br>
     * @<br>
     * () this.fileName:not null<br>
     * <br>
     * ҒlF(߂l) this.fileName:not null<br>
     * <br>
     * fileNamegetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testGetFileName01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "AbstractFileLineIterator_skip01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01> fileLineIterator = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub01>(
                fileName, AbstractFileLineIterator_Stub01.class,
                columnParserMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        String fileName_dummy = "t@C";
        UTUtil.setPrivateField(fileLineIterator, "fileName", fileName_dummy);

        // eXg{
        String result = fileLineIterator.getFileName();

        // ԋpl̊mF
        assertEquals(fileName_dummy, result);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testIsCheckByte01() <br>
     * <br>
     * (n) <br>
     * <br>
     * ͒lF() inputFileColumn:not null<br>
     * () inputFileColumn#bytes():1<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsCheckByte01() throws Exception {
        // O(Ώ)
        String fileName = this.getClass().getResource("File_Empty.txt")
                .getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIterator<FixedFileLine_Stub01> fileLineWriter = new AbstractFileLineIteratorImpl02<FixedFileLine_Stub01>(
                fileName, FixedFileLine_Stub01.class, columnParserMap);

        // O()
        Field column = FixedFileLine_Stub01.class.getDeclaredFields()[0];
        InputFileColumn inputFileColumn = column
                .getAnnotation(InputFileColumn.class);

        // eXg{
        boolean result = fileLineWriter.isCheckByte(inputFileColumn);

        // (߂l)
        assertTrue(result);
    }

    /**
     * testIsCheckByte02() <br>
     * <br>
     * (ُn) <br>
     * <br>
     * ͒lF() inputFileColumn:not null<br>
     * () inputFileColumn#bytes():-1<br>
     * <br>
     * ҒlF(߂l) boolean:false<br>
     * <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsCheckByte02() throws Exception {
        // O(Ώ)
        String fileName = this.getClass().getResource("File_Empty.txt")
                .getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        AbstractFileLineIterator<AbstractFileLineIterator_Stub80> fileLineWriter = new AbstractFileLineIteratorImpl02<AbstractFileLineIterator_Stub80>(
                fileName, AbstractFileLineIterator_Stub80.class,
                columnParserMap);

        // O()
        Field column = AbstractFileLineIterator_Stub80.class
                .getDeclaredFields()[0];
        InputFileColumn inputFileColumn = column
                .getAnnotation(InputFileColumn.class);

        // eXg{
        boolean result = fileLineWriter.isCheckByte(inputFileColumn);

        // (߂l)
        assertFalse(result);
    }

}
