/*
 * $Id: StringConverterToLowerCaseTest.java 5819 2007-12-20 05:55:47Z fukuyot $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.annotation;

import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.annotation.StringConverterToLowerCase} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Ame[VStringConverter̋Lqɏ]A̕ϊsB<br>
 * StringConverterToLowerCase͓͂ꂽiAt@xbgj SďɂĕԋpB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.annotation.StringConverterToLowerCase
 */
public class StringConverterToLowerCaseTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(StringConverterToLowerCaseTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public StringConverterToLowerCaseTest(String name) {
        super(name);
    }

    /**
     * testConvert01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() string:null<br>
     * <br>
     * ҒlF(߂l) resultString:null<br>
     * <br>
     * Nullꍇ̏B<br>
     * nullԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testConvert01() throws Exception {
        // O
        StringConverter stringTransformer = new StringConverterToLowerCase();

        // eXg{
        String resultString = stringTransformer.convert(null);

        // 
        assertNull(resultString);
    }

    /**
     * testConvert02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() string:not null<br>
     * ȉStringCX^X<br>
     * "abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ"<br>
     * <br>
     * ҒlF(߂l) resultString:ȉStringCX^X<br>
     * "abcdefghijklmnopqrstuvwxyz_abcdefghijklmnopqrstuvwxyz"<br>
     * <br>
     * ϊ{B<br>
     * ̏ꍇAϊȂ̂ŁA͂SďɕϊĕԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testConvert02() throws Exception {
        // O
        StringConverter stringTransformer = new StringConverterToLowerCase();

        // eXg{
        String resultString = stringTransformer
                .convert("abcdefghijklmnopqrstuvwxyz_ABCDEFGHIJKLMNOPQRSTUVWXYZ");

        // 
        assertEquals("abcdefghijklmnopqrstuvwxyz_abcdefghijklmnopqrstuvwxyz",
                resultString);
    }

    /**
     * testConvert03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() string:ȉStringCX^X<br>
     * "JLN"<br>
     * <br>
     * ҒlF(߂l) resultString:ȉStringCX^X<br>
     * "JLN"<br>
     * <br>
     * ϊ{B<br>
     * Ђ炪ȁAJ^JiÁÂ܂ܕϊꂸɏo͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testConvert03() throws Exception {
        // O
        StringConverter stringTransformer = new StringConverterToLowerCase();

        // eXg{
        String resultString = stringTransformer.convert("JLN");

        // 
        assertEquals("JLN", resultString);
    }

    /**
     * testConvert04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() string:not null<br>
     * ȉStringCX^X<br>
     * ""(󕶎j<br>
     * <br>
     * ҒlF(߂l) resultString:not null<br>
     * ȉStringCX^X<br>
     * ""(󕶎j<br>
     * <br>
     * ϊ{B""(󕶎j̏ꍇ́Â܂܏o͂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testConvert04() throws Exception {
        // O()
        StringConverter stringTransformer = new StringConverterToLowerCase();

        // eXg{
        String resultString = stringTransformer.convert("");

        // 
        assertEquals("", resultString);
    }

}
