/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.batch.constants.LogId;
import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.logger.TLogger;

/**
 * bZ[WǗ[eBeBB<br>
 * <br>
 * <p>
 * bZ[W̊ǗsꍇɗpB<br>
 * {NX̃NXϐɕۑMessageAccessor̓XbhO[vɃCX^XێB
 * </p>
 */
public class MessageUtil {

    /** K[. */
    private static final TLogger LOGGER = TLogger.getLogger(MessageUtil.class);

    /** XbhO[vɃbZ[W\[XANZTێ. */
    private static final ConcurrentHashMap<ThreadGroup, MessageAccessor> tgm = new ConcurrentHashMap<ThreadGroup, MessageAccessor>();

    /**
     * RXgN^.
     */
    protected MessageUtil() {
    }

    /**
     * R[hɉbZ[Wԋp<br>
     * @param errorCode R[h
     * @return R[hɉbZ[Wԋp
     */
    public static String getMessage(String code) {
        return getMessage(code, null);
    }

    /**
     * R[hɉbZ[Wԋp<br>
     * @param errorCode R[h
     * @return R[hɉbZ[Wԋp
     */
    public static String getMessage(String code, Object[] args) {
        String mes = null;
        MessageAccessor ma = null;

        ThreadGroup tg = getThreadGroup();
        if (tg != null) {
            ma = tgm.get(tg);

            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(LogId.TAL025006, getThreadMessage());
            }

        }

        if (ma != null) {
            try {
                mes = ma.getMessage(code, args);
            } catch (Throwable e) {
                // Ȃ
            }
        } else {
            LOGGER.debug(LogId.DAL025043);

        }

        // bZ[WȂꍇ
        if (mes == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Message not found. CODE:[");
            sb.append(code);
            sb.append("]");
            return sb.toString();
        }

        return mes;
    }

    /**
     * bZ[W\[XANZTݒ肷.<br>
     * <p>
     * Őݒ肷MessageAccessor̓XbhO[vɕێB
     * </p>
     * @param messageAccessor MessageAccessor
     */
    public static void setMessageAccessor(MessageAccessor messageAccessor) {
        if (messageAccessor == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(LogId.WAL025008, getThreadMessage());
            }

            return;
        }

        ThreadGroup tg = getThreadGroup();
        if (tg != null) {
            tgm.put(tg, messageAccessor);

            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(LogId.TAL025007, getThreadMessage());
            }

        }
    }

    /**
     * bZ[W\[XANZT폜.<br>
     */
    public static void removeMessageAccessor() {
        ThreadGroup tg = getThreadGroup();
        if (tg != null) {
            tgm.remove(tg);

            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(LogId.TAL025008, getThreadMessage());
            }

        }
    }

    /**
     * XbhO[v擾.
     * @return ThreadGroup
     */
    private static ThreadGroup getThreadGroup() {
        Thread ct = Thread.currentThread();
        if (ct != null && ct.getThreadGroup() != null) {
            return ct.getThreadGroup();
        }
        return null;
    }

    /**
     * XbhO[vƃXbhԂ\bh.<br>
     * fobOpbZ[WԂB
     * @return String
     */
    private static String getThreadMessage() {
        StringBuilder sb = new StringBuilder();
        Thread ct = Thread.currentThread();

        if (ct != null && getThreadGroup() != null) {
            sb.append(" tg:[");
            sb.append(getThreadGroup().getName());
            sb.append("]");
        }
        if (ct != null) {
            sb.append(" t:[");
            sb.append(ct.getName());
            sb.append("]");
        }

        return sb.toString();
    }
}
