/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.lang.reflect.Method;

import junit.framework.TestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest01 extends TestCase {

    /**
     * eXgpCX^XB
     */
    private ValidatorAction va = null;

    /**
     * eXgpCX^XB
     */
    private Field field = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest01.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        va = new ValidatorAction();
        field = new Field();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest01(String name) {
        super(name);
    }

    /**
     * testGetParamClass01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() va:not null<br>
     *         () va.methodParams:""<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:Class[]{}<br>
     *                  vf0<br>
     *
     * <br>
     * vamethodParams󕶎̂ƂA
     * vf0Class^z񂪎擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetParamClass01() throws Exception {
        // O
        va.setMethodParams("");

        // eXg{
        Class[] result = new FieldChecks().getParamClass(va);

        // 
        assertEquals(0, result.length);
    }

    /**
     * testGetParamClass02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() va:not null<br>
     *         () va.methodParams:
     *                "java.lang.String,java.lang.Integer,java.lang.Boolean"<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:{String.class,<br>
     *                   Integer.class,<br>
     *                   Boolean.class}<br>
     *
     * <br>
     * vamethodParamsɐݒ肳ĂA
     * J}؂̃NX̃NXCX^X擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetParamClass02() throws Exception {
        // O
        va.setMethodParams(
                "java.lang.String,java.lang.Integer,java.lang.Boolean");

        // eXg{
        Class[] result = new FieldChecks().getParamClass(va);

        // 
        assertEquals(3, result.length);
        assertSame(String.class, result[0]);
        assertSame(Integer.class, result[1]);
        assertSame(Boolean.class, result[2]);
    }

    /**
     * testGetParamClass03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() va:not null<br>
     *         () va.methodParams:"java.lang.String,bbb"<br>
     *
     * <br>
     * ҒlF(߂l) Class[]:null<br>
     *
     * <br>
     * vamethodParamsɃNXpXɑ݂ȂNX܂܂ĂꍇA
     * null擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetParamClass03() throws Exception {
        // O
        va.setMethodParams("java.lang.String,bbb");

        // eXg{
        // 
        assertNull(new FieldChecks().getParamClass(va));

    }

    /**
     * testGetMethod01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() va:not null<br>
     *         () va.getName:null<br>
     *
     * <br>
     * ҒlF(߂l) Method:null<br>
     *
     * <br>
     * va擾\bhnull̏ꍇAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod01() throws Exception {
        // O
        va.setName(null);

        // eXg{
        // 
        assertNull(new FieldChecks().getMethod(va, new Class[]{}));
    }

    /**
     * testGetMethod02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() va:not null<br>
     *         () va.getName:󕶎<br>
     *
     * <br>
     * ҒlF(߂l) Method:null<br>
     *
     * <br>
     * va擾\bh󕶎̏ꍇAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod02() throws Exception {
        // O
        va.setName("");

        // eXg{
        // 
        assertNull(new FieldChecks().getMethod(va, new Class[]{}));
    }

    /**
     * testGetMethod03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() va:not null<br>
     *         () paramClass:{Object.class,<br>
     *                 ValidatorAction.class,<br>
     *                 Field.class,<br>
     *                 ValidationErrors.class}<br>
     *         () va.getName:"requiredArray"<br>
     *
     * <br>
     * ҒlF(߂l) Method:new FieldChecks()#validateRequired<br>
     *
     * <br>
     * va擾\bh̍Ō5A
     * 擪validatet^\bh݂ꍇA
     * ̃\bh̃CX^X擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod03() throws Exception {
        // O
        va.setName("requiredArray");
        Class[] paramClass = {
            Object.class,
            ValidatorAction.class,
            Field.class,
            ValidationErrors.class
        };

        // eXg{
        Method result = new FieldChecks().getMethod(va,paramClass);

        // 
        assertEquals(FieldChecks.class, result.getDeclaringClass());
        assertEquals("validateRequired", result.getName());
    }

    /**
     * testGetMethod04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() va:not null<br>
     *         () paramClass:{Object.class,<br>
     *                 ValidatorAction.class,<br>
     *                 Field.class}<br>
     *         () va.getName:"requiredArray"<br>
     *
     * <br>
     * ҒlF(߂l) Method:null<br>
     *
     * <br>
     * va擾\bh̍Ō5A
     * 擪validatet^\bh݂邪A
     * ̃p^[paramClassƈvȂꍇA
     * nullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod04() throws Exception {
        // O
        va.setName("requiredArray");
        Class[] paramClass = {
            Object.class,
            ValidatorAction.class,
            Field.class
        };

        // eXg{
        // 
        assertNull(new FieldChecks().getMethod(va,paramClass));
    }

    /**
     * testGetMethod05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() va:not null<br>
     *         () paramClass:{Object.class,<br>
     *                 ValidatorAction.class,<br>
     *                 Field.class,<br>
     *                 ValidationErrors.class}<br>
     *         () va.getName:"requiredXXXXX"<br>
     *
     * <br>
     * ҒlF(߂l) Method:new FieldChecks()#validateRequired<br>
     *
     * <br>
     * va擾\bh̍Ō5A
     * 擪validatet^\bh݂ꍇA
     * ̃\bh̃CX^X擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod05() throws Exception {
        // O
        va.setName("requiredXXXXX");
        Class[] paramClass = {
            Object.class,
            ValidatorAction.class,
            Field.class,
            ValidationErrors.class
        };

        // eXg{
        Method result = new FieldChecks().getMethod(va,paramClass);

        // 
        assertEquals(FieldChecks.class, result.getDeclaringClass());
        assertEquals("validateRequired", result.getName());
    }

    /**
     * testExtractValue01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * beannull̏ꍇAnullԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue01() throws Exception {
        // eXg{
        // 
        assertNull(new FieldChecks().extractValue(null, field));
    }

    /**
     * testExtractValue02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"test"<br>
     *
     * <br>
     * ҒlF(߂l) String:"test"<br>
     *
     * <br>
     * beanString^̏ꍇAbean̒lԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue02() throws Exception {
        // eXg{
        // 
        assertEquals("test", new FieldChecks().extractValue("test", field));
    }

    /**
     * testExtractValue03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean {<br>
     *                   field="testProperty"<br>
     *                }<br>
     *         () field:property="field"<br>
     *
     * <br>
     * ҒlF(߂l) String:"testProperty"<br>
     *
     * <br>
     * beanɁAfieldpropertyl̃tB[h݂ꍇA
     * ̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue03() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean
            = new FieldChecks_JavaBeanStub01();
        field.setProperty("field");

        // eXg{
        // 
        assertEquals("testProperty", new FieldChecks().extractValue(bean, field));
    }

    /**
     * testExtractValue04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:JavaBean {<br>
     *                   field="testProperty"<br>
     *                }<br>
     *         () field:property="field2"<br>
     *
     * <br>
     * ҒlF(߂l) String:null<br>
     *
     * <br>
     * beanɁAfieldpropertyl̃tB[h݂ȂꍇA
     * null擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue04() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean
            = new FieldChecks_JavaBeanStub01();
        field.setProperty("field2");

        // eXg{
        // 
        assertNull(new FieldChecks().extractValue(bean, field));
    }

    /**
     * testExtractValue05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:new Integer(12345)<br>
     *         
     * <br>
     * ҒlF(߂l) String:"12345"<br>
     *         
     * <br>
     * beanNumber^̏ꍇAbean̒lԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue05() throws Exception {
        // eXg{
        // 
        assertEquals("12345", new FieldChecks().extractValue(new Integer(12345), field));
    }

    /**
     * testExtractValue06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:new Boolean(true)<br>
     *         
     * <br>
     * ҒlF(߂l) String:"true"<br>
     *         
     * <br>
     * beanBoolean^̏ꍇAbean̒lԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue06() throws Exception {
        // eXg{
        // 
        assertEquals("true", new FieldChecks().extractValue(new Boolean(true), field)); 
    }

    /**
     * testExtractValue07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:new Character('@')<br>
     *         
     * <br>
     * ҒlF(߂l) String:"@"<br>
     *         
     * <br>
     * beanCharacter^̏ꍇAbean̒lԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractValue07() throws Exception {
        // eXg{
        // 
        assertEquals("@", new FieldChecks().extractValue(new Character('@'), field)); 
    }

    /**
     * testRejectValue01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() errors:not null<br>
     *         () field:not null<br>
     *         () va:not null<br>
     *         () bean:not null<br>
     *
     * <br>
     * ҒlF(ԕω) errors:bean,field,vaƂ
     * addErrorsĂяoB<br>
     *
     * <br>
     * bean,field,vaƂaddErrorsĂяo邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRejectValue01() throws Exception {
        // O
        FieldChecks_JavaBeanStub01 bean = new FieldChecks_JavaBeanStub01();
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();

        // eXg{
        new FieldChecks().rejectValue(errors, field, va, bean);

        // 
        assertEquals(1, errors.addErrorCount);
        assertSame(field, errors.fieldList.get(0));
        assertSame(va, errors.vaList.get(0));
        assertSame(bean, errors.beanList.get(0));
    }

}
