/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.io.impl;

import java.util.ArrayList;
import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTarget<T>
implements OutputTarget<T> {
    protected final JdbcTemplate template;
    protected String sql;
    protected String[] header;
    protected String tableName;

    public DbTarget(JdbcTemplate template, String tableName) {
        this.template = template;
        this.tableName = tableName;
    }

    public DbTarget(JdbcTemplate template, Class<T> clazz) {
        this(template, clazz.getSimpleName());
    }

    @Override
    public void write(T obj) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(obj);
        ArrayList<Object> list = new ArrayList<Object>();
        String[] stringArray = this.header;
        int n = this.header.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (beanWrapper.isReadableProperty(propertyName)) {
                list.add(beanWrapper.getPropertyValue(propertyName));
            } else {
                list.add(null);
            }
            ++n2;
        }
        JdbcTemplateUtils.update(this.template, this.sql, list.toArray(new Object[list.size()]));
    }

    @Override
    public void writeHeader(String[] header) {
        this.header = header;
        if (this.getSql() == null) {
            this.sql = JdbcTemplateUtils.createInsertSql(this.tableName, header);
        }
    }

    @Override
    public void close() {
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

