/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jms;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jms.MockMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class MockObjectMessage
extends MockMessage
implements ObjectMessage {
    private Serializable object;

    public MockObjectMessage() {
        this(null);
    }

    public MockObjectMessage(Serializable serializable) {
        this.object = serializable;
    }

    public void setObject(Serializable serializable) throws JMSException {
        if (!this.isInWriteMode()) {
            throw new MessageNotWriteableException("Message is in read mode");
        }
        this.object = serializable;
    }

    public Serializable getObject() throws JMSException {
        return this.object;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.object = null;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof MockObjectMessage)) {
            return false;
        }
        MockObjectMessage mockObjectMessage = (MockObjectMessage)object;
        if (null == this.object && null == mockObjectMessage.object) {
            return true;
        }
        return this.object.equals(mockObjectMessage.object);
    }

    public int hashCode() {
        if (null == this.object) {
            return 0;
        }
        return this.object.hashCode();
    }

    public Object clone() {
        MockObjectMessage mockObjectMessage = (MockObjectMessage)super.clone();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.object);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            mockObjectMessage.object = (Serializable)objectInputStream.readObject();
            return mockObjectMessage;
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName() + ": ");
        if (null == this.object) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.object.toString());
        }
        return stringBuffer.toString();
    }
}

