/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.plugins;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.ValidatorResources;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.validator.ValidatorPlugIn;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;
import org.xml.sax.SAXException;

public class ValidatorPlugInEx
extends ValidatorPlugIn {
    private static Log log = LogFactory.getLog(ValidatorPlugInEx.class);
    private ActionServlet servlet;

    public void init(ActionServlet servlet, ModuleConfig config) throws ServletException {
        this.servlet = servlet;
        super.init(servlet, config);
    }

    protected void initResources() throws IOException, ServletException {
        String pathnames = this.getPathnames();
        if (pathnames == null || pathnames.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(pathnames, ",");
        ArrayList<BufferedInputStream> streamList = new ArrayList<BufferedInputStream>();
        try {
            while (st.hasMoreTokens()) {
                Resource[] resources;
                String validatorRules = st.nextToken().trim();
                ServletContextResourcePatternResolver resourcePatternResolver = new ServletContextResourcePatternResolver(this.servlet.getServletContext());
                for (Resource resource : resources = resourcePatternResolver.getResources(validatorRules)) {
                    InputStream input;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loading validation rules file from '" + resource + "'"));
                    }
                    if ((input = resource.getInputStream()) == null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Skipping validation rules file from '");
                        sb.append(resource);
                        sb.append("'.  No stream could be opened.");
                        throw new ServletException(sb.toString());
                    }
                    BufferedInputStream bis = new BufferedInputStream(input);
                    streamList.add(bis);
                }
            }
            int streamSize = streamList.size();
            InputStream[] streamArray = new InputStream[streamSize];
            for (int streamIndex = 0; streamIndex < streamSize; ++streamIndex) {
                InputStream is;
                streamArray[streamIndex] = is = (InputStream)streamList.get(streamIndex);
            }
            this.resources = new ValidatorResources(streamArray);
        }
        catch (SAXException e) {
            log.error((Object)"Skipping all validation", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            for (InputStream inputStream : streamList) {
                inputStream.close();
            }
        }
    }
}

