/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.requestanalysis.controller;

import jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController;
import jp.terasoluna.rich.functionsample.requestanalysis.bean.RequestAnalysisData;
import jp.terasoluna.rich.functionsample.requestanalysis.exception.TypeCheckException;
import jp.terasoluna.rich.functionsample.requestanalysis.service.RequestAnalysisService;

/**
 * NGXgf[^̃^Cv`FbNsRg[
 * 
 */
public class RequestAnalysisController 
    extends TerasolunaController
            <RequestAnalysisData, RequestAnalysisData> {

    /**
     * NGXgf[^̃^Cv`FbNsT[rX
     */
    private RequestAnalysisService requestAnalysisService = null;

    /**
     * requestAnalysisServiceݒ肷B
     * @param requestAnalysisService NGXgf[^̃^Cv`FbNsT[rX
     */
    public void setRequestAnalysisService(
            RequestAnalysisService requestAnalysisService) {
        this.requestAnalysisService = requestAnalysisService;
    }

    /**
     * NGXgf[^̃^Cv`FbNsB<br>
     * `FbNʂɖ肪Ȃ͓̓f[^o͂B
     * 
     * @param command ̓f[^
     * @return ̓f[^
     * @throws TypeCheckException O
     */
    @Override
    protected RequestAnalysisData 
           executeService(RequestAnalysisData command) 
           throws TypeCheckException {
        
        requestAnalysisService.checkInputDataType(command);
        
        return command; 
    }
}
