/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.Messages;

public final class SqlBindParser {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$util$SqlBindParser == null ? (class$org$exolab$castor$util$SqlBindParser = SqlBindParser.class$("org.exolab.castor.util.SqlBindParser")) : class$org$exolab$castor$util$SqlBindParser);
    private String _sql;
    private int _sql_len;
    private int _pos;
    private int _lastPos;
    private int _bindPos;
    static /* synthetic */ Class class$org$exolab$castor$util$SqlBindParser;

    public SqlBindParser(String sql) {
        this._sql = sql;
        this._sql_len = this._sql.length();
        this._pos = 0;
        this._lastPos = 0;
        this._bindPos = 0;
    }

    public boolean next() {
        this._lastPos = this._pos;
        block4: for (int pos = this._pos; pos < this._sql_len; ++pos) {
            char c = this._sql.charAt(pos);
            switch (c) {
                case '\"': 
                case '\'': {
                    while (pos < this._sql_len) {
                        if ((pos = this._sql.indexOf(c, pos + 1)) == -1) {
                            pos = this._sql_len;
                            continue block4;
                        }
                        if (this._sql.charAt(pos - 1) == '\\') continue;
                        continue block4;
                    }
                    continue block4;
                }
                case '?': {
                    this._bindPos = pos;
                    while (++pos < this._sql_len && Character.isDigit(this._sql.charAt(pos))) {
                    }
                    this._pos = pos;
                    return true;
                }
            }
        }
        this._bindPos = this._pos = this._sql_len;
        return false;
    }

    public String getLastExpr() {
        return this._sql.substring(this._lastPos, this._bindPos);
    }

    public String getBindExpr() {
        return this._sql.substring(this._bindPos, this._pos);
    }

    public int getParamNumber() {
        int idx = this._bindPos + 1;
        return idx < this._pos ? Integer.parseInt(this._sql.substring(idx, this._pos)) : 0;
    }

    public static String getJdbcSql(String pre_sql) {
        StringBuffer sb = new StringBuffer();
        SqlBindParser parser = new SqlBindParser(pre_sql);
        while (parser.next()) {
            sb.append(parser.getLastExpr());
            sb.append("?");
        }
        sb.append(parser.getLastExpr());
        return sb.toString();
    }

    public static void bindJdbcValues(PreparedStatement stmt, String pre_sql, Object[] values) throws SQLException {
        SqlBindParser parser = new SqlBindParser(pre_sql);
        int i = 1;
        while (parser.next()) {
            int bindNum = parser.getParamNumber();
            if (bindNum == 0) {
                bindNum = i;
            }
            Object value = values[bindNum - 1];
            if (_log.isDebugEnabled()) {
                if (value == null) {
                    _log.debug((Object)Messages.format("jdo.bindSqlNull", Integer.toString(i)));
                } else {
                    _log.debug((Object)Messages.format("jdo.bindSql", Integer.toString(i), value, value.getClass().getName()));
                }
            }
            stmt.setObject(i, value);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

