/**
 * 
 */
package jp.terasoluna.fw.collector.db;

import java.util.List;

import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.CollectorTestUtil;
import jp.terasoluna.fw.collector.util.MemoryInfo;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.ex.unit.testcase.DaoTestCase;
import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DBCollectorTest
 */
public class DBCollectorFinalize001Test extends DaoTestCase {

    /**
     * Log.
     */
    private static Log logger = LogFactory
            .getLog(DBCollectorFinalize001Test.class);

    private QueryRowHandleDAO queryRowHandleDAO = null;

    private int previousThreadCount = 0;

    @Override
    protected void addConfigLocations(List<String> configLocations) {
        configLocations.add("jp/terasoluna/fw/collector/db/dataSource.xml");
    }

    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
        DBCollector.setVerbose(true);
        super.onSetUpBeforeTransaction();
    }

    @Override
    protected void onTearDownAfterTransaction() throws Exception {
        DBCollector.setVerbose(false);
        super.onTearDownAfterTransaction();
    }

    @Override
    protected void onSetUp() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        super.onSetUp();
        this.previousThreadCount = CollectorTestUtil.getCollectorThreadCount();
    }

    @Override
    protected void onTearDown() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        CollectorTestUtil.allInterrupt();
        super.onTearDown();
    }

    /**
     * {@link jp.terasoluna.fw.collector.db.DBCollector#DBIteratorTest(jp.terasoluna.fw.dao.QueryRowHandleDAO, java.lang.String, java.lang.Object)}
     * ̂߂̃eXgE\bhB
     */
    public void testDBCollectorFinalize001() throws Exception {
        if (this.queryRowHandleDAO == null) {
            fail("queryRowHandleDAOnullłB");
        }

        {
            Collector<UserBean> col = new DBCollector<UserBean>(
                    this.queryRowHandleDAO, "selectUserList", null);
            try {
                for (UserBean user : col) {
                    if (logger.isInfoEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("UserId:[");
                        sb.append(String.format("%2s", user.getUserId()));
                        sb.append("],");
                        sb.append("FirstName:[");
                        sb.append(String.format("%4s", user.getFirstName()));
                        sb.append("],");
                        sb.append("FamilyName:[");
                        sb.append(String.format("%4s", user.getFamilyName()));
                        sb.append("],");
                        sb.append("UserAge:[");
                        sb.append(String.format("%2s", user.getUserAge()));
                        sb.append("])");
                        if (false) {
                            logger.info(sb.toString());
                        }
                    }

                    // ērŔ
                    break;
                }
            } catch (Throwable e) {
                throw new SystemException(e);
            } finally {
                // ăN[Yɕu
                // DBCollector.closeQuietly(it);
            }
        }

        // RN^Xbh`FbN
        assertTrue(CollectorTestUtil
                .lessThanCollectorThreadCount(1 + this.previousThreadCount));

        System.gc();
        System.gc();
        System.gc();
    }

}
