/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.db;

import jp.terasoluna.fw.collector.AbstractCollector;
import jp.terasoluna.fw.collector.LogId;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.logger.TLogger;

/**
 * DBCollector<br>
 * ƗʃXbhNAQueryRowHandleDAO񓯊ŎsB
 * @param &ltP&gt
 */
public class DBCollector<P> extends AbstractCollector<P> {

    /**
     * Log.
     */
    private static final TLogger LOGGER = TLogger.getLogger(DBCollector.class);

    /** QueryRowHandleDAO */
    protected QueryRowHandleDAO queryRowHandleDAO = null;

    /** sSQLID */
    protected String sqlID = null;

    /** SQLɃoChli[IuWFNg */
    protected Object bindParams = null;

    /** QueueingDataRowHandlerCX^X */
    protected QueueingDataRowHandler rowHandler = null;

    /** QueueingDataRowHandler̃NX^ */
    protected Class<? extends QueueingDataRowHandler> queueingDataRowHandlerClass = QueueingDataRowHandlerImpl.class;

    /** DBCollectorO㏈ */
    protected DBCollectorPrePostProcess dbCollectorPrePostProcess = null;

    /**
     * DBCollectorRXgN^<br>
     */
    protected DBCollector() {
    }

    /**
     * DBCollectorRXgN^<br>
     * @param queryRowHandleDAO QueryRowHandleDAOCX^X
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     */
    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID,
            Object bindParams) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams));
    }

    /**
     * DBCollectorRXgN^<br>
     * @param queryRowHandleDAO QueryRowHandleDAOCX^X
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param relation1n 1:N}bsOgptrue
     */
    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID,
            Object bindParams, boolean relation1n) {

        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams)
                .addRelation1n(relation1n));
    }

    /**
     * DBCollectorRXgN^<br>
     * @param queryRowHandleDAO QueryRowHandleDAOCX^X
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param queueSize L[̃TCYi1ȏݒ肷邱ƁB0ȉ͖j
     */
    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID,
            Object bindParams, int queueSize) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams)
                .addQueueSize(queueSize));
    }

    /**
     * DBCollectorRXgN^<br>
     * @param queryRowHandleDAO QueryRowHandleDAOCX^X
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param exceptionHandler Onh
     */
    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID,
            Object bindParams, CollectorExceptionHandler exceptionHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams)
                .addExceptionHandler(exceptionHandler));
    }

    /**
     * DBCollectorRXgN^<br>
     * @param queryRowHandleDAO QueryRowHandleDAOCX^X
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @param queueSize L[̃TCYi1ȏݒ肷邱ƁB0ȉ͖j
     * @param relation1n 1:N}bsOgptrue
     * @param exceptionHandler Onh
     * @param dbCollectorPrePostProcess DBCollectorO㏈
     */
    public DBCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID,
            Object bindParams, int queueSize, boolean relation1n,
            CollectorExceptionHandler exceptionHandler,
            DBCollectorPrePostProcess dbCollectorPrePostProcess) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams)
                .addQueueSize(queueSize).addRelation1n(relation1n)
                .addExceptionHandler(exceptionHandler)
                .addDbCollectorPrePostProcess(dbCollectorPrePostProcess));
    }

    /**
     * DBCollectorRXgN^<br>
     * @param config DBCollectorConfig DBCollectorݒ荀
     */
    public DBCollector(DBCollectorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }

        this.queryRowHandleDAO = config.getQueryRowHandleDAO();
        this.sqlID = config.getSqlID();
        this.bindParams = config.getBindParams();
        if (config.getQueueSize() > 0) {
            setQueueSize(config.getQueueSize());
        }
        if (config.isRelation1n()) {
            this.queueingDataRowHandlerClass = Queueing1NRelationDataRowHandlerImpl.class;
        }
        this.exceptionHandler = config.getExceptionHandler();
        this.dbCollectorPrePostProcess = config.getDbCollectorPrePostProcess();

        if (config.isExecuteByConstructor()) {
            // sJn
            execute();
        }
    }

    /*
     * (non-Javadoc)
     * @see java.util.concurrent.Callable#call()
     */
    public Integer call() throws Exception {
        try {
            DBCollectorPrePostProcessStatus expStatus = null;
            do {
                try {
                    // SQLsO
                    preprocess();

                    // QueryRowHandleDAO s
                    this.queryRowHandleDAO.executeWithRowHandler(this.sqlID,
                            bindParams, this.rowHandler);
                    this.rowHandler.delayCollect();

                } catch (Throwable th) {
                    // SQLs㏈iOj
                    expStatus = postprocessException(th);

                    // Xe[^X
                    if (expStatus == null
                            || DBCollectorPrePostProcessStatus.THROW
                                    .equals(expStatus)) {
                        // OX[
                        throw th;
                    } else if (expStatus == null
                            || DBCollectorPrePostProcessStatus.END
                                    .equals(expStatus)) {
                        // OX[ɏI
                        break;
                    }
                } finally {
                    // SQLs㏈
                    postprocessComplete();
                }

                // Xe[^XgCȂēxSQLs
            } while (expStatus != null
                    && DBCollectorPrePostProcessStatus.RETRY.equals(expStatus));
        } catch (Throwable e) {
            // Vbg_E͔OL[ɋl߂Ȃ
            if (!isFinish()) {
                // OL[ɂ߂
                try {
                    addQueue(new DataValueObject(e));
                } catch (InterruptedException ie) {
                    LOGGER.warn(LogId.WAL041003, e);
                    LOGGER.warn(LogId.WAL041003, ie);
                }

                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(LogId.DAL041002, e.getClass().getName(),
                            Thread.currentThread().getName());
                }
            }

            return Integer.valueOf(-1);
        } finally {
            setFinish();
        }

        return Integer.valueOf(0);
    }

    /**
     * SQLsO
     */
    protected void preprocess() {
        if (this.dbCollectorPrePostProcess != null) {
            this.dbCollectorPrePostProcess.preprocess(this);
        }
    }

    /**
     * SQLs㏈iOj
     * @param th Throwable
     * @return DBCollectorPrePostProcessStatus
     */
    protected DBCollectorPrePostProcessStatus postprocessException(Throwable th) {
        DBCollectorPrePostProcessStatus expStatus = null;
        if (this.dbCollectorPrePostProcess != null) {
            expStatus = this.dbCollectorPrePostProcess.postprocessException(
                    this, th);
        }
        return expStatus;
    }

    /**
     * SQLs㏈
     */
    protected void postprocessComplete() {
        if (this.dbCollectorPrePostProcess != null) {
            this.dbCollectorPrePostProcess.postprocessComplete(this);
        }
    }

    /**
     * getDataRowHandler\bh.
     * @return QueueingDataRowHandler
     */
    protected QueueingDataRowHandler getDataRowHandler() {
        QueueingDataRowHandler dataRowHandler = null;

        try {
            dataRowHandler = this.queueingDataRowHandlerClass.newInstance();
        } catch (InstantiationException e) {
            SystemException exception = new SystemException(e);
            exception.setMessage("Generation of an instance goes wrong.");
            throw exception;
        } catch (IllegalAccessException e) {
            SystemException exception = new SystemException(e);
            exception.setMessage("Generation of an instance goes wrong.");
            throw exception;
        }

        return dataRowHandler;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#clone()
     */
    @SuppressWarnings("unchecked")
    @Override
    protected Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        if (obj instanceof DBCollector) {
            DBCollector<P> qac = (DBCollector<P>) obj;
            qac.rowHandler = getDataRowHandler();
            qac.rowHandler.setDbCollector(this);
        }
        return obj;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.collector.AbstractCollector#addQueue(jp.terasoluna.fw.collector.vo.DataValueObject)
     */
    @Override
    protected void addQueue(DataValueObject dataValueObject)
                                                            throws InterruptedException {
        super.addQueue(dataValueObject);
    }
}
