/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * DateUtil ubN{bNXeXgB<br>
 * O<br>
 * Etest.propertiesNXpXɐݒ肳ĂKv<br>
 * EvpeBt@CɈȉ̂悤ȐݒĂ<br>
 * @wareki.gengo.0.name = <br>
 * @wareki.gengo.0.roman = H<br>
 * @wareki.gengo.0.startDate = 1989/01/08<br>
 * @wareki.gengo.1.name = a<br>
 * @wareki.gengo.1.roman = S<br>
 * @wareki.gengo.1.startDate = 1926/12/25<br>
 * @wareki.gengo.2.name = 吳<br>
 * @wareki.gengo.2.roman = T<br>
 * @wareki.gengo.2.startDate = 1912/07/30<br>
 * @wareki.gengo.3.name = <br>
 * @wareki.gengo.3.roman = M<br>
 * @wareki.gengo.3.startDate = 1868/09/04<br>
 * @wareki.gengo.4.name = <br>
 * @wareki.gengo.4.roman = H<br>
 * @wareki.gengo.5.name = <br>
 * @wareki.gengo.5.roman = H<br>
 * @wareki.gengo.5.startDate = asdf<br>
 *
 */
@SuppressWarnings("unused")
public class DateUtil2Test extends PropertyTestCase {

    /**
     * ݒ肷邽߂̃tB[h
     */
    private SimpleDateFormat df = null;

    /**
     * ݒ肷邽߂̃tB[h
     */
    private Date date = null;

    /**
     * Constructor for DateUtilTest.
     * @param arg0
     */
    public DateUtil2Test(String arg0) {
        super(arg0);
    }

    @Override
    protected void setUpData() throws Exception {
        addProperty("wareki.gengo.0.name", "");
        addProperty("wareki.gengo.0.roman", "H");
        addProperty("wareki.gengo.0.startDate", "1989/01/08");
        addProperty("wareki.gengo.1.name", "a");
        addProperty("wareki.gengo.1.roman", "S");
        addProperty("wareki.gengo.1.startDate", "1926/12/25");
        addProperty("wareki.gengo.2.name", "吳");
        addProperty("wareki.gengo.2.roman", "T");
        addProperty("wareki.gengo.2.startDate", "1912/07/30");
        addProperty("wareki.gengo.3.name", "");
        addProperty("wareki.gengo.3.roman", "M");
        addProperty("wareki.gengo.3.startDate", "1868/09/04");
        addProperty("wareki.gengo.4.name", "");
        addProperty("wareki.gengo.4.roman", "H");
        addProperty("wareki.gengo.5.name", "");
        addProperty("wareki.gengo.5.roman", "H");
        addProperty("wareki.gengo.5.startDate", "asdf");
    }

    @Override
    protected void cleanUpData() throws Exception {
        clearProperty();
    }

    /**
     * testStatic01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() vpeB:wareki.gengo.0.name = <br>
     *                 @@wareki.gengo.0.roman = H<br>
     *                 @@wareki.gengo.0.startDate = 1989/01/08<br>
     *                 @@wareki.gengo.1.name = a<br>
     *                 @@wareki.gengo.1.roman = S<br>
     *                 @@wareki.gengo.1.startDate = 1926/12/25<br>
     *                 @@wareki.gengo.2.name = 吳<br>
     *                 @@wareki.gengo.2.roman = T<br>
     *                 @@wareki.gengo.2.startDate = 1912/07/30<br>
     *                 @@wareki.gengo.3.name = <br>
     *                 @@wareki.gengo.3.roman = M<br>
     *                 @@wareki.gengo.3.startDate = 1868/09/04<br>
     *                 @@wareki.gengo.4.name = <br>
     *                 @@wareki.gengo.4.roman = H<br>
     *                 @@wareki.gengo.5.name = <br>
     *                 @@wareki.gengo.5.roman = H<br>
     *                 @@wareki.gengo.5.startDate = asdf<br>
     *
     * <br>
     * ҒlF(ԕω) vCx[gtB[h:vCx[gtB[hłuGENGO_NAMEvuGENGO_ROMANvuGENGO_BEGIN_DATESvuGENGO_BEGIN_YEARSṽTCYSł邱ƁB<br>
     *         (ԕω) O:<errorx><br>
     *                    bZ[WFwareki.gengo.4.startDate not found<br>
     *                    <errorx><br>
     *                    bZ[WFUnparseable date: "asdf"<br>
     *
     * <br>
     * ׂẴp^[ԗeXg
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testStatic01() throws Exception {

        // ʊmF
        //vCx[gtB[ȟ4ł邱ƂmFB
        Map GENGO_NAME
            = (Map) UTUtil.getPrivateField(DateUtil.class, "GENGO_NAME");
        Map GENGO_ROMAN
            = (Map) UTUtil.getPrivateField(DateUtil.class, "GENGO_ROMAN");
        Date[] GENGO_BEGIN_DATES
            = (Date[]) UTUtil.getPrivateField(DateUtil.class, "GENGO_BEGIN_DATES");
        int[] GENGO_BEGIN_YEARS
            = (int[]) UTUtil.getPrivateField(DateUtil.class, "GENGO_BEGIN_YEARS");
        assertEquals(4, GENGO_NAME.size());
        assertEquals(4, GENGO_ROMAN.size());
        assertEquals(4, GENGO_BEGIN_DATES.length);
        assertEquals(4, GENGO_BEGIN_YEARS.length);
        assertTrue(LogUTUtil.checkError("wareki.gengo.4.startDate not found"));
        assertTrue(LogUTUtil.checkError("Unparseable date: \"asdf\""));
    }
}
