/*
 * $Id: FileContent.java 5230 2007-09-28 10:04:13Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */
package jp.terasoluna.fw.file.ut;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * t@C̒goCir邽߂̃bp[NXB <BR>
 * <BR>
 * ʏUTUtil.assertEqualsFile()\bĥŁÃNX𒼐 gKv͏ȂƎvB
 * @author ؑ^K
 * @version 2003.08.20
 */
public class FileContent {

    /**
     * ێt@CIuWFNgB
     */
    private File file = null;

    /**
     * RXgN^B
     * @param file grt@C
     */
    public FileContent(File file) {
        this.file = file;
    }

    /**
     * ێĂFileIuWFNg擾B
     * @return FileIuWFNg
     */
    public File getFile() {
        return file;
    }

    /**
     * nbVR[hԂB
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        long hash = 0L;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(getFile());
            for (long i = 0; i < getFile().length(); i++) {
                int input = stream.read();
                if (input == -1) {
                    printReadBytes(i);
                    break;
                }
                hash = (hash << 1) + hash + (long) input;
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (stream != null) {
                stream.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return (int) ((hash >> 32) + hash);
    }

    /**
     * t@CoCirB
     * @param other rΏƂ̃t@C
     * @return rʁBȂtrueAقȂfalseԂB
     */
    public boolean equals(FileContent other) {
        if (hashCode() != other.hashCode()) {
            printHashCode();
            other.printHashCode();
            return false;
        }
        if (getFile().length() != other.getFile().length()) {
            printLength();
            other.printLength();
            return false;
        }

        FileInputStream stream1 = null;
        FileInputStream stream2 = null;
        try {
            stream1 = new FileInputStream(getFile());
            stream2 = new FileInputStream(other.getFile());
            for (long i = 0; i < getFile().length(); i++) {
                int input1 = stream1.read();
                int input2 = stream2.read();
                if (input1 != input2) {
                    System.out.println("first " + i + " bytes are same.");
                    return false;
                }
                if (input1 == -1) {
                    printReadBytes(i);
                    break;
                }
            }
            return true;
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        } finally {
            try {
                if (stream1 != null) {
                    stream1.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (stream2 != null) {
                    stream2.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * toString̃I[o[ChBt@C̃pXԂɂȂĂB
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return getFile().toString();
    }

    /**
     * ǂݍ񂾃oCgWo͂ɏo͂B
     * @param bytes ǂݍ񂾃oCg
     */
    private void printReadBytes(long bytes) {
        printLength();
        System.out.println("but only " + bytes + " bytes can be read.");
    }

    /**
     * nbVR[hWo͂ɏo͂B
     */
    private void printHashCode() {
        System.out.println("hashCode of " + toString() + " is " + hashCode());
    }

    /**
     * t@C̒Wo͂ɏo͂B
     */
    private void printLength() {
        System.out
                .println(toString() + " is " + getFile().length() + " bytes.");
    }
}
