/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.VariableFileUpdateDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ϒt@CpFileLineWriter𐶐B<br>
 * AbstractFileUpdateDAÕTuNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.VariableFileUpdateDAO
 */
public class VariableFileUpdateDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(VariableFileUpdateDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public VariableFileUpdateDAOTest(String name) {
        super(name);
    }

    /**
     * testExecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:VariableFileUpdateDAO_execute01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:VariableFileUpdateDAO_Stub01<br>
     * @<br>
     * () AbstractFileUpdateDAO.columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatterCX^X<br>
     * <br>
     * ҒlF(߂l) FileLineWriter:VariableFileLineWriter̃CX^X<br>
     * (ԕω) VariableFileLineWriter:RXgN^1Ă΂邱ƁB<br>
     * Ăяop[^ɓnĂ邱ƁB<br>
     * <br>
     * ꂼnot nullł΁A߂lAĂ邱ƂmFB<br>
     * ̃\bh́AVariableFileLineWriter̃RXgN^ĂяoȂ̂ŁÃoG[V͈sȂB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecute01() throws Exception {
        // eXgΏۂ̃CX^X
        VariableFileUpdateDAO fileUpdateDAO = new VariableFileUpdateDAO();

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileUpdateDAO_Stub01> clazz = VariableFileUpdateDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        UTUtil.setPrivateField(fileUpdateDAO, "columnFormatterMap",
                columnFormatterMap);

        // eXg{
        FileLineWriter fileLineWriter = fileUpdateDAO.execute(fileName, clazz);

        // ԋpl̊mF
        assertEquals(VariableFileLineWriter.class, fileLineWriter.getClass());

        // ԕω̊mF
        List arguments = VMOUTUtil.getArguments(VariableFileLineWriter.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertEquals(columnFormatterMap, arguments.get(2));
    }

}
