/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.VariableFileQueryDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> ϒt@CǎpFileLineIteratorNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.VariableFileQueryDAO
 */
public class VariableFileQueryDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(VariableFileQueryDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public VariableFileQueryDAOTest(String name) {
        super(name);
    }

    /**
     * testExcecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:VariableFileQueryDAO_execute01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:VariableFileQueryDAO_Stub01<br>
     * @<br>
     * () AbstractFileQueryDAO.columnParserMap:ȉ̗vfMap<String, ColumnParser>CX^X<br>
     * E"java.lang.String"=NullColumnParser.java<br>
     * <br>
     * ҒlF(߂l) FileLineIterator:VariableFileLineIterator̃CX^X<br>
     * (ԕω) VariableFileLineIterator:RXgN^1Ă΂邱ƁB<br>
     * p[^Ɉn邱ƁB<br>
     * <br>
     * nullł͂ȂꍇAVariableFileLineIterator̃CX^X擾ł邱ƁB<br>
     * ̃\bh́AVariableFileLineWriter̃RXgN^ĂяoȂ̂ŁÃoG[V͈sȂB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExcecute01() throws Exception {
        // eXgΏۂ̃CX^X
        VariableFileQueryDAO fileQueryDAO = new VariableFileQueryDAO();

        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<VariableFileQueryDAO_Stub01> clazz = VariableFileQueryDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        UTUtil
                .setPrivateField(fileQueryDAO, "columnParserMap",
                        columnParserMap);

        // eXg{
        FileLineIterator fileLineIterator = fileQueryDAO.execute(fileName,
                VariableFileQueryDAO_Stub01.class);

        // ԋpl̊mF
        assertEquals(VariableFileLineIterator.class, fileLineIterator
                .getClass());

        // ԕω̊mF
        List arguments = VMOUTUtil.getArguments(VariableFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertEquals(columnParserMap, arguments.get(2));

    }

}
