/*
 * $Id: PlainFileLineWriterTest.java 5230 2007-09-28 10:04:13Z anh $
 * 
 * Copyright (c) 2006 NTT DATA Corporation
 * 
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.PlainFileLineWriter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> rWlXWbNȂǂ󂯎t@Cɏo͂B ̃t@CANZX@\Ƃ͈قȂAt@CsIuWFNggȂB<br>
 * AbstractFileLineWriter̃TuNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.PlainFileLineWriter
 */
public class PlainFileLineWriterTest {

    private static final String TEMP_FILE_NAME = PlainFileLineWriterTest.class
            .getResource("PlainFileLineWriterTest_tmp.txt").getPath();

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(PlainFileLineWriterTest.class);
    }

    @Before
    public void setUp() throws Exception {
        VMOUTUtil.initialize();
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    /**
     * testPlainFileLineWriter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:PlainFileLineWriter01.txt<br>
     * @f[^Ȃt@C̃pX<br>
     * () clazz:PlainFileLineWriter_Stub01<br>
     * @@FileFormat̐ݒLAׂďlB<br>
     * () columnFormatterMap:ȉ̗vfMap<String, ColumnFormatter>CX^X<br>
     * E"java.lang.String"=NullColumnFormatterCX^X<br>
     * <br>
     * ҒlF(ԕω) super:1Ăяo邱ƂmFB<br>
     * ĂяoƂ̈AfileName,clazz,columnFormatterMapƓCX^Xł邱<br>
     * (ԕω) super.init:1Ăяo邱ƂmFB<br>
     * <br>
     * eNX̃RXgN^Ă΂邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testPlain01() throws Exception {
        // eXgΏۂ̃CX^X
        // RXgN^Ȃ̂ŕsv

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;

        Class<PlainFileLineWriter_Stub01> clazz = PlainFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // O̐ݒ
        // Ȃ

        // eXg{
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, clazz, columnFormatterMap);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineWriter.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertEquals(columnFormatterMap, arguments.get(2));
        plainFileLineWriter.closeFile();
    }

    /**
     * testPrintDataLine01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() t:StringCX^X<br>
     * () AbstractFileLineWriter#checkWriteTrailer():s<br>
     * () Writer.writer():s<br>
     * () AbstractFileLineWriter#getLineFeedChar():StringCX^X<br>
     * () AbstractFileLineWriter#getWriter():WriterCX^X<br>
     * () AbstractFileLineWriter#setWriteData():s<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#checkWriteTrailer():1Ă΂<br>
     * (ԕω) Writer.writer():2Ă΂<br>
     * (ԕω) AbstractFileLineWriter#getLineFeedChar():1Ă΂<br>
     * (ԕω) AbstractFileLineWriter#getWriter():2Ă΂<br>
     * (ԕω) AbstractFileLineWriter#setWriteData():1Ă΂<br>
     * <br>
     * p^[ <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPrintDataLine01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, PlainFileLineWriter_Stub01.class, columnFormatterMap);

        // ̐ݒ
        String t = "f[^";

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        plainFileLineWriter.printDataLine(t);

        // ԋpl̊mF
        // Ȃ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "checkWriteTrailer"));
        assertEquals(2, VMOUTUtil.getCallCount(Writer.class, "write"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "getLineFeedChar"));
        assertEquals(2, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "getWriter"));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "setWriteData"));
        plainFileLineWriter.closeFile();
    }

    /**
     * testPrintDataLine02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:StringCX^X<br>
     * () AbstractFileLineWriter#checkWriteTrailer():s<br>
     * () Writer.writer():IOException<br>
     * O<br>
     * () AbstractFileLineWriter#getLineFeedChar():StringCX^X<br>
     * () AbstractFileLineWriter#getWriter():WriterCX^X<br>
     * () AbstractFileLineWriter#setWriteData():s<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#checkWriteTrailer():1Ă΂<br>
     * (ԕω) Writer.writer():PĂ΂<br>
     * (ԕω) AbstractFileLineWriter#getLineFeedChar():Ă΂Ȃ<br>
     * (ԕω) AbstractFileLineWriter#getWriter():1Ă΂<br>
     * (ԕω) AbstractFileLineWriter#setWriteData():Ă΂Ȃ<br>
     * (ԕω) Ȃ:ȉ̗vfFileExceptionO<br>
     * EbZ[WF"writer control operation was failed."<br>
     * EOFWriter.writer()甭IOException<br>
     * Et@CigetFileNaměʁj<br>
     * <br>
     * Writer.writer()IOExceptionꍇFileExceptionX[̂mFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPrintDataLine02() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Class<PlainFileLineWriter_Stub01> clazz = PlainFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, clazz, columnFormatterMap);

        // ̐ݒ
        String t = "f[^";

        // O̐ݒ
        IOException exception = new IOException();
        VMOUTUtil.setExceptionAtAllTimes(Writer.class, "write", exception);
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            plainFileLineWriter.printDataLine(t);
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "checkWriteTrailer"));
            assertEquals(1, VMOUTUtil.getCallCount(Writer.class, "write"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getLineFeedChar"));
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getWriter"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));

            assertSame(FileException.class, e.getClass());
            assertEquals("writer control operation was failed.", e.getMessage());
            assertSame(exception, e.getCause());
            assertEquals(fileName, e.getFileName());
        } finally {
            plainFileLineWriter.closeFile();
        }
    }

    /**
     * testPrintDataLine03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:StringCX^X<br>
     * () AbstractFileLineWriter#checkWriteTrailer():FileException<br>
     * O<br>
     * () Writer.writer():s<br>
     * () AbstractFileLineWriter#getLineFeedChar():StringCX^X<br>
     * () AbstractFileLineWriter#getWriter():WriterCX^X<br>
     * () AbstractFileLineWriter#setWriteData():s<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineWriter#checkWriteTrailer():1Ă΂<br>
     * (ԕω) Writer.writer():Ă΂Ȃ<br>
     * (ԕω) AbstractFileLineWriter#getLineFeedChar():Ă΂Ȃ<br>
     * (ԕω) AbstractFileLineWriter#getWriter():Ă΂Ȃ<br>
     * (ԕω) AbstractFileLineWriter#setWriteData():Ă΂Ȃ<br>
     * (ԕω) Ȃ:checkWriteTrailer()甭FileException<br>
     * <br>
     * AbstractFileLineWriter#checkWriteTrailer()FileExceptionX[̂mFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPrintDataLine03() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Class<PlainFileLineWriter_Stub01> clazz = PlainFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, clazz, columnFormatterMap);

        // ̐ݒ
        String t = "f[^";

        // O̐ݒ
        FileException exception = new FileException("checkWriteTrailer̃G[ł");
        VMOUTUtil.setExceptionAtAllTimes(AbstractFileLineWriter.class,
                "checkWriteTrailer", exception);
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            plainFileLineWriter.printDataLine(t);
            fail("FileExceptionX[܂ł");
        } catch (FileException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "checkWriteTrailer"));
            assertEquals(0, VMOUTUtil.getCallCount(Writer.class, "write"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getLineFeedChar"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "getWriter"));
            assertEquals(0, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "setWriteData"));

            assertSame(exception, e);
        } finally {
            plainFileLineWriter.closeFile();
        }
    }

    /**
     * testPrintDataLine04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t:null<br>
     * () AbstractFileLineWriter#checkWriteTrailer():s<br>
     * () Writer.writer():s<br>
     * () AbstractFileLineWriter#getLineFeedChar():StringCX^X<br>
     * () AbstractFileLineWriter#getWriter():WriterCX^X<br>
     * () AbstractFileLineWriter#setWriteData():s<br>
     * <br>
     * ҒlF(ԕω) Ȃ:NullPointerException<br>
     * <br>
     * Nullݒ肵ꍇ́AOX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPrintDataLine04() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Class<PlainFileLineWriter_Stub01> clazz = PlainFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, clazz, columnFormatterMap);

        // ̐ݒ
        String t = null;

        // O̐ݒ
        // eXgΏۂ̃CX^Xɐݒς

        // eXg{
        try {
            plainFileLineWriter.printDataLine(t);
            fail("NullPointerExceptionX[܂ł");
        } catch (NullPointerException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertSame(NullPointerException.class, e.getClass());
        } finally {
            plainFileLineWriter.closeFile();
        }
    }

    /**
     * n<br>
     * FileFormatencloseChardelimiterݒ肳ĂĂA
     * @throws Exception
     */
    @Test
    public void testPrintDataLine05() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        PlainFileLineWriter fileLineWriter = new PlainFileLineWriter(fileName,
                PlainFileLineIterator_Stub02.class, columnFormatterMap);

        // eXg{
        fileLineWriter.printDataLine("\"1\",'22',\"333\",|4444|");
        fileLineWriter.printDataLine("\"5\",'66',\"777\",|8888|");
        fileLineWriter.printDataLine("\"9\",'AA',\"BBB\",|CCCC|");

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("\"1\",'22',\"333\",|4444|", reader.readLine());
            assertEquals("\"5\",'66',\"777\",|8888|", reader.readLine());
            assertEquals("\"9\",'AA',\"BBB\",|CCCC|", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) char:0<br>
     * <br>
     * getDelimiter()sƂKOԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Class<PlainFileLineWriter_Stub01> clazz = PlainFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, clazz, columnFormatterMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        char result = plainFileLineWriter.getDelimiter();

        // ԋpl̊mF
        assertEquals(0, result);

        // ԕω̊mF
        // Ȃ

        plainFileLineWriter.closeFile();
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) char:0<br>
     * <br>
     * getEncloseChar()sƂKOԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;

        Class<PlainFileLineWriter_Stub01> clazz = PlainFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());
        PlainFileLineWriter plainFileLineWriter = new PlainFileLineWriter(
                fileName, clazz, columnFormatterMap);

        // ̐ݒ
        // Ȃ

        // O̐ݒ
        // Ȃ

        // eXg{
        char result = plainFileLineWriter.getEncloseChar();

        // ԋpl̊mF
        assertEquals(0, result);

        // ԕω̊mF
        // Ȃ

        plainFileLineWriter.closeFile();
    }

}
