/*
 * $Id: FixedFileLineWriterTest.java 5576 2007-11-15 13:13:32Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertSame;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;
import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.FixedFileLineWriter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> t@CsIuWFNgf[^ǂݍ݁A1s̃f[^Œ蒷`Ńt@CɏށB<br>
 * AbstractFileLineWriter̃TuNXB
 * <p>
 * @author cNi
 * @author O
 * @see jp.terasoluna.fw.file.dao.standard.FixedFileLineWriter
 */
public class FixedFileLineWriterTest {

    private static final String TEMP_FILE_NAME = FixedFileLineWriterTest.class
            .getResource("FixedFileLineWriterTest_tmp.txt").getPath();

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FixedFileLineWriterTest.class);
    }

    @Before
    public void setUp() throws Exception {
        VMOUTUtil.initialize();
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        // t@C̏
        File file = new File(TEMP_FILE_NAME);
        file.delete();
        file.createNewFile();
    }

    /**
     * testFixedFileLineWriter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() fileName:"File_Empty.txt"(΃pX)<br>
     * () clazz:FixedFileLineWriter_Stub01<br>
     * @FileFormat()<br> () columnFormatterrMap:ȉ̐ݒHashMap̃CX^X<br>
     *                   vf1<br>
     *                   key:"test"<br>
     *                   value:ColumnFormatterCX^X<br>
     *                   FixedFileLineWriter_ColumnFormatterStub01CX^X<br>
     *                   <br>
     * <br>
     *                   ҒlF(ԕω) super:1Ă΂<br>
     *                   ƓCX^Xݒ肳<br>
     *                   (ԕω) super.init:1Ă΂<br>
     * <br>
     *                   fileName΃pXŎw肳ꂽt@CꍇɁARXgN^̌Ăяoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testFixedFileLineWriter01() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Class<FixedFileLineWriter_Stub01> clazz = FixedFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);

        // OȂ

        // eXg{
        FixedFileLineWriter<FixedFileLineWriter_Stub01> fileWriter = new FixedFileLineWriter<FixedFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineWriter.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnFormatterMap, arguments.get(2));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "init"));

        // N[Y
        fileWriter.closeFile();
    }

    /**
     * testFixedFileLineWriter02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FF.G <br>
     * <br>
     * ͒lF() fileName:(΃pX)<br>
     * () clazz:FixedFileLineWriter_Stub02<br>
     * @FileFormat(delimiter='A')<br> () columnFormatterrMap:ȉ̐ݒHashMap̃CX^X<br>
     *                                vf1<br>
     *                                key:"test"<br>
     *                                value:ColumnFormatterCX^X<br>
     *                                FixedFileLineWriter_ColumnFormatterStub01CX^X<br>
     *                                <br>
     * <br>
     *                                ҒlF(ԕω) super:1Ă΂<br>
     *                                ƓCX^Xݒ肳<br>
     *                                (ԕω) super.init:Ă΂Ȃ<br>
     *                                (ԕω)
     *                                Ȃ:"Delimiter can not change."̃bZ[WAIllegalStateExceptionAt@CFileException B<br>
     * <br>
     *                                OB@FileFormatdelimiterɏlȊOݒ肵ꍇAO邱ƂmFB<br>
     *                                t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testFixedFileLineWriter02() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Class<FixedFileLineWriter_Stub02> clazz = FixedFileLineWriter_Stub02.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);

        // eXg{
        try {
            new FixedFileLineWriter<FixedFileLineWriter_Stub02>(fileName,
                    clazz, columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF]
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "<init>", 0);
            assertEquals(fileName, arguments.get(0));
            assertEquals(FixedFileLineWriter_Stub02.class, arguments.get(1));
            assertSame(columnFormatterMap, arguments.get(2));
            assertFalse(VMOUTUtil
                    .isCalled(AbstractFileLineWriter.class, "init"));

            assertEquals("Delimiter can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testFixedFileLineWriter03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FF.G <br>
     * <br>
     * ͒lF() fileName:(΃pX)<br>
     * () clazz:FixedFileLineWriter_Stub03<br>
     * @FileFormat(encloseChar='"')<br> () columnFormatterrMap:ȉ̐ݒHashMap̃CX^X<br>
     *                                  vf1<br>
     *                                  key:"test"<br>
     *                                  value:ColumnFormatterCX^X<br>
     *                                  FixedFileLineWriter_ColumnFormatterStub01CX^X<br>
     *                                  <br>
     * <br>
     *                                  ҒlF(ԕω) super:1Ă΂<br>
     *                                  ƓCX^Xݒ肳<br>
     *                                  (ԕω) super.init:Ă΂Ȃ<br>
     *                                  (ԕω)
     *                                  Ȃ:"EncloseChar can not change."̃bZ[WAIllegalStateExceptionAt@CFileException
     *                                  B<br>
     * <br>
     *                                  OB@FileFormatencloseCharɏlȊOݒ肵ꍇAO邱ƂmFB<br>
     *                                  t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testFixedFileLineWriter03() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Class<FixedFileLineWriter_Stub03> clazz = FixedFileLineWriter_Stub03.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);

        // OȂ

        // eXg{
        try {
            new FixedFileLineWriter<FixedFileLineWriter_Stub03>(fileName,
                    clazz, columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineWriter.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineWriter.class, "<init>", 0);
            assertEquals(fileName, arguments.get(0));
            assertEquals(FixedFileLineWriter_Stub03.class, arguments.get(1));
            assertSame(columnFormatterMap, arguments.get(2));
            assertFalse(VMOUTUtil
                    .isCalled(AbstractFileLineWriter.class, "init"));
            assertEquals("EncloseChar can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testFixedFileLineWriter04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() fileName:"aaa.txt"i΃pXj<br>
     * () clazz:FixedFileLineWriter_Stub01<br>
     * @FileFormat()<br> () columnFormatterrMap:ȉ̐ݒHashMap̃CX^X<br>
     *                   vf1<br>
     *                   key:"test"<br>
     *                   value:ColumnFormatterCX^X<br>
     *                   FixedFileLineWriter_ColumnFormatterStub01CX^X<br>
     *                   <br>
     * <br>
     *                   ҒlF(ԕω) super:1Ă΂<br>
     *                   ƓCX^Xݒ肳<br>
     *                   (ԕω) super.init:1Ă΂<br>
     * <br>
     *                   fileName΃pXŎw肳ꂽt@CꍇɁARXgN^̌Ăяoɍs邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testFixedFileLineWriter04() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineWriter_Stub01> clazz = FixedFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);

        // OȂ

        // eXg{
        FixedFileLineWriter<FixedFileLineWriter_Stub01> fileWriter = new FixedFileLineWriter<FixedFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineWriter.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnFormatterMap, arguments.get(2));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineWriter.class,
                "init"));

        // N[Y
        fileWriter.closeFile();
    }

    /**
     * ُn<br>
     * t@CsIuWFNgOutputFileColumnAme[V
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testFixedFileLineWriter05() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Class<FileLineObject_Empty> clazz = FileLineObject_Empty.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new FixedFileLineWriter<FileLineObject_Empty>(fileName, clazz,
                    columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("OutputFileColumn is not found.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * OutputFileColumnEncloseCharݒ肳ĂꍇAG[Ƃ
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testFixedFileLineWriter06() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        // eXg{
        try {
            new FixedFileLineWriter<CSVFileLine_Stub01>(fileName,
                    CSVFileLine_Stub01.class, columnFormatterMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("columnEncloseChar can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * n<br>
     * s؂薳̌Œ蒷`t@CŃwb_sw肵ꍇA<br>
     * ُIȂmFB
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testFixedFileLineWriter07() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        FixedFileLineWriter<FixedFileLine_Stub03> fileWriter = null;

        // eXg{
        try {
            fileWriter = new FixedFileLineWriter<FixedFileLine_Stub03>(
                    fileName, FixedFileLine_Stub03.class, columnFormatterMap);
        } finally {// N[Y
            fileWriter.closeFile();
        }
    }

    /**
     * n<br>
     * s؂薳̌Œ蒷`t@CŃgCsw肵ꍇA<br>
     * ُIȂmFB
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testFixedFileLineWriter08() throws Exception {
        // ̐ݒ
        String fileName = TEMP_FILE_NAME;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        FixedFileLineWriter<FixedFileLine_Stub04> fileWriter = null;

        // eXg{
        try {
            fileWriter = new FixedFileLineWriter<FixedFileLine_Stub04>(
                    fileName, FixedFileLine_Stub04.class, columnFormatterMap);
        } finally {// N[Y
            fileWriter.closeFile();
        }
    }

    /**
     * testIsCheckByte01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() outputFileColumn:null<br>
     * () -:Ȃ<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * (ԕω) -:Ȃ<br>
     * <br>
     * trueԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testIsCheckBytes01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;
        Class<FixedFileLineWriter_Stub01> clazz = FixedFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);

        FixedFileLineWriter<FixedFileLineWriter_Stub01> fileWriter = new FixedFileLineWriter<FixedFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // ̐ݒ
        OutputFileColumn outputFileColumn = null;

        // OȂ

        // eXg{
        boolean result = fileWriter.isCheckByte(outputFileColumn);
        assertTrue(result);

        // ԕωȂ

        // N[Y
        fileWriter.closeFile();
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) DELIMITER:not null<br>
     * '\u0000'<br>
     * <br>
     * delimitergetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;
        Class<FixedFileLineWriter_Stub01> clazz = FixedFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);
        FixedFileLineWriter<FixedFileLineWriter_Stub01> lineWriter = new FixedFileLineWriter<FixedFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // Ȃ

        // OȂ

        // eXg{
        char result = lineWriter.getDelimiter();

        // ԋpl̊mF
        assertEquals(Character.MIN_VALUE, result);

        // ԕωȂ

        // N[Y
        lineWriter.closeFile();
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FF <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) ENCLOSE_CHAR:not null<br>
     * '\u0000'<br>
     * <br>
     * encloseChargetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        String fileName = TEMP_FILE_NAME;
        Class<FixedFileLineWriter_Stub01> clazz = FixedFileLineWriter_Stub01.class;
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        ColumnFormatter formatter = new FixedFileLineWriter_ColumnFormatterStub01();
        columnFormatterMap.put("java.lang.String", formatter);
        FixedFileLineWriter<FixedFileLineWriter_Stub01> lineWriter = new FixedFileLineWriter<FixedFileLineWriter_Stub01>(
                fileName, clazz, columnFormatterMap);

        // Ȃ

        // OȂ

        // eXg{
        char result = lineWriter.getEncloseChar();

        // ԋpl̊mF
        assertEquals(Character.MIN_VALUE, result);

        // ԕωȂ

        // N[Y
        lineWriter.closeFile();
    }

    /**
     * n<br>
     * Œ蒷s
     * @throws Exception
     */
    @Test
    public void testPrintDataLine01() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Class<FixedFileLine_Stub01> clazz = FixedFileLine_Stub01.class;

        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        FixedFileLineWriter<FixedFileLine_Stub01> fileLineWriter = new FixedFileLineWriter<FixedFileLine_Stub01>(
                fileName, clazz, columnFormatterMap);

        // O()
        FixedFileLine_Stub01 t1 = new FixedFileLine_Stub01();
        FixedFileLine_Stub01 t2 = new FixedFileLine_Stub01();
        FixedFileLine_Stub01 t3 = new FixedFileLine_Stub01();

        // ԋpl̊mF
        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");
        t2.setColumn1("5");
        t2.setColumn2("66");
        t2.setColumn3("777");
        t2.setColumn4("8888");
        t3.setColumn1("9");
        t3.setColumn2("AA");
        t3.setColumn3("BBB");
        t3.setColumn4("CCCC");

        // eXg{
        fileLineWriter.printDataLine(t1);
        fileLineWriter.printDataLine(t2);
        fileLineWriter.printDataLine(t3);

        fileLineWriter.closeFile();
        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("122333444456677788889AABBBCCCC", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * n<br>
     * Œ蒷
     * @throws Exception
     */
    @Test
    public void testPrintDataLine02() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("int", new IntColumnFormatter());
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        FixedFileLineWriter<FixedFileLine_Stub02> fileLineWriter = new FixedFileLineWriter<FixedFileLine_Stub02>(
                fileName, FixedFileLine_Stub02.class, columnFormatterMap);

        // O()
        FixedFileLine_Stub02 t1 = new FixedFileLine_Stub02();
        FixedFileLine_Stub02 t2 = new FixedFileLine_Stub02();
        FixedFileLine_Stub02 t3 = new FixedFileLine_Stub02();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");
        t2.setColumn1("5");
        t2.setColumn2("66");
        t2.setColumn3("777");
        t2.setColumn4("8888");
        t3.setColumn1("9");
        t3.setColumn2("AA");
        t3.setColumn3("BBB");
        t3.setColumn4("CCCC");

        // eXg{
        fileLineWriter.printDataLine(t1);
        fileLineWriter.printDataLine(t2);
        fileLineWriter.printDataLine(t3);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("1223334444", reader.readLine());
            assertEquals("5667778888", reader.readLine());
            assertEquals("9AABBBCCCC", reader.readLine());
        } finally {
            reader.close();
        }
    }

    /**
     * n<br>
     * LbVĂAme[V̏𗘗pĂ鎖mFB<br>
     * @throws Exception
     */
    @Test
    public void testPrintDataLine03() throws Exception {
        // O(t@C)
        String fileName = TEMP_FILE_NAME;

        // O(Ώ)
        Map<String, ColumnFormatter> columnFormatterMap = new HashMap<String, ColumnFormatter>();
        columnFormatterMap.put("java.lang.String", new NullColumnFormatter());

        FixedFileLineWriter<CSVFileLine_Stub04> fileLineWriter = new FixedFileLineWriter<CSVFileLine_Stub04>(
                fileName, CSVFileLine_Stub04.class, columnFormatterMap);

        // O()
        CSVFileLine_Stub04 t1 = new CSVFileLine_Stub04();

        t1.setColumn1("1");
        t1.setColumn2("22");
        t1.setColumn3("333");
        t1.setColumn4("4444");

        // t@CsIuWFNgɐݒ肵ĂlSď㏑
        // ȉ̐ݒ肪Kp΁At@CsIuWFNg
        // Ame[VɃANZXĂȂƂɂȂB
        char[] charArray = new char[] { 0, 0, 0, 0 };
        // O
        UTUtil.setPrivateField(fileLineWriter, "lineFeedChar", "\r\n");
        // UTUtil.setPrivateField(fileLineWriter, "delimiter", '_');
        UTUtil.setPrivateField(fileLineWriter, "outputFileColumns", null);
        UTUtil.setPrivateField(fileLineWriter, "columnFormats", new String[] {
                "", "", "", "" });
        UTUtil.setPrivateField(fileLineWriter, "columnBytes", new int[] { 1, 2,
                3, 4 });
        // UTUtil.setPrivateField(fileLineWriter, "totalBytes", 0);
        UTUtil.setPrivateField(fileLineWriter, "paddingTypes",
                new PaddingType[] { PaddingType.NONE, PaddingType.NONE,
                        PaddingType.NONE, PaddingType.NONE });
        UTUtil.setPrivateField(fileLineWriter, "paddingChars", charArray);
        UTUtil.setPrivateField(fileLineWriter, "trimChars", charArray);
        UTUtil.setPrivateField(fileLineWriter, "columnEncloseChar", charArray);
        UTUtil.setPrivateField(fileLineWriter, "stringConverters",
                new NullStringConverter[] { new NullStringConverter(),
                        new NullStringConverter(), new NullStringConverter(),
                        new NullStringConverter() });

        // eXg{
        fileLineWriter.printDataLine(t1);

        fileLineWriter.closeFile();

        BufferedReader reader = null;

        try {
            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(fileName), System
                            .getProperty("file.encoding")));
            assertEquals("1223334444", reader.readLine());
        } finally {
            reader.close();
        }
    }
}
