/*
 * $Id: FixedFileLineIteratorTest.java 5354 2007-10-03 06:06:25Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Test;

import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.NullStringConverter;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.FixedFileLineIterator} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Œ蒷t@Cp̃t@CANZX(f[^擾)NXB
 * <p>
 * @author cNi
 * @author O
 * @see jp.terasoluna.fw.file.dao.standard.FixedFileLineIterator
 */
public class FixedFileLineIteratorTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FixedFileLineIteratorTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public FixedFileLineIteratorTest(String name) {
        super(name);
    }

    /**
     * testFixedFileLineIterator01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:"aaa.txt"<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * FixedFileLineIterator_Stub01<br>
     * @ Ame[VFileFormatFl<br>
     * () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     * vf1<br>
     * key:"java.lang.String"<br>
     * value:ColumnParserCX^X<br>
     * FixedFileLineWriter_ColumnParserStub01CX^X<br>
     * <br>
     * () totalDefineBytes:0<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂B<br>
     * ƓCX^XnB<br>
     * (ԕω) AbstractFileLineIterator#init():1Ă΂B<br>
     * <br>
     * ɃRXgN^̏s邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFixedFileLineIterator01() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", parser);
        columnParserMap.put("java.util.Date", parser);
        columnParserMap.put("java.math.BigDecimal", parser);
        columnParserMap.put("java.lang.int", parser);

        // OȂ

        // eXg{
        new FixedFileLineIterator<FixedFileLineIterator_Stub01>(fileName,
                clazz, columnParserMap);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * testFixedFileLineIterator02() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:"aaa.txt"<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * FixedFileLineIterator_Stub05<br>
     * @Ame[VFileFormatFdelimiterlȊO<br>
     * @FileFormat(delimiter='A')<br> () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     *                                vf1<br>
     *                                key:"java.lang.String"<br>
     *                                value:ColumnParserCX^X<br>
     *                                FixedFileLineWriter_ColumnParserStub01CX^X<br>
     *                                <br>
     *                                () totalDefineBytes:0<br>
     * <br>
     *                                ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂B<br>
     *                                ƓCX^XnB<br>
     *                                (ԕω) AbstractFileLineIterator#init():Ă΂ȂB<br>
     *                                (ԕω)
     *                                Ȃ:"Delimiter can not change."̃bZ[WAIllegalStateExceptionAt@CFileExceptionB<br>
     * <br>
     *                                OB@FileFormatdelimiterɏlȊOݒ肵ꍇAO邱ƂmFB<br>
     *                                t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFixedFileLineIterator02() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub05> clazz = FixedFileLineIterator_Stub05.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", parser);
        columnParserMap.put("java.util.Date", parser);
        columnParserMap.put("java.math.BigDecimal", parser);
        columnParserMap.put("java.lang.int", parser);

        // OȂ

        // eXg{
        try {
            new FixedFileLineIterator<FixedFileLineIterator_Stub05>(fileName,
                    clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineIterator.class, "<init>", 0);
            assertEquals(fileName, arguments.get(0));
            assertEquals(clazz, arguments.get(1));
            assertSame(columnParserMap, arguments.get(2));
            assertEquals(IllegalStateException.class, e.getCause().getClass());
            assertEquals("Delimiter can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testFixedFileLineIterator03() <br>
     * <br>
     * (n) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileName:"aaa.txt"<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * FixedFileLineIterator_Stub06<br>
     * @Ame[VFileFormatFencloseCharlȊO<br>
     * @FileFormat(encloseChar='"')<br> () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     *                                  vf1<br>
     *                                  key:"java.lang.String"<br>
     *                                  value:ColumnParserCX^X<br>
     *                                  FixedFileLineWriter_ColumnParserStub01CX^X<br>
     *                                  <br>
     *                                  () totalDefineBytes:0<br>
     * <br>
     *                                  ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂B<br>
     *                                  ƓCX^XnB<br>
     *                                  (ԕω) AbstractFileLineIterator#init():Ă΂ȂB<br>
     *                                  (ԕω)
     *                                  Ȃ:"EncloseChar can not change."̃bZ[WAIllegalStateExceptionAt@CFileExceptionB<br>
     * <br>
     *                                  OB@FileFormatencloseCharɏlȊOݒ肵ꍇAO邱ƂmFB<br>
     *                                  t@C͒lfileNameɈv邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFixedFileLineIterator03() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub06> clazz = FixedFileLineIterator_Stub06.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", parser);
        columnParserMap.put("java.util.Date", parser);
        columnParserMap.put("java.math.BigDecimal", parser);
        columnParserMap.put("java.lang.int", parser);

        // OȂ

        // eXg{
        try {
            new FixedFileLineIterator<FixedFileLineIterator_Stub06>(fileName,
                    clazz, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(1, VMOUTUtil.getCallCount(
                    AbstractFileLineIterator.class, "<init>"));
            List arguments = VMOUTUtil.getArguments(
                    AbstractFileLineIterator.class, "<init>", 0);
            assertEquals(fileName, arguments.get(0));
            assertEquals(clazz, arguments.get(1));
            assertSame(columnParserMap, arguments.get(2));
            assertEquals(IllegalStateException.class, e.getCause().getClass());
            assertEquals("EncloseChar can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
        }
    }

    /**
     * testFixedFileLineIterator04() <br>
     * <br>
     * (n) <br>
     * ϓ_FE <br>
     * <br>
     * ͒lF() fileName:"aaa.txt"<br>
     * () clazz:ȉ̐ݒFileFormatAme[VX^u<br>
     * FixedFileLineIterator_Stub02<br>
     * @ Ame[VFileFormatFl<br>
     * F<br>
     * @@@@InputFileColumn(columnIndex = 1, bytes = 5)<br>
     * @@@String column1;<br>
     * @@@@InputFileColumn(columnIndex = 1, bytes = 3)<br>
     * @@@String column2;<br>
     * () columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     * vf1<br>
     * key:"java.lang.String"<br>
     * value:ColumnParserCX^X<br>
     * FixedFileLineWriter_ColumnParserStub01CX^X<br>
     * <br>
     * () totalDefineBytes:0<br>
     * <br>
     * ҒlF(ԕω) AbstractFileLineIteratorRXgN^:1Ă΂B<br>
     * ƓCX^XnB<br>
     * (ԕω) AbstractFileLineIterator#init():1Ă΂B<br>
     * <br>
     * ɃRXgN^̏s邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testFixedFileLineIterator04() throws Exception {
        // eXgΏۂ̃CX^XȂ

        // ̐ݒ
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub02> clazz = FixedFileLineIterator_Stub02.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", parser);
        columnParserMap.put("java.util.Date", parser);
        columnParserMap.put("java.math.BigDecimal", parser);
        columnParserMap.put("java.lang.int", parser);

        // OȂ

        // eXg{
        new FixedFileLineIterator<FixedFileLineIterator_Stub02>(fileName,
                clazz, columnParserMap);

        // ԋplȂ

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(AbstractFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnParserMap, arguments.get(2));
        assertEquals(1, VMOUTUtil.getCallCount(AbstractFileLineIterator.class,
                "init"));
    }

    /**
     * ُn<br>
     * t@CsIuWFNgInputFileColumnAme[V
     * @throws Exception ̃\bhŔO
     */
    public void testFixedFileLineIterator05() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Class<FileLineObject_Empty> clazz = FileLineObject_Empty.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        // eXg{
        try {
            new FixedFileLineIterator<FileLineObject_Empty>(fileName, clazz,
                    columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("InputFileColumn is not found.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * InputFileColumnEncloseCharݒ肳ĂꍇAG[Ƃ
     * @throws Exception ̃\bhŔO
     */
    public void testFixedFileLineIterator06() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        // eXg{
        try {
            new FixedFileLineIterator<CSVFileLine_Stub01>(fileName,
                    CSVFileLine_Stub01.class, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("columnEncloseChar can not change.", e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * s؂薳̌Œ蒷`t@CŃwb_sw肵ꍇA<br>
     * ُI鎖mFB
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testFixedFileLineIterator07() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        // eXg{
        try {
            new FixedFileLineIterator<FixedFileLine_Stub03>(fileName,
                    FixedFileLine_Stub03.class, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("HeaderLineCount or trailerLineCount cannot be used.",
                    e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * ُn<br>
     * s؂薳̌Œ蒷`t@CŃgCsw肵ꍇA<br>
     * ُI鎖mFB
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testFixedFileLineIterator08() throws Exception {
        // ̐ݒ
        URL url = this.getClass().getResource("File_Empty.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new CSVFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        // eXg{
        try {
            new FixedFileLineIterator<FixedFileLine_Stub04>(fileName,
                    FixedFileLine_Stub04.class, columnParserMap);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals("HeaderLineCount or trailerLineCount cannot be used.",
                    e.getMessage());
            assertEquals(fileName, e.getFileName());
            assertEquals(IllegalStateException.class, e.getCause().getClass());
        }
    }

    /**
     * testSeparateColumns01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() fileLineString:null<br>
     * <br>
     * ҒlF(߂l) String[]:new String[0]<br>
     * <br>
     * p^[B<br>
     * nullƂēnꂽꍇAvf0̔zԋp邱ƂmFB<br>
     * ʏ̏ł̕ԋpl߂邱Ƃ͂ȂB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", parser);
        columnParserMap.put("java.util.Date", parser);
        columnParserMap.put("java.math.BigDecimal", parser);
        columnParserMap.put("java.lang.int", parser);
        FixedFileLineIterator<FixedFileLineIterator_Stub01> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = null;

        // OȂ

        // eXg{
        String[] columns = lineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(0, columns.length);

        // ԕωȂ
    }

    /**
     * testSeparateColumns02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileLineString:"aaa"<br>
     * () this.fields[]:zvf0<br>
     * <br>
     * ҒlF(ԕω) O:IllegaStateExceptionBFileExceptionɃbv邱ƂmFB<br>
     * t@C͒lfileNameɈv邱ƂmFB<br>
     * bZ[WF"Total Columns byte is different from Total FileLineObject's columns byte."<br>
     * <br>
     * OBAme[VŐݒ肵oCg̍vƁAt@C1s̃oCgقȂꍇAO邱ƂmFB<br>
     * t@CsIuWFNg̃CX^XϐȂꍇB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", parser);
        columnParserMap.put("java.util.Date", parser);
        columnParserMap.put("java.math.BigDecimal", parser);
        columnParserMap.put("java.lang.int", parser);
        FixedFileLineIterator<FixedFileLineIterator_Stub01> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "aaa";

        // O(CX^Xfileds[]ɐݒ肳)

        // eXg{
        try {
            lineIterator.separateColumns(fileLineString);
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            String message = "Total Columns byte is different from "
                    + "Total FileLineObject's columns byte.";
            assertEquals(message, e.getMessage());
        }
    }

    /**
     * testSeparateColumns03() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"12345"<br>
     * () this.fields[]:zvf1<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0, bytes = 5, stringConverter =
     * StringConverterToUpperCase.class, trimChar = '0', trimType = TrimType.LEFT)<br>
     * private String shopId = null;<br>
     * () AbstractFileLineIterator.fileEncoding:VXeftHg<br>
     * <br>
     * ҒlF(߂l) String[]:ȉ̗vfStringz<br>
     * @vf1F"12345"<br>
     * <br>
     * p^[Bzvf1̕^zԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub03> clazz = FixedFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        FixedFileLineIterator<FixedFileLineIterator_Stub03> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub03>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "12345";

        // O(CX^Xfileds[]ɐݒ肳)

        // eXg{
        String[] columns = lineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(1, columns.length);
        assertEquals("12345", columns[0]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileLineString:"12345"<br>
     * () this.fields[]:zvf1<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0, bytes = 5, stringConverter =
     * StringConverterToUpperCase.class, trimChar = '0', trimType = TrimType.LEFT)<br>
     * private String shopId = null;<br>
     * () AbstractFileLineIterator.fileEncoding:݂ȂGR[h<br>
     * <br>
     * ҒlF(ԕω) O:UnsupoortedEncodingExceptionBFileExceptionɃbv邱ƂmF<br>
     * t@C͒lfileNameɈv邱ƂmFB<br>
     * bZ[WF"fileEncoding which isn't supported was set."<br>
     * <br>
     * OBݒ肳ĂGR[h݂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns04() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub03> clazz = FixedFileLineIterator_Stub03.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        FixedFileLineIterator<FixedFileLineIterator_Stub03> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub03>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "12345";

        // O̐ݒ
        UTUtil.setPrivateField(lineIterator, "fileEncoding", "aaa");

        // eXg{
        try {
            lineIterator.separateColumns(fileLineString);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(UnsupportedEncodingException.class, e.getCause()
                    .getClass());
            assertEquals(fileName, e.getFileName());
            assertEquals("fileEncoding which isn't supported was set.", e
                    .getMessage());
        }
    }

    /**
     * testSeparateColumns05() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:"2006/12/10aaaaa123456789"<br>
     * () this.fields[]:zvf3<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0, bytes = 10, columnFormat = "yyyy/MM/dd")<br>
     * private Date hiduke = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 1, bytes = 5, stringConverter = StringConverterToUpperCase.class, trimChar = '0', trimType
     *                              = TrimType.LEFT)<br>
     *                              private String shopId = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 2, bytes = 9, columnFormat = "#########")<br>
     *                              private BigDecimal uriage = null;<br>
     *                              () AbstractFileLineIterator.fileEncoding:VXeftHg<br>
     * <br>
     *                              ҒlF(߂l) String[]:ȉ̗vfStringz<br>
     *                              @vf1F"2006/12/10"<br>
     *                              @vf2F"aaaaa"<br>
     *                              @vf3F"123456789"<br>
     * <br>
     *                              p^[<br>
     *                              zvf3̕zԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns05() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub04> clazz = FixedFileLineIterator_Stub04.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        FixedFileLineIterator<FixedFileLineIterator_Stub04> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub04>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "2006/12/10aaaaa123456789";

        // O(CX^Xfileds[]ɐݒ肳)

        // eXg{
        String[] columns = lineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(3, columns.length);
        assertEquals("2006/12/10", columns[0]);
        assertEquals("aaaaa", columns[1]);
        assertEquals("123456789", columns[2]);

        // ԕωȂ
    }

    /**
     * testSeparateColumns06() <br>
     * <br>
     * (n) <br>
     * ϓ_FE, F <br>
     * <br>
     * ͒lF() fileLineString:󕶎<br>
     * <br>
     * ҒlF(߂l) String[]:new String[0]<br>
     * <br>
     * p^[B<br>
     * 󕶎ƂēnꂽꍇAvf0̔zԋp邱ƂmFB<br>
     * ʏ̏ł̕ԋpl߂邱Ƃ͂ȂB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns06() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        FixedFileLineIterator<FixedFileLineIterator_Stub01> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "";

        // O(CX^Xfileds[]ɐݒ肳)

        // eXg{
        String[] columns = lineIterator.separateColumns(fileLineString);

        // ԋpl̊mF
        assertEquals(0, columns.length);
    }

    /**
     * testSeparateColumns07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileLineString:"2006/01/01012345678"iSpgpj<br>
     * () this.fields[]:zvf3<br>
     * () this.field[]̃Ame[VInputFileColumn:@InputFileColumn(columnIndex = 0, bytes = 10, columnFormat = "yyyy/MM/dd")<br>
     * private Date hiduke = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 1, bytes = 5, stringConverter = StringConverterToUpperCase.class, trimChar = '0', trimType
     *                              = TrimType.LEFT)<br>
     *                              private String shopId = null;<br>
     * <br>
     * @InputFileColumn(columnIndex = 2, bytes = 9, columnFormat = "#########")<br>
     *                              private BigDecimal uriage = null;<br>
     *                              () AbstractFileLineIterator.fileEncoding:VXeftHg<br>
     * <br>
     *                              ҒlF(ԕω) O:IllegaStateExceptionBFileExceptionɃbv邱ƂmFB<br>
     *                              t@C͒lfileNameɈv邱ƂmFB<br>
     *                              bZ[WF"Total Columns byte is different from Total FileLineObject's columns byte."<br>
     * <br>
     *                              OBAme[VŐݒ肵oCg̍vƁAt@C1s̃oCgقȂꍇAO邱ƂmFB<br>
     *                              t@CsIuWFNg̃CX^XϐȂꍇB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testSeparateColumns07() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub04> clazz = FixedFileLineIterator_Stub04.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);
        FixedFileLineIterator<FixedFileLineIterator_Stub04> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub04>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        String fileLineString = "2006/01/01012345678";

        // O(CX^Xfileds[]ɐݒ肳)

        // eXg{
        try {
            lineIterator.separateColumns(fileLineString);
            fail("FileExceptionX[܂łB");
        } catch (FileException e) {
            // ԋplȂ

            // ԕω̊mF
            assertEquals(IllegalStateException.class, e.getCause().getClass());
            assertEquals(fileName, e.getFileName());
            String message = "Total Columns byte is different from "
                    + "Total FileLineObject's columns byte.";
            assertEquals(message, e.getMessage());
        }
    }

    /**
     * testIsCheckByte01() <br>
     * <br>
     * (n) <br>
     * ϓ_FA <br>
     * <br>
     * ͒lF() inputFileColumn:null<br>
     * () -:Ȃ<br>
     * <br>
     * ҒlF(߂l) boolean:false<br>
     * (ԕω) -:Ȃ<br>
     * <br>
     * falseԋp邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testIsCheckByte01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);

        FixedFileLineIterator<FixedFileLineIterator_Stub01> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // ̐ݒ
        InputFileColumn inputFileColumn = null;

        // OȂ

        // eXg{
        boolean result = lineIterator.isCheckByte(inputFileColumn);

        // ԋpl̊mF
        assertFalse(result);

        // ԕωȂ
    }

    /**
     * testGetDelimiter01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) DELIMITER:,(J})'<br>
     * <br>
     * delimitergetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetDelimiter01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();

        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);

        FixedFileLineIterator<FixedFileLineIterator_Stub01> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // Ȃ

        // OȂ

        // eXg{
        char result = lineIterator.getDelimiter();

        // ԋpl̊mF
        assertEquals(',', result);

        // ԕωȂ
    }

    /**
     * testGetEncloseChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF <br>
     * ҒlF(߂l) ENCLOSE_CHAR:Character.MIN_VALUE<br>
     * <br>
     * encloseChargetter\bhl擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testGetEncloseChar01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileLineIterator_Stub01> clazz = FixedFileLineIterator_Stub01.class;
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();

        ColumnParser columnParser = new FixedFileLineIterator_ColumnParserStub01();
        columnParserMap.put("java.lang.String", columnParser);
        columnParserMap.put("java.util.Date", columnParser);
        columnParserMap.put("java.math.BigDecimal", columnParser);
        columnParserMap.put("java.lang.int", columnParser);

        FixedFileLineIterator<FixedFileLineIterator_Stub01> lineIterator = new FixedFileLineIterator<FixedFileLineIterator_Stub01>(
                fileName, clazz, columnParserMap);

        // Ȃ

        // OȂ

        // eXg{
        char result = lineIterator.getEncloseChar();

        // ԋpl̊mF
        assertEquals(Character.MIN_VALUE, result);

        // ԕωȂ
    }

    /**
     * n<br>
     * Œ蒷s
     * @throws Exception
     */
    public void testNext01() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "FixedFileLineIterator_next01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        FixedFileLineIterator<FixedFileLine_Stub01> fileLineIterator = new FixedFileLineIterator<FixedFileLine_Stub01>(
                fileName, FixedFileLine_Stub01.class, columnParserMap);

        // eXg{
        FixedFileLine_Stub01 result1 = fileLineIterator.next();
        FixedFileLine_Stub01 result2 = fileLineIterator.next();
        FixedFileLine_Stub01 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("4444", result1.getColumn4());

        assertEquals("5", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("8888", result2.getColumn4());

        assertEquals("9", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("CCCC", result3.getColumn4());
    }

    /**
     * n<br>
     * Œ蒷
     * @throws Exception
     */
    public void testNext02() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource(
                "FixedFileLineIterator_next02.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());
        columnParserMap.put("java.util.Date", new DateColumnParser());
        columnParserMap.put("java.math.BigDecimal", new DecimalColumnParser());
        columnParserMap.put("int", new IntColumnParser());

        FixedFileLineIterator<FixedFileLine_Stub02> fileLineIterator = new FixedFileLineIterator<FixedFileLine_Stub02>(
                fileName, FixedFileLine_Stub02.class, columnParserMap);

        // eXg{
        FixedFileLine_Stub02 result1 = fileLineIterator.next();
        FixedFileLine_Stub02 result2 = fileLineIterator.next();
        FixedFileLine_Stub02 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("1", result1.getColumn1());
        assertEquals("22", result1.getColumn2());
        assertEquals("333", result1.getColumn3());
        assertEquals("4444", result1.getColumn4());

        assertEquals("5", result2.getColumn1());
        assertEquals("66", result2.getColumn2());
        assertEquals("777", result2.getColumn3());
        assertEquals("8888", result2.getColumn4());

        assertEquals("9", result3.getColumn1());
        assertEquals("AA", result3.getColumn2());
        assertEquals("BBB", result3.getColumn3());
        assertEquals("CCCC", result3.getColumn4());
    }

    /**
     * n<br>
     * LbVĂAme[V̏𗘗pĂ鎖mFB<br>
     * @throws Exception
     */
    public void testNext03() throws Exception {
        // eXgΏۂ̃CX^X
        URL url = this.getClass().getResource("CsvFileLineIterator_next01.txt");
        String fileName = url.getPath();
        Map<String, ColumnParser> columnParserMap = new HashMap<String, ColumnParser>();
        columnParserMap.put("java.lang.String", new NullColumnParser());

        // lXȐݒ肪Ăt@CsIuWFNgݒ
        FixedFileLineIterator<CSVFileLine_Stub04> fileLineIterator = new FixedFileLineIterator<CSVFileLine_Stub04>(
                fileName, CSVFileLine_Stub04.class, columnParserMap);

        // t@CsIuWFNgɐݒ肵ĂlSď㏑
        // ȉ̐ݒ肪Kp΁At@CsIuWFNg
        // Ame[VɃANZXĂȂƂɂȂB
        char[] charArray = new char[] { 0, 0, 0, 0 };
        // O
        UTUtil.setPrivateField(fileLineIterator, "lineFeedChar", "\r\n");
        UTUtil.setPrivateField(fileLineIterator, "inputFileColumns", null);
        UTUtil.setPrivateField(fileLineIterator, "columnFormats", new String[] {
                "", "", "", "" });
        UTUtil.setPrivateField(fileLineIterator, "columnBytes", new int[] { 4,
                3, 4, 6 });
        UTUtil.setPrivateField(fileLineIterator, "totalBytes", 17);

        UTUtil.setPrivateField(fileLineIterator, "trimChars", charArray);
        UTUtil
                .setPrivateField(fileLineIterator, "columnEncloseChar",
                        charArray);
        UTUtil.setPrivateField(fileLineIterator, "stringConverters",
                new NullStringConverter[] { new NullStringConverter(),
                        new NullStringConverter(), new NullStringConverter(),
                        new NullStringConverter() });
        LineReader reader = (LineReader) UTUtil.getPrivateField(
                fileLineIterator, "lineReader");
        UTUtil.setPrivateField(reader, "lineFeedChar", "\r\n");

        // eXg{
        CSVFileLine_Stub04 result1 = fileLineIterator.next();
        CSVFileLine_Stub04 result2 = fileLineIterator.next();
        CSVFileLine_Stub04 result3 = fileLineIterator.next();

        // ԋpl̊mF
        assertEquals("\"1\",", result1.getColumn1());
        assertEquals("22,", result1.getColumn2());
        assertEquals("333,", result1.getColumn3());
        assertEquals("|4444|", result1.getColumn4());

        assertEquals("\"5\",", result2.getColumn1());
        assertEquals("66,", result2.getColumn2());
        assertEquals("777,", result2.getColumn3());
        assertEquals("|8888|", result2.getColumn4());

        assertEquals("\"9\",", result3.getColumn1());
        assertEquals("AA,", result3.getColumn2());
        assertEquals("BBB,", result3.getColumn3());
        assertEquals("|CCCC|", result3.getColumn4());
    }
}
