/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.DateFormatLocal} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> SimpleDateFormatXbhZ[tł͂Ȃ߁AThreadLocalgpăXbhZ[tɂB
 * <p>
 * @author I 
 * @see jp.terasoluna.fw.file.dao.standard.DateFormatLocal
 */
public class DateFormatLocalTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(DateFormatLocalTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public DateFormatLocalTest(String name) {
        super(name);
    }

    /**
     * testDateFormatLocalStringpattern01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() pattern:StringCX^X<br>
     * <br>
     * ҒlF(ԕω) this.pattern:patternƓl<br>
     * <br>
     * patternƓlݒ肳邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDateFormatLocalStringpattern01() throws Exception {
        // O()
        String pattern = new String();

        // eXg{
        DateFormatLocal dateFormatLocal = new DateFormatLocal(pattern);

        // 
        assertNotNull(dateFormatLocal);
        assertSame(pattern, UTUtil.getPrivateField(dateFormatLocal, "pattern"));
    }

    /**
     * testDateFormatinitialValue01() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FE.G <br>
     * <br>
     * ͒lF() pattern:null<br>
     * <br>
     * ҒlF(ԕω) Ȃ:NullPointerException<br>
     * <br>
     * Onull̏ꍇNullPointerException邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDateFormatinitialValue01() throws Exception {
        // O
        DateFormatLocal dateFormatLocal = new DateFormatLocal(null);

        // O()
        UTUtil.setPrivateField(dateFormatLocal, "pattern", null);

        try {
            // eXg{
            dateFormatLocal.initialValue();
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testDateFormatinitialValue02() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() pattern:"yyyy/MM/dd"<br>
     * <br>
     * ҒlF(߂l) DateFormat:ȉ̗vfSimpleDateFormatCX^X<br>
     * @patternF@"yyyy/MM/dd"<br>
     * @setLenientF@FALSE<br>
     * <br>
     * OnullȂꍇ{邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testDateFormatinitialValue02() throws Exception {
        // O
        DateFormatLocal dateFormatLocal = new DateFormatLocal(null);

        // O()
        String pattern = "yyyy/MM/dd";
        UTUtil.setPrivateField(dateFormatLocal, "pattern", pattern);

        // eXg{
        DateFormat result = dateFormatLocal.initialValue();

        // 
        assertNotNull(result);
        assertTrue(result instanceof SimpleDateFormat);
        assertEquals(pattern, SimpleDateFormat.class.cast(result).toPattern());
        assertFalse(result.isLenient());
    }
}
